/******************************************************************************
 * FILE        : ecnr-error.h
 * PROJECT     : Gen3 and Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2019 RBEI
 * HISTORY     :
 * Date        | Author                 | Modification
 * 15.05.2019  | RBEI/ECO Ranjit Susal  | initial version
 *             |                        | error codes handling
 *****************************************************************************/


#ifndef __ECNR_ERROR_H__
#define __ECNR_ERROR_H__


/* C standard library */
#include <stdio.h>
#include <unistd.h>
#include <string.h>

/* glib */
#include <glib.h>
#include <gmodule.h>



//#define ECNR_OBJECT_ERROR (ecnr_object_error_quark())


typedef enum sErrorCode{
  ECNR_ERR_OK = 0,
  ECNR_ERR_INVALID_INPUT = 0x1000,
  ECNR_ERR_FAILED,
  ECNR_ERR_NO_ECNR_OBJECT_AVAILABLE,
  ECNR_ERR_CONFIG_FILE_OPEN_FAILED,
  ECNR_ERR_CONFIG_FILE_EMPTY,
  ECNR_ERR_CONFIG_FILE_READING_FAILED,
  ECNR_ERR_CONFIG_NOT_AVAILABLE,
  ECNR_ERR_NO_RESULT,
  ECNR_ERR_SIZE_ONLY,
  ECNR_ERR_ALLOC,
  ECNR_ERR_NULL_POINTER,
  ECNR_ERR_MODULE_NOT_INIT,
  ECNR_ERR_NOT_CREATED,
  ECNR_ERR_MODULE_ALREADY_INIT,
  ECNR_ERR_INVALID_MAIN_STRUCT,
  ECNR_ERR_DEINIT_FAILED,
  ECNR_ERR_ILLEGAL_SET_PARAM,
  ECNR_ERR_ILLEGAL_SET_PARAM_BEFORE_INIT,
  ECNR_ERR_ILLEGAL_SET_PARAM_AFTER_INIT,
  ECNR_ERR_INVALID_PARAM_ID,
  ECNR_ERR_INVALID_CHANNEL_NUMBER,
  ECNR_ERR_INVALID_OPERATION_MODE,
  ECNR_ERR_INVALID_SIZE,
  ECNR_ERR_PARAM,
  ECNR_ERR_PARAM_CNT,
  ECNR_ERR_SAMPLE_RATE,
  ECNR_ERR_FRAMESHIFT,
  ECNR_ERR_INVALID_CHAN_CNT,
  ECNR_ERR_FFT_LENGTH,
  ECNR_ERR_INVALID_FILTER_LEN,
  ECNR_ERR_NULL_FILTER,
  ECNR_ERR_PARAMETER_TABLE,
  ECNR_ERR_NOT_IMP,
  ECNR_ERR_SUBMODULE_DISABLED,
  ECNR_ERR_INVALID_SET_PARAM_ENDIANNESS,
  ECNR_ERR_INIT_MMGR,
  ECNR_ERR_DGB_INIT_FAILED,
  ECNR_ERR_DGB_NO_DATA,
  ECNR_ERR_INVALID_ASR_MODE,

  /* error service module */
  ECNR_ERR_SERV_NOT_INITIALIZED,
  ECNR_ERR_SERV_ASR_TYPE_UNSUPPORTED,

  /* error in configuration module */
  ECNR_ERR_APPID_NOT_AVAILABLE,
  ECNR_ERR_CONFID_NOT_AVAILABLE,
  ECNR_ERR_NO_DEFAULT_CONFIGURATION,
  ECNR_ERR_APPID_INSTANCE_ALREADY_ACTIVE,
  ECNR_ERR_NO_INSTANCE_AVAILABLE,
  ECNR_ERR_APPID_INSTANCE_NOT_AVAILABLE,
  ECNR_ERR_APPID_CONFIGID_NOT_MATCHING,
  ECNR_ERR_NO_CONFIG_FILE_AVAILABLE,
  ECNR_ERR_DEV_ID_NOT_AVAILABLE,
  ECNR_ERR_DEV_CHNID_NOT_MATCHING,
  ECNR_ERR_CONFIG_EOL_IO_ERROR,
  ECNR_ERR_VERSION_SSE_DP_DO_NOT_MATCH,
  ECNR_ERR_NO_FILE_AVAILABLE,
  ECNR_ERR_VALUE_RANGE_FAILURE,
  ECNR_ERR_TBL_IDX_NB_CFG_VALUE_TRANSGRESSION,
  ECNR_ERR_PERIODE_SIZE_INVALID,

  /*-----------------------------*/

  ECNR_ERR_REQ_APPID_NOT_ACTIVE,
  ECNR_ERR_ALSA_NO_INSTANCE,
  ECNR_ERR_DEBUG_ALREADY_ACTIVE,
  ECNR_ERR_DEBUG_MODER_NOT_SUPPORTED,
  ECNR_ERR_DGB_SET_RMV_TRIGGER_FILE_FAILED,
  ECNR_ERR_OBJECT_FI_NOT_SUPPORTED,
  ECNR_ERR_OBJECT_FI_AUDIO_IS_RUNNING,
  ECNR_ERR_NO_AUDIO_STREAMING,
  ECNR_ERR_AUDIO_THREAD_ALREADY_ACTIVE,

  /* error in RTS handler  */
  ECNR_ERR_RTS_NOT_SUPPORTED,
  ECNR_ERR_RTS_STATE_ERROR,

  /* error in ecnr_datapool_access module*/
  ECNR_ERR_DP_ACCES_NULL_FCT_POINTER,
  ECNR_ERR_DP_ACCES_DP_ALREADY_REGISTRIED,
  ECNR_ERR_DP_NO_ELEMENT_AVAILABLE,
  ECNR_ERR_DP_INVALID_ELEMENT,
  ECNR_ERR_DP_ERROR_SIZE_OF_DATAPOOL,

  /* QWA handler specific */
  ECNR_ERR_OSAL_ERROR,

  /* QWA RCS error group */
  ECNR_QWA_RCS_ERR_INV_POINTER,
  ECNR_QWA_RCS_ERR_INVALID_BUFFSIZE,
  ECNR_QWA_RCS_ERR_NO_FILE_FOR_CFG_ID

}ERRORCODE;

struct EcnrError
{
          int    code; // tQwaInt code;
    const gchar* str;
};

extern  GQuark ecnr_object_error_quark(void);
extern  const gchar *ecnr_error_str(int code);
extern  gboolean report_ecnr_error(int status, const gchar * dbus_msg, GError ** error);
extern const gchar *qwa_rcs_error_str(int code);







#endif /* __ECNR_ERROR_H__ */
