/******************************************************************************
 * FILE        : ecnr-datapool-access.h
 * PROJECT     : Gen3 and Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2014 RBCM GMBH
 * HISTORY     :
 * Date        | Author                  | Modification
 * 14.04.2014  | Patrick Rey             | initial version
 *             |                         | data pool features handling
 *****************************************************************************/


#ifndef __ECNR_DATAPOOL_ACCESS_H__
#define __ECNR_DATAPOOL_ACCESS_H__



#define NB_ELEM_MAX             22

struct ecnr_dp_reg{
    void            (*ecnrdpFunc) (void);
    enum eDataPool   dp;
          gboolean   active;
};


struct ecnr_dp_header_infos
{
        int  sse_lib_version[4];
    guint16  bsd_file_length;
};

struct ecnr_dp_data_struct
{
     struct ecnr_dp_header_infos   hinfos;
                          guint8*  Data;
                         guint16   crc;
};


typedef         void   (*ecnrdpFuncCallback)(void);

/* data pool interface service functions */
extern           int   ecnr_datapool_access_reg_notification                 (                    void* pFunc,
                                                                                        enum eDataPool  dp);
extern          void   ecnr_datapool_access_init                             (void);
extern          void   ecnr_datapool_access_finalize                         (void);

/* data set content access functions */
extern unsigned char*  ecnr_datapool_access_get_bsd_dataset                  (          enum eDataPool  dp,
                                                                                               guint16* size_dataset,
                                                                                                   int* pversion,
                                                                                               guint16* crc);
extern           int   ecnr_datapool_access_get_bsd_dataset_size             (          enum eDataPool  dp);
extern           int   ecnr_datapool_access_get_engine_version               (      unsigned      char* data,
                                                                                                   int* version);
extern           int   ecnr_datapool_access_get_config_data_size             (      unsigned      char* data,
                                                                                               guint16* size);
extern           int   ecnr_datapool_access_get_config_data_crc              (                     int  crc_pos,
                                                                                    unsigned      char* data,
                                                                                               guint16* crc);
extern           int   ecnr_datapool_access_get_config_row_data_start_pos    (      unsigned      char* data,
                                                                                               guint16* size);
extern      gboolean   ecnr_datapool_access_compare_crc                      (          enum eDataPool  dp,
                                                                                               guint16  crc_in);
extern           int   ecnr_datapool_access_set_dp_size_dyn                  (          enum eDataPool  dpkey,
                                                                                                   int  dpsize);
extern           int   ecnr_datapool_access_get_dp_size_dyn                  (          enum eDataPool  dpkey,
                                                                                                   int* dpsize);

/* test function */
extern          void   ecnr_datapool_access_trigger_new_datapool             (          enum eDataPool  dp);
extern       guint16   ecnr_datapool_access_calc_crc_ccitt                   (const             guint8  data[],
                                                                                               guint16  length);
extern      gboolean   ecnr_datapool_access_calc_and_compare_crc_ccitt       (const             guint8  data[],
                                                                                               guint16  length,
                                                                                               guint16  crc);
extern          void   ecnr_datapool_access_print_datapool_infos             (void);
extern       guint32   ecnr_datapool_access_reload_dp_element                (          enum eDataPool  dpkey);
extern        size_t   ecnr_datapool_access_export_dp_to_file                (const             guint8* data,
                                                                                               guint16  length,
                                                                              const               char* exportfile);
extern          void   ecnr_datapool_import_from_bin_file                    (                gboolean  avail);



#endif /* __ECNR_DATAPOOL_ACCESS_H__ */
