/******************************************************************************
 * FILE        : ecnr-configuration.h
 * PROJECT     : Gen3 & Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 20.08.2013  | Patrick Rey            | initial version
 *             |                        | configuration features handling
 *****************************************************************************/

#ifndef __ECNR_CONFIGURATION_H__
#define __ECNR_CONFIGURATION_H__

#include "ecnr-types.h"

/*******************************************************************************
              DEFINES
*******************************************************************************/
#define D_FEATURE_DEV_CONF_MAX 5
#define D_CREATE_ALWAYS_DYN_SYNC_DATA


#if (defined (VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RIVIE) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI2) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV_LINUX) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART))
    #ifndef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_LSIM
        #define D_SUPPORT_PERIOD_PARAMETER
    #endif
#endif


/*******************************************************************************
              type definition
*******************************************************************************/

struct tcconfigData
{
    unsigned char       *data;
    unsigned int        size;
};

struct EcnrConfigFile
{
    enum eDataPool      EcnrdPBaseKey;
    const char          *file;
    unsigned char       delete_on_powerOn;
    unsigned int        dpsize;
    int                 select_io_pin;
    gboolean            select_logical_level;
};


struct EcnrConfig
{
  unsigned short              configId;
  const     char              *bsd_str;
  const     char              *opeth_str;
             int              (*vsetFunction) (void);
             int              (*vsetFunction_2) (void);
  struct tcconfigData         configData;
  unsigned short              EcnrKdsBaseKey;
  enum eDataPool              EcnrdPBaseKey;
};


#ifdef D_SUPPORT_GLOBAL_CONF_STRUCTURE
struct EcnrConfigFile_e
{
    enum eDataPool          EcnrdPBaseKey;
    const char              *bsd_str;
    const char              *opeth_str;
    struct tcconfigData     configData;
    unsigned char           delete_on_powerOn;
    int                     select_io_pin;
    gboolean                select_logical_level;
};

struct EcnrDataSet
{
    unsigned short              configId;
    enum eDataPool              EcnrdPBaseKey;
    unsigned int                (*vsetFunction) (void);
    unsigned int                (*vsetFunction_2) (void);
};


struct EcnrConfig_e
{
    struct EcnrConfigFile_e*    EcnrdpCfg;
    struct EcnrDataSet*         EcnrCfg;
    struct EcnrAppIds*          EcnrUsercfg;
};

#endif //D_SUPPORT_GLOBAL_CONF_STRUCTURE

struct EcnrAppIds
{
    unsigned char       EcnrAppId;
    unsigned short      EcnrAppConfId;
    unsigned short      EcnrConfId;
};

#define D_NB_IN_SYNC_DEV 1
#define D_NB_OUT_SYNC_DEV 1
#define D_NB_SYNC_DEV_PROP_MAX  (1 + (D_NB_IN_SYNC_DEV + D_NB_OUT_SYNC_DEV) * 5)
struct sync_stream_descriptor
{
    gchar              *in_adev[D_NB_IN_SYNC_DEV];
    gchar              *out_adev[D_NB_OUT_SYNC_DEV];
    guint32            prop_adev[D_NB_SYNC_DEV_PROP_MAX];
};

struct  stream_descriptor
{
    const char          *adev_name;
    enum ecnr_audio     stream_ch_Id;
};


struct ecnr_feature_cfg
{
    gboolean            is_device;
    gboolean            is_preFill;
    gboolean            is_sync_infos;
    guint               prefill_value;
#ifdef D_SUPPORT_PERIOD_PARAMETER
    guint               period_value;
#endif
    struct stream_descriptor str_desc[D_FEATURE_DEV_CONF_MAX];
    struct sync_stream_descriptor str_sync_desc;
};

struct ecnr_id_spec_feature
{
    unsigned short             config_id;
    struct ecnr_feature_cfg    feat_cfg_table;
};



/* return size of configuration buffer, return 0 if there is no available configuration to the passed ConfigId  */
extern int                      ecnr_configuration_get_configuration(unsigned short ConfigId, tecnrConfigData* pConfigData, gboolean* isdefault);
extern void                     ecnr_configuration_free_Configuration_Data(tecnrConfigData *ConfigData);
extern const struct EcnrConfig* ecnr_configuration_get_config_data(unsigned short configId);
extern guint8                   ecnr_configuration_get_config_class(unsigned short configId);
extern guint8                   ecnr_configuration_get_config_type(unsigned short configId);
extern guint8                   ecnr_configuration_get_config_instance(unsigned short configId);
extern guint8                   ecnr_configuration_get_config_feature(unsigned short configId);
extern guint                    ecnr_configuration_get_prefill(unsigned short config_id);
#ifdef D_SUPPORT_PERIOD_PARAMETER
extern guint                    ecnr_configuration_get_period(unsigned short config_id);
#endif
extern int                      ecnr_configuration_check_match_AppId_and_configId(unsigned short configId, unsigned char AppId);
extern int                      ecnr_configuration_check_AppId(unsigned char AppId);
extern int                      ecnr_configuration_check_ConfigId(short configId);
extern gboolean                 ecnr_sse_debug_check_enable_file(void);
extern void                     ecnr_configuration_print_config_data(void);
extern int                      ecnr_configuration_get_dp_size(enum eDataPool dpkey, int* dpsize);
extern int                      ecnr_configuration_init(void);
extern unsigned short           ecnr_configuration_get_ecnr_config_Id(unsigned short configId);
extern enum eDataPool           ecnr_configuration_get_dp(unsigned short configId);
extern gboolean                 ecnr_configuration_get_crc(enum eDataPool dpid, guint16* crc);
extern gboolean                 ecnr_configuration_get_crc_from_current_active_dataset(enum eDataPool dpid, guint16* crc);
extern int                      ecnr_configuration_print_all_dp_infos(void);
extern gchar*                   ecnr_configuration_get_in_devices(guchar ecnrAppId, gint ecnrConfigurationId, gboolean* isSyncDataMatching);
extern gchar*                   ecnr_configuration_get_out_devices(guchar ecnrAppId, gint ecnrConfigurationId, gboolean* isSyncDataMatching);
extern GArray*                  ecnr_configuration_get_device_properties(guchar ecnrAppId, gint ecnrConfigurationId, gboolean* isSyncDataMatching);
extern void                     ecnr_configuration_sync_data_clear(void);
extern int                      ecnr_configuration_retrieve_all_dp_size(void);
extern int                      ecnr_configuration_remove_bsd_file(const char* str);
extern int                      ecnr_configuration_read_default_configuration(const struct EcnrConfig* pdata, tecnrConfigData *pConfigData);

/* alsa device configuration help functions */
extern gchar*                   ecnr_configuration_get_default_dev_name(enum ecnr_audio ecnr_dev_id, gboolean* is_default_dev);
extern unsigned int             ecnr_configuration_get_default_num_channels(enum ecnr_audio ecnr_dev_id);
extern unsigned int             ecnr_configuration_get_default_active_channel(enum ecnr_audio ecnr_dev_id);
extern unsigned int             ecnr_configuration_get_default_dev_open_order(enum ecnr_audio ecnr_dev_id);
extern enum ecnr_audio          ecnr_configuration_get_dev_id(gchar * dev, snd_pcm_stream_t sdir);
extern int                      ecnr_configuration_check_match_dev_chid(enum ecnr_audio dev_id, gchar * dev);
extern void                     ecnr_configuration_print_user_config(void);
extern int                      ecnr_configuration_remove_crc_file(const char* str);
extern void                     ecnr_configuration_set_new_datapool(enum eDataPool dpid);



/* test function section */
#ifdef D_DP_NOTIFICATION_SUPPORT
extern int                      ecnr_configuration_stub_notify_dp_change(void);
#endif

#ifndef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_GMG3_LINUX
extern gboolean                 ecnr_configuration_ut_s2_1_1(void);
extern gboolean                 ecnr_configuration_ut_s2_1_2(void);
extern gboolean                 ecnr_configuration_ut_s2_1_3(void);
extern gboolean                 ecnr_configuration_ut_s2_1_4(void);
extern gboolean                 ecnr_configuration_ut_s2_1_5(void);
extern gboolean                 ecnr_configuration_ut_s2_1_6(void);
extern gboolean                 ecnr_configuration_ut_s2_1_7(void);
#endif



/* ecnr_cnfiguration specifical defines */
#define NEW_DP_FILE_BT_PHONE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_bt_phone_nb.txt"
#define NEW_DP_FILE_BT_PHONE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_bt_phone_wb.txt"
#define NEW_DP_FILE_BT_VOICE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_bt_voice_nb.txt"
#define NEW_DP_FILE_BT_VOICE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_bt_voice_wb.txt"
#define NEW_DP_FILE_BT_SIRI_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_bt_siri_nb.txt"
#define NEW_DP_FILE_BT_SIRI_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_bt_siri_wb.txt"
#define NEW_DP_FILE_CP_VOICE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_voice_nb.txt"
#define NEW_DP_FILE_CP_VOICE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_voice_wb.txt"
#define NEW_DP_FILE_CP_VOICE_SWB  "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_voice_swb.txt"
#define NEW_DP_FILE_CP_PHONE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_phone_nb.txt"
#define NEW_DP_FILE_CP_PHONE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_phone_wb.txt"
#define NEW_DP_FILE_CP_PHONE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_phone_swb.txt"
#define NEW_DP_FILE_CP_FTIME_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_cp_ftime_swb.txt"
#define NEW_DP_FILE_AA_VOICE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_aa_voice_nb.txt"
#define NEW_DP_FILE_AA_VOICE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_aa_voice_wb.txt"
#define NEW_DP_FILE_AA_VOICE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_aa_voice_swb.txt"
#define NEW_DP_FILE_AA_PHONE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_aa_phone_nb.txt"
#define NEW_DP_FILE_AA_PHONE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_aa_phone_wb.txt"
#define NEW_DP_FILE_AA_PHONE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_aa_phone_swb.txt"
#define NEW_DP_FILE_INT_VOICE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_int_voice_nb.txt"
#define NEW_DP_FILE_INT_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_int_voice_wb.txt"
#define NEW_DP_FILE_WUW_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_wuw_voice_wb.txt"
#define NEW_DP_FILE_VPA_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_new_dp_vpa_voice_wb.txt"


#define CRC_DP_FILE_BT_PHONE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_bt_phone_nb.txt"
#define CRC_DP_FILE_BT_PHONE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_bt_phone_wb.txt"
#define CRC_DP_FILE_BT_VOICE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_bt_voice_nb.txt"
#define CRC_DP_FILE_BT_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_bt_voice_wb.txt"
#define CRC_DP_FILE_BT_SIRI_NB     "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_bt_siri_nb.txt"
#define CRC_DP_FILE_BT_SIRI_WB     "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_bt_siri_wb.txt"
#define CRC_DP_FILE_CP_VOICE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_voice_nb.txt"
#define CRC_DP_FILE_CP_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_voice_wb.txt"
#define CRC_DP_FILE_CP_VOICE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_voice_swb.txt"
#define CRC_DP_FILE_CP_PHONE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_phone_nb.txt"
#define CRC_DP_FILE_CP_PHONE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_phone_wb.txt"
#define CRC_DP_FILE_CP_PHONE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_phone_swb.txt"
#define CRC_DP_FILE_CP_FTIME_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_cp_ftime_swb.txt"
#define CRC_DP_FILE_AA_VOICE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_aa_voice_nb.txt"
#define CRC_DP_FILE_AA_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_aa_voice_wb.txt"
#define CRC_DP_FILE_AA_VOICE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_aa_voice_swb.txt"
#define CRC_DP_FILE_AA_PHONE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_aa_phone_nb.txt"
#define CRC_DP_FILE_AA_PHONE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_aa_phone_wb.txt"
#define CRC_DP_FILE_AA_PHONE_SWB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_aa_phone_swb.txt"
#define CRC_DP_FILE_INT_VOICE_NB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_int_voice_nb.txt"
#define CRC_DP_FILE_INT_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_int_voice_wb.txt"
#define CRC_DP_FILE_WUW_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_wuw_voice_wb.txt"
#define CRC_DP_FILE_VPA_VOICE_WB   "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_crc_dp_vpa_voice_wb.txt"


#define EXPORT_DP_FILE_BT_PHONE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_export_dp_bt_phone_nb.txt"
#define IMPORT_BIN_FILE_BT_PHONE_NB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_import_dp_bt_phone_nb.bin"
#define IMPORT_BIN_FILE_BT_PHONE_WB    "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_import_dp_bt_phone_wb.bin"

#endif /* __ECNR_CONFIGURATION_H__ */
