/******************************************************************************
 * FILE        : ecnr-audio-rts-handler.h
 * PROJECT     : Gen3 & Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2014 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 06.01.2014  | Patrick Rey            | initial version
 *             |                        | RTS library handling features
 *****************************************************************************/

#ifndef __ECNR_AUDIO_RTS_HANDLER_H__
#define __ECNR_AUDIO_RTS_HANDLER_H__


extern  int  ecnr_audio_rts_handler_init(void);
extern  int  ecnr_audio_rts_handler_create(stecnr_alsa_state* state, gboolean log);
extern  int  ecnr_audio_rts_handler_destroy(stecnr_alsa_state* state);
extern  int  ecnr_audio_rts_handler_recover(stecnr_alsa_state* state);
extern  int  ecnr_audio_rts_handler_read(void * buffer[]);
extern  int  ecnr_audio_rts_handler_write(void * buffer[]);
extern  int  ecnr_audio_rts_handler_statistic_get(trts_stat *stat);
extern  int  ecnr_audio_rts_get_state(stecnr_alsa_state* state);
extern  void ecnr_audio_rts_handler_print_config_data(void);
extern  int  ecnr_audio_rts_handler_get_xrun(unsigned int *xrun);
extern  int  ecnr_audio_rts_handler_streaming_rw_state_get(int* wrount, int* rdcount);
extern  int  ecnr_audio_rts_handler_clear_xrun(void);
extern  void ecnr_audio_rts_handler_performance_enable(gboolean state);




#endif //__ECNR_AUDIO_RTS_HANDLER_H__
