//
// CCA_Service.h
//
//  Created on: Jan 12, 2015
//      Author: Martin Koch, Fa. ESE
//

#ifndef CCA_SERVICE_H_
#define CCA_SERVICE_H_


#include "CCA_TargetBase.h"
#include <list>

class fi_tclMessageBase;
class amt_tclServiceRegister;


namespace FIMessaging  {

   // --------------------------------------------------------------------------

namespace /* FIMessaging:: */ CCA
{

   // --------------------------------------------------------------------------

   class Service : public TargetBase
   {
      public:
         /* constructor */ Service (Node& node, ITarget& externalTarget);
         virtual /* destructor */ ~Service ();

         // callback for application state changes
         virtual void vOnNewAppState (tU32 u32AppState);

         // callback function for incoming messages (overrides TargetBase)
         virtual void vOnNewMessage (amt_tclServiceData& oSvcData);

         // ISender implementation - send outgoing message
         virtual void    vSetServiceAvailable (bool bIsAvailable);
         //  - direct server responses (MethodResult, Status, Error) - must echo the responseID from command
         virtual bool     bPostFIResult (const fi_tclMessageBase& fiMsg, uint16_t responseID);
         //  - spontaneous server notifications (Status) for registered clients
         virtual bool     bNotifyClients (const fi_tclMessageBase& fiMsg);
         // - dummy implementation of client message
         virtual uint16_t u16PostFICommand (const fi_tclMessageBase& fiMsg);

         #define ServiceRegisterSize 26    // AMT_C_U32_BASEMSG_ABSMSGSIZE + AMT_C_U32_SVCREGISTER_RELMSGSIZE
         struct tMemorizedRegisterMsg
         {
            tU8 byte[ServiceRegisterSize];

            /* default constructor */ tMemorizedRegisterMsg ();
         };
         typedef std::list<tMemorizedRegisterMsg> PendingRegistrationList;
         static void vPostponeRegisterMsg (const amt_tclServiceRegister& regMsg);
         void vGetPostponedRegisters (PendingRegistrationList& pendingRegistrations);

      private:
         // private helper types
         class   NotificationTable;
         class   MessageTracker;

         // prohibit copy - implementation intentionally missing
         /* copy constructor */ Service (const Service&);
         Service& /* assignment */ operator= (const Service&);

         // member variables
         bool                 _bServiceAvailable;
         NotificationTable*   _pNotifications;
         MessageTracker*      _pMessageTracker;

         static PendingRegistrationList delayedRegisterMessages;
   };

   // --------------------------------------------------------------------------

}  }  // namespace FIMessaging::CCA


#endif /* CCA_SERVICE_H_ */
