//
// ITarget.h
//
//  Created on: Jan 22, 2015
//      Author: Martin Koch, Fa. ESE
//

#ifndef ITARGET_H_
#define ITARGET_H_


namespace FIMessaging
{

   // --------------------------------------------------------------------------

   class ISender;

   // --------------------------------------------------------------------------
   //
   //                    I M e s s a g e - T a r g e t
   //
   // Interface to be provided by users (Clients/Services) of INode
   //

   /* required interface */ class ITarget
   {
      protected:
         /* constructor */ ITarget ()  {}

      public:
         virtual /* destructor */ ~ITarget ()  {}

         // return ID and version of either provided or requested service
         virtual ServiceInfo GetServiceInfo () const = 0;

         // distinguish clients from services:
         virtual bool bProvidesService () const = 0;

         // callback functions for connection state changes
         virtual void vOnConnect () = 0;
         virtual void vOnDisconnect () = 0;

         // callback function for incoming messages
         virtual void vOnNewMessage (const FIMessage& oMsg) = 0;

         // callback function to obtain message sender interface provided by Node
         // (will be called internally during INode::poAddTarget())
         virtual void vSetAssociatedSender (ISender* pSender) = 0;

         // disclose list of properties which should be UpReg'ed automatically
         // (meaningful for clients only; services implement as dummy returning {NULL, 0})
         struct AutoRegisterList
         {
            tU16*    pFunctionList;  // list Function-IDs only
            uint32_t u32ListSize;    // number of functions-IDs in list

            inline /* constructor */ AutoRegisterList (tU16* pList, uint32_t size)
               : pFunctionList(pList)
               , u32ListSize(size)
            {  }
         };
         virtual AutoRegisterList GetAutoRegisterList () = 0;
   };

   // --------------------------------------------------------------------------

}  // namespace FIMessaging

#endif /* ITARGET_H_ */
