//
// IRxPollingThread.h
//
//  Created on: Aug 27, 2015
//      Author: Martin Koch, Fa. ESE
//

#ifndef IRXPOLLINGTHREAD_H_
#define IRXPOLLINGTHREAD_H_

// Message processing is done in the application following its logic.
// In order to allow efficient single-threaded processing of not only incoming messages
// a thread external to the node shall be used for message polling and dispatching.
// This thread shall expose IRxPollingThread and invoke .


namespace FIMessaging
{
   // --------------------------------------------------------------------------
   //
   //                    I R x - P o l l i n g - T h r e a d
   //
   // Required Interface to be provided by applications using INode objects
   //
   //  Rx-loop shall manage message polling
   //

   /* required interface */ class IRxPollingThread
   {
      protected:
         /* inline constructor */ IRxPollingThread ()  {}

      public:
         virtual /* destructor */ ~IRxPollingThread ()  {}


         // Notification function to be called when a new message arrives
         virtual void vRxNotificationCallback () = 0;
   };

   // --------------------------------------------------------------------------

}  // namespace FIMessaging


#endif /* IRXPOLLINGTHREAD_H_ */
