//
// INode.h
//
// Public interface for generic messaging nodes, such as CCA_Node
//
//  Created on: Dec 5, 2014
//      Author: Martin Koch, Fa. ESE
//

#ifndef INode_H_
#define INode_H_

#define INVALID_RESPONSE_ID 0xFFFF


namespace FIMessaging
{

   class ITarget;
   class ISender;


   // --------------------------------------------------------------------------
   //
   //                    I M e s s a g i n g - N o d e
   //
   // Interface of INode specializations (CCA, INC, etc)
   //

   /* provided interface */ class INode
   {
      protected:
         /* constructor */ INode ()  {}
         virtual /* destructor */ ~INode ()  {}

      public:
         // cannot delete directly - use this instead.
         // It will delete the object when no more references are in use
         virtual void vReleaseInstance () = 0;

         // Dynamically add/remove clients / services
         virtual ISender* poAddTarget (ITarget& target) = 0;
         virtual void vRemoveTarget (ITarget& target) = 0;  // invalidates previous pointer

         // Retrieve incoming message from queue and dispatch it to application logic.
         // To be called from external worker thread.
         virtual bool bPollAndDispatchMessage () = 0;
   };

   // --------------------------------------------------------------------------

}  // namespace FIMessaging


#endif /* INode_H_ */
