#include <glib/gi18n.h>
#include <glib.h>
#include <alsa/asoundlib.h>
#include "apl.h"
#include "apl-main.h"
#include "apl-internal.h"
#include "apl-volume.h"





//LOCAL  module_desc this_modul_desc;

typedef struct _mydata
{
    tAplI32                 this_switch;
    aplAudioSamples_desc*   buf_desc;
    tAplI32                 mparam_aplvolumeSwitch;            /*  0x0200   WB,(tAplI32)*/
    tAplU16                 mparam_aplFrameShiftIn;             /*  10       WB,(tAplU16)*/
    tAplU16                 mparam_aplSampleRateIn;             /*  11       WB,(tAplU16)*/
    tAplU16                 mparam_aplChannelCntIn;             /*  12       WB,(tAplU16)*/
    tAplU16                 mparam_aplAudioPcmFormatIn;         /*  13       WB,(tAplU16)*/
    tAplU16                 mparam_aplFrameShiftOut;            /*  20       WB,(tAplU16)*/
    tAplU16                 mparam_aplSampleRateOut;            /*  21       WB,(tAplU16)*/
    tAplU16                 mparam_aplChannelCntOut;            /*  22       WB,(tAplU16)*/
    tAplU16                 mparam_aplAudioPcmFormatOut;        /*  23       WB,(tAplU16)*/
}mydata;


LOCAL mydata* module_data_inst = (mydata*)NULL;
LOCAL tAplBool create_own_stream_buffer = aplFALSE;


/*******************************************************************************
*
* FUNCTION: apl_volume_prepare
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_volume_prepare(void* data, void* mdata)//,  const tAplCfg* paplCfg)
{
    unsigned int             i = 0;

    pr_debug("ENTERED\n");

    struct aplMainStruct*  aplh = (struct aplMainStruct*)data;

    if(!aplh)
    {
        pr_debug("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }
    if(!module_data_inst->buf_desc)
    {
        pr_debug(" module stream buffer descriptor not available \n");
        return APL_ERR_NULL_POINTER;
    }
    /* initialize volume intern data  */

    module_data_inst->mparam_aplFrameShiftIn        = aplh->par_aplFrameShiftIn;
    module_data_inst->mparam_aplSampleRateIn        = aplh->par_aplSampleRateIn;
    module_data_inst->mparam_aplChannelCntIn        = aplh->par_aplChannelCntIn;
    module_data_inst->mparam_aplAudioPcmFormatIn    = aplh->par_aplAudioPcmFormatIn;
    module_data_inst->mparam_aplFrameShiftOut       = aplh->par_aplFrameShiftOut;
    module_data_inst->mparam_aplSampleRateOut       = aplh->par_aplSampleRateOut;
    module_data_inst->mparam_aplChannelCntOut       = aplh->par_aplChannelCntOut;
    module_data_inst->mparam_aplAudioPcmFormatOut   = aplh->par_aplAudioPcmFormatOut;


    /* initialize volume stream buffer */
    module_data_inst->buf_desc->apl_stream_nb_ch    = aplh->par_aplChannelCntOut;
    module_data_inst->buf_desc->apl_audio_format    = (snd_pcm_format_t)aplh->par_aplAudioPcmFormatOut;
    module_data_inst->buf_desc->apl_sample_rate     = aplh->par_aplSampleRateOut;
    module_data_inst->buf_desc->apl_period_size     = aplh->par_aplFrameShiftOut;

    /* create streaming buffer */
    if(create_own_stream_buffer)
    {
        if(!module_data_inst->buf_desc->apl_stream_nb_ch)
            return APL_ERR_INVALID_CHANNEL_NUMBER;

        for(i = 0; i < module_data_inst->buf_desc->apl_stream_nb_ch; i++)
        {
            if(module_data_inst->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE)
            {
                pr_debug("create s16 stream buffer[%d] with size(%d)\n", i, module_data_inst->buf_desc->apl_period_size);
                module_data_inst->buf_desc->s16audiosamples[i] = g_malloc0(module_data_inst->buf_desc->apl_period_size * sizeof(short));
            }
            else if(module_data_inst->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE)
            {
                pr_debug("create s32 stream buffer[%d] with size(%d)\n", i, module_data_inst->buf_desc->apl_period_size);
                module_data_inst->buf_desc->s32audiosamples[i] = g_malloc0(module_data_inst->buf_desc->apl_period_size * sizeof(long));
            }
            else
            {
                pr_debug("streaming format mismatch \n");
                return APL_ERR_AUDIO_STREAM_FORMAT_MISMATCH;
            }
        }
    }
    (void)mdata;
    return APL_ERR_OK;
}


/*******************************************************************************
*
* FUNCTION: apl_volume_get_buffer
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL aplAudioSamples_desc* apl_volume_get_buffer(void* data)
{
    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return (aplAudioSamples_desc*)NULL;
    }

    mydata* mdata = (mydata*)data;

  /* currently only one instance supported */
    if(mdata->this_switch != aplvolumeSwitch)
        return (aplAudioSamples_desc*)NULL;

    return mdata->buf_desc;
}
/*******************************************************************************
*
* FUNCTION: apl_volume_final
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_volume_finalize(void* data)
{
    unsigned int        i = 0;

    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_MODULE_NOT_INITIALIZED;
    }

    mydata* mdata = (mydata*)data;


    if(mdata->buf_desc)
    {
        if(create_own_stream_buffer)
        {
            /* delete streaming buffer */
            for(i = 0; i < module_data_inst->buf_desc->apl_stream_nb_ch; i++)
            {
                if(module_data_inst->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE)
                {
                    short int* s16buf = module_data_inst->buf_desc->s16audiosamples[i];
                    if(s16buf)
                        g_free(s16buf);

                }
                else if(module_data_inst->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE)
                {
                    long int* s32buf = module_data_inst->buf_desc->s32audiosamples[i];
                    if(s32buf)
                        g_free(s32buf);
                }
            }
        }

        g_free(mdata->buf_desc);
        mdata->buf_desc = NULL;
    }

    g_free(mdata);

    return APL_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: apl_volume_get_property
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS   apl_volume_get_property
(
    void* data,
    tAplDataID iDataID,
    tAplU32* pulSize,
    void* pData
)
{
    tAplI32 i32value;

    pr_debug("ENTERED\n");

    if(!data)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    mydata* mdata = (mydata*)data;

    if(mdata->this_switch != aplvolumeSwitch)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    switch(iDataID)
    {
        case aplvolumeSwitch:
            *pulSize = sizeof(tAplI32);
            i32value = mdata->mparam_aplvolumeSwitch;
            memcpy(pData, (void*)&i32value, *pulSize);
            break;
        default:
            break;
    }

    return APL_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: apl_volume_set_property
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL   APL_STATUS   apl_volume_set_property
(
    void* data,
    tAplInt iDataID,
    tAplU32 ulSize,
    const void* pData
)
{
    pr_debug("ENTERED\n");

    if(!data)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    mydata* mdata = (mydata*)data;
    if(mdata->this_switch != aplvolumeSwitch)
        return APL_ERR_MODULE_NOT_INITIALIZED;


    switch(iDataID)
    {
        case aplvolumeSwitch:
            memcpy((void*)&(mdata->mparam_aplvolumeSwitch), pData , ulSize);
            break;
        default:
            break;
    }

    return APL_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: apl_volume_s16AudioTransfert
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_volume_s16AudioTransfert
(
    const aplAudioSamples_desc*   inAudio,
    aplAudioSamples_desc*   outAudio,
    tAplBool                can_swap
)
{
    unsigned int    i;
    APL_STATUS      status = APL_ERR_OK;
    short int*      s16ibuf;
    short int*      s16obuf;
    unsigned int    sample_cnt = 0;
    unsigned int    stream_cnt = 0;


    pr_debug("ENTERED\n");

    if(!inAudio)
        return APL_ERR_NULL_POINTER ;

    if(!outAudio)
        return APL_ERR_NULL_POINTER ;

    s16ibuf = inAudio->s16audiosamples[0];
    if(!s16ibuf)
    {
        pr_debug("No input data stream buffer available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(outAudio->apl_period_size <  inAudio->apl_period_size)
    {
        pr_critical("mismatch in size out_stream(%d) and in_stream(%d) \n", outAudio->apl_period_size, inAudio->apl_period_size);
        return APL_ERR_AUDIO_BUFFER_MISMATCH;
    }

    /* in stream and out stream are aligned */
    if(   (outAudio->apl_stream_nb_ch == inAudio->apl_stream_nb_ch)
        ||(outAudio->apl_stream_nb_ch > inAudio->apl_stream_nb_ch ))
    {
       stream_cnt =  inAudio->apl_stream_nb_ch;
    }
    else if(outAudio->apl_stream_nb_ch < inAudio->apl_stream_nb_ch)
    {
       stream_cnt =  outAudio->apl_stream_nb_ch;
       pr_warning(" mismatch nb channel out_stream(%d) and in_stream(%d)\n",outAudio->apl_stream_nb_ch, inAudio->apl_stream_nb_ch );
    }

    for( i = 0; i < stream_cnt ; i++)
    {
        if(   (outAudio->apl_period_size ==  inAudio->apl_period_size)
            ||(outAudio->apl_period_size >  inAudio->apl_period_size))
        {
            sample_cnt = inAudio->apl_period_size;

            if(can_swap)
            {
                pr_debug ("swap stream buffer[%d]\n", i);

                s16ibuf = inAudio->s16audiosamples[i];
                outAudio->s16audiosamples[i] = s16ibuf;
            }
            else
            {
                pr_debug("copy %d s16 sample to out stream s16 buffer[%d]\n", sample_cnt, i);

                s16ibuf = inAudio->s16audiosamples[i];
                s16obuf = outAudio->s16audiosamples[i];
                memcpy((void*)s16obuf, (void*)s16ibuf, sample_cnt * sizeof(short int));
            }
        }
        else
        {
            pr_critical(" mismatch between nb of in_stream(%d) and out_strem(%d) samples \n", inAudio->apl_period_size, outAudio->apl_period_size);
        }
    }

    return status;
}


/*******************************************************************************
*
* FUNCTION: apl_volume_is16os32AudioTransfert
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/

LOCAL APL_STATUS apl_volume_is16os32AudioTransfert
(
    const aplAudioSamples_desc*   inAudio,
    const aplAudioSamples_desc*   outAudio
)
{
    unsigned int    i, j;
    APL_STATUS      status = APL_ERR_OK;
    short int*      s16ibuf;
    long int*       s32obuf;
    unsigned int    sample_cnt = 0;
    unsigned int    stream_cnt = 0;

    pr_debug("ENTERED\n");

    if(!inAudio)
        return APL_ERR_NULL_POINTER ;

    if(!outAudio)
        return APL_ERR_NULL_POINTER ;


    s16ibuf = inAudio->s16audiosamples[0];
    if(!s16ibuf)
    {
        pr_debug("No input data stream buffer available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(outAudio->apl_period_size <  inAudio->apl_period_size)
    {
        pr_critical("mismatch in size out_stream(%d) and in_stream(%d) \n", outAudio->apl_period_size, inAudio->apl_period_size);
        return APL_ERR_AUDIO_BUFFER_MISMATCH;
    }

    /* in stream and out stream are aligned */
    if(   (outAudio->apl_stream_nb_ch == inAudio->apl_stream_nb_ch)
        ||(outAudio->apl_stream_nb_ch > inAudio->apl_stream_nb_ch ))
    {
       stream_cnt =  inAudio->apl_stream_nb_ch;
    }
    else if(outAudio->apl_stream_nb_ch < inAudio->apl_stream_nb_ch)
    {
       stream_cnt =  outAudio->apl_stream_nb_ch;
       pr_warning(" mismatch nb channel out_stream(%d) and in_stream(%d)\n",outAudio->apl_stream_nb_ch, inAudio->apl_stream_nb_ch );
    }

    for( i = 0; i < stream_cnt ; i++)
    {
        if(   (outAudio->apl_period_size ==  inAudio->apl_period_size)
            ||(outAudio->apl_period_size >  inAudio->apl_period_size))
        {
            sample_cnt = inAudio->apl_period_size;

            pr_debug("copy %d s16 sample to stream s32 buffer[%d]\n", sample_cnt, i);

            s16ibuf = inAudio->s16audiosamples[i];
            s32obuf = outAudio->s32audiosamples[i];
            for (j = 0; j < sample_cnt; j++)
                *s32obuf++ = *s16ibuf++;
        }
        else
        {
            pr_critical(" mismatch between nb of in_stream(%d) and out_strem(%d) samples \n", inAudio->apl_period_size, outAudio->apl_period_size);
        }
    }

    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_volume_s32AudioTransfert
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/

LOCAL APL_STATUS apl_volume_s32AudioTransfert
(
    const aplAudioSamples_desc*     inAudio,
    aplAudioSamples_desc*           outAudio,
    tAplBool                        can_swap
)
{
    unsigned int    i;
    APL_STATUS      status = APL_ERR_OK;
    long int*       s32ibuf;
    long int*       s32obuf;
    unsigned int    sample_cnt = 0;
    unsigned int    stream_cnt = 0;


    pr_debug("ENTERED\n");

    if(!inAudio)
        return APL_ERR_NULL_POINTER ;

    if(!outAudio)
        return APL_ERR_NULL_POINTER ;


    s32ibuf = inAudio->s32audiosamples[0];
    if(!s32ibuf)
    {
        pr_debug("No input data stream buffer available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(outAudio->apl_period_size <  inAudio->apl_period_size)
    {
        pr_critical("mismatch in size out_stream(%d) and in_stream(%d) \n", outAudio->apl_period_size, inAudio->apl_period_size);
        return APL_ERR_AUDIO_BUFFER_MISMATCH;
    }

    /* in stream and out stream are aligned */
    if(   (outAudio->apl_stream_nb_ch == inAudio->apl_stream_nb_ch)
        ||(outAudio->apl_stream_nb_ch > inAudio->apl_stream_nb_ch ))
    {
       stream_cnt =  inAudio->apl_stream_nb_ch;
    }
    else if(outAudio->apl_stream_nb_ch < inAudio->apl_stream_nb_ch)
    {
       stream_cnt =  outAudio->apl_stream_nb_ch;
       pr_warning(" mismatch nb channel out_stream(%d) and in_stream(%d)\n",outAudio->apl_stream_nb_ch, inAudio->apl_stream_nb_ch );
    }

    for( i = 0; i < stream_cnt ; i++)
    {
        if(   (outAudio->apl_period_size ==  inAudio->apl_period_size)
            ||(outAudio->apl_period_size >  inAudio->apl_period_size))
        {
            sample_cnt = inAudio->apl_period_size;

            if(can_swap)
            {
                pr_debug ("swap stream buffer[%d]\n", i);

                s32ibuf = inAudio->s32audiosamples[i];
                outAudio->s32audiosamples[i] = s32ibuf;
            }
            else
            {
                pr_debug("copy %d s32 sample to out stream s32 buffer[%d]\n", sample_cnt, i);

                s32ibuf = inAudio->s32audiosamples[i];
                s32obuf = outAudio->s32audiosamples[i];
                memcpy((void*)s32obuf, (void*)s32ibuf, sample_cnt * sizeof(short int));
            }
        }
        else
        {
            pr_critical(" mismatch between nb of in_stream(%d) and out_strem(%d) samples \n", inAudio->apl_period_size, outAudio->apl_period_size);
        }
    }

    return status;
}


/*******************************************************************************
*
* FUNCTION: apl_volume_is32os16AudioTransfert
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/

LOCAL APL_STATUS apl_volume_is32os16AudioTransfert
(
    const aplAudioSamples_desc*   inAudio,
    const aplAudioSamples_desc*   outAudio
)
{
    unsigned int    i, j;
    APL_STATUS      status = APL_ERR_OK;
    long int*       s32ibuf;
    short int*      s16obuf;
    unsigned int    sample_cnt = 0;
    unsigned int    stream_cnt = 0;


    pr_debug("ENTERED\n");

    if(!inAudio)
        return APL_ERR_NULL_POINTER ;

    if(!outAudio)
        return APL_ERR_NULL_POINTER ;


    if(!inAudio->s32audiosamples[0])
    {
        pr_debug("inAudio->s32audiosamples[0] is NULL \n");
        return APL_ERR_NULL_POINTER;
    }

    s32ibuf = inAudio->s32audiosamples[0];
    if(!s32ibuf)
    {
        pr_debug("No input data stream buffer available \n");
        return APL_ERR_NULL_POINTER;
    }

    /* in stream and out stream are aligned */
    if(   (outAudio->apl_stream_nb_ch == inAudio->apl_stream_nb_ch)
        ||(outAudio->apl_stream_nb_ch > inAudio->apl_stream_nb_ch ))
    {
       stream_cnt =  inAudio->apl_stream_nb_ch;
    }
    else if(outAudio->apl_stream_nb_ch < inAudio->apl_stream_nb_ch)
    {
       stream_cnt =  outAudio->apl_stream_nb_ch;
       pr_warning(" mismatch nb channel out_stream(%d) and in_stream(%d)\n",outAudio->apl_stream_nb_ch, inAudio->apl_stream_nb_ch );
    }

    for( i = 0; i < stream_cnt ; i++)
    {
        if(   (outAudio->apl_period_size ==  inAudio->apl_period_size)
            ||(outAudio->apl_period_size >  inAudio->apl_period_size))
        {
            sample_cnt = inAudio->apl_period_size;

            pr_debug("copy %d s32 sample to stream s16 buffer[%d]\n", sample_cnt, i);

            s32ibuf = inAudio->s32audiosamples[i];
            s16obuf = outAudio->s16audiosamples[i];
            for (j = 0; j < sample_cnt; j++)
                *s16obuf++ = (short int)*s32ibuf++;
        }
        else
        {
            pr_critical(" mismatch between nb of in_stream(%d) and out_strem(%d) samples \n", inAudio->apl_period_size, outAudio->apl_period_size);
        }
    }

    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_volume_process
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_volume_process
(
    void* data,
    const aplAudioSamples_desc* inAudio
)
{

    APL_STATUS status = APL_ERR_OK;
    tAplBool can_swap  = aplTRUE;

    pr_debug("ENTERED\n");

    if(!data)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    module_desc*            this_module = (module_desc*)data;
    mydata*                 mdata = this_module->data;

    if(create_own_stream_buffer)
        can_swap  = aplFALSE;


    if(   (inAudio->apl_audio_format == SND_PCM_FORMAT_S16_LE)
        &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE))
    {

        status = apl_volume_s16AudioTransfert(inAudio, mdata->buf_desc, can_swap);
    }
    else if(  (inAudio->apl_audio_format == SND_PCM_FORMAT_S16_LE)
            &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE))
    {
        status = apl_volume_is16os32AudioTransfert(inAudio, mdata->buf_desc);
    }
    else if(  (inAudio->apl_audio_format == SND_PCM_FORMAT_S32_LE)
            &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE))
    {
        status = apl_volume_s32AudioTransfert(inAudio, mdata->buf_desc, can_swap);
    }
    else if(  (inAudio->apl_audio_format == SND_PCM_FORMAT_S32_LE)
            &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE))
    {
        pr_warning("there a lost of data, s32_in -> s16_out\n");
        status = apl_volume_is32os16AudioTransfert(inAudio, mdata->buf_desc);
    }
    else
    {
        /* do nothing */
    }


    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_volume_notification
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL tAplBool apl_volume_notification
(
    void*       data,
    tAplInt*    piDataID,
    tAplAction* paplAct
)
{
    pr_debug("No implmentation available\n");

    (void)data;
    (void)piDataID;
    (void)paplAct;

    return aplFALSE;
}

/*******************************************************************************
*
* FUNCTION: apl_volume_initialize
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
EXPORT module_desc* apl_volume_initialize(void)
{
    module_desc*  this_modul_desc = (module_desc*)NULL ;

    pr_debug("ENTERED\n");

    this_modul_desc = g_malloc0(sizeof(module_desc));

    if(!this_modul_desc)
    {
        pr_critical("fails while allocating memory for new module descriptor\n");
        return (module_desc*)NULL;
    }

    this_modul_desc->associated_switch          = aplvolumeSwitch;
    this_modul_desc->state                = apl_state_setup;
    this_modul_desc->aplopmode                  = APL_OM_PROD_CONS;
    this_modul_desc->apl_module_prepare          = apl_volume_prepare;
    this_modul_desc->apl_module_process          = apl_volume_process;
    this_modul_desc->apl_module_finalize      = apl_volume_finalize;
    this_modul_desc->apl_module_get_buffer      = apl_volume_get_buffer;
    this_modul_desc->apl_module_get_property    = apl_volume_get_property;
    this_modul_desc->apl_module_set_property  = apl_volume_set_property;
    this_modul_desc->apl_module_notification  = apl_volume_notification;

    this_modul_desc->next        = (void*)NULL;
    this_modul_desc->prev        = (void*)NULL;

    module_data_inst = g_malloc0(sizeof(mydata));

    if(!module_data_inst)
    {
        pr_critical("fails while allocating memory for new buffer descriptor\n");
        return (module_desc*)NULL;
    }

    module_data_inst->this_switch = aplvolumeSwitch;
    module_data_inst->buf_desc = g_malloc0(sizeof(aplAudioSamples_desc));
    create_own_stream_buffer = aplTRUE;

    /* setup stream audio buffer in buffer descriptor
     * not required in thsi module because not new audio data are processed
     * buffer pointer s16/s32audiosamplesinput hold a pointer of the input streaming buffer
     * so it can be return with the function call get_buffer()
    */
    this_modul_desc->data = (void*)module_data_inst;

    return this_modul_desc;
}

/*******************************************************************************
*
* FUNCTION: apl_volume_is_inst_available
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
EXPORT tAplBool apl_volume_is_inst_available(tAplI32 aplswitch)
{
    tAplBool status = aplFALSE;

    pr_debug("ENTERED\n");

    if(!module_data_inst)
        return status;

    if(module_data_inst->this_switch == aplswitch)
    {
        pr_debug(" the module volume is available for switch: %d\n", aplswitch);
        status = aplTRUE;
    }
    return status;
}
