#include <glib/gi18n.h>
#include <glib.h>
#include <alsa/asoundlib.h>
#include "apl-main.h"
#include "apl-internal.h"
#include "apl-parameter-factory.h"
#include "apl-micro-level.h"
#include "apl-pcm-copy.h"
#include "apl-volume.h"
#include "apl-arkamys.h"






/*******************************************************************************
*
* FUNCTION: apl_parameter_get_data
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_get_data
(
    struct aplMainStruct*   hApl,
    const tAplDataID        DataID,
    tAplInt                 iChannel,
    unsigned int*           pSize,
    void*                   pData
)
{
    APL_STATUS            status = APL_ERR_OK;

    pr_debug("ENTERED\n");

    if(!hApl)
        return APL_ERR_INVALID_MAIN_STRUCT;

//    g_mutex_lock(&hApl->lock);

    /* extract module Id */
    tAplU8 u8Moduleid = (tAplU8)(DataID >> 8) ;

    pr_debug("extract groupeId(%d)out of dataId(0x%x)\n", u8Moduleid, DataID);

    switch(u8Moduleid)
    {
        case aplGeneralGrp:
            status = apl_parameter_general_get(hApl, DataID, iChannel, pSize, pData);
            break;
        case aplModuleMicLvl:
            status = apl_parameter_Mic_Lvl_get(hApl, DataID, iChannel, pSize, pData);
            break;
        case aplModuleArkamys:
            status = apl_parameter_Arkamys_get(hApl, DataID, iChannel, pSize, pData);
            break;
        case aplModulePcmCopy:
            status = apl_parameter_PcmCopy_get(hApl, DataID, iChannel, pSize, pData);
            break;
        case aplModuleVolume:
            status = apl_paramteer_Volume_get(hApl, DataID, iChannel, pSize, pData);
            break;
        default:
            break;
    }

//    g_mutex_unlock(&hApl->lock);

    return status;
}



/*******************************************************************************
*
* FUNCTION: apl_parameter_set_data
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_set_data
(
    struct aplMainStruct*   hApl,
    const tAplDataID        DataID,
    const int               iChannel,
    const unsigned int      iSize,
    const void*             pData
)
{
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED\n");

    if(!hApl)
        return APL_ERR_INVALID_MAIN_STRUCT;

    if(!pData)
        return APL_ERR_NULL_POINTER;

//    g_mutex_lock(&hApl->lock);

    /* extract module Id */
    tAplU8  u8Moduleid = (tAplU8)(DataID >> 8) ;

    if(iSize <= 4)
    {
        int value = 0;
        memcpy((void*)&value, (void*)pData, iSize);
        pr_message("module_id -> %d associated to parameter -> 0x%x with size -> %d and value -> %d\n", u8Moduleid, DataID, iSize, value);
    }
    else
    {
        pr_message("module_id -> %d associated to parameter -> 0x%x with size -> %d\n", u8Moduleid, DataID, iSize);
    }

    switch(u8Moduleid)
    {
        case aplGeneralGrp:
            status = apl_parameter_general_set(hApl, DataID, iChannel, iSize, pData);
            break;
        case aplModuleMicLvl:
            status = apl_parameter_Mic_Lvl_set(hApl, DataID, iChannel, iSize, pData);
            break;
        case aplModuleArkamys:
            status = apl_parameter_Arkamys_set(hApl, DataID, iChannel, iSize, pData);
            break;
        case aplModulePcmCopy:
            status = apl_parameter_PcmCopy_set(hApl, DataID, iChannel, iSize, pData);
            break;
        case aplModuleVolume:
            status = apl_parameter_Volume_set(hApl, DataID, iChannel, iSize, pData);
            break;
        default:
            break;
    }

//    g_mutex_unlock(&hApl->lock);

    return status;
}







/*******************************************************************************
*
* FUNCTION: apl_parameter_general_set
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_general_set
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32                 iSize,
    const void*             pData
)
{
    APL_STATUS              err = APL_ERR_OK;


    pr_debug("ENTERED, dataid(%d), channel(%d), size(%d)\n",DataID, iChannel, iSize);

    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    switch(DataID)
    {
        case aplFrameShiftIn:
            memcpy((void*)&(aplh->par_aplFrameShiftIn), pData , iSize);
            pr_debug(" set value parameter aplFrameShift(%d)\n",aplh->par_aplFrameShiftIn );
            break;
        case aplSampleRateIn:
            memcpy((void*)&(aplh->par_aplSampleRateIn), pData , iSize);
            pr_debug(" set value parameter aplSampleRateIn(%d)\n",aplh->par_aplSampleRateIn );
            break;
        case aplChannelCntIn:
            memcpy((void*)&(aplh->par_aplChannelCntIn), pData , iSize);
            pr_debug(" set value parameter aplChannelCntIn(%d)\n",aplh->par_aplChannelCntIn );
            break;
        case aplAudioPcmFormatIn:
            memcpy((void*)&(aplh->par_aplAudioPcmFormatIn), pData , iSize);
            pr_debug(" set value parameter aplAudioPcmFormatIn(%d)\n",aplh->par_aplAudioPcmFormatIn );
            break;
        case aplFrameShiftOut:
            memcpy((void*)&(aplh->par_aplFrameShiftOut), pData , iSize);
            pr_debug(" set value parameter aplFrameShiftOut(%d)\n",aplh->par_aplFrameShiftOut );
            break;
        case aplSampleRateOut:
            memcpy((void*)&(aplh->par_aplSampleRateOut), pData , iSize);
            pr_debug(" set value parameter aplSampleRateOut(%d)\n",aplh->par_aplSampleRateOut);
            break;
        case aplChannelCntOut:
            memcpy((void*)&(aplh->par_aplChannelCntOut), pData , iSize);
            pr_debug(" set value parameter aplChannelCntOut(%d)\n",aplh->par_aplChannelCntOut );
            break;
        case aplAudioPcmFormatOut:
            memcpy((void*)&(aplh->par_aplAudioPcmFormatOut), pData , iSize);
            pr_debug(" set value parameter aplAudioPcmFormatOut(%d)\n",aplh->par_aplAudioPcmFormatOut );
            break;
        default:
            err = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return err;
}


/*******************************************************************************
*
* FUNCTION: apl_parameter_general_get
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_general_get
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32*                pSize,
    void*                   pData
)
{
    APL_STATUS              status = APL_ERR_OK;
    tAplU16                 u16value = 0;


    pr_debug("ENTERED, dataid(%d), channel(%d)\n",DataID, iChannel);

    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    switch(DataID)
    {
        case aplFrameShiftIn:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplFrameShiftIn;
            memcpy(pData, (void*)&u16value, *pSize);
            break;
        case aplSampleRateIn:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplSampleRateIn;
            memcpy(pData , (void*)&u16value, *pSize);
            break;
        case aplChannelCntIn:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplChannelCntIn;
            memcpy(pData , (void*)&u16value, *pSize);
            break;
        case aplAudioPcmFormatIn:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplAudioPcmFormatIn;
            memcpy(pData , (void*)&u16value, *pSize);
            break;
        case aplFrameShiftOut:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplFrameShiftOut;
            memcpy(pData, (void*)&u16value, *pSize);
            break;
        case aplSampleRateOut:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplSampleRateOut;
            memcpy(pData , (void*)&u16value, *pSize);
            break;
        case aplChannelCntOut:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplChannelCntOut;
            memcpy(pData , (void*)&u16value, *pSize);
            break;
        case aplAudioPcmFormatOut:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplAudioPcmFormatOut;
            memcpy(pData , (void*)&u16value, *pSize);
            break;

        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_parameter_Mic_Lvl_set
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_Mic_Lvl_set
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32                 iSize,
    const void*             pData
)
{
    module_desc*            pm = (module_desc*)NULL;
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;


    pr_debug("ENTERED, dataid(%d), channel(%d), size(%d)\n",DataID, iChannel, iSize);

    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    /* set parameter in module instance  */
    module_desc* this_module =  apl_internal_find_module(aplh, aplMicLvlWatchSwitch);

    if(this_module)
    {
        status = this_module->apl_module_set_property(this_module->data, DataID, iSize, pData);
        return status;
    }


    /* store always parameter in APL instance container */
    switch(DataID)
    {
        case aplMicLvlWatchSwitch:
            memcpy((void*)&i32value, pData , iSize);
            if((i32value == aplTRUE) && !apl_micro_level_is_inst_available(aplMicLvlWatchSwitch))
            {
                pm = apl_micro_level_initialize();
                if(pm)
                    status = apl_internal_attach_module(&aplh->mdesc, pm);
            }
            else if((i32value == aplFALSE) && apl_micro_level_is_inst_available(aplMicLvlWatchSwitch))
            {
                /* tbd */
            }
            else
            {
                /* do nothing */
            }
            aplh->par_aplMicLvlWatchSwitch = i32value;
            pr_debug(" set value parameter aplMicLvlWatchSwitch(%d)\n",aplh->par_aplMicLvlWatchSwitch );
            break;
        case aplMicLvl:
            memcpy((void*)&(aplh->par_aplMicLvl), pData , iSize);
            pr_debug(" set value parameter aplMicLvl(%d)\n",aplh->par_aplMicLvl );
            break;
        case aplMicLvlWatchRefInt:
            memcpy((void*)&(aplh->par_aplMicLvlWatchRefInt), pData , iSize);
            pr_debug(" set value parameter aplMicLvlWatchRefInt(%d)\n",aplh->par_aplMicLvlWatchRefInt );
            break;
        case aplMicLvlWatchStartStop:
            memcpy((void*)&(aplh->par_aplMicLvlWatchStartStop), pData , iSize);
            pr_debug(" set value parameter aplMicLvlWatchStartStop(%d)\n",aplh->par_aplMicLvlWatchStartStop );
            break;
        case aplMicLvlOperationMode:
            memcpy((void*)&(aplh->par_aplMicLvlOperationMode), pData , iSize);
            pr_debug(" set value parameter aplMicLvlOperationMode(%d)\n",aplh->par_aplMicLvlOperationMode );

            /* set here the operation mode -  check whether it need to be made thread safe */
            //this_module->aplopmode = (tAplOpMode)aplh->par_aplMicLvlOperationMode;

            break;
        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return status;
}


/*******************************************************************************
*
* FUNCTION: apl_parameter_Mic_Lvl_get
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_Mic_Lvl_get
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32*                pSize,
    void*                   pData
)
{
    tAplU16                 u16value = 0;
    tAplI16                 i16value= 0;
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;


    pr_debug("ENTERED, dataid(%d), channel(%d)\n",DataID, iChannel);


    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    /* set parameter in module instance  */
    module_desc* this_module =  apl_internal_find_module(aplh, aplMicLvlWatchSwitch);

    if(this_module)
    {
        status = this_module->apl_module_get_property(this_module->data, DataID, pSize, pData);
        return status;
    }

    switch(DataID)
    {
        case aplMicLvlWatchSwitch:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplMicLvlWatchSwitch;
            pr_debug(" get value parameter aplMicLvlWatchSwitch(%d)\n",aplh->par_aplMicLvlWatchSwitch );
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        case aplMicLvl:
            *pSize = sizeof(tAplI16);
            i16value = aplh->par_aplMicLvl;
            pr_debug(" get value parameter aplMicLvl(%d)\n",aplh->par_aplMicLvl );
            memcpy(pData , (void*)&i16value, *pSize);
            break;
        case aplMicLvlWatchRefInt:
            *pSize = sizeof(tAplU16);
            u16value = aplh->par_aplMicLvlWatchRefInt;
            pr_debug(" get value parameter aplMicLvlWatchRefInt(%d)\n",aplh->par_aplMicLvlWatchRefInt );
            memcpy(pData , (void*)&u16value, *pSize);
            break;
        case aplMicLvlWatchStartStop:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplMicLvlWatchStartStop;
            pr_debug(" get value parameter aplMicLvlWatchStartStop(%d)\n",aplh->par_aplMicLvlWatchStartStop );
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        case aplMicLvlOperationMode:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplMicLvlOperationMode;
            pr_debug(" get value parameter aplMicLvlOperationMode(%d)\n",aplh->par_aplMicLvlOperationMode );
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    pr_debug("EXIT\n");

    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_parameter_Arkamys_set
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_Arkamys_set
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32                 iSize,
    const void*             pData
)
{
    module_desc*            pm = (module_desc*)NULL;
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED, dataid(%d), channel(%d), size(%d)\n", DataID, iChannel, iSize);

    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    module_desc* this_module =  apl_internal_find_module(aplh, aplArkamysSwitch);

    if(this_module)
    {
        status = this_module->apl_module_set_property(this_module->data, DataID, iSize, pData);
        return status;
    }

    switch(DataID)
    {
        case aplArkamysSwitch:
            memcpy((void*)&i32value, pData , iSize);
            if((i32value == aplTRUE) && !apl_arkamys_is_inst_available(aplArkamysSwitch))
            {
                pm = apl_arkamys_initialize();
                if(pm)
                {
                    status = apl_internal_attach_module(&aplh->mdesc, pm);
                    //g_print("apl_parameter_Arkamys_set_probe_1_0_1\n");
                }
            }
            else if((i32value == aplFALSE) && apl_arkamys_is_inst_available(aplArkamysSwitch))
            {
                /* tbd */
            }
            else
            {
                /* do nothing */
            }

            aplh->par_aplArkamysSwitch = i32value;
            pr_debug(" set value parameter aplArkamysSwitch(%d)\n",aplh->par_aplArkamysSwitch );

            break;
        case aplArkamysAvcActivate:
            memcpy((void*)&(aplh->par_aplArkamysAvcActivate), pData , iSize);
            pr_debug(" set value parameter par_aplArkamysAvcActivate(%d)\n",aplh->par_aplArkamysAvcActivate );
            break;
        case aplArkamysAmbienceSelect:
            memcpy((void*)&(aplh->par_aplArkamysAmbienceSelect), pData , iSize);
            pr_debug(" set value parameter aplArkamysReverbActivate(%d)\n",aplh->par_aplArkamysAmbienceSelect );
            break;
        case aplArkamysBassExciterActivate:
            memcpy((void*)&(aplh->par_aplArkamysBassExciterActivate), pData , iSize);
            pr_debug(" set value parameter aplArkamysBassExciterActivate(%d)\n",aplh->par_aplArkamysBassExciterActivate );
            break;
        case aplArkamysByPassActivate:
            memcpy((void*)&(aplh->par_aplArkamysByPassActivate), pData , iSize);
            break;
        case aplArkamysEolData:
            if(aplh->par_aplArkamysEolData)
                g_free(aplh->par_aplArkamysEolData);
            aplh->par_aplArkamysEolData = g_malloc0(iSize * sizeof(tAplU8));
            if(aplh->par_aplArkamysEolData)
            {
                memcpy((void*)&(aplh->par_aplArkamysEolData), pData , iSize);
            }
            break;
        case aplArkamysInputLevelDeviation:
            memcpy((void*)&(aplh->par_aplArkamysInputLevelDeviation), pData , iSize);
            break;
        case aplArkamysCurrentSpeed:
            memcpy((void*)&(aplh->par_aplArkamysCurrentSpeed), pData , iSize);
            break;
        case aplArkamysCurrentVolumeStep:
            memcpy((void*)&(aplh->par_aplArkamysCurrentVolumeStep), pData , iSize);
            break;
        case aplArkamysSetData:
        case aplArkamysWriteMultiFrame:
        case aplArkamysGetData:
        case aplArkamysSetGetData:
        case aplArkamysReadData:
            break;
        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_parameter_Arkamys_get
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_Arkamys_get
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32*                pSize,
    void*                   pData
)
{
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED, dataid(%d), channel(%d)\n",DataID, iChannel);


    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;

    if(!pSize)
       return APL_ERR_NULL_POINTER;

    if(!pData)
       return APL_ERR_NULL_POINTER;


    module_desc* this_module =  apl_internal_find_module(aplh, aplArkamysSwitch);

    if(this_module)
    {
        status = this_module->apl_module_get_property(this_module->data, DataID, pSize, pData);
        return status;
    }

    switch(DataID)
    {
        case aplArkamysSwitch:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplArkamysSwitch;
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        case aplArkamysAvcActivate:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplArkamysAvcActivate;
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        case aplArkamysReverbActivate:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplArkamysReverbActivate;
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        case aplArkamysBassExciterActivate:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplArkamysBassExciterActivate;
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_parameter_PcmCopy_set
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_PcmCopy_set
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32                 iSize,
    const void*             pData
)
{
    module_desc*            pm = (module_desc*)NULL;
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED, dataid(%d), channel(%d), size(%d)\n",DataID, iChannel, iSize);

    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    module_desc* this_module =  apl_internal_find_module(aplh, aplPcmCopySwitch);

    if(this_module)
    {
        status = this_module->apl_module_set_property(this_module->data, DataID, iSize, pData);
        return status;
    }

    switch(DataID)
    {
        case aplPcmCopySwitch:
        {
#ifndef APL_PCM_COPY_MULTIPLE_INST_ENABLE
            memcpy((void*)&i32value, pData , iSize);
            if((i32value == aplTRUE) && !apl_pcmcopy_is_inst_available(aplPcmCopySwitch))
            {
#endif
                pm = apl_pcmcopy_initialize();
                if(pm)
                    status = apl_internal_attach_module(&aplh->mdesc, pm);
#ifndef APL_PCM_COPY_MULTIPLE_INST_ENABLE
            }
            else if((i32value == aplFALSE) && apl_pcmcopy_is_inst_available(aplPcmCopySwitch))
            {
                /* tbd */
            }
            else
            {
                /* do nothing */
            }
            aplh->par_aplPcmCopySwitch = i32value;
            pr_debug(" set value parameter aplPcmCopySwitch(%d)\n",aplh->par_aplPcmCopySwitch );
#endif
            break;
        }
        case aplAudioChannelBinding:
        {
            if(aplh->par_aplAudioChannelBinding.audbind)
                g_free(aplh->par_aplAudioChannelBinding.audbind);

            aplh->par_aplAudioChannelBinding.audbind = g_malloc0(iSize);
            if(aplh->par_aplAudioChannelBinding.audbind)
            {
                memcpy((void*)aplh->par_aplAudioChannelBinding.audbind, pData , iSize);
            }
            break;
        }
        case aplInRoutingChannelCnt:
        {
            memcpy((void*)&aplh->par_aplAudioChannelBinding.inchannelnb, pData , iSize);
            break;
        }
        case aplOutRoutingChannelCnt:
        {
            memcpy((void*)&aplh->par_aplAudioChannelBinding.outchannelnb, pData , iSize);
            break;
        }
        case aplNbBinding:
        {
            memcpy((void*)&aplh->par_aplAudioChannelBinding.bindingnb, pData , iSize);
            break;
        }
        case aplPcmCopyFrameShiftOut:
        {
            pr_debug("set parameter aplPcmCopyFrameShiftOut\n");
            //memcpy((void*)&aplh->mparam_aplFrameShiftOut, pData , iSize);
            break;
        }
        case aplPcmCopyampleRateOut:
        {
            pr_debug("set parameter aplPcmCopyampleRateOut\n");
            //memcpy((void*)&aplh->mparam_aplsampleRateOut, pData , iSize);
            break;
        }
        case aplPcmCopyChannelCntOut:
        {
            pr_debug("set parameter aplPcmCopyChannelCntOut\n");
            //memcpy((void*)&aplh->mparam_aplChannelCntOut, pData , iSize);
            break;
        }
        case aplPcmCopyAudioPcmFormatOut:
        {
            pr_debug("set parameter aplPcmCopyAudioPcmFormatOut\n");
            //memcpy((void*)&aplh->mparam_aplAudioPcmFormatOut, pData , iSize);
            break;
        }
        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }


    (void)i32value;
    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_parameter_PcmCopy_get
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS  apl_parameter_PcmCopy_get
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32*                pSize,
    void*                   pData
)
{
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED, dataid(%d), channel(%d)\n",DataID, iChannel);


    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;



    module_desc* this_module =  apl_internal_find_module(aplh, aplPcmCopySwitch);

    if(this_module)
    {
        status = this_module->apl_module_get_property(this_module->data, DataID, pSize, pData);
        return status;
    }

    switch(DataID)
    {
        case aplPcmCopySwitch:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplPcmCopySwitch;
            pr_debug(" get value parameter aplPcmCopySwitch(%d)\n",aplh->par_aplPcmCopySwitch );
            memcpy(pData , (void*)&i32value, *pSize);
            break;
        default:
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return status;
}
/*******************************************************************************
*
* FUNCTION: apl_parameter_Volume_set
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_parameter_Volume_set
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32                 iSize,
    const void*             pData
)
{
    module_desc*            pm = (module_desc*)NULL;
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED, dataid(%d), channel(%d), size(%d)\n",DataID, iChannel, iSize);

    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;

    module_desc* this_module =  apl_internal_find_module(aplh, aplvolumeSwitch);

    if(this_module)
    {
        status = this_module->apl_module_set_property(this_module->data, DataID, iSize, pData);
        return status;
    }


    switch(DataID)
    {
        case aplvolumeSwitch:
            memcpy((void*)&i32value, pData , iSize);
            if((i32value == aplTRUE) && !apl_volume_is_inst_available(aplvolumeSwitch))
            {
                pm = apl_volume_initialize();
                if(pm)
                    status = apl_internal_attach_module(&aplh->mdesc, pm);
            }
            else if((i32value == aplFALSE) && apl_volume_is_inst_available(aplvolumeSwitch))
            {
                /* tbd */
            }
            else
            {
                /* do nothing */
            }
            aplh->par_aplvolumeSwitch = i32value;
            pr_debug(" set value parameter aplvolumeSwitch(%d)\n",aplh->par_aplvolumeSwitch );
            break;

        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }

    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_paramteer_Volume_get
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
APL_STATUS apl_paramteer_Volume_get
(
    struct aplMainStruct*   aplh,
    tAplDataID              DataID,
    tAplInt                 iChannel,
    tAplU32*                pSize,
    void*                   pData
)
{
    tAplI32                 i32value= 0;
    APL_STATUS              status = APL_ERR_OK;

    pr_debug("ENTERED, dataid(%d), channel(%d)\n",DataID, iChannel);


    if(!aplh)
        return APL_ERR_INVALID_MAIN_STRUCT;


    module_desc* this_module =  apl_internal_find_module(aplh, aplvolumeSwitch);

    if(this_module)
    {
        status = this_module->apl_module_get_property(this_module->data, DataID, pSize, pData);
        return status;
    }

    switch(DataID)
    {
        case aplvolumeSwitch:
            *pSize = sizeof(tAplI32);
            i32value = aplh->par_aplvolumeSwitch;
            pr_debug(" get value parameter aplvolumeSwitch(%d)\n",aplh->par_aplvolumeSwitch );
            memcpy(pData , (void*)&i32value, *pSize);
            break;

        default:
            pr_warning("parameter(%d) not defined\n", DataID);
            status = APL_ERR_INVALID_PARAM_ID;
            break;
    }



    return status;
}
