#include <glib/gi18n.h>
#include <glib.h>
#include <alsa/asoundlib.h>
#include "stdlib.h"
#include "math.h"
#include "apl-main.h"
#include "apl-internal.h"
#include "apl-micro-level.h"




typedef struct _mydata
{
    tAplI32                 this_switch;
    aplAudioSamples_desc*   buf_desc;
    tAplI32                 mparam_aplMicLvlWatchSwitch;    /*  0x0100   WB,(tAplI32)*/
    tAplU16                 mparam_aplMicLvlWatchRefInt;    /*  0x0101   RW,(tAplU16), time in ms , in the range from 200ms to 65535 ms */
    tAplU16                 mparam_aplMicLvl;               /*  0x0102   WB,(tAplI16)*/
    tAplI32                 mparam_aplMicLvlWatchStartStop; /*  0x0103   WB,(tAplI32)*/
    tAplI32                 mparam_aplMicLvlOperationMode;  /*  0x0103   WB,(tAplI32)*/
    tAplBool                is_boost_gain;
    tAplU16                 gain_boost;
    tAplI16                 max_lvl_2_boost;

}mydata;


LOCAL mydata* module_data_inst = (mydata*)NULL;



#ifdef D_TEST_MICRO_LEVEL_FOLLLOW_TO_FILE


/***************************
 * Test functions
 **************************/
LOCAL   APL_STATUS              apl_micro_level_test_file_open(void);
LOCAL   APL_STATUS              apl_micro_level_test_file_close(void);
LOCAL   APL_STATUS              apl_micro_level_test_file_write(tAplU16 mic_level);



LOCAL FILE*        file_mic_level;
LOCAL size_t       wdata = 0;
LOCAL long int     rpos  = 0;



LOCAL APL_STATUS apl_micro_level_test_file_open(void)
{
    APL_STATUS err = APL_ERR_OK;

    pr_message("ENTERED\n");

    /* open output test file */
    remove(D_TEST_MICRO_LEVEL_FOLLOWER_VALUES);
    file_mic_level = fopen (D_TEST_MICRO_LEVEL_FOLLOWER_VALUES,"a+");
    if(!file_mic_level)
        return APL_ERR_NULL_POINTER;
    fseek(file_mic_level, 0, SEEK_SET);

    wdata = 0;
    rpos = 0;

    return err;
}

LOCAL APL_STATUS apl_micro_level_test_file_write(tAplU16 mic_level)
{
    APL_STATUS err = APL_ERR_OK;

    pr_debug("ENTERED\n");

    if(!file_mic_level)
        return APL_ERR_NULL_POINTER;

    wdata = fwrite((void*)&mic_level, sizeof(tAplU16), 1, file_mic_level);
    pr_debug("number of write bytes: %d\n", wdata);

    return err;
}

LOCAL APL_STATUS apl_micro_level_test_file_close(void)
{
    APL_STATUS err = APL_ERR_OK;

    pr_message("ENTERED\n");

    if(file_mic_level)
        fclose(file_mic_level);

    wdata = 0;

    return err;
}


#endif // D_TEST_MICRO_LEVEL_FOLLLOW_TO_FILE

/*******************************************************************************
*
* FUNCTION: apl_micro_level_prepare
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_print_curr_state(void)
{
    pr_debug("ENTERED\n");

    if(!module_data_inst->buf_desc)
        return APL_ERR_NULL_POINTER;

    /* initialize stream buffer */
    pr_debug("-------------------current apl_micro_level state --------------------------------------------\n");
    pr_debug("this_switch       = %d\n", module_data_inst->this_switch);
    pr_debug("apl_stream_nb_ch  = %d\n", module_data_inst->buf_desc->apl_stream_nb_ch);
    pr_debug("apl_audio_format  = %d\n", module_data_inst->buf_desc->apl_audio_format);
    pr_debug("apl_sample_rate   = %d\n", module_data_inst->buf_desc->apl_sample_rate);
    pr_debug("apl_period_size   = %d\n", module_data_inst->buf_desc->apl_period_size);

    return APL_ERR_OK;
}



/*******************************************************************************
*
* FUNCTION: apl_micro_level_prepare
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_prepare(void*  data, void* mdata)
{
    APL_STATUS err = APL_ERR_OK;

    pr_debug("ENTERED\n");

    if(!data)
        return APL_ERR_NULL_POINTER;

    struct aplMainStruct*   aplh = (struct aplMainStruct*)data;

    if(!module_data_inst->buf_desc)
        return APL_ERR_NULL_POINTER;

    /* initialize stream buffer */
    module_data_inst->buf_desc->apl_stream_nb_ch = aplh->par_aplChannelCntIn;
    module_data_inst->buf_desc->apl_audio_format = (snd_pcm_format_t)aplh->par_aplAudioPcmFormatIn;
    module_data_inst->buf_desc->apl_sample_rate  = aplh->par_aplSampleRateIn;
    module_data_inst->buf_desc->apl_period_size  = aplh->par_aplFrameShiftIn;

    apl_micro_level_print_curr_state();


#ifdef D_TEST_MICRO_LEVEL_FOLLLOW_TO_FILE
    (void)apl_micro_level_test_file_open();
#endif

    (void)mdata;
    return err;
}


/*******************************************************************************
*
* FUNCTION: apl_micro_level_command
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_command(void* data, tAplCmd cmd)
{
    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_NULL_POINTER;
    }

    //mydata* mdata = (mydata*)data;

    (void)cmd;

    return APL_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_get_buffer
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL aplAudioSamples_desc* apl_micro_level_get_buffer(void* data)
{
    pr_debug("ENTERED\n");


    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return (aplAudioSamples_desc*)NULL;
    }

    mydata*  mdata = (mydata*)data;

    if(!mdata->buf_desc)
    {
        pr_debug("buffer descriptor pointer is NULL\n");
        return (aplAudioSamples_desc*)NULL;
    }

    return mdata->buf_desc;
}
/*******************************************************************************
*
* FUNCTION: apl_micro_level_final
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_finalize(void* data)
{
    APL_STATUS err = APL_ERR_OK;
    mydata* mdata = (mydata*)NULL;

    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_MODULE_NOT_INITIALIZED;
    }

    mdata = (mydata*)data;


    if(mdata->buf_desc)
    {
        g_free(mdata->buf_desc);
        mdata->buf_desc = NULL;
    }

    g_free(mdata);

#ifdef D_TEST_MICRO_LEVEL_FOLLLOW_TO_FILE
    (void)apl_micro_level_test_file_close();
#endif

    return err;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_get_property
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS   apl_micro_level_get_property
(
    void* data,
    tAplDataID iDataID,
    tAplU32* pulSize,
    void* pData
)
{
    APL_STATUS  err = APL_ERR_OK;
    mydata* mdata = (mydata*)NULL;
    tAplU16     u16value = 0;
    tAplI16     i16value= 0;
    tAplI32     i32value= 0;

    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_MODULE_NOT_INITIALIZED;
    }

    mdata = (mydata*)data;

    switch(iDataID)
    {
        case aplMicLvlWatchSwitch:
            *pulSize = sizeof(tAplI32);
            i32value = mdata->mparam_aplMicLvlWatchSwitch;
            pr_debug(" get value parameter aplMicLvlWatchSwitch(%d)\n",mdata->mparam_aplMicLvlWatchSwitch );
            memcpy(pData , (void*)&i32value, *pulSize);
            break;
        case aplMicLvl:
            *pulSize = sizeof(tAplI16);
            i16value = (tAplI16)mdata->mparam_aplMicLvl;
            pr_debug(" get value parameter aplMicLvl(%d)\n",mdata->mparam_aplMicLvl );
            memcpy(pData , (void*)&i16value, *pulSize);
            break;
        case aplMicLvlWatchRefInt:
            *pulSize = sizeof(tAplU16);
            u16value = mdata->mparam_aplMicLvlWatchRefInt;
            pr_debug(" get value parameter aplMicLvlWatchRefInt(%d)\n",mdata->mparam_aplMicLvlWatchRefInt );
            memcpy(pData , (void*)&u16value, *pulSize);
            break;
        case aplMicLvlWatchStartStop:
            *pulSize = sizeof(tAplI32);
            i32value = mdata->mparam_aplMicLvlWatchStartStop;
            pr_debug(" get value parameter aplMicLvlWatchStartStop(%d)\n",mdata->mparam_aplMicLvlWatchStartStop );
            memcpy(pData , (void*)&i32value, *pulSize);
            break;
        case aplMicLvlOperationMode:
            *pulSize = sizeof(tAplI32);
            i32value = mdata->mparam_aplMicLvlOperationMode;
            pr_debug(" get value parameter aplMicLvlOperationMode(%d)\n",mdata->mparam_aplMicLvlOperationMode );
            memcpy(pData , (void*)&i32value, *pulSize);
            break;
        default:
            err = APL_ERR_INVALID_PARAM_ID;
            break;
    }

    pr_debug("EXIT\n");

    return err;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_set_property
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL   APL_STATUS   apl_micro_level_set_property
(
    void* data,
    tAplInt iDataID,
    tAplU32 ulSize,
    const void* pData
)
{
    APL_STATUS err = APL_ERR_OK;
    mydata* mdata = (mydata*)NULL;

    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_MODULE_NOT_INITIALIZED;
    }

    if(!pData)
    {
        pr_warning("NULL data pointer parameter\n");
        return APL_ERR_NULL_POINTER;
    }


    mdata = (mydata*)data;

    switch(iDataID)
    {
        case aplMicLvlWatchSwitch:
            memcpy((void*)&(mdata->mparam_aplMicLvlWatchSwitch), pData , ulSize);
            pr_debug(" set value parameter aplMicLvlWatchSwitch(%d)\n",mdata->mparam_aplMicLvlWatchSwitch );
            break;
        case aplMicLvl:
            pr_debug("not settable \n");
            break;
        case aplMicLvlWatchRefInt:
            memcpy((void*)&(mdata->mparam_aplMicLvlWatchRefInt), pData , ulSize);
            pr_debug(" set value parameter aplMicLvlWatchRefInt(%d)\n",mdata->mparam_aplMicLvlWatchRefInt );
            break;
        case aplMicLvlWatchStartStop:
            memcpy((void*)&(mdata->mparam_aplMicLvlWatchStartStop), pData , ulSize);
            pr_debug(" set value parameter aplMicLvlWatchStartStop(%d)\n",mdata->mparam_aplMicLvlWatchStartStop );
            break;
        case aplMicLvlOperationMode:
            memcpy((void*)&(mdata->mparam_aplMicLvlOperationMode), pData , ulSize);
            pr_debug(" set value parameter aplMicLvlOperationMode(%d)\n",mdata->mparam_aplMicLvlOperationMode );
            break;
        default:
            err = APL_ERR_INVALID_PARAM_ID;
            break;
    }


    return err;
}






#define FLOAT_KOEFF 0.01
#define AUD_FLOAT_ENVELOP_DELAY  0.9999

LOCAL double fintegrator = 0;
LOCAL double fenvelope  = 0;
/*******************************************************************************
*
* FUNCTION: apl_micro_level_calcul_env
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_calcul_env(short int* datas, int sample_num,  tAplU16* new_value)
{
    APL_STATUS  status = APL_ERR_OK;
    gint        i = 0;
    double fsample_row, fsample_abs;
//    guint8 integrator_dB, envelop_dB;
    short int*  samples  = (short int*)NULL;

    pr_debug("ENTERED\n");

    if(!datas)
        return APL_ERR_NULL_POINTER;
    if(!new_value)
        return APL_ERR_NULL_POINTER;


    samples  = datas;


    for ( i = 0; i < sample_num ; i++)
    {
        //get your data into 'input'

        fsample_row = (float)samples[i];
        //pr_debug("new sample: %f\n", fsample_row);

        //fsample_row /= 32768;
        fsample_abs = fabs(fsample_row);
        fsample_row = fsample_abs * fsample_abs;
        fintegrator = fsample_row * FLOAT_KOEFF + fintegrator * (1-FLOAT_KOEFF);

        if (fenvelope < fsample_abs)
        {
            fenvelope = fsample_abs;
        }
        else
        {
            fenvelope = fenvelope * AUD_FLOAT_ENVELOP_DELAY;
        }

    }

    /* now update mic level with new value */
    fsample_abs      = sqrt(fintegrator);
//    integrator_dB    = (gint8)(20 * log10(fsample_abs));
//    envelop_dB       = (gint8)(20 * log10(fenvelope));

    pr_debug("new fsample_abs: %f\n", fsample_abs);
    *new_value =  (tAplU16)fsample_abs;

    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_s16AudioTransfert
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_s16AudioTransfert
(
    const aplAudioSamples_desc*   inAudio,
    aplAudioSamples_desc*   outAudio,
    tAplBool                can_swap
)
{
    unsigned int    i;
    APL_STATUS      status = APL_ERR_OK;
    short int*      s16ibuf;
    short int*      s16obuf;
    unsigned int    sample_cnt = 0;
    unsigned int    stream_cnt = 0;


    pr_debug("ENTERED\n");

    if(!inAudio)
        return APL_ERR_NULL_POINTER ;

    if(!outAudio)
        return APL_ERR_NULL_POINTER ;

    s16ibuf = inAudio->s16audiosamples[0];
    if(!s16ibuf)
    {
        pr_debug("No input data stream buffer available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(outAudio->apl_period_size <  inAudio->apl_period_size)
    {
        pr_critical("mismatch in size out_stream(%d) and in_stream(%d) \n", outAudio->apl_period_size, inAudio->apl_period_size);
        return APL_ERR_AUDIO_BUFFER_MISMATCH;
    }

    /* in stream and out stream are aligned */
    if(   (outAudio->apl_stream_nb_ch == inAudio->apl_stream_nb_ch)
        ||(outAudio->apl_stream_nb_ch > inAudio->apl_stream_nb_ch ))
    {
       stream_cnt =  inAudio->apl_stream_nb_ch;
    }
    else if(outAudio->apl_stream_nb_ch < inAudio->apl_stream_nb_ch)
    {
       stream_cnt =  outAudio->apl_stream_nb_ch;
       pr_warning(" mismatch nb channel out_stream(%d) and in_stream(%d)\n",outAudio->apl_stream_nb_ch, inAudio->apl_stream_nb_ch );
    }

    for( i = 0; i < stream_cnt ; i++)
    {
        if(   (outAudio->apl_period_size ==  inAudio->apl_period_size)
            ||(outAudio->apl_period_size >  inAudio->apl_period_size))
        {
            sample_cnt = inAudio->apl_period_size;

            if(can_swap)
            {
                pr_debug ("swap stream buffer[%d]\n", i);

                s16ibuf = inAudio->s16audiosamples[i];
                outAudio->s16audiosamples[i] = s16ibuf;
            }
            else
            {
                pr_debug("copy %d s16 sample to out stream s16 buffer[%d]\n", sample_cnt, i);

                s16ibuf = inAudio->s16audiosamples[i];
                s16obuf = outAudio->s16audiosamples[i];
                memcpy((void*)s16obuf, (void*)s16ibuf, sample_cnt * sizeof(short int));
            }
        }
        else
        {
            pr_critical(" mismatch between nb of in_stream(%d) and out_strem(%d) samples \n", inAudio->apl_period_size, outAudio->apl_period_size);
        }
    }

    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_process
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_micro_level_process
(
    void* data,
    const aplAudioSamples_desc* inAudio
)
{
    APL_STATUS  status = APL_ERR_OK;
    tAplBool info = aplFALSE;

    pr_debug("ENTERED\n");

    if(!data)
        return APL_ERR_NULL_POINTER;

    if(!inAudio)
        return APL_ERR_NULL_POINTER;

    module_desc*            this_module = (module_desc*)data;
    mydata*                 mdata = this_module->data;
    short int*              samples  = inAudio->s16audiosamples[0];
    int                     sample_num = (int)inAudio->apl_period_size;

    if(!samples)
        return APL_ERR_MODULE_NOT_DATA;



    status = apl_micro_level_calcul_env(samples,
                                        sample_num,
                                        &mdata->mparam_aplMicLvl);


#ifdef D_GAIN_BOOST
    /* boost each sample from "gain_boost"  */
    if(mdata->is_boost_gain)
    {
        unsigned int i;
        for(i = 0; i < sample_num ; i++)
        {
            if(samples[i] < 0x8000)
            {
                if(mdata->max_lvl_2_boost > samples[i])
                {
                    short int sample = samples[i];
                    short int boosted_sample = sample << mdata->gain_boost;
                    samples[i]  = boosted_sample; //<<= mdata->gain_boost;

                    pr_debug(" new samples[%d] = %d , prior to boost sample[%d] = %d, boosted_sample = %d \n", i, samples[i], i,  sample, boosted_sample);
                }
            }
        }
    }
#endif  //D_GAIN_BOOST

    pr_debug("new mic value: %d \n", mdata->mparam_aplMicLvl);

#ifdef D_TEST_MICRO_LEVEL_FOLLLOW_TO_FILE
    (void)apl_micro_level_test_file_write(mdata->mparam_aplMicLvl);
#endif

    if(!status)
    {
        if(this_module->aplopmode == APL_OM_PROD_CONS)
        {
            /* do process and copy afterwards streaming buffer pointer */
            if(   (inAudio->apl_audio_format == SND_PCM_FORMAT_S16_LE)
                &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE))
            {
                status = apl_micro_level_s16AudioTransfert(inAudio, mdata->buf_desc, aplTRUE);
            }
            else if(  (inAudio->apl_audio_format == SND_PCM_FORMAT_S16_LE)
                    &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE))
            {
                pr_warning("not supported format combination In_S16_LE and Out_S32_LE in this module\n");
                info = aplTRUE;
            }
            else if(  (inAudio->apl_audio_format == SND_PCM_FORMAT_S32_LE)
                    &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE))
            {
                pr_warning("not supported combination Out_S32_LE and Out_S32_LE in this module\n");
                info = aplTRUE;
            }
            else if(  (inAudio->apl_audio_format == SND_PCM_FORMAT_S32_LE)
                    &&(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE))
            {
                pr_warning("not supported combination Out_S32_LE and In_S16_LE in this module\n");
                info = aplTRUE;
            }
            else
            {
                /* do nothing */
                pr_warning("not supported format combination, in_format(%d), out_format(%d)\n", inAudio->apl_audio_format, mdata->buf_desc->apl_audio_format);
                info = aplTRUE;
            }

            if(info)
            {
                (void)apl_internal_print_module_desc(inAudio, "inAudio");
                apl_micro_level_print_curr_state();
            }
        }
    }
    pr_debug("EXIT\n");

    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_notification
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL tAplBool apl_micro_level_notification
(
    void*       data,
    tAplInt*    piDataID,
    tAplAction* paplAct
)
{
    pr_debug("No implmentation available\n");


    (void)data;
    (void)piDataID;
    (void)paplAct;

    return aplFALSE;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_initialize
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
EXPORT module_desc* apl_micro_level_initialize(void)
{
    module_desc*  this_modul_desc = (module_desc*)NULL ;

    pr_debug("ENTERED\n");

    this_modul_desc = g_malloc0(sizeof(module_desc));

    if(!this_modul_desc)
    {
        pr_critical("fails while allocating memory for new module descriptor\n");
        return (module_desc*)NULL;
    }

    this_modul_desc->associated_switch          = aplMicLvlWatchSwitch;
    this_modul_desc->state                = apl_state_setup;
    this_modul_desc->aplopmode                  = APL_OM_PROD_CONS;
    this_modul_desc->apl_module_command          = apl_micro_level_command;
    this_modul_desc->apl_module_prepare          = apl_micro_level_prepare;
    this_modul_desc->apl_module_process          = apl_micro_level_process;
    this_modul_desc->apl_module_finalize      = apl_micro_level_finalize;
    this_modul_desc->apl_module_get_buffer      = apl_micro_level_get_buffer;
    this_modul_desc->apl_module_get_property    = apl_micro_level_get_property;
    this_modul_desc->apl_module_set_property  = apl_micro_level_set_property;
    this_modul_desc->apl_module_notification  = apl_micro_level_notification;


    this_modul_desc->next        = (void*)NULL;
    this_modul_desc->prev        = (void*)NULL;

    module_data_inst = g_malloc0(sizeof(mydata));

    if(!module_data_inst)
    {
        pr_critical("fails while allocating memory for new buffer descriptor\n");
        return (module_desc*)NULL;
    }

    module_data_inst->this_switch       = aplMicLvlWatchSwitch;
    module_data_inst->buf_desc          = g_malloc0(sizeof(aplAudioSamples_desc));
    module_data_inst->is_boost_gain     = aplTRUE;
    module_data_inst->gain_boost        = 6;  /*shift left 6 -> 36 db */
    module_data_inst->max_lvl_2_boost   = 0x01FF;


    /* setup stream audio buffer in buffer descriptor
     * not required in thsi module because not new audio data are processed
     * buffer pointer s16/s32audiosamplesinput hold a pointer of the input streaming buffer
     * so it can be return with the function call get_buffer()
     */

    this_modul_desc->data = (void*)module_data_inst;

    return this_modul_desc;
}

/*******************************************************************************
*
* FUNCTION: apl_micro_level_is_inst_available
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
EXPORT tAplBool apl_micro_level_is_inst_available(tAplI32 aplswitch)
{
    tAplBool status = aplFALSE;

    pr_debug("ENTERED\n");

    if(!module_data_inst)
        return status;

    if(module_data_inst->this_switch == aplswitch)
    {
        pr_debug(" the module micro_level is available for switch: %d\n", aplswitch);
        status =  aplTRUE;
    }
    return status;
}
