/*
 * apl-arkamys.h
 *
 * Patrick Rey   23.11.2015
 */

#ifndef __APL_ARKAMYS_H__
#define __APL_ARKAMYS_H__

#include "apl.h"


//#define D_AUDPROC_ARKAMYS_API_IMPLEMENT_OWN

extern module_desc* apl_arkamys_initialize(void);
extern tAplBool     apl_arkamys_is_inst_available(tAplI32 aplswitch);



#define APL_ARK_INC_AND_CHECK_PTR(idx , inc, size)\
                    if((idx + inc) > size)\
                    {\
                        pr_warning("out of array index, invalide increment \"%s\" and calc idx -> %d, array size -> %d\n", #inc, (idx + inc), size);\
                        return APL_ERR_PARAM_SIZE;\
                    }\
                    else\
                    {\
                        idx = idx + inc;\
                    }


#define BLOCK_ID_UNDEF                  0
#define PARAM_ID_UNDEF                  0
#define PARAM_SIZE_UNDEF                0
#define PARAM_ADRESS_UNDEF              (void*)NULL
#define D_MAX_ARK_PARAM_CNT             20
#define D_MAX_ARK_NOTIFY_CNT            20

#define D_ARKAMYS_WRITE_FRAME_SIZE_MIN  12
#define D_ARKAMYS_READ_FRAME_SIZE_MIN   12


//#define D_AUDPROC_TEST_ARKAMYS
#define D_USE_LIB_VER_2_2_2

/* arkamys parameter data structure */
#if 0
typedef struct _ArkParamList
{
    tAplI32       aplparameter;
    tAplU32       arkblockid;
    tAplU32       arkparamid;
    void*         data;
    tAplU32       size;
    tAplBool      NewValue;
    taplparamtype  aplparamtype;
}ArkParamList;
#endif
typedef struct _ArkParamList
{
    tAplI32       aplparameter;
    tAplU32       arkblockid;
    tAplU32       arkparamid;
    void*         data;
    tAplU32       size;
    tAplBool      NewValue;
    taplparamtype  aplparamtype;
}ArkParamList;

/* definiton of Ambience setting*/
#define AUDPROC_FI_AMBIENCE_NATURAL     0
#define AUDPROC_FI_AMBIENCE_CLUB        2
#define AUDPROC_FI_AMBIENCE_LOUNGE      3
#define AUDPROC_FI_AMBIENCE_LIVE        1
#define AUDPROC_FI_AMBIENCE_DEMO_MODE   4
#define AUDPROC_FI_AMBIENCE_MAX         5


#define ARK_AMBIENCE_NATURAL    0x00
#define ARK_AMBIENCE_CLUB       0x03
#define ARK_AMBIENCE_LOUNGE     0x01
#define ARK_AMBIENCE_LIVE       0x02
#define ARK_AMBIENCE_DEMO_MOD   0xFF
#define ARK_AMBIENCE_MAX        4
#define ARK_AVC_ENABLE          0
#define ARK_AVC_DISABLE         1

#define ARK_BLOCK_ID_AMBIENCE   100
#define ARK_PARAM_ID_AMBIENCE   3
#define ARK_PARAM_SIZE_AMBIENCE 1
#define ARK_PARAM_SIZE_BLOCK_ID 4
#define ARK_PARAM_SIZE_PARAM_ID 4
#define ARK_PARAM_SIZE_SIZE_PARAM 4
#define ARK_PARAM_CMD_COUNT 0



typedef struct _ArkAmbienceMap
{
    tAplI32 audproc_id;
    tAplU8  ark_id;
}ArkAmbienceMap;

#endif //__APL_ARKAMYS_H__
