/*
 * File:    audproc-datapool-access.cpp
 *
 * Author : Patrick Rey
 * Date:    07.08.2015
 * description:
 */


/*********************************************************************************/
/*                         define                                                */
/*********************************************************************************/


#ifndef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
#define D_AUDPROC_DATAPOOL_SUPPORT
#endif

#ifdef D_AUDPROC_DATAPOOL_SUPPORT
#include "dp/dp_def.h"
#include "ccaservice.h"
#define DP_DATAPOOL_ID =CCA_C_U16_APP_DIAGDEBUG
//#endif

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#include "dp_diagdebug_if.h" // For Arkamys EOL Datapool


/* Needed for Trace */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define SPM_UNIT_TESTS // solve warning
#include "audproc-audioprocess-trace.h"
#include "etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDPROC
#include "trcGenProj/Header/audproc-datapool-access.cpp.trc.h"
#endif

#endif // D_AUDPROC_DATAPOOL_SUPPORT



#ifdef __cplusplus
  extern "C" {
#endif


#include <glib.h>
#include <glib/gi18n.h>
#include <glib-object.h>
#include "audproc-common-defs.h"
#include "audproc-datapool-access.h"
#include "audproc-apl-handler.h"




/*******************************************************************************
              DEFINES
*******************************************************************************/
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
#define ARK_DP_MAX_SIZE 20000

typedef struct _tArkamysEolHeader
{
    guint8   eol_file_generation_date[4];    /* BCD coding */
    gchar   car_manufacturer[4];            /* ASCII coding, "RSA" or "NIS"     */
    gchar   radio_manufacturer[4];          /* ASCII coding, "BOSC"             */
    gchar   radio_project[8];               /* ASCII coding, "AIVI    "         */
    guint8  vehicle_id[20];                 /* Binary coding                    */
    guint8   tuning_date[4];                 /* BCD coding                       */
    gchar   tuning_place[4];                /* ASCII coding, "TCR"              */
    guint8  tuning_version[4];              /* Binary coding                    */
    gchar   tuning_target_region[4];        /* ASCII coding, "EUR"              */
    guint32 speaker_configuration;       /* Binary coding, value=4 for AIVI  */
    gchar   library_type[4];                /* ASCII coding, "CLAS" or "AUDI"   */
    guint8   ark_lib_adr3_version[4];        /* BCD coding                       */
    guint8   ark_lib_imx_version[4];         /* BCD coding                       */
    guint8   ark_sat_version[4];             /* BCD coding                       */
    gchar   radio_sw_version[8];            /* ASCII coding, "AIVI    "         */
    gchar   configuration_type[4];          /* ASCII coding, "LHD", "RHD"       */
    guint32 data_size;
    guint8  reserved[8];
}tArkamysEolHeader;

typedef struct _tArkamysEolFile
{
    tArkamysEolHeader      header;
    guint8                    data[ARK_DP_MAX_SIZE];
} tArkamysEolFile;


typedef struct _dp_configuration_data
{
    tArkamysEolFile eoldata;
    guint32         eoldatasize;
    gboolean        iseolavailable;
    guint8          isarkamysClassicSupport;    // 00 = Classic, 01 = Auditorium, 10 = Premium //Audiosystem_PD_Item ;
    guint8          isarkamysAuditoriumSupport; // 00 = Classic, 01 = Auditorium, 10 = Premium //Audiosystem_PD_Item ;
    guint8          outputinformationitem;  //audiosystem_CD_Item ;
    guint8          audiomode;              //audiosystem_CD_Item ;
}dp_configuration_data;

/*******************************************************************************
              VARIABLE DECLARATIONS
*******************************************************************************/


//#define D_AUPROC_TEST_DP_ACCESS
//#define D_TEST_DP_CONTENT


/*********************************************************************************/
/*                         static function                                       */
/*********************************************************************************/

#ifdef D_AUPROC_TEST_DP_ACCESS
/* definition dp test class */

    static guint8 stubeoldata[] = {
        0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19, \
        0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19, \
        0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19, \
        0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19, \
        0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19
    };

    static tArkamysEolHeader myheader =
    {
        .eol_file_generation_date   = {1,2,3,4},                                            /* BCD coding */
        .car_manufacturer           = {0x52,0x52,0x41,0x20},                                /* ASCII coding, "RSA " or "NIS "     */
        .radio_manufacturer         = {0x42,0x4F,0x53,0x43},                                /* ASCII coding, "BOSC"             */
        .radio_project              = {0x41,0x49,0x56,0x49},                                /* ASCII coding, "AIVI    "         */
        .vehicle_id                 = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20}, /* Binary coding                    */
        .tuning_date                = {1,2,3,4},                                            /* BCD coding                       */
        .tuning_place               = {0x54,0x43,0x52,0x20},                                /* ASCII coding, "TCR "              */
        .tuning_version             = {1,2,3,4},                                            /* Binary coding                    */
        .tuning_target_region       = {0x45,0x55,0x52,0x20},                                /* ASCII coding, "EUR "              */
        .speaker_configuration      = 4,                                                    /* Binary coding, value=4 for AIVI  */
        .library_type               = {0x41,0x55,0x44,0x49},                                /* ASCII coding, "CLAS" or "AUDI"   */
        .ark_lib_adr3_version       = {1,2,3,4},                                            /* BCD coding                       */
        .ark_lib_imx_version        = {1,2,3,4},                                            /* BCD coding                       */
        .ark_sat_version            = {1,2,3,4},                                            /* BCD coding                       */
        .radio_sw_version           = {0x41,0x55,0x44,0x49,0x20,0x20,0x20,0x20},            /* ASCII coding, "AIVI    "         */
        .configuration_type         = {0x4C,0x48,0x44,0x20},                                /* ASCII coding, "LHD ", "RHD "       */
        .data_size                  = (guint32)sizeof(stubeoldata),
        .reserved                   = {0,1,2,3,4,5,6,7}
    };




class dp_tcl_audproc_dataset{

private:


    /* member variables */
    tArkamysEolFile m_eoldata;

public:


    dp_tcl_audproc_dataset()
    {
        pr_message("ENTERED\n");

        memcpy((void*)&m_eoldata.header, (void*)&myheader, sizeof(tArkamysEolHeader));
        memcpy((void*)&m_eoldata.data, (void*)&stubeoldata, sizeof(stubeoldata));

    };

    virtual ~dp_tcl_audproc_dataset() {};


    //read access for pool element
    tS32  s32GetData(tU8* data, tU32 u32ArraySize)
    {
        tS32 data_size = (guint32)(sizeof(stubeoldata) + 100);
        tU32 ret_size=0;
        tS32 cpy_size = 0;

        pr_message("ENTERED, with requested data size : %d \n", u32ArraySize);

        if(!data || !u32ArraySize)
        {
            pr_warning("copy buffer is NULL\n");
            return -1;
        }

        /* get pointer to data set memory */

        if(u32ArraySize < data_size)
            cpy_size = u32ArraySize;
        else
            cpy_size = data_size;

        (tVoid)memcpy((void*)data, (void*)&m_eoldata , cpy_size * sizeof(tU8));

        ret_size = data_size - cpy_size ;

        if(!ret_size)
            ret_size = data_size;

        return ret_size;
    };

};


#endif //D_AUPROC_TEST_DP_ACCESS



static dp_configuration_data* dp_data = (dp_configuration_data*)NULL;
static const char*            D_EOL_FILE = "/var/opt/bosch/dynamic/audiomanager/AIVI_EOL_DATA.bin";
static const char      *IsAuditorium = "/var/opt/bosch/dynamic/audiomanager/audproc_force_auditorium.txt";

#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT

#ifdef D_AUDPROC_DATAPOOL_SUPPORT
static void audproc_datapool_access_print_arkamys_eol_file_header(tArkamysEolHeader* header)
{


    if(!header)
        return;

    pr_message("******************************* arkamys eol header  ***********************\n");
    pr_message("eol_file_generation_date: %d/%d/%d%d\n", header->eol_file_generation_date[0],
                                                         header->eol_file_generation_date[1],
                                                         header->eol_file_generation_date[2],
                                                         header->eol_file_generation_date[3]);
    gchar* str = g_strndup((const char*)&header->car_manufacturer[0], 4);
    pr_message("car_manufacturer: %s\n", str);
    g_free(str);
    str = g_strndup((const char*)&header->radio_manufacturer[0], 4);
    pr_message("radio_manufacturer: %s\n", str);
    g_free(str);
    str = g_strndup((const char*)&header->radio_project[0], 8);
    pr_message("radio_project: %s\n", str);
    g_free(str);
    pr_message("vehicle_id: %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n", header->vehicle_id[0],
                                                                         header->vehicle_id[1],
                                                                         header->vehicle_id[2],
                                                                         header->vehicle_id[3],
                                                                         header->vehicle_id[4],
                                                                         header->vehicle_id[5],
                                                                         header->vehicle_id[6],
                                                                         header->vehicle_id[7],
                                                                         header->vehicle_id[8],
                                                                         header->vehicle_id[9],
                                                                         header->vehicle_id[10],
                                                                         header->vehicle_id[11],
                                                                         header->vehicle_id[12],
                                                                         header->vehicle_id[13],
                                                                         header->vehicle_id[14],
                                                                         header->vehicle_id[15],
                                                                         header->vehicle_id[16],
                                                                         header->vehicle_id[17],
                                                                         header->vehicle_id[18],
                                                                         header->vehicle_id[19]);
    pr_message("tuning_date: %d/%d/%d%d\n", header->tuning_date[0],
                                            header->tuning_date[1],
                                            header->tuning_date[2],
                                            header->tuning_date[3]);
    str = g_strndup((const char*)&header->tuning_place[0], 4);
    pr_message("tuning_place: %s\n", str);
    g_free(str);
    pr_message("tuning_version: %d%d%d%d\n", header->tuning_version[0],
                                                         header->tuning_version[1],
                                                         header->tuning_version[2],
                                                         header->tuning_version[3]);
    str = g_strndup((const char*)&header->tuning_target_region[0], 4);
    pr_message("tuning_target_region: %s\n", str);
    g_free(str);
    pr_message("speaker_configuration: %d\n", header->speaker_configuration);
    str = g_strndup((const char*)&header->library_type[0], 4);
    pr_message("library_type: %s\n", str);
    g_free(str);

    pr_message("ark_lib_adr3_version: v%d.%d.%d.%d\n",  header->ark_lib_adr3_version[0],
                                                        header->ark_lib_adr3_version[1],
                                                        header->ark_lib_adr3_version[2],
                                                        header->ark_lib_adr3_version[3]);
    pr_message("ark_lib_imx_version: v%d.%d.%d.%d\n",  header->ark_lib_imx_version[0],
                                                        header->ark_lib_imx_version[1],
                                                        header->ark_lib_imx_version[2],
                                                        header->ark_lib_imx_version[3]);
    pr_message("ark_sat_version: v%d.%d.%d.%d\n",  header->ark_sat_version[0],
                                                        header->ark_sat_version[1],
                                                        header->ark_sat_version[2],
                                                        header->ark_sat_version[3]);
    str = g_strndup((const char*)&header->radio_sw_version[0], 8);
    pr_message("radio_sw_version: %s\n", str);
    g_free(str);
    str = g_strndup((const char*)&header->configuration_type[0], 4);
    pr_message("configuration_type: %s\n", str);
    g_free(str);

    pr_message("******************************* arkamys eol header - end  ***********************\n");
    return;

}
#endif // D_AUDPROC_DATAPOOL_SUPPORT

//static guint8 current_imx_ark_lib_vers[4] = {1,2,3,4};
#define D_VERS_3_ONLY
//#define D_VERS_3_WITH_REV
#define D_BACKWARD_COMPATIBILITY
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
typedef struct tArk_lib_version
{
    int majeur;
    int mineur;
    int revision;
}Ark_lib_version;
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT

static gboolean  audproc_datapool_access_match_imx_lib_vers(guint8* vers)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    gboolean        match = FALSE;
    int             err = AUDPROC_ERR_OK;
    Ark_lib_version ark_lib_ver = {0,0,0};

    if(!vers)
        return FALSE;

    pr_message("match version: [0]:%d,[1]:%d,[2]:%d,[3]:%d\n", vers[0],vers[1],vers[2],vers[3]);
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:********* version of imx arkamys library in EOL Header************"));
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:EOL Header majeur   number: %d", vers[1]));
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:EOL Header mineur   number: %d", vers[2]));
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:EOL Header revision number: %d", vers[3]));


    err = audproc_apl_handler_get_ark_lib_ver((void*)&ark_lib_ver);
    pr_debug("arkamy library version is retrieved with status %d",err);

    pr_message("********* version of imx arkamys library ************ \n");
    pr_message("majeur   number: %d\n", ark_lib_ver.majeur);
    pr_message("mineur   number: %d\n", ark_lib_ver.mineur);
    pr_message("revision number: %d\n", ark_lib_ver.revision);

    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:********* version of imx arkamys library ************"));
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library majeur   number: %d", ark_lib_ver.majeur));
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library mineur   number: %d", ark_lib_ver.mineur));
    ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library revision number: %d", ark_lib_ver.revision));

#ifdef D_SUPPORT_MATCH_IMX_ARK_LIB_VERS
#ifndef D_BACKWARD_COMPATIBILITY
    if(ark_lib_ver.majeur == (int)vers[1])
#else
    if(ark_lib_ver.majeur > (int)vers[1])
    {
        match = TRUE;
        ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library eol and linked version are matching due to backward compatibility "));
    }
    else if(ark_lib_ver.majeur == (int)vers[1])
#endif //D_BACKWARD_COMPATIBILITY
    {
#ifndef D_BACKWARD_COMPATIBILITY
        if(ark_lib_ver.mineur == (int)vers[2])
#else
        if(ark_lib_ver.mineur > (int)vers[2])
        {
            match = TRUE;
            ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library eol and linked version are matching due to backward compatibility "));
        }
        else if(ark_lib_ver.mineur == (int)vers[2])
#endif
        {
            #if D_VERS_3_WITH_REV
            if(ark_lib_ver.revision == (int)vers[3])
            {
            #endif
                match = TRUE;
                pr_message("imx arkamys library eol and linked version are matching\n");
                ETG_TRACE_USR3(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library eol and linked version are matching"));
            #if D_VERS_3_WITH_REV
            }
            #endif
        }
    }

    if(!match)
    {
        pr_warning("imx arkamys library eol and linked version are not matching\n");
        ETG_TRACE_USR1(("[audproc_datapool_access_match_imx_lib_vers]:imx arkamys library eol and linked version are not matching"));
        ETG_TRACE_ERRMEM(("[AUDPROC][audproc_datapool_access_match_imx_lib_vers]: imx arkamys library eol and linked version are not matching"));
    }


#else
    match = TRUE;
#endif

    return match;
#else
    return TRUE;
#endif


}

#ifdef D_TEST_DP_CONTENT
static guint32 dpsize_test = 0;
#endif



static int audproc_datapool_read_cd_pd_config(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
  int err = AUDPROC_ERR_OK;

    if(!dp_data)
        return AUDPROC_ERR_NULL_POINTER;

    pr_message("ENTERED\n");

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding","ArkamysClassicSupport", &dp_data->isarkamysClassicSupport, 1)))
    {
        pr_message("PD: target support Arkamys classic: %d", dp_data->isarkamysClassicSupport);
    }
    else
    {
        err = AUDPROC_ERR_DP_CD_READ_FAILURE;
        pr_warning("error in diagnosis read ");
    }

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding","ArkamysAuditoriumSupport", &dp_data->isarkamysAuditoriumSupport, 1)))
    {
        pr_message("PD: target support Arkamys auditorium : %d", dp_data->isarkamysAuditoriumSupport);
    }
    else
    {
        err = AUDPROC_ERR_DP_CD_READ_FAILURE;
        pr_warning("error in diagnosis read ");
    }

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","OutputInformation", &dp_data->outputinformationitem, 1)))
    {
        pr_message("CD: Audio_Configuration was set to : %d", dp_data->outputinformationitem);
    }
    else
    {
        err = AUDPROC_ERR_DP_CD_READ_FAILURE;
        pr_warning("error in diagnosis read ");
    }

    return err;
#else
        return AUDPROC_ERR_OK;
#endif // D_AUDPROC_DATAPOOL_SUPPORT
}



static  void audproc_datapool_access_check_audio_mode_config_validity(void)
{

#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_datapool_access_check_audio_mode_config_validity]: ENTERED"));


    if(!dp_data)
        return;

    dp_data->iseolavailable = TRUE;

    gchar* str_lib_type = g_strndup((const char*)&dp_data->eoldata.header.library_type, 4);
    pr_message("library_type : %s\n", str_lib_type);
    ETG_TRACE_USR3(("[audproc_datapool_access_check_audio_mode_config_validity]: library_type : %s", str_lib_type));

    /* match version */
    if(!audproc_datapool_access_match_imx_lib_vers(&dp_data->eoldata.header.ark_lib_imx_version[0]))
    {
        dp_data->iseolavailable = FALSE;
        dp_data->audiomode     = D_AUDIO_MODE_CLASSIC;
    }
    else
    {
        /* the library version match, eol content can be evaluated */

        if(!g_strcmp0(str_lib_type, "CLAS"))  // standard log -> message
        {
            if(   (dp_data->outputinformationitem == D_OUTPUT_INFO_INT_AMP)
                ||(dp_data->outputinformationitem == D_OUTPUT_INFO_PREMIUM_1)
                ||(dp_data->outputinformationitem == D_OUTPUT_INFO_PREMIUM_2))
            {
                dp_data->iseolavailable = FALSE;
                dp_data->audiomode     = D_AUDIO_MODE_CLASSIC;
            }
        }
        else if (!g_strcmp0(str_lib_type, "AUDI"))
        {
            if(   (dp_data->outputinformationitem == D_OUTPUT_INFO_INT_AMP)
                ||(dp_data->outputinformationitem == D_OUTPUT_INFO_PREMIUM_1)
                ||(dp_data->outputinformationitem == D_OUTPUT_INFO_PREMIUM_2))
            {
                if(    dp_data->isarkamysClassicSupport
                    && !dp_data->isarkamysAuditoriumSupport )
                {
                    dp_data->iseolavailable = FALSE;
                    dp_data->audiomode = D_AUDIO_MODE_CLASSIC;
                }
                else if(dp_data->isarkamysAuditoriumSupport)
                {
                    dp_data->iseolavailable = TRUE;
                    dp_data->audiomode = D_AUDIO_MODE_AUDITORIUM;
                }
                else
                {
                    dp_data->iseolavailable = FALSE;
                    dp_data->audiomode = D_AUDIO_MODE_CLASSIC;
                }
            }
            else //D_AUDIO_MODE_CLASSIC
            {
                dp_data->iseolavailable = FALSE;
                dp_data->audiomode = D_AUDIO_MODE_CLASSIC;
            }
        }
        else
        {
            /* default classic */
            dp_data->iseolavailable = FALSE;
            dp_data->audiomode = D_AUDIO_MODE_CLASSIC;
        }
    }

    if(str_lib_type)
    g_free(str_lib_type);

    ETG_TRACE_USR3(("[audproc_datapool_access_check_audio_mode_config_validity]: EXIT with iseolavailable=%d, audiomode=%d", dp_data->iseolavailable, dp_data->audiomode));
    pr_message(" dp_data->iseolavailable=%d, dp_data->audiomode=%d \n", dp_data->iseolavailable, dp_data->audiomode);
#endif // #ifdef D_AUDPROC_DATAPOOL_SUPPORT
    return;
}


static void audproc_datapool_access_eol_load_dataset(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    FILE            *pFile = NULL;
    long int         dpsize = 0;
    gboolean        iseolfromfile = FALSE;



    #ifdef D_AUPROC_TEST_DP_ACCESS
    dp_tcl_audproc_dataset oDpEol;
    #else
    dp_tclArkamysDPArkamys_Eol oDpEol;
    #endif

    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_datapool_access_eol_load_dataset]: ENTERED"));

    /***********************************
     * read dataset from a file
     */

#ifdef D_SUPPORT_AUDPROC_LOAD_EOL_FROM_FILE
     const char* sload_eol_from_file = getenv("AUDPROC_LOAD_EOL_FROM_FILE");

    if(sload_eol_from_file)
        pr_message("FEAT AUDPROC_LOAD_EOL_FROM_FILE = %s\n", sload_eol_from_file);

    if (!g_strcmp0(sload_eol_from_file, "1"))  // read eol from file
    {
#endif
        FILE            *eolfile = NULL;

        eolfile = fopen(D_EOL_FILE, "rb");

        if(NULL == eolfile)
        {
             pr_warning("no arkamys eol file found:  %s", D_EOL_FILE);
             ETG_TRACE_USR1(("[audproc_datapool_access_eol_load_dataset]: no arkamys eol file found:  %s", D_EOL_FILE));
        }
        else
        {

            pr_message("the AIVI_EOL_DATA.bin file was found, the arkamys eol dataset is readen from this file instead of from datapool\n");
            ETG_TRACE_USR1(("[audproc_datapool_access_eol_load_dataset]: the AIVI_EOL_DATA.bin file was found, the arkamys eol dataset is readen from this file instead of from datapool"));

            /* find out the length of the file */
            fseek(eolfile, 0L, SEEK_END);
            dpsize = ftell(eolfile);
            fseek(eolfile, 0L, SEEK_SET); /* go back to the beginning */

            if(dpsize)
            {
                if(!dp_data)
                {
                    dp_data = (dp_configuration_data*)g_malloc0(sizeof(dp_configuration_data));

                    if(!dp_data)
                    {
                        pr_critical("fails to allocate memory dor eol control structure\n");
                        ETG_TRACE_ERR(("[audproc_datapool_access_eol_load_dataset]: fails to allocate memory dor eol control structure"));
                        return;
                    }
                }

                if(dpsize != (long int)fread((void*)&dp_data->eoldata, 1, dpsize, eolfile))
                {
                    pr_warning("fail to read arkamys eol file");
                    ETG_TRACE_USR1(("[audproc_datapool_access_eol_load_dataset]: fail to read arkamys eol file"));
                }
                else
                {
                    iseolfromfile = TRUE;
                    dp_data->iseolavailable = TRUE;
                    dp_data->audiomode = D_AUDIO_MODE_AUDITORIUM;
                    ETG_TRACE_USR1(("[audproc_datapool_access_eol_load_dataset]: eol file was loaded"));
                }
            }
            fclose(eolfile);
        }
#ifdef  D_SUPPORT_AUDPROC_LOAD_EOL_FROM_FILE
    }
#endif



    /********************************************
     * read Arkamys eol data from datapool
     */
    if(!iseolfromfile)
    {
        pr_message("read arkamys eol data from the datapool\n");
        ETG_TRACE_USR3(("[audproc_datapool_access_eol_load_dataset]: read arkamys eol data from the datapool"));

        dpsize = oDpEol.s32GetData((tU8*)&dp_data->eoldata.header, (tU32)(sizeof(tArkamysEolHeader)));
    }

    if(dpsize)
    {
        pr_message("size of the eol configuration dataset -> %ld\n", dpsize);
        ETG_TRACE_USR3(("[audproc_datapool_access_eol_load_dataset]: size of the eol configuration dataset -> %ld", dpsize));

#ifdef D_TEST_DP_CONTENT
        dpsize_test = oDpEol.s32GetData((tU8*)&dp_data->eoldata, (tU32)(ARK_DP_MAX_SIZE));
        pr_message("size of complete data pool dpsize_test: %d\n", dpsize_test);

        if(dpsize_test)
        {
            dp_data->iseolavailable = TRUE;
            dp_data->audiomode = D_AUDIO_MODE_AUDITORIUM;
            pr_message("D_TEST_DP_CONTENT is active: iseolavailable: %d, audiomode :%d\n", dp_data->iseolavailable, dp_data->audiomode);
            return;
        }
#endif


        /* read eol data size */
        dp_data->eoldatasize =  dp_data->eoldata.header.data_size;

        if(   (dp_data->eoldatasize > ARK_DP_MAX_SIZE)
            ||!dp_data->eoldatasize)
        {
            pr_warning("the arkamys eol datapool is not available, eoldatasize(%d)\n", dp_data->eoldatasize);
            dp_data->eoldatasize = 0;
        }

        else if(dp_data->eoldatasize)
        {
            /* print eol headder content */
            audproc_datapool_access_print_arkamys_eol_file_header(&dp_data->eoldata.header);

            pr_message("size of eol data : %d\n", dp_data->eoldatasize);

            /* make a local copy of the eol file  */
            if(!iseolfromfile)
                dpsize = oDpEol.s32GetData((tU8*)&dp_data->eoldata, (dp_data->eoldatasize + (tU32)(sizeof(tArkamysEolHeader))));

            /* if dp content available than go forward with content matching with target configuration (CD/PD)*/
            if(dpsize)
            {

                /* check validity of configuration
                 * check eol file and cd/dp setting
                */
                audproc_datapool_access_check_audio_mode_config_validity();

            }
            else
            {
                pr_warning("no arkamys eol data available\n");
                ETG_TRACE_USR1(("[audproc_datapool_access_eol_load_dataset]: arkamys eol dataset not available"));
                dp_data->iseolavailable = FALSE;
                dp_data->audiomode = D_AUDIO_MODE_CLASSIC;
            }
        }
    }
    else
    {
        pr_warning("the arkamys EOL datapool is empty\n");
        ETG_TRACE_USR1(("[audproc_datapool_access_eol_load_dataset]: the arkamys EOL datapool is empty"));
    }
    /***************************************************
     * force system configuration from file if present
     */
    pr_message("search if the file audproc_force_auditorium.txt exist\n");

    pFile = fopen(IsAuditorium, "r");

    if(NULL == pFile)
    {
        /* consider this state only if the eol datapool is not available */
        if(!dp_data->iseolavailable)
            dp_data->audiomode = D_AUDIO_MODE_CLASSIC;
    }
    else
    {
        pr_message("auditorium configuration enabled per file\n");
        ETG_TRACE_USR3(("[audproc_datapool_access_eol_load_dataset]: auditorium configuration enabled per file"));
        dp_data->audiomode = D_AUDIO_MODE_AUDITORIUM;
        if(dpsize)
            dp_data->iseolavailable = TRUE;
        fclose(pFile);
    }

    ETG_TRACE_USR3(("[audproc_datapool_access_eol_load_dataset]: iseolavailable: %d, audiomode :%d", dp_data->iseolavailable, dp_data->audiomode ));
    pr_message("iseolavailable: %d, audiomode :%d\n", dp_data->iseolavailable, dp_data->audiomode);

#endif // #ifdef D_AUDPROC_DATAPOOL_SUPPORT
    return;

}


/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void  audproc_datapool_access_init(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    int       err = AUDPROC_ERR_OK;

    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_datapool_access_init]: ENTERED"));

    /* initialize structure  */
    dp_data = (dp_configuration_data*)g_malloc0(sizeof(dp_configuration_data));

    if(!dp_data)
    {
        pr_critical("fails to allocate memory dor eol control structure\n");
        ETG_TRACE_ERR(("[audproc_datapool_access_init]: fails to allocate memory dor eol control structure"));
        return;
    }


    /* default configuration */
    dp_data->iseolavailable = FALSE;
    dp_data->eoldatasize = 0;
    dp_data->audiomode = D_AUDIO_MODE_CLASSIC;

    /***********************************
     * - read from PD: item audioconfigutration (device)
     * - read from CD: item output information
     * - [ref:Arkamys Mode.docx]
     */

    err = audproc_datapool_read_cd_pd_config();
    if(err)
    {
        /* set default configuration */
        dp_data->outputinformationitem    = D_OUTPUT_INFO_INT_AMP;
        dp_data->isarkamysClassicSupport    = 1;
        dp_data->isarkamysAuditoriumSupport  = 0;
    }

    /* load configuration and scheck content */
    audproc_datapool_access_eol_load_dataset();
    ETG_TRACE_USR3(("[audproc_datapool_access_init]: EXIT"));
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT

    return;
}

/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_eol_reload_dataset
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int     audproc_datapool_access_eol_reload_dataset(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_datapool_access_eol_reload_dataset]: ENTERED"));



    /* free previous local eol container */
    if(dp_data)
    {
        memset((void*)&dp_data->eoldata.header, 0, sizeof(tArkamysEolHeader));
        memset((void*)&dp_data->eoldata.data, 0, ARK_DP_MAX_SIZE);

        /* load new eol data from either dp or file  */
        audproc_datapool_access_eol_load_dataset();
    }
    else
    {
        audproc_datapool_access_init();
    }

    ETG_TRACE_USR3(("[audproc_datapool_access_eol_reload_dataset]: EXIT"));
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    return AUDPROC_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_eol_set_auditorium_avail
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void    audproc_datapool_access_eol_set_auditorium_avail(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    ETG_TRACE_USR3(("[audproc_datapool_access_eol_set_auditorium_avail]: ENTERED"));

    if(dp_data)
    {
        dp_data->iseolavailable = TRUE;
        dp_data->audiomode = D_AUDIO_MODE_AUDITORIUM;

        ETG_TRACE_USR3(("[audproc_datapool_access_eol_set_auditorium_avail]: iseolavailable -> %d, audiomode->%d",dp_data->iseolavailable, dp_data->audiomode ));

    }
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    return;
}


/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_get_eol_dataset
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
guint8*  audproc_datapool_access_get_eol_dataset(guint32*   size_dataset)
{
    int err = AUDPROC_ERR_OK;

#ifdef D_AUDPROC_DATAPOOL_SUPPORT

    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_datapool_access_get_eol_dataset]: ENTERED"));

    if(!dp_data)
        return  (guint8*)NULL;

    if(!size_dataset)
        return (guint8*)NULL;

    ETG_TRACE_USR1(("[audproc_datapool_access_get_eol_dataset]: eol loading state: iseolavailable->%d, eoldatasize->%d", dp_data->iseolavailable, dp_data->eoldatasize ));

#ifndef D_TEST_DP_CONTENT
    if(!dp_data->iseolavailable || dp_data->eoldatasize == 0)
    {

        ETG_TRACE_USR1(("[audproc_datapool_access_get_eol_dataset]: trigger reload of the eol dataset, iseolavailable->%d, eoldatasize->%d", dp_data->iseolavailable, dp_data->eoldatasize ));
        err = audproc_datapool_access_eol_reload_dataset();
        if(err)
        {
            pr_warning("fails to reload dataset with error:%d\n", err);
            pr_warning("EOL dataset not available (iseolavailable=%d, eoldatasize=%d)\n", dp_data->iseolavailable, dp_data->eoldatasize );
            ETG_TRACE_USR1(("[audproc_datapool_access_get_eol_dataset]: fails to reload dataset with error, EOL dataset not available"));
            *size_dataset = 0;
            return  (guint8*)NULL;
        }

/*
        pr_warning("EOL dataset not available (iseolavailable=%d, eoldatasize=%d)\n", dp_data->iseolavailable, dp_data->eoldatasize );
        ETG_TRACE_USR1(("[audproc_datapool_access_get_eol_dataset]: EOL dataset not available"));
        *size_dataset = 0;
        return  (guint8*)NULL;
*/
    }
    /* size of Imx eol data set */
#else
    if(dpsize_test)
    {
        *size_dataset =  dpsize_test;
        return (guint8*)&dp_data->eoldata;
    }
    else
        pr_warning("D_TEST_DP_CONTENT is active: EOL dataset not available dpsize_test=%d\n", dpsize_test );
#endif
    if(dp_data->eoldatasize)
        *size_dataset = dp_data->eoldatasize + (guint32)sizeof(tArkamysEolHeader)  ; //dp_data->eolsize;
    else
        *size_dataset = 0;

    ETG_TRACE_USR3(("[audproc_datapool_access_get_eol_dataset]: EXIT with EOL dataset size ->%d and eol avail state ->%d",*size_dataset, dp_data->iseolavailable));

    return (guint8*)&dp_data->eoldata;
#else
    return  (guint8*)NULL;
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT
}

/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_finalize
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void   audproc_datapool_access_finalize(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    pr_message("all datapool related resources are freed");

    if(dp_data)
        g_free(dp_data);
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    return;
}



/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_get_audio_audio_mode
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void audproc_datapool_access_print_audio_mode_config(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    if(dp_data)
    {
        audproc_datapool_access_print_arkamys_eol_file_header(&dp_data->eoldata.header);

        pr_message("dp_data->iseolavailable            :%d\n", dp_data->iseolavailable);
        pr_message("dp_data->eoldatasize               :%d\n", dp_data->eoldatasize);
        pr_message("dp_data->audiomode                 :%d\n", dp_data->audiomode);
        pr_message("dp_data->outputinformationitem     :%d\n", dp_data->outputinformationitem);
        pr_message("dp_data->isarkamysClassicSupport   :%d\n", dp_data->isarkamysClassicSupport);
        pr_message("dp_data->isarkamysAuditoriumSupport:%d\n", dp_data->isarkamysAuditoriumSupport);

    }
    else
        pr_message("No configuration available\n");
#endif //#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    return;

}


/*******************************************************************************
*
* FUNCTION: audproc_datapool_access_get_audio_audio_mode
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
guint8   audproc_datapool_access_get_audio_audio_mode(void)
{
#ifdef D_AUDPROC_DATAPOOL_SUPPORT
    pr_message("ENTERED\n");

    if(dp_data)
    {
        if(   (dp_data->audiomode == D_AUDIO_MODE_CLASSIC_PREMIUM_1)
            ||(dp_data->audiomode == D_AUDIO_MODE_CLASSIC_PREMIUM_2)
            ||(dp_data->audiomode == D_AUDIO_MODE_CLASSIC))

            return  D_AUDIO_MODE_CLASSIC;

        else if(  (dp_data->audiomode == D_AUDIO_MODE_AUDITORIUM_PREMIUM_1)
                ||(dp_data->audiomode == D_AUDIO_MODE_AUDITORIUM_PREMIUM_2)
                ||(dp_data->audiomode == D_AUDIO_MODE_AUDITORIUM))

            return  D_AUDIO_MODE_AUDITORIUM;
        else
        {
            return  D_AUDIO_MODE_CLASSIC;
        }
    }


    return D_AUDIO_MODE_CLASSIC; /* default value */
#else
    #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
    return D_AUDIO_MODE_WEB_CONTAINER;
    #endif
#endif
}

#ifdef __cplusplus
}
#endif

