/*
 * audproc-object.h
 *
 *
 * Author: Patrick Rey
 * Date: 07.08.2015
 * Version 0.1 :  init version
 */

#ifndef __AUDPROC_OBJECT_H__
#define __AUDPROC_OBJECT_H__


/**
 * Define enumerations for the different signals that we can generate
 * (so that we can refer to them within the signals-array [below]
 * using symbolic names). These are not the same as the signal name
 * strings.
 *
 * NOTE: E_SIGNAL_COUNT is NOT a signal enum. We use it as a
 *       convenient constant giving the number of signals defined so
 *       far. It needs to be listed last.
 */
typedef enum
{
    E_SIGNAL_AUDPROC_STATUS,
    E_SIGNAL_AUDPROC_MICRO_LEVEL_STATUS,
    E_SIGNAL_AUDPROC_ARKAMYS_LEVEL_LOSS,
    E_SIGNAL_COUNT
} AudProcSignal;

/* Symbolic constants for the signal names to use with GLib.
   These need to map into the D-Bus signal names. */
#define SIGNAL_AUDPROC_STATUS                   "audproc_status"
#define SIGNAL_AUDPROC_MICRO_LEVEL_STATUS       "audproc_microlevel_status"
#define SIGNAL_AUDPROC_ARKAMYS_LEVEL_LOSS       "audproc_arkamys_level_loss"


typedef struct AudprocObject AudprocObject;
typedef struct AudprocObjectClass AudprocObjectClass;

GType audproc_object_get_type(void);

struct AudprocObject {
  GObject parent;
  gboolean Audproc_is_initialized;
  gint Audproc_current_configid;
};

struct AudprocObjectClass {
  GObjectClass parent;

  /* Signals created for this class. */
  guint signals[E_SIGNAL_COUNT];
};


#define AUDPROC_TYPE_OBJECT              (audproc_object_get_type ())
#define AUDPROC_OBJECT(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), AUDPROC_TYPE_OBJECT, AudprocObject))
#define AUDPROC_OBJECT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), AUDPROC_TYPE_OBJECT, AudprocObjectClass))
#define AUDPROC_IS_OBJECT(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), AUDPROC_TYPE_OBJECT))
#define AUDPROC_IS_OBJECT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDPROC_TYPE_OBJECT))
#define AUDPROC_OBJECT_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDPROC_TYPE_OBJECT, AudprocObjectClass))




extern   gboolean audproc_object_audproc_get_version(AudprocObject * qobj, GArray ** version, gchar ** version_string, gchar ** version_comment, GError ** error);
extern   gboolean audproc_object_audproc_get_status(AudprocObject * qobj, GError ** error);
extern   gboolean audproc_object_audproc_initialize(AudprocObject * qobj, guchar AudprocSourceId, gchar* AudprocConfigurationFile, GError ** error);
extern   gboolean audproc_object_audproc_set_configuration(AudprocObject * qobj, guchar AudprocSourceId, gchar* AudprocConfigurationFile, GError ** error);
extern   gboolean audproc_object_audproc_set_param(AudprocObject * qobj, guchar AudprocSourceId, guint ParameterId, guchar ParamType, guint32 uParameter, gint32 iParameter, GError ** error);
extern   gboolean audproc_object_audproc_write_data(AudprocObject * qobj, guchar AudprocSourceId, guint ParameterId, GArray *data, GArray   **result, GError ** error);
extern   gboolean audproc_object_audproc_read_data(AudprocObject * qobj, guchar AudprocSourceId, guint ParameterId, GArray *ReadInfos, GArray **data, GError ** error);
extern   gboolean audproc_object_audproc_destroy(AudprocObject * qobj, guchar AudprocSourceId, GError ** error);
extern   gboolean audproc_object_audproc_terminate(AudprocObject * qobj, GError ** error);
extern   gboolean audproc_object_audproc_get_audproc_configuration(AudprocObject * qobj, gchar ** DatasetName, GArray ** AudprocProperties, GError ** error);
extern   gboolean audproc_object_audproc_start_audio(AudprocObject * qobj, guchar AudprocSourceId, GError ** error);
extern   gboolean audproc_object_audproc_stop_audio(AudprocObject * qobj, guchar AudprocSourceId, GError ** error);
extern   gboolean audproc_object_audproc_source_select(AudprocObject * qobj, guchar AudprocSourceSelectMode, guchar AudprocSourceId, gchar* AudprocAlsaDev, GError ** error);
extern   gboolean audproc_object_audproc_source_activity(AudprocObject * qobj, guchar AudprocSourceMapId,  guchar AudprocSourceActivity, GError ** error);
extern   gboolean audproc_object_audproc_mute(AudprocObject * qobj, GError ** error);
extern   gboolean audproc_object_audproc_create(AudprocObject * qobj, GError ** error);
extern   gboolean audproc_object_audproc_setup_debug(AudprocObject * qobj, guchar AudprocSelectMode, GError ** error);

/* send functions */
extern   int      audproc_object_emit_signal_micro_level(guint32 MicroLevel);
extern   int      audproc_object_emit_signal_voice_sources_state(guint8 state);
extern   int      audproc_object_emit_signal_ent_sources_state(guint8 state);
extern   int      audproc_object_emit_signal_info_sources_state(guint8 state);
extern   int      audproc_object_emit_signal_arkamys_level_loss(gint ArkamysLevelLoss);


#endif //__AUDPROC_OBJECT_H__
