/*******************************************************************************
* FILE : audproc-configuration-data.h
*
* SW-COMPONENT :
*
* DESCRIPTION :
*
* AUTHOR : Patrick Rey
*
* COPYRIGHT : (C)
*
* HISTORY : 09.02.2016
* Initial version
*******************************************************************************/



#ifndef __AUDPROC_CONFIGURATION_DATA_H__
#define __AUDPROC_CONFIGURATION_DATA_H__


static guint8 CH_MAP_0_1[2] = {0,1};
static guint8 CH_MAP_0_1_2_3[4] = {0,1,2,3};
static guint8 CH_MAP_0 = 0;

static tAplBinding bindingdef_00_11 [2] =
{
    [0] =
    {
        .in  = 0,
        .out = 0
    },
    [1] =
    {
        .in  = 1,
        .out = 1
    }
};
static tAplBinding bindingdef_00_11_02_13 [4] =
{
    [0] =
    {
        .in  = 0,
        .out = 0
    },
    [1] =
    {
        .in  = 1,
        .out = 1
    },
    [2] =
    {
        .in  = 0,
        .out = 2
    },
    [3] =
    {
        .in  = 1,
        .out = 3
    }
};


static tAplBindingMatrix   binding_00_11 =
{
    .inchannelnb = 2,
    .outchannelnb = 2,
    .bindingnb = 2,
    .audbind = (tAplBinding*)&bindingdef_00_11
};

static tAplBindingMatrix   binding_00_11_02_13 =
{
    .inchannelnb = 2,
    .outchannelnb = 4,
    .bindingnb = 4,
    .audbind = (tAplBinding*)&bindingdef_00_11_02_13
};


/*******************************************************************************
*
* FUNCTION: audproc_cfg_classic
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/

static audproc_alsa_stream_cfg audproc_cfg_classic [] =
{
    {
        .source_id = AUD_PROC_SRC_ENT5,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:7",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*8ms */
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 32,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT6,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:6",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,        /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT7,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:5",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT8,
        .available = FALSE, // TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntADRIn",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT9,
        .available = TRUE, // TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:0",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT10,
        .available = TRUE, // TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:3",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT14,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:2",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_VOICE1,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevAudProcInOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 16000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 160 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcInOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 16000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 160 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 10,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_MICRO_LEVEL_MONITORING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_VOICE
        },
        .prefill_ms = 10,
        .proc_frame_size = 160,
        .audproc_close_on_stop = TRUE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_VOICE2,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:5",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcVoiceOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 31,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_RECREATE_AT_STR_START_ONLY
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO //AUD_PROC_SRC_TYPE_ENT //AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = TRUE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_INFO1,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:1",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_INFO2,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:4",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_INFO3,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:7",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_CLOCK_ON_OFF,
        .available = FALSE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEsaiClockOnOff",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
    },
#if 0
    {
        .source_id = AUD_PROC_SRC_ENT17,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:1",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
        .audproc_start_time_out_ms = 100
    }
#else
    {
        .source_id = AUD_PROC_SRC_ENT17,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:1",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevClassicOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*8ms */
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 32,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON, //TRUE
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    }
#endif
};

#define AUD_PROC_SRC_SOURCE_CLASSIC_MAX ARRAYSIZE(audproc_cfg_classic)


/*******************************************************************************
*
* FUNCTION: audproc_cfg_auditorium
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/


static audproc_alsa_stream_cfg audproc_cfg_auditorium [] =
{
    {
        .source_id = AUD_PROC_SRC_ENT1,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:7",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*8ms*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 32,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT2,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:6",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT3,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:5",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT4,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntADRIn",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT11,
        .available = TRUE, // TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:0",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT12,
        .available = TRUE, // TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:3",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_ENT13,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:2",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_VOICE1,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevAudProcInOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 16000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 160 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcInOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 16000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 160 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 10,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_MICRO_LEVEL_MONITORING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_VOICE
        },
        .prefill_ms = 10,
        .proc_frame_size = 160,
        .audproc_close_on_stop = TRUE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_VOICE2,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:5",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcVoiceOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = &CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S16_LE,         /*format*/
            .audproc_prefill_ms = 31,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_RECREATE_AT_STR_START_ONLY
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO //AUD_PROC_SRC_TYPE_ENT //AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = TRUE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_INFO1,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:1",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_INFO2,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:4",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_INFO3,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:7",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    },
    {
        .source_id = AUD_PROC_SRC_CLOCK_ON_OFF,
        .available = FALSE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEsaiClockOnOff",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAudProcMixOut",      /*zero terminated string*/
            .audproc_nb_ch = 1,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
    },
#if 0
    {
        .source_id = AUD_PROC_SRC_ENT16,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:1",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11_02_13,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_INFO
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
        .audproc_start_time_out_ms = 100
    }
#else
    {
        .source_id = AUD_PROC_SRC_ENT16,
        .available = TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevEntSrcSelectIn:1",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevAuditoriumOut",      /*zero terminated string*/
            .audproc_nb_ch = 4,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1_2_3,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*8ms*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 32,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .lpdev = {0},
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_ARKAMYS_PROCESSING,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_ARKAMYS_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
#ifdef D_ENABLE_RTS_LOG_CB
        .audproc_start_time_out_ms = 100
#else
        .audproc_start_time_out_ms = 100,
        .audproc_rts_log_cb = (trts_logcb)NULL
#endif
    }
 #endif
};

#define AUD_PROC_SRC_SOURCE_AUDITORIUM_MAX ARRAYSIZE(audproc_cfg_auditorium)


/*******************************************************************************
*
* FUNCTION: audproc_cfg_web_container
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/

static audproc_alsa_stream_cfg audproc_cfg_web_container [] =
{
    {
        .source_id = AUD_PROC_SRC_ENT1,
        .available = TRUE, // TRUE,
        .create_route_on_init = TRUE,
        .indev =
        {
            .audproc_dev_name = "AdevLxcSrcSelect:0",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_CAPTURE,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
        .outdev =
        {
            .audproc_dev_name = "AdevEnt1Out",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_OPEN_AT_STR_START_CLOSE_AT_STR_END, //TRUE
        },
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
        .lpdev =
        {
            .audproc_dev_name = "AdevVPAOut",      /*zero terminated string*/
            .audproc_nb_ch = 2,
            .audproc_str_ch_map = (guint8*)&CH_MAP_0_1,
            .audproc_dir = SND_PCM_STREAM_PLAYBACK,          /*SND_PCM_STREAM_PLAYBACK*/
            .audproc_rate = 48000,           /*any, e.g. 8000-192000*/
            .audproc_period_frames = 384 ,  /*e.g. 64/128/256/512*/
            .audproc_format = SND_PCM_FORMAT_S32_LE,         /*format*/
            .audproc_prefill_ms = 8,
            .audproc_startup_tout_ms = 50,
            .audproc_create_on_start = AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON
        },
#else
        .lpdev = {0},
#endif
        .audbinding = (tAplBindingMatrix*)&binding_00_11,
        .audcfg  =
        {
            .audproc_aud_cfg_id     = AUDPROC_CFG_AUDIO_ENT_LOOPBACK, //AUDPROC_CFG_AUDIO_LOOPBACK,
            .audproc_apl_inst_name  = APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, //APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS,
            .audproc_this_src_type  = AUD_PROC_SRC_TYPE_ENT
        },
        .prefill_ms = 8,
        .proc_frame_size = 384,
        .audproc_close_on_stop = FALSE,
        .audproc_start_time_out_ms = 100
    }
};

#define AUD_PROC_SRC_SOURCE_WEB_CONTAINER_MAX ARRAYSIZE(audproc_cfg_web_container)


/*******************************************************************************
*
* FUNCTION: apl_parm_table
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/

#define D_DATA_AREA_CNT_MAX 100


/* apl parameter table*/
static const struct aplParameter apl_parm_table[] =
{
    /* Property ID 0 is reserved by GLib, so don't use index 0 in the table. */
    {.apl_name = "",},
    APL_PARM_U16("apl-frame-shift-in"                     , aplFrameShiftIn                   , APL_INSTANCE_STR_ALL_FCTS),
    APL_PARM_U16("apl-frame-shift-out"                    , aplFrameShiftOut                  , APL_INSTANCE_STR_ALL_FCTS),
    APL_PARM_U16("apl-sample-rate-in"                     , aplSampleRateIn                   , APL_INSTANCE_STR_ALL_FCTS),
    APL_PARM_U16("apl-sample-rate-out"                    , aplSampleRateOut                  , APL_INSTANCE_STR_ALL_FCTS),
    APL_PARM_I32("apl-arkamys-switch"                     , aplArkamysSwitch                  , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-avc-activate"               , aplArkamysAvcActivate             , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-sdeq-activate"              , aplArkamysSdeqActivate            , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-bass-exciter-activate"      , aplArkamysBassExciterActivate     , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-reverb-activate"            , aplArkamysReverbActivate          , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-by-pass-activate"           , aplArkamysByPassActivate          , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-set-data"                   , aplArkamysSetData                 , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-get-data"                   , aplArkamysGetData                 , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-read-data"                  , aplArkamysReadData                , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-set-get-data"               , aplArkamysSetGetData              , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-eol-data"                   , aplArkamysEolData                 , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-input-level-deviation"      , aplArkamysInputLevelDeviation     , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-current-speed"              , aplArkamysCurrentSpeed            , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-current-volume-step"        , aplArkamysCurrentVolumeStep       , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-level-loss"                 , aplArkamysLevelLoss               , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32_ARRAY("apl-arkamys-library-version"      , aplArkamysLibraryVersion          , 3,  APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-ambience-select"            , aplArkamysAmbienceSelect          , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-curr-vol-attenuation"       , aplArkamysCurrVolAttenuation      , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-frame-shift-in"             , aplArkamysFrameShiftIn            , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-sample-rate-in"             , aplArkamysSampleRateIn            , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-channel-cnt-in"             , aplArkamysChannelCntIn            , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-audio-pcm-format-in"        , aplArkamysAudioPcmFormatIn        , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-frame-shift-out"            , aplArkamysFrameShiftOut           , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-sample-rate-out"            , aplArkamysSampleRateOut           , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-channel-cnt-out"            , aplArkamysChannelCntOut           , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_U16("apl-arkamys-audio-pcm-format-out"       , aplArkamysAudioPcmFormatOut       , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-library-state"              , aplArkamysLibraryState            , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-flush"                      , aplArkamysFlush                   , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-mic-lvl-watch-switch"               , aplMicLvlWatchSwitch              , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),
    APL_PARM_U16("apl-mic-lvl-watch-ref-int"              , aplMicLvlWatchRefInt              , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),    /* micro level watch refresh interval */
    APL_PARM_I16("apl-mic-lvl"                            , aplMicLvl                         , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),               /* micro level */
    APL_PARM_I32("apl-mic-lvl-watch-start-stop"           , aplMicLvlWatchStartStop           , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),
    APL_PARM_I32("apl-mic-lvl-operation-mode"             , aplMicLvlOperationMode            , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),
    APL_PARM_I32("apl-pcm-copy-switch"                    , aplPcmCopySwitch                  , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),
    APL_PARM_I32("apl-audio-channel-binding"              , aplAudioChannelBinding            , APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS),
    APL_PARM_I32("apl-audio-mode"                         , aplAudioMode                      , APL_INSTANCE_STR_ALL_FCTS),
    APL_PARM_I32("apl-loopback-activate"                  , aplLoopbackActivate               , APL_INSTANCE_STR_ALL_FCTS),
    APL_PARM_I32("apl-arkamys-switch-state"               , aplArkamysSwitchState             , APL_INSTANCE_STR_ARKAMYS_FCTS),
    APL_PARM_I32("apl-arkamys-write-multi-frame"          , aplArkamysWriteMultiFrame         , APL_INSTANCE_STR_ARKAMYS_FCTS),
};

#define APL_PARAM_TABLE_SIZE ARRAYSIZE(apl_parm_table)


/*******************************************************************************
*
* STRUCTURE: audproc_audsrc_lookup_table
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE:
*
*******************************************************************************/



static const  audproc_audsrc_lookup audproc_audsrc_lookup_table_classic[] =
{
    {
        .midw_audsrc_fi = 24, //midw_fi_tcl_e8_AudSource::FI_EN_CPRA2 // ARL_SRC_CPRA2,   // AdevMPOut
        .audproc_audsrc_def = AUD_PROC_SRC_ENT7,  //AdevEntSrcSelectIn:5
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_CPRA2"
    },
    {
        .midw_audsrc_fi = 15, //midw_fi_tcl_e8_AudSource::FI_EN_BT_AUDIO // ARL_SRC_BTAUDIO,   // AdevEnt2Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT6,  //AdevEntSrcSelectIn:6
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_BTAUDIO"
    },
    {
        .midw_audsrc_fi = 41, //midw_fi_tcl_e8_AudSource::FI_EN_ECORE_MAIN_1 // ARL_SRC_ECORE_MAIN_1,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT5, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_ECORE_MAIN_1"
    },
    {
        .midw_audsrc_fi = 42, //midw_fi_tcl_e8_AudSource::FI_EN_ECORE_MAIN_2 // ARL_SRC_ECORE_MAIN_2,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT5, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_ECORE_MAIN_2"
    },
    {
        .midw_audsrc_fi = 26, //midw_fi_tcl_e8_AudSource::FI_EN_SPI_MAIN // ARL_SRC_SPI_MAIN,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT5, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_SPI_MAIN"
    },
    {
        .midw_audsrc_fi = 34, //midw_fi_tcl_e8_AudSource:::FI_EN_SPI_ALERT // ARL_SRC_SPI_ALERT,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT17, //AdevEntSrcSelectIn:1
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_SPI_ALERT"
    },
    {
        .midw_audsrc_fi = 45, //midw_fi_tcl_e8_AudSource:::FI_EN_SPI_VR_STEREO // ARL_SRC_SPI_VR_STEREO,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT5, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_SPI_VR_STEREO"
    },
    {
        .midw_audsrc_fi = 46, //midw_fi_tcl_e8_AudSource:::FI_EN_BLU_RAY // ARL_SRC_BLU_RAY,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT5, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_BLU_RAY"
    },
    {
        .midw_audsrc_fi = 4, //midw_fi_tcl_e8_AudSource::FI_EN_DRM//ARL_SRC_DRM,   // AdevEnt2Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT14, //AdevEntSrcSelectIn:2
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_DRM"
    },
    {
        .midw_audsrc_fi = 41, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_ENT, ARL_SRC_WEB_ENT
        .audproc_audsrc_def = AUD_PROC_SRC_ENT9, //AdevWebMainOut,   AdevLxcSrcSelect:0
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_ENT"
    },
    {
        .midw_audsrc_fi = 42, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_INFO_USR, ARL_SRC_WEB_INFO_USR
        .audproc_audsrc_def = AUD_PROC_SRC_ENT9, //AdevClassicOut(pb),   AdevLxcSrcSelect:0(cap)
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_INFO_USR"
    },
    {
        .midw_audsrc_fi = 54, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_INFO_SYSTEM, ARL_SRC_WEB_INFO_SYSTEM
        .audproc_audsrc_def = AUD_PROC_SRC_ENT9, //AdevClassicOut(pb),   AdevLxcSrcSelect:0(cap)
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_INFO_SYSTEM"
    },
    {
        .midw_audsrc_fi = 55, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_MIX, ARL_SRC_WEB_MIX
        .audproc_audsrc_def = AUD_PROC_SRC_INFO1, //AdevAudProcMixOut(pb), AdevLxcSrcSelect:1 (cap)
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_MIX"
    },
    {
        .midw_audsrc_fi = 58, // midw_fi_tcl_e8_AudSource::FI_EN_VPA_MAIN, ARL_SRC_VPA_ENT
        .audproc_audsrc_def = AUD_PROC_SRC_ENT10, // AdevClassicOut(pb), AdevLxcSrcSelect:3(cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_VPA_ENT"
    } ,
    {
        .midw_audsrc_fi = 59, //  midw_fi_tcl_e8_AudSource::FI_EN_VPA_SDS, ARL_SRC_VPA_SDS
        .audproc_audsrc_def = AUD_PROC_SRC_VOICE2, // AdevAudProcVoiceOut (pb), AdevLxcSrcSelect:5(cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_VPA_SDS"
    },
    {
        .midw_audsrc_fi = 60, // midw_fi_tcl_e8_AudSource::FI_EN_VPA_TTS, ARL_SRC_VPA_MIX
        .audproc_audsrc_def = AUD_PROC_SRC_INFO2, // AdevAudProcMixOut(pb), AdevLxcSrcSelect:4 (cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_VPA_MIX"
    },
    {
        .midw_audsrc_fi = 68, // midw_fi_tcl_e8_AudSource::FI_EN_EXT_NAV, ARL_SRC_EXT_NAV
        .audproc_audsrc_def = AUD_PROC_SRC_INFO3, // AdevAudProcMixOut(pb), AdevLxcSrcSelect:7 (cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_EXT_NAV"
    }
 };


#define APL_AUD_SRC_TABLE_CLASSIC_SIZE ARRAYSIZE(audproc_audsrc_lookup_table_classic)


static const  audproc_audsrc_lookup audproc_audsrc_lookup_table_auditorium[] =
{
    {
        .midw_audsrc_fi = 24, //midw_fi_tcl_e8_AudSource::FI_EN_CPRA2 // ARL_SRC_CPRA2,   // AdevMPOut
        .audproc_audsrc_def = AUD_PROC_SRC_ENT3,  //AdevEntSrcSelectIn:5
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_CPRA2"
    },
    {
        .midw_audsrc_fi = 6, //midw_fi_tcl_e8_AudSource::FI_EN_XMTUN // ARL_SRC_XM,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_XM"
    },
    {
        .midw_audsrc_fi = 15, //midw_fi_tcl_e8_AudSource::FI_EN_BT_AUDIO // ARL_SRC_BTAUDIO,   // AdevEnt2Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT2,  //AdevEntSrcSelectIn:6
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_BTAUDIO"
    },
    {
        .midw_audsrc_fi = 41, //midw_fi_tcl_e8_AudSource::FI_EN_ECORE_MAIN_1 // ARL_SRC_ECORE_MAIN_1,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT1, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_ECORE_MAIN_1"
    },
    {
        .midw_audsrc_fi = 42, //midw_fi_tcl_e8_AudSource::FI_EN_ECORE_MAIN_2 // ARL_SRC_ECORE_MAIN_2,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT1, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_ECORE_MAIN_2"
    },
    {
        .midw_audsrc_fi = 26, //midw_fi_tcl_e8_AudSource::FI_EN_SPI_MAIN // ARL_SRC_SPI_MAIN,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT1, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_SPI_MAIN"
    },
    {
        .midw_audsrc_fi = 34, //midw_fi_tcl_e8_AudSource:::FI_EN_SPI_ALERT // ARL_SRC_SPI_ALERT,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT16, //AdevEntSrcSelectIn:1
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_SPI_ALERT"
    },

    {
        .midw_audsrc_fi = 45, //midw_fi_tcl_e8_AudSource:::FI_EN_SPI_VR_STEREO // ARL_SRC_SPI_VR_STEREO,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT1, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_SPI_VR_STEREO"
    },
    {
        .midw_audsrc_fi = 46, //midw_fi_tcl_e8_AudSource:::FI_EN_BLU_RAY // ARL_SRC_BLU_RAY,   // AdevEnt1Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT1, //AdevEntSrcSelectIn:7
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_BLU_RAY"
    },
    {
        .midw_audsrc_fi = 1, //midw_fi_tcl_e8_AudSource::FI_EN_FM // ARL_SRC_FM // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_FM"
    },
    {
        .midw_audsrc_fi = 2, //midw_fi_tcl_e8_AudSource::FI_EN_FM_TA // ARL_SRC_FMTA // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_FMTA"
    },
    {
        .midw_audsrc_fi = 3, //midw_fi_tcl_e8_AudSource::FI_EN_AM//ARL_SRC_AM,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_AM"
    },
    {
        .midw_audsrc_fi = 4, //midw_fi_tcl_e8_AudSource::FI_EN_DAB//ARL_SRC_DAB,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_DAB"
    },
    {
        .midw_audsrc_fi = 5, //midw_fi_tcl_e8_AudSource::FI_EN_DABTA//ARL_SRC_DAB_TA,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_DAB_TA"
    },
    {
        .midw_audsrc_fi = 35, //midw_fi_tcl_e8_AudSource::FI_EN_DRM//ARL_SRC_DRM,   // AdevEnt2Out
        .audproc_audsrc_def = AUD_PROC_SRC_ENT13, //AdevEntSrcSelectIn:2
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_DRM"
    },
    {
        .midw_audsrc_fi = 9, //midw_fi_tcl_e8_AudSource::FI_EN_AUX//ARL_SRC_AUX,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_AUX"
    },
    {
        .midw_audsrc_fi = 17, //midw_fi_tcl_e8_AudSource::FI_EN_AUX_2//ARL_SRC_AUX2,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_AUX2"
    },
    {
        .midw_audsrc_fi = 8, //midw_fi_tcl_e8_AudSource::FI_EN_CDDA//ARL_SRC_CDDA,   // AdevEntADRIn
        .audproc_audsrc_def = AUD_PROC_SRC_ENT4, //AdevEntADRIn
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_CDDA"
    },
    {
        .midw_audsrc_fi = 41, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_ENT, ARL_SRC_WEB_ENT
        .audproc_audsrc_def = AUD_PROC_SRC_ENT11, //AdevWebMainOut,   AdevLxcSrcSelect:0
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_ENT"
    },
    {
        .midw_audsrc_fi = 42, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_INFO_USR, ARL_SRC_WEB_INFO_USR
        .audproc_audsrc_def = AUD_PROC_SRC_ENT11, //AdevAuditoriumOut(pb),   AdevLxcSrcSelect:0(cap)
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_INFO_USR"
    },
    {
        .midw_audsrc_fi = 54, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_INFO_SYSTEM, ARL_SRC_WEB_INFO_SYSTEM
        .audproc_audsrc_def = AUD_PROC_SRC_ENT11, //AdevAuditoriumOut(pb),   AdevLxcSrcSelect:0(cap)
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_INFO_SYSTEM"
    },
    {
        .midw_audsrc_fi = 55, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_MIX, ARL_SRC_WEB_MIX
        .audproc_audsrc_def = AUD_PROC_SRC_INFO1, //AdevAudProcMixOut(pb), AdevLxcSrcSelect:1 (cap)
        .audproc_is_set_to_flat = TRUE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_MIX"
    },
    {
        .midw_audsrc_fi = 58, // midw_fi_tcl_e8_AudSource::FI_EN_VPA_MAIN, ARL_SRC_VPA_ENT
        .audproc_audsrc_def = AUD_PROC_SRC_ENT12, // AdevAuditoriumOut(pb), AdevLxcSrcSelect:3(cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_VPA_ENT"
    } ,
    {
        .midw_audsrc_fi = 59, //  midw_fi_tcl_e8_AudSource::FI_EN_VPA_SDS, ARL_SRC_VPA_SDS
        .audproc_audsrc_def = AUD_PROC_SRC_VOICE2, // AdevAudProcVoiceOut (pb), AdevLxcSrcSelect:5(cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_VPA_SDS"
    },
    {
        .midw_audsrc_fi = 60, // midw_fi_tcl_e8_AudSource::FI_EN_VPA_TTS, ARL_SRC_VPA_MIX
        .audproc_audsrc_def = AUD_PROC_SRC_INFO2, // AdevAudProcMixOut(pb), AdevLxcSrcSelect:4 (cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_VPA_MIX"
    },
    {
        .midw_audsrc_fi = 68, // midw_fi_tcl_e8_AudSource::FI_EN_EXT_NAV, ARL_SRC_EXT_NAV
        .audproc_audsrc_def = AUD_PROC_SRC_INFO3, // AdevAudProcMixOut(pb), AdevLxcSrcSelect:7 (cap)
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_EXT_NAV"
    }
 };


#define APL_AUD_SRC_TABLE_AUDITORIUM_SIZE ARRAYSIZE(audproc_audsrc_lookup_table_auditorium)


/*******************************************************************************
*
* STRUCTURE: audproc_audsrc_lookup_table_web_container
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE:
*
*******************************************************************************/

static const  audproc_audsrc_lookup audproc_audsrc_lookup_table_web_container[] =
{
    {
        .midw_audsrc_fi = 41, // midw_fi_tcl_e8_AudSource::FI_EN_WEB_ENT, ARL_SRC_WEB_ENT
        .audproc_audsrc_def = AUD_PROC_SRC_ENT1, //AdevWebMainOut,   AdevLxcSrcSelect:0
        .audproc_is_set_to_flat = FALSE,
        .midw_audsrc_fi_name = "ARL_SRC_WEB_ENT"
    }
 };


#define APL_AUD_SRC_TABLE_WEB_CONTAINER_SIZE ARRAYSIZE(audproc_audsrc_lookup_table_web_container)




#endif // __AUDPROC_CONFIGURATION_DATA_H__
