/*
 * audproc-common-defs.h
 *
 * Patrick Rey   06.08.2015
 */


#ifndef AUDPROC_COMMON_DEFS_H
#define AUDPROC_COMMON_DEFS_H

#include <stdio.h>
#include <stdint.h>
#include <alsa/asoundlib.h>
#include "apl.h"
#include "Arkamys.h"

#include"rts.h"

/***************************************
 * trace function common definition
 */

//#define DEBUG

#define D_LOG_WITH_TIME_STAMP

#ifdef DEBUG

#define pr_debug(fmtstr, args...) \
            g_print("APP_DBG:%s: " fmtstr, __FUNCTION__, ##args)
#define pr_message(fmtstr, args...) \
            g_print("APP_MSG:%s: " fmtstr, __FUNCTION__, ##args)
#define pr_warning(fmtstr, args...) \
            g_print("APP_WARN:%s: " fmtstr, __FUNCTION__, ##args)
#define pr_critical(fmtstr, args...) \
            g_print("APP_CRIT:%s: " fmtstr, __FUNCTION__, ##args)
#define pr_error(fmtstr, args...) \
            g_print("APP_ERR:%s: " fmtstr, __FUNCTION__, ##args)

#else

#ifndef D_LOG_WITH_TIME_STAMP

#define pr_debug(fmtstr, args...) \
         g_debug("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_message(fmtstr, args...) \
        g_message("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_warning(fmtstr, args...) \
        g_warning("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_critical(fmtstr, args...) \
        g_critical("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_error(fmtstr, args...) \
        g_error("%s: " fmtstr, __FUNCTION__, ##args)

#else

#define pr_message(fmtstr, args...) {struct timespec ts; \
                                    clock_gettime(CLOCK_MONOTONIC, &ts);\
                                    g_message("audproc time [%05u,%09lu] - %s: " fmtstr,(unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_debug(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_debug("audproc time [%05u,%09lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_warning(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_warning("audproc time [%05u,%09lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_critical(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_critical("audproc time [%05u,%09lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_error(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_error("audproc time [%05u,%09lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#endif // D_LOG_WITH_TIME_STAMP

#endif // DEBUG


#define  audproc_debug(status, fmtstr, args...) \
         g_debug("%s: %s (%d): " fmtstr, __FUNCTION__, \
         audproc_service_error_str(status), status, ##args)
#define audproc_message(status, fmtstr, args...) \
        g_message("%s: %s (%d): " fmtstr, __FUNCTION__, \
    audproc_service_error_str(status), status, ##args)
#define audproc_warning(status, fmtstr, args...) \
        g_warning("%s: %s (%d): " fmtstr, __FUNCTION__, \
    audproc_service_error_str(status), status, ##args)
#define audproc_critical(status, fmtstr, args...) \
        g_critical("%s: %s (%d): " fmtstr, __FUNCTION__, \
    audproc_service_error_str(status), status, ##args)
#define audproc_error(status, fmtstr, args...) \
        g_error("%s: %s (%d): " fmtstr, __FUNCTION__, \
    audproc_service_error_str(status), status, ##args)



/****************************
 * product common defintion
 */


#define AUDPROC_USE_MULTI_SOURCE_INSTANCE_INTERFACE
#define AUDPROC_MAX_STREAM_PER_DIR 4
#define AUDPROC_SERVICE_SERVER_PATH "/org/bosch/vrns/handsfree/ecnrservice"
#define AUDPROC_SERVICE_SERVER_NAME "org.bosch.vrns.handsfree.ecnrservice"
#define AUDPROC_APPID_ADMIN 33
#define AUDPROC_START_STOP_TIMEOUT 1000000
#define AUDPROC_DP_DESC_MAX 7
#define AUDPROC_MAX_NB_AUDIO_INSTANCE 10
#define D_RETRY_COUNT 20  // max (20 * 100 ms) retry cycle
#define D_MIN_R_W_COUNT_BEFORE_SIGNAL_READ 5 //10 ->ok // 2 -> initial issue
#define D_READ_DATA_TIME_OUT 1000  // in ms
#define D_MIC_LEVEL_TIME_OUT_INTERVAL_MIN (guint16)100
#define AUDPROC_MAX_COUNT_SILENCE_AFTER_RECOVER 4 // 10 -> work good but remove too much frames //4 -> initial value
#define AUDPROC_MAX_SUCCESS_IO_AFTER_RECOVER    2



#define ARRAYSIZE(x)  (sizeof(x)/sizeof(x[0]))


/****************************
 * build defines
 */
//#define D_SUPPORT_LOOPBACK_DEVICE_ENABLE
#define D_RTS_WRITE_WORK_AROUND
#define D_PLAYBACK_DEVICE_RECREATE
#define D_SUPPORT_MATCH_IMX_ARK_LIB_VERS
#define D_SUPPORT_INFO_SRC
#define D_MAKE_AUDPROC_SRC_ID_AVAILABLE_PER_AUDPROC_CFG
//#define D_AUDPROC_SM_PROCESS_REQUEST_IN_OWN_THREAD
#define D_PREPROCESS_SILENCE_PRIOR_TO_STABILE_RUN
//#define D_PREPROCESS_SILENCE_ENT_SRC_ONLY  // AIVI fix for scope 2.0, shoudl be undefined for scope 2.1
//#define D_SUPPORT_AUDROC_SERVER
//#define D_ONLY_FOR_DEBUG
#define D_WRITE_SILENCE_DURING_PAUSE_TRACK_CHANGE
#define D_SAFE_NOTIFICATION
#define D_REDEFINE_RTS_STRUCT
#define D_ENABLE_RTS_LOG_CB


#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_LSIM
#ifndef D_PREPROCESS_SILENCE_ENT_SRC_ONLY
#define D_PREPROCESS_SILENCE_ENT_SRC_ONLY
#endif
#endif

/***********************
 * data type definitions
 */

typedef enum sErrorCode
{
    /* BEGIN section reserved to apl error code: range 1 - 512  */
    AUDPROC_ERR_ARKAMYS_FIRST_ERROR             = ARKAMYS_NO_HANDLE_ERROR,              /*-100*/
    AUDPROC_ERR_ARKAMYS_NO_HANDLE_ERROR         = ARKAMYS_NO_HANDLE_ERROR,              /*-100*/
    AUDPROC_ERR_ARKAMYS_BLOCK_ID_ERROR          = ARKAMYS_BLOCK_ID_ERROR,               /*-98*/
    AUDPROC_ERR_ARKAMYS_PARAMETER_ID_ERROR      = ARKAMYS_PARAMETER_ID_ERROR,           /*-95*/
    AUDPROC_ERR_ARKAMYS_PARAMETER_VALUE_ERROR   = ARKAMYS_PARAMETER_VALUE_ERROR,        /*-94*/
    AUDPROC_ERR_ARKAMYS_SIZE_ERROR              = ARKAMYS_SIZE_ERROR,                   /*-93*/
    AUDPROC_ERR_ARKAMYS_EOL_ERROR               = ARKAMYS_EOL_ERROR,                    /*-91*/
    AUDPROC_ERR_ARKAMYS_INIT_ERROR              = ARKAMYS_INIT_ERROR,                   /*-93*/
    AUDPROC_ERR_ARKAMYS_AMBIENCE_ERROR          = ARKAMYS_AMBIENCE_ERROR,               /*-89*/
    AUDPROC_ERR_ARKAMYS_LAST_ERROR              = AUDPROC_ERR_ARKAMYS_AMBIENCE_ERROR,   /*-89*/
    /* END - section error code APL */
    AUDPROC_ERR_OK = 0,
    AUDPROC_ERR_INVALID_INPUT = 0x1000,
    AUDPROC_ERR_FAILED,
    AUDPROC_ERR_NO_AUDPROC_OBJECT_AVAILABLE,
    AUDPROC_ERR_CONFIG_FILE_OPEN_FAILED,
    AUDPROC_ERR_CONFIG_FILE_EMPTY,
    AUDPROC_ERR_CONFIG_FILE_READING_FAILED,
    AUDPROC_ERR_CONFIG_NOT_AVAILABLE,
    AUDPROC_ERR_CONFIG_ALREADY_ACTIVE,
    AUDPROC_ERR_NO_RESULT,
    AUDPROC_ERR_SIZE_ONLY,
    AUDPROC_ERR_ALLOC,
    AUDPROC_ERR_NULL_POINTER,  //0x100B
    AUDPROC_ERR_MODULE_NOT_INIT,
    AUDPROC_ERR_NOT_CREATED,
    AUDPROC_ERR_MODULE_ALREADY_INIT,
    AUDPROC_ERR_INVALID_MAIN_STRUCT,
    AUDPROC_ERR_DEINIT_FAILED, //0x1010
    AUDPROC_ERR_ILLEGAL_SET_PARAM,
    AUDPROC_ERR_ILLEGAL_SET_PARAM_BEFORE_INIT,
    AUDPROC_ERR_ILLEGAL_SET_PARAM_AFTER_INIT,
    AUDPROC_ERR_INVALID_PARAM_ID,
    AUDPROC_ERR_INVALID_CHANNEL_NUMBER,
    AUDPROC_ERR_INVALID_OPERATION_MODE,
    AUDPROC_ERR_INVALID_SIZE,
    AUDPROC_ERR_PARAM, //0x1018
    AUDPROC_ERR_PARAM_CNT,
    AUDPROC_ERR_SAMPLE_RATE,
    AUDPROC_ERR_FRAMESHIFT,
    AUDPROC_ERR_INVALID_CHAN_CNT,
    AUDPROC_ERR_FFT_LENGTH,
    AUDPROC_ERR_INVALID_FILTER_LEN,
    AUDPROC_ERR_NULL_FILTER,
    AUDPROC_ERR_PARAMETER_TABLE,
    AUDPROC_ERR_NOT_IMP,
    AUDPROC_ERR_SUBMODULE_DISABLED,
    AUDPROC_ERR_INVALID_SET_PARAM_ENDIANNESS,
    AUDPROC_ERR_INIT_MMGR,
    AUDPROC_ERR_DGB_INIT_FAILED,
    AUDPROC_ERR_DGB_NO_DATA,
    AUDPROC_ERR_ALREADY_INITIALIZED,
    AUDPROC_ERR_ILLEGAL_SRC_NUMBER,
    AUDPROC_ERR_AUDIO_BUFFER_MISMATCH,

    /* error service module */
    AUDPROC_ERR_SERV_NOT_INITIALIZED,
    AUDPROC_ERR_SERV_ALREADY_INSTANCED,
    AUDPROC_ERR_SERV_NOT_INSTANCED,
    AUDPROC_ERR_SERV_STREAMING_STILL_ACTIVE,
    AUDPROC_ERR_SERV_SRC_NOT_ACTIVE,
    AUDPROC_ERR_SERV_SRC_LOOPBACK_ALREADY_ACTIVE,
    AUDPROC_ERR_SERV_ROUTE_NOT_AVAILABLE,
    AUDPROC_ERR_SERV_ROUTE_REQUEST_MISMATCH,


    /* error in configuration modul */
    AUDPROC_ERR_APPID_NOT_AVAILABLE,
    AUDPROC_ERR_CONFID_NOT_AVAILABLE,
    AUDPROC_ERR_NO_DEFAULT_CONFIGURATION,
    AUDPROC_ERR_APPID_INSTANCE_ALREADY_ACTIVE,
    AUDPROC_ERR_NO_INSTANCE_AVAILABLE,
    AUDPROC_ERR_APPID_INSTANCE_NOT_AVAILABLE,
    AUDPROC_ERR_APPID_CONFIGID_NOT_MATCHING,
    AUDPROC_ERR_NO_CONFIG_FILE_AVAILABLE,
    AUDPROC_ERR_DEV_ID_NOT_AVAILABLE,
    AUDPROC_ERR_DEV_CHNID_NOT_MATCHING,
    AUDPROC_ERR_CONFIG_EOL_IO_ERROR,
    AUDPROC_ERR_VERSION_SSE_DP_DO_NOT_MATCH,
    AUDPROC_ERR_NO_FILE_AVAILABLE,
    AUDPROC_ERR_VALUE_RANGE_FAILURE,
    AUDPROC_ERR_TBL_IDX_NB_CFG_VALUE_TRANSGRESSION,
    AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE,
    AUDPROC_ERR_APL_CFG_ERROR,
    AUDPROC_ERR_APL_NO_INSTANCE,
    AUDPROC_ERR_AP_NO_SOURCE_TRANSLATION_AVAILABLE,
    AUDPROC_ERR_AR_RECONGIF_FAILURE,
    AUDPROC_ERR_DP_CD_READ_FAILURE,



    /*-----------------------------*/

    AUDPROC_ERR_REQ_APPID_NOT_ACTIVE,
    AUDPROC_ERR_ALSA_NO_INSTANCE,
    AUDPROC_ERR_DEBUG_ALREADY_ACTIVE,
    AUDPROC_ERR_DEBUG_MODER_NOT_SUPPORTED,
    AUDPROC_ERR_DGB_SET_RMV_TRIGGER_FILE_FAILED,
    AUDPROC_ERR_OBJECT_FI_NOT_SUPPORTED,
    AUDPROC_ERR_OBJECT_FI_AUDIO_IS_RUNNING,
    AUDPROC_ERR_NO_AUDIO_STREAMING,
    AUDPROC_ERR_AUDIO_THREAD_ALREADY_ACTIVE,
    AUDPROC_ERR_OBJECT_FI_PARAM_OUT_OF_RANGE,

    /* error in rts handler  */
    AUDPROC_ERR_RTS_NOT_SUPPORTED,
    AUDPROC_ERR_RTS_STATE_ERROR,
    AUDPROC_ERR_RTS_HANDLE_INVALID,
    AUDPROC_ERR_RTS_INST_MAX_EXCEED,
    AUDPROC_ERR_RTS_CONF,
    AUDPROC_ERR_RTS_DEVICE_INSTANCE_CREATION_FAILS,


    /* error in ecnr_datapool_access module*/
    AUDPROC_ERR_DP_ACCES_NULL_FCT_POINTER,
    AUDPROC_ERR_DP_ACCES_DP_ALREADY_REGISTRIED,
    AUDPROC_ERR_DP_NO_ELEMENT_AVAILABLE,
    AUDPROC_ERR_DP_INVALID_ELEMENT,
    AUDPROC_ERR_DP_ERROR_SIZE_OF_DATAPOOL,

   /* specifical error in  handler  */
    AUDPROC_ERR_OSAL_ERROR,

   /* state machine error codes   */
    AUDPROC_ERR_SM_UNDEFINED_STATE,
    AUDPROC_ERR_SM_CONF_LOCK,
    AUDPROC_ERR_SM_INST_NAME_NOT_AVAIL,
    AUDPROC_ERR_SM_INST_NOT_AVAIL,
    AUDPROC_ERR_SM_TRY_AGAIN,

   /* specifical server error */
    AUDPROC_INVALID_PLUG_SRC_INST,
    AUPROC_PROXY_INSTANCE_ALREADY_AVAILABLE

}ERRORCODE;

enum eAudprocDataPool{
    ECNR_DP_NOT_DEF = 0,
    ECNR_DP_LAST
};

/* AUDPROC dbug mode  */
enum eAudprocDebugMode {
    AUDPROC_DBUG_PRINT_ALL_OPTIONS              =0,               /*0*/
    AUDPROC_DBUG_PRINT_CURRENT_SERV_STATE,                        /*1*/
    AUDPROC_DBUG_PRINT_AUDIO_STATISTIC,                           /*2*/
    AUDPROC_DBUG_PRINT_AUDIO_PROC_EOL_CONFIG,                     /*3*/
    AUDPROC_DBUG_PRINT_AUDIO_ROUTE_CONFIG,                        /*4*/
    AUDPROC_DBUG_PRINT_AUDIO_DEVICE_CONFIG,                       /*5*/
    AUDPROC_DBUG_PRINT_AUDIO_SRC_CONFIG,                          /*6*/
    AUDPROC_DBUG_RESTART_RTS_RECORDING,                           /*7*/
    AUDPROC_DBUG_STOP_RTS_RECORDING,                              /*8*/
    AUDPROC_DBUG_SET_MIC_LVL_300_MS,                              /*9*/
    AUDPROC_DBUG_SET_ACTIVATE_AUDIO_RECORD,                       /*10*/
    AUDPROC_DBUG_SET_ACTIVATE_DEBUG_LOG_LEVEL,                    /*11*/
    AUDPROC_DBUG_SET_DEACTIVATE_DEBUG_LOG_LEVEL,                  /*12*/
    AUDPROC_DBUG_SET_ACTIVATE_APL_MSG_LOG_LEVEL,                  /*13*/
    AUDPROC_DBUG_SET_ACTIVATE_APL_DEBUG_LOG_LEVEL,                /*14*/
    AUDPROC_DBUG_SET_DEACTIVATE_APL_LOG,                          /*15*/
    AUDPROC_DBUG_SET_ACTIVATE_APL_ARK_LOGGER,                     /*16*/
    AUDPROC_DBUG_SET_DEACTIVATE_APL_ARK_LOGGER,                   /*17*/
    AUDPROC_DBUG_ACTIVATE_PERFORMANCE_TEST,                       /*18*/
    AUDPROC_DBUG_DEACTIVATE_PERFORMANCE_TEST,                     /*19*/
    AUDPROC_DBUG_ACTIVATE_APL_PERFORMANCE,                        /*20*/
    AUDPROC_DBUG_DEACTIVATE_APL_PERFORMANCE,                      /*21*/
    AUDPROC_DBUG_SET_ACTIVATE_APL_DEBUG_DATA_LOG_LEVEL,           /*22*/
    AUDPROC_DBUG_SET_ACTIVATE_APL_JOURNAL_LOG,                    /*23*/
    AUDPROC_DBUG_SET_DEACTIVATE_APL_JOURNAL_LOG,                  /*24*/
    AUDPROC_DBUG_SET_START_TEST_CASE_1          = 100,            /*100 -> start test case selection */
    AUDPROC_DBUG_SET_STOP_TEST_CASE_1           = 200,            /*200 -> stop test case selection */
    AUDPROC_DBUG_LAST_ENTRY = AUDPROC_DBUG_SET_STOP_TEST_CASE_1
};



typedef enum _audproc_type_defs
{
    AUDPROC_TYPE_UNDEF = 0,
    AUDPROC_TYPE_U8 = 1,
    AUDPROC_TYPE_I8 ,  /*2*/
    AUDPROC_TYPE_U16 , /*3*/
    AUDPROC_TYPE_I16 , /*4*/
    AUDPROC_TYPE_U32 , /*5*/
    AUDPROC_TYPE_I32,  /*6*/
    AUDPROC_TYPE_ARRAY_U8 ,  /*7*/
    AUDPROC_TYPE_ARRAY_I8 ,  /*8*/
    AUDPROC_TYPE_ARRAY_U16 , /*9*/
    AUDPROC_TYPE_ARRAY_I16 , /*10*/
    AUDPROC_TYPE_ARRAY_U32 , /*11*/
    AUDPROC_TYPE_ARRAY_I32   /*12*/
}audproc_type;


typedef enum _audproc_access_defs
{
    AUDPROC_ACCESS_UNDEF = 0,
    AUDPROC_ACCESS_RO = 1,              // Read only
    AUDPROC_ACCESS_WB,                  // Data can only be written before initialization, read anytime
    AUDPROC_ACCESS_WA,                  // Data can only be written after initialization, read anytime
    AUDPROC_ACCESS_RW,                  // Data can be written, read anytime
    AUDPROC_ACCESS_WO                   // Data can only be written after initialization, never read */
}audproc_access;


typedef enum _audproc_update_defs
{
    AUDPROC_UPDATE_UNDEF = 0,
    AUDPROC_UPDATE_ON_PROCESS = 1,  // update and set paramter within the streaming task prior to processing call, means the filter parameter are set prior to audio processing
    AUDPROC_UPDATE_IMMEDIAT         // update, set parameter at any time asynchronously to the streaming context
}audproc_update;



typedef enum _audproc_source_activity_def
{
    AUDPROC_SA_UNDEF        = 0,
    AUDPROC_SA_PREPARE      = 1,
    AUDPROC_SA_ON           = 2, //source / route  selection automatically activated for the selected source</line>
    AUDPROC_SA_OFF          = 3, //streaming is stopped, route is deallocated for the selected source </line>
    AUDPROC_SA_PAUSE        = 4,
    AUDPROC_SA_ACTIVATE     = 5,
    AUDPROC_SA_DEACTIVATE   = 6
}audproc_source_activity;




typedef enum _audproc_source_select_Mode
{
    AUDPROC_SELECT_SRC_UNDEF = 0,
    AUDPROC_SELECT_SRC_PER_DEV = 1,
    AUDPROC_SELECT_SRC_PER_ID  = 2,
    AUDPROC_SELECT_SRC_PER_MDW_SRC_DEF  = 3
}audproc_source_select_Mode;


/*******************
 * source definition
 */
#define     AUD_PROC_SRC_NA         (guint8)0
#define     AUD_PROC_SRC_DEFAULT    (guint8)0
#define     AUD_PROC_SRC_ENT1       (guint8)1               // application uses device AdevEnt1Out
#define     AUD_PROC_SRC_ENT2       (guint8)2               // application uses device AdevEnt2Out, AudProc  AdevEntSrcSelectIn:
#define     AUD_PROC_SRC_ENT3       (guint8)3               // application uses device AdevMPOut,
#define     AUD_PROC_SRC_ENT4       (guint8)4               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT5       (guint8)5               // NU
#define     AUD_PROC_SRC_ENT6       (guint8)6               // application uses device AdevEnt2Out, AudProc  AdevEntSrcSelectIn:
#define     AUD_PROC_SRC_ENT7       (guint8)7               // application uses device AdevMPOut,
#define     AUD_PROC_SRC_ENT8       (guint8)8               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT9       (guint8)9               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT10      (guint8)10               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT11      (guint8)12               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT12      (guint8)13               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT13      (guint8)14               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT14      (guint8)15               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT15      (guint8)16               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT16      (guint8)17               // ADR audio though AdevEntADRIn
#define     AUD_PROC_SRC_ENT17      (guint8)18               // ADR audio though AdevEntADRIn


/* Product mapping configuration */
#define     AUD_PROC_SRC_MICIN_1        (guint8)20
#define     AUD_PROC_SRC_MICIN_2        (guint8)21
#define     AUD_PROC_SRC_LOOPBACK       (guint8)23
#define     AUD_PROC_SRC_INFO1          (guint8)24
#define     AUD_PROC_SRC_INFO2          (guint8)25
#define     AUD_PROC_SRC_INFO3          (guint8)28
#define     AUD_PROC_SRC_VOICE1         (guint8)11
#define     AUD_PROC_SRC_VOICE2         (guint8)26
#define     AUD_PROC_SRC_CLOCK_ON_OFF   (guint8)27
#define     AUD_PROC_SRC_ALL            (guint8)33


/* device activation / deactivation */

#define AUD_PROC_DEVICE_CREATE_ONCE_AT_POWER_ON             0
#define AUD_PROC_DEVICE_OPEN_AT_STR_START_CLOSE_AT_STR_END  1
#define AUD_PROC_DEVICE_RECREATE_AT_STR_START_ONLY          2
#define AUD_PROC_DEVICE_RECREATE_AT_STR_END_ONLY            3

typedef enum _audproc_source_type
{
    AUD_PROC_SRC_TYPE_DEFAULT = 0,
    AUD_PROC_SRC_TYPE_ENT,      /*1*/
    AUD_PROC_SRC_TYPE_VOICE,    /*2*/
    AUD_PROC_SRC_TYPE_INFO,     /*3*/
    AUD_PROC_SRC_TYPE_STREAM,
    AUD_PROC_SRC_TYPE_COUNT
}audproc_source_type;


typedef enum _audproc_cfg_id
{
    AUDPROC_CFG_DEFAULT = 0,
    AUDPROC_CFG_MICRO_LEVEL_MONITORING,
    AUDPROC_CFG_MICRO_LEVEL_MEASUREMENT,
    AUDPROC_CFG_ARKAMYS_PROCESSING,
    AUDPROC_CFG_AUDIO_LOOPBACK,
    AUDPROC_CFG_AUDIO_ENT_LOOPBACK,
    AUDPROC_CFG_AUDIO_VOICE_LOOPBACK,
    AUDPROC_CFG_AUDIO_INFO_LOOPBACK,
    AUDPROC_CFG_COUNT
}audproc_cfg_id;


typedef struct _audproc_config_data
{
    audproc_cfg_id          audproc_aud_cfg_id;
    const gchar*            audproc_apl_inst_name;
    audproc_source_type     audproc_this_src_type;
}audproc_config_data;


typedef struct
{
    const char*         audproc_dev_name;       /*zero terminated string*/
    guint               audproc_nb_ch;
    guint8*             audproc_str_ch_map;
    snd_pcm_stream_t    audproc_dir;            /*SND_PCM_STREAM_PLAYBACK*/
    unsigned int        audproc_rate;           /*any, e.g. 8000-192000*/
    unsigned int        audproc_period_frames;  /*e.g. 64/128/256/512*/
    snd_pcm_format_t    audproc_format;         /*format*/
    unsigned int        audproc_prefill_ms;     /* output prefill in ms*/
    signed short        audproc_startup_tout_ms;
    signed short        audproc_stream_tout_ms;
    guint8              audproc_create_on_start; /* */
}audproc_alsa_adev_cfg;/*ALSA device*/



typedef struct _audproc_alsa_stream_cfg
{
    /*********
     * alsa streaming thread element
     */
    guint8                  source_id;
    gboolean                available;
    gboolean                create_route_on_init;
    audproc_alsa_adev_cfg   indev;      /* input stream from internal source or ADR3 */
    audproc_alsa_adev_cfg   outdev;     /* output stream to ADR3 */
    audproc_alsa_adev_cfg   lpdev;       /* loopback stream to ADR3 */
    tAplBindingMatrix*      audbinding;
    audproc_config_data     audcfg;
    unsigned int            proc_frame_size; // processing unit, frame size , nb of simple pro processing cycle
    unsigned int            prefill_ms; /* output prefill in ms*/
    guint8                  audproc_close_on_stop; /* output prefill in ms*/
    glong                   audproc_start_time_out_ms;
    trts_logcb              audproc_rts_log_cb;
}audproc_alsa_stream_cfg;



struct aplParameter
{
    const gchar*    prop_name;          /* obj parameter name */
    const gchar*    apl_name;           /* apl parameter  */
    gint            apl_data_id;        /* parameter id*/
    gint            apl_channel;        /* parameter channel */
    gint            apl_num;            /* number of APL data type */
    audproc_type    apl_type;           /* APL data type */
    audproc_access  apl_access;         /* APL access restriction */
    audproc_update  apl_update;         /* APL update mode */
    const gchar*    apl_instance_name;  /* name of the apl instance for which the parameter is available */
    GType           parm_type;          /* obj parameter type  */
    GType           element_type;       /* obj element type */
    GParamFlags     flags;              /* obj Parameter flag */
};



#define APL_PARM(pname, name, id, ch, num, type, access, update, iname,  ptype, etype, gflags ) \
  { \
    .prop_name          = pname, \
    .apl_name           = name, \
    .apl_data_id        = id, \
    .apl_channel        = ch, \
    .apl_num            = num, \
    .apl_type           = type, \
    .apl_access         = access, \
    .apl_update         = update,\
    .apl_instance_name  = iname,\
    .parm_type          = ptype, \
    .element_type       = etype, \
    .flags              = gflags, \
  }


#define APL_PARM_RW(pname, name, id, ch, type, ptype, iname) \
  APL_PARM(pname, name, id, ch, 1, type, AUDPROC_ACCESS_RW, AUDPROC_UPDATE_IMMEDIAT,iname, ptype, 0, \
    (G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS))

#define APL_PARM_RW_EXT(pname, name, type, ptype, access, update, iname) \
  APL_PARM(pname, #name, name, 0, 1, type, access, update, iname, ptype, 0, \
    (G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS))


#define APL_PARM_RW_ARRAY(pname, name, id, ch, num, type, etype, iname) \
  APL_PARM(pname, name, id, ch, num, type, AUDPROC_ACCESS_RW, AUDPROC_UPDATE_IMMEDIAT, iname, G_TYPE_BOXED, etype, \
    (G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS))

#define APL_PARM_I16(pname, name, iname) \
  APL_PARM_RW(pname, #name, name, 0, AUDPROC_TYPE_I16, G_TYPE_INT, iname)

#define APL_PARM_U16(pname, name, iname) \
  APL_PARM_RW(pname, #name, name, 0, AUDPROC_TYPE_U16, G_TYPE_UINT, iname)

#define APL_PARM_I32(pname, name, iname) \
  APL_PARM_RW(pname, #name, name, 0, AUDPROC_TYPE_I32, G_TYPE_INT, iname)

#define APL_PARM_U32(pname, name, iname) \
  APL_PARM_RW(pname, #name, name, 0, AUDPROC_TYPE_U32, G_TYPE_UINT, iname)

#define APL_PARM_I16_ARRAY(pname, name, num, iname) \
  APL_PARM_RW_ARRAY(pname, #name, name, 0, num, AUDPROC_TYPE_ARRAY_I16, G_TYPE_INT, iname)

#define APL_PARM_U16_ARRAY(pname, name, num, iname) \
  APL_PARM_RW_ARRAY(pname, #name, name, 0, num, AUDPROC_TYPE_ARRAY_U16, G_TYPE_UINT, iname)

#define APL_PARM_I32_ARRAY(pname, name, num, iname) \
  APL_PARM_RW_ARRAY(pname, #name, name, 0, num, AUDPROC_TYPE_ARRAY_I32, G_TYPE_INT, iname)

#define APL_PARM_U32_ARRAY(pname, name, num, iname) \
  APL_PARM_RW_ARRAY(pname, #name, name, 0, num, AUDPROC_TYPE_ARRAY_U32, G_TYPE_UINT, iname)


typedef struct _audproc_audsrc_lookup
{
    guint8       midw_audsrc_fi;
    guint8       audproc_audsrc_def;
    gboolean    audproc_is_set_to_flat;
    const gchar*  midw_audsrc_fi_name;
}audproc_audsrc_lookup;



#define D_AUDIO_MODE_CLASSIC                    0x00
#define D_AUDIO_MODE_CLASSIC_PREMIUM_1          0x10
#define D_AUDIO_MODE_CLASSIC_PREMIUM_2          0x20
#define D_AUDIO_MODE_AUDITORIUM                 0x01
#define D_AUDIO_MODE_AUDITORIUM_PREMIUM_1       0x11
#define D_AUDIO_MODE_AUDITORIUM_PREMIUM_2       0x21
#define D_AUDIO_MODE_PREMIUM                    0x02
#define D_AUDIO_MODE_EOL_RELOAD                 0x03
#define D_AUDIO_MODE_WEB_CONTAINER              0x04
#define D_AUDIO_MODE_UNDEFINED                  0xFF


#define D_OUTPUT_INFO_INT_AMP      0x00
#define D_OUTPUT_INFO_PREMIUM_1    0x01
#define D_OUTPUT_INFO_PREMIUM_2    0x03

//#define D_SM_FULL

typedef enum _audproc_audio_state
{
  AUDPROC_AS_STREAM_UNDEFINED       = -1,
#ifdef D_SM_FULL
  AUDPROC_SM_SOURCE_INIT            = 0,        //0
  AUDPROC_SM_SOURCE_CONFIG          = 1,        //0
  AUDPROC_SM_SOURCE_RUNNING         = 2,        //0
  AUDPROC_SM_SOURCE_TERMINATED      = 3,        //0
  AUDPROC_SM_STREAM_SILENCE         = 20,        //0
  AUDPROC_SM_STREAM_INIT            = 21,           //1
  AUDPROC_SM_STREAM_WAIT_DATA       = 22,      //2
  AUDPROC_SM_STREAM_RUNNING         = 23,        //3
  AUDPROC_SM_STREAM_WAIT_RECOVER    = 24,   //4
  AUDPROC_SM_STREAM_STOP            = 25,           //5
  AUDPROC_SM_STREAM_TERMINATED      = 26,     //6
  AUDPROC_SM_STREAM_ERROR           = 27,          //7
  AUDPROC_SM_STREAM_LAST            =  AUDPROC_AS_STREAM_ERROR //7
#else
  AUDPROC_AS_STREAM_SILENCE = 0,        //0
  AUDPROC_AS_STREAM_INIT,           //1
  AUDPROC_AS_STREAM_WAIT_DATA,      //2
  AUDPROC_AS_STREAM_RUNNING,        //3
  AUDPROC_AS_STREAM_WAIT_RECOVER,   //4
  AUDPROC_AS_STREAM_STOP,           //5
  AUDPROC_AS_STREAM_TERMINATED,     //6
  AUDPROC_AS_STREAM_ERROR,          //7
  AUDPROC_AS_STREAM_SILENCE_PRELOAD,   //8
  AUDPROC_AS_STREAM_LAST =  AUDPROC_AS_STREAM_SILENCE_PRELOAD //8
#endif
}audproc_audio_state;

#endif //AUDPROC_COMMON_DEFS_H
