 /*
 * audproc-audio-rts-handler.h
 *
 * Author : Patrick Rey
 * Date: 06.01.2014
 *
 *
 */

#ifndef __AUDPROC_AUDIO_RTS_HANDLER_H__
#define __AUDPROC_AUDIO_RTS_HANDLER_H__

/****************************************
 *  Module functions                    *
 ****************************************/
extern int      audproc_audio_rts_handler_init(void);
extern int      audproc_audio_rts_handler_finalize(void);

/******************************************
 *  derivated fucntion of teh rts library *
 ******************************************/
extern int      audproc_audio_rts_handler_recreate_ext(audproc_alsa_state* state, gboolean log, gint16 dev_dir, gboolean restore_state);
extern int      audproc_audio_rts_handler_close(audproc_alsa_state* state, const gchar* dev_name, gint16 dev_dir);
extern int      audproc_audio_rts_handler_force_close(audproc_alsa_state* state, const gchar* dev_name, gint16 dev_dir);
extern int      audproc_audio_rts_handler_ent_reset(audproc_alsa_state* state);
extern int      audproc_audio_rts_handler_voice_reset(audproc_alsa_state* state);
extern int      audproc_audio_rts_handler_info_reset(audproc_alsa_state* state);
extern int      audproc_audio_rts_handler_read(audproc_alsa_state* inst, void * buffer[], audproc_source_type src_type);
extern int      audproc_audio_rts_handler_Loop_write(audproc_alsa_state* inst, void * buffer[]);
extern int      audproc_audio_rts_handler_write(audproc_alsa_state* inst, void * buffer[], audproc_source_type src_type,gboolean silence);
extern int      audproc_audio_rts_handler_recover(audproc_alsa_state* inst, gint16 dev_dir);
extern int      audproc_audio_rts_handler_statistic_get(trts_stat *stat);
extern gboolean audproc_audio_rts_handler_get_xrun(audproc_alsa_state* inst, unsigned int *xrun, gint16 dev_dir);
extern int      audproc_audio_rts_handler_clear_xrun(audproc_alsa_state* inst);
extern void     audproc_audio_rts_handler_print_audio_route_config(void);
extern int      audproc_audio_rts_handler_create_new_inst_desc(audproc_alsa_state* state, const gchar* instance_name, gint16 dev_dir, unsigned int prefill_ms, trts_logcb cb);

#define audproc_audio_rts_handler_recreate(state, log, dev_dir)       audproc_audio_rts_handler_recreate_ext(state, log, dev_dir, FALSE)
#define audproc_audio_rts_handler_restore_state(state, log, dev_dir)  audproc_audio_rts_handler_recreate_ext(state, log, dev_dir, TRUE)

/****************************************
 *  Debug functions                     *
 ****************************************/
extern void audproc_audio_rts_handler_performance_init(void);
extern void audproc_audio_rts_handler_performance_test_init(gint nb_test_step);
extern void audproc_audio_rts_handler_performance_test_terminate(guint8 audproc_this_src, audproc_source_type audproc_this_src_type, char* capdev, char* pbdev );


#define D_CONV_PLAYBACK_DEVICE      0x0001
#define D_CONV_CAPTURE_DEVICE       0x0002
#define D_CONV_LOOPBACK_DEVICE      0x0004//3
#define D_CONV_RECORDING            0x0008//4
#define D_PREFILL_SET_DISABLE       (int)-1


#endif //__AUDPROC_AUDIO_RTS_HANDLER_H__
