/*
 * audproc-apl-handler.h
 *
 * Patrick Rey   06.08.2015
 */

#ifndef __AUDPROC_APL_HANDLER_H__
#define __AUDPROC_APL_HANDLER_H__


/* build compiler */
//#define D_APL_HANDLER_FCT_GET_ARK_LIB_VER_LOAD_EOL_DATA



#define APL_INSTANCE_STR_NA                             "apl_no_available"
#define APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS    "apl_micro_level_monitoring_fcts"
#define APL_INSTANCE_STR_MICRO_MEASURE_FCTS             "apl_micro_level_measure_fcts"
#define APL_INSTANCE_STR_ARKAMYS_FCTS                   "apl_arkamys_audio_fcts"
#define APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS            "apl_audio_loopback_fcts"
#define APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS        "apl_ent_audio_loopback_fcts"
#define APL_INSTANCE_STR_AUDIO_VOICE_LOOPBACK_FCTS      "apl_voice_audio_loopback_fcts"
#define APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS       "apl_info_audio_loopback_fcts"
#define APL_INSTANCE_STR_ALL_FCTS                       "apl_all_audio_fcts"


typedef struct
{
    int         AplInitState; //Ok;
    tApl        Aplh;
    gchar*      instance_name;
    gboolean    mic_lvl_cb_return;
    int         ref_cnt;
} AplState;

#define APL_NO_INST                    0x0000
#define APL_DESTROY_PREVIOUS_INST      0x0001
#define APL_INIT_PREPARE_INST          0x0002
#define APL_INIT_FINALIZE_INST         0x0004


extern int          audproc_apl_handler_init(tAplStCfg* cfg);
extern void         audproc_apl_handler_finalize(void);
extern int          audproc_apl_handler_process_audio_ent (AplState* aplinst,  aplAudioSamples_desc* InAudio, const aplAudioSamples_desc* OutAudio);
extern int          audproc_apl_handler_process_audio_voice (AplState* aplinst, const aplAudioSamples_desc* InAudio, const aplAudioSamples_desc* OutAudio);
extern int          audproc_apl_handler_process_audio_info (AplState* aplinst, const aplAudioSamples_desc* InAudio, const aplAudioSamples_desc* OutAudio);
extern int          audproc_apl_handler_create(AplState* aplinst);
extern AplState*    audproc_apl_handler_create_instance(const gchar* instance_name, gint mode);
extern int          audproc_apl_handler_get_data(AplState* aplinst, const tAplDataID DataID, const unsigned int  iChannel, unsigned int* pSize, void* pData);
extern int          audproc_apl_handler_set_data(AplState* aplinst, const tAplDataID DataID, const unsigned int  iChannel,unsigned int iSize, void* pData);
extern int          audproc_apl_handler_destroy (const gchar* instance_name);
extern int          audproc_apl_handler_command (const gchar* instance_name, tAplCmd cmd);
extern void         audproc_apl_handler_delete(void);
extern int          audproc_apl_handler_initialize(const gchar* instance_name, const tAplCfg* paapCfg);
extern void         audproc_apl_handler_get_version(const int** pVersionArray, const char** pVersionString, const char** pVersionComment );
extern int          audproc_apl_handler_get_Status_Message( char* pStatusMessage);
extern AplState*    audproc_apl_handler_get_instance(const gchar* instance_name);
extern void         audproc_apl_handler_set_miclvl_timeout(guint16 timeout_ms);
extern int          audproc_apl_handler_chain_set_up(AplState* aplinst, const tAplDataID*  chain_order, int nb_module);
extern int          audproc_apl_handler_is_instance(const gchar* instance_name);
extern int          audproc_configuration_set_configuration_by_apl_inst(const gchar*    apl_instance_name);
extern int          audproc_apl_handler_analyze_setup(tAplAnalyze feature, tAplI32 value);

/* special features */
extern int          audproc_apl_handler_get_ark_lib_ver(void* pData);

#endif // __AUDPROC_APL_HANDLER_H__

