 /*
 * audproc-alsa.h
 *
 * Author     : Patrick Rey
 * Date       : 07.08.2015
 * description: porting from qwa-alsa.h to G3g
 *
 *
 */

#ifndef __AUDPROC_ALSA_H__
#define __AUDPROC_ALSA_H__


/***************************************
 * section include engines definitions
 */

#include "apl.h"
#include "audproc-stream-buffer.h"

/*******************************************
 * section include ADIT RTS API definition
 */
//#include"rts.h"


#ifdef D_REDEFINE_RTS_STRUCT
typedef struct {
    const char* pcmname;            /*zero terminated string*/
    snd_pcm_stream_t dir;           /*SND_PCM_STREAM_PLAYBACK*/
    unsigned int rate;              /*any, e.g. 8000-192000*/
    unsigned int period_frames;     /*e.g. 64/128/256/512*/
    snd_pcm_format_t format;        /*format*/
    signed short startup_tout;      /*tout ms for initial read/write 0=default chosen by RTS, -1=endless */
    signed short stream_tout;       /*tout ms during streaming 0=default chosen by RTS, -1=endless */
    char _future_use_[12];          /*must be initialized to ZERO */
}trts_cfgadev_imp;/*ALSA device*/
#else
#define  trts_cfgadev_imp trts_cfgadev
#endif

#define audproc_stream_prefill_ms 8
#define CHANNEL_0 0
#define CHANNEL_1 1
#define CHANNEL_2 2
#define CHANNEL_3 3


typedef enum _audproc_adev_num
{
    ADEV_CAPTURE_IN  = 0,
    ADEV_PLAYBACK_OUT,
    ADEV_LOOPBACK_OUT,
    ADEV_NUM_MAX
}audproc_adev_num;


typedef struct _loopback_desc
{
    tRTS                rts_handle;
    trts_cfg*           rtsdata;
    trts_cfgadev_imp*   adevs;
    trts_cfgstream*     streamdefs;
    guint               audproc_in_ch_cnt;
    guint               audproc_out_ch_cnt;
    short int*          OutAudio_S16[AUDPROC_MAX_STREAM_PER_DIR];   /* array 16 bits frame buffer pointer if conversion is required */
    long  int*          OutAudio_S32[AUDPROC_MAX_STREAM_PER_DIR];   /* array 32 bits frame buffer pointer if conversion is required */
}loopback_desc;


typedef struct _rts_inst_desc
{

    gchar*          dev_name;
    gint16          dev_dir;
    gboolean        isActive;
    gboolean        isCloseforced;

    /**********
     * rts lib
     */
    tRTS                rts_handle;
    trts_cfg*           rtsdata;
    trts_cfgadev_imp*   adevs;
    trts_cfgstream*     streamdefs;

}rts_inst_desc;


typedef struct _audproc_alsa_state
{
    /**********************************
     * alsa streaming thread element
     *********************************/

    GThread*            thread;
    GMutex              lock;
    GCond               update;
    gboolean            athread_active;
    guint32             devices_restart_after_xrun_count;

    /* thread local data */
    gint                err;
    gint                last_err;
    gint                apl_err;
    gint                rts_err;
    gint                audio_started;
    gint                retry ;
    AplState*           aplinst;
    const gchar*        aplStr;


    /*********************************************************************
     * The following members are shared between threads and are locked by
     * the above mutex.
     *******************************************************************/

    gboolean            run;             /* run cmd*/
    gboolean            exit;            /* exit cmd*/
    gboolean            initialized;     /* streaming status, all streaming was prepared and are running successfully */
    gboolean            prepared;        /* streaming status, thread was initialized   */
    gboolean            dosilence;       /* streaming status, thread was initialized   */
    gboolean            wrtsilence;        /* streaming status, thread was initialized   */
    gboolean            Req_start_audio;    /* streaming status, thread was initialized   */
    guint               alsa_thread_priority;
    gboolean            req_statistic;
    guint               silence_wrt_cnt_after_recover;
    guint               recov_success_write_count;

    /***************************************************************
     * copies of some of the audproc parameters for quick reference
     **************************************************************/

    guint               audproc_frame_shift_in;    /* samples per period of Auditorium up stream  */
    guint               audproc_frame_shift_out;   /* samples per period of Auditorium down stream  */
    guint               audproc_sample_rate_in;    /* sample rate of Auditorium up stream */
    guint               audproc_sample_rate_out;   /* sample rate for Auditorium down stream */

    audproc_alsa_stream_cfg* audproc_stream_data;

    /**********************
     * rst data structur
     *********************/
    tRTS                rts_handle;
    tRTS                rts_pb_hdl;      /* rts handler playback device */
    tRTS                rts_cap_hdl;   /* rts handler capture device */
    tRTS                rts_lp_hdl;      /* rts handler loopback device */
    rts_inst_desc*      rts_pb_desc;
    rts_inst_desc*      rts_cap_desc;
    rts_inst_desc*      rts_lp_desc;
    guint               pb_prefill_ms;
    guint               cap_prefill_ms;
    guint               lp_prefill_ms;
    guint               rts_read_cnt;
    guint               rts_write_cnt;
    gboolean            rts_read_err_occured;
    gboolean            rts_write_err_occured;
    gboolean            rts_xrun_pb_count;
    gboolean            rts_xrun_cap_count;
    trts_cfg*           rtsdata;
    trts_cfgadev_imp*   adevs;
    trts_cfgstream*     streamdefs;



    /**********************
     * audio pipeline
     *********************/
    guint                   audproc_in_ch_cnt;
    guint                   audproc_out_ch_cnt;
    gboolean                audproc_can_process;
    gboolean                audproc_can_write;
    gboolean                audproc_can_read;
    aplAudioSamples_desc    InAudio;
    aplAudioSamples_desc    OutAudio;
    aplAudioSamples_desc    PreProcess;
    aplAudioSamples_desc    PostProcess;
    aplAudioSamples_desc    PreSilence;
#ifdef D_SUPPORT_LOOPBACK_DEVICE_ENABLE
    aplAudioSamples_desc    lpAudio;
#endif

    /**********************
    * loopback desciptor
    *********************/
    gboolean                select_loopback;
    loopback_desc*          audproc_loopback_descr;

    /**********************
    * routing desciptor
    *********************/
    gboolean                isRouting;
    gboolean                isAudioprocessing;
    gboolean                isReadWriteErr;
    gboolean                isWriteErr;
    gboolean                isReadErr;

    /**********************
     * thread safe data stack for audproc_alsa functions:
     * - audproc_alsa_write_all -> err_w_s;
     * - audproc_alsa_process_prepare ->  avail_pp_s;
     * - audproc_alsa_write_prepare ->  avail_wp_s;
     * - audproc_alsa_read_all -> err_r_s
     *********************/
    gint                    err_w_s;
    gint                    err_r_s;
    guint                   nb_wrt_chunk_s ;
    guint                   i_s;
    guint                   j_s;
    short int*              s16ibuf_s;
    short int*              s16obuf_s;
    long int*               s32ibuf_s;
    long int*               s32obuf_s;
    //gboolean                available_s;
    gboolean                avail_pp_s;
    gboolean                avail_wp_s;

     /**********************
     * thread safe data stack for audproc_audio_rts_handler functions:
     * - audproc_audio_rts_handler_write -> rts_err_w_s
     * - audproc_audio_rts_handler_read -> rts_err_r_s
     * - audproc_audio_rts_handler_recover -> rts_err_rv_s
     *********************/
  gint                    rts_err_r_s;
  gint                    rts_err_w_s;
  gint                    rts_err_rv_s;
  unsigned int            rts_curr_xrun_num_w_s;
  unsigned int            rts_curr_xrun_num_r_s;

    struct timespec rts_read_enter_time;
    struct timespec rts_read_fail_time;
    struct timespec rts_read_last_ok_time;

    struct timespec rts_write_enter_time;
    struct timespec rts_write_fail_time;
    struct timespec rts_write_last_ok_time;

}audproc_alsa_state;






extern void                 audproc_alsa_init(void);
extern void                 audproc_alsa_finalize(void);
extern void                 audproc_alsa_set_thread_priority(audproc_alsa_state* state, guint thread_priority);
extern guint                audproc_alsa_get_thread_priority(audproc_alsa_state* state);


extern gboolean             audproc_alsa_get_audio_run_state(audproc_alsa_state* state);
extern void                 audproc_alsa_print_current_audio_state(audproc_alsa_state* state);
extern void                 audproc_alsa_request_print_current_audio_state(void);

/* multi-instance interface */
extern audproc_alsa_state*  audproc_alsa_init_instance(audproc_alsa_stream_cfg* data);
extern int                  audproc_alsa_create_ent_streaming_thread(audproc_alsa_state* state);
extern int                  audproc_alsa_create_voice_streaming_thread(audproc_alsa_state* state);
extern int                  audproc_alsa_create_info_streaming_thread(audproc_alsa_state* state);
extern gint                 audproc_alsa_start_ent_instance(glong timeout_ms, audproc_alsa_state* state);
extern gint                 audproc_alsa_start_voice_instance(glong timeout_ms, audproc_alsa_state* state);
extern gint                 audproc_alsa_start_info_instance(glong timeout_ms, audproc_alsa_state* state);
extern gint                 audproc_alsa_stop_instance(audproc_alsa_state* state);
extern void                 audproc_alsa_exit_instance(audproc_alsa_state* state);
extern gint                 audproc_alsa_finalize_intance(audproc_alsa_state* state);
extern int                  audproc_alsa_streaming_initialize(audproc_alsa_state* state);
extern void                 audproc_alsa_set_scheduling_priority(audproc_alsa_state* state);
extern gboolean             audproc_alsa_set_audio_thread_state(gboolean thread_state, audproc_alsa_state* state);

#ifdef D_WRITE_SILENCE_DURING_PAUSE_TRACK_CHANGE
extern void                 audproc_alsa_process_silence_start(gpointer data);
extern void                 audproc_alsa_process_silence_terminated(void);
#endif

#endif
