/*
 * audmgr_main.cpp
 *
 *  Created on: Sep 18, 2012
 *      Author: rjk2hi
 */


#include "g3g_dbus.h"

#include "audmgr_clienthandler.h"
#include "audmgr_main.h"

#include <iostream>


#define NODE_NAME  "org.genivi.audiomanager"
#define OBJECT_PATH1 "/org/genivi/audiomanager/CommandInterface"
#define INTERFACE_NAME "org.genivi.audiomanager.CommandInterface"


/*
 * Constructor
 */
audmgr_main::audmgr_main()
{
  m_ptrProxy = NULL;
}

/*
 * Destructor
 */
audmgr_main::~audmgr_main()
{
  std::cout<<"in vOnAppClose"<<std::endl;
  if(NULL != m_ptrProxy)
  {
      delete m_ptrProxy;
      m_ptrProxy = NULL;
  }
}

bool audmgr_main::bOnAppInit()
{
  std::cout<<"in bOnAppInit"<<std::endl;
  g3g_dbusconnection* conn = g3g_dbusconnection::getConnection(DBUS_BUS_SYSTEM);

  if(*conn)
  {
    m_ptrProxy = new audmgr_clienthandler(conn,NODE_NAME,OBJECT_PATH1,INTERFACE_NAME);

    return true;
  }
  return false;
}

void audmgr_main::vOnAppClose()
{
  std::cout<<"in vOnAppClose"<<std::endl;
  if(m_ptrProxy != NULL)
  {
    delete m_ptrProxy;
    m_ptrProxy = NULL;
  }
}
