/*
 * testapp_dbusobject.h
 *
 *  Created on: Sep 12, 2012
 *      Author: rjk2hi
 */

#ifndef TESTAPP_DBUSOBJECT_H_
#define TESTAPP_DBUSOBJECT_H_

#include "g3g_dbus.h"

class audmgrproxy;

typedef void (audmgrproxy::*SigCallback)(g3g_dbusmessage*);

class audmgrproxy:public g3g_dbusobjectproxy
{
private:
  audmgrproxy();//Constructor
  std::map<std::string, SigCallback> m_SignalTable;

  /*
   * Signal handler stubs
   */
  void _NumberOfMainConnectionsChanged(g3g_dbusmessage *msg);
  void _SinkAdded(g3g_dbusmessage *msg);
  void _SinkRemoved(g3g_dbusmessage *msg);
  void _SourceAdded(g3g_dbusmessage *msg);
  void _SourceRemoved(g3g_dbusmessage *msg);
  void _NumberOfSinkClassesChanged(g3g_dbusmessage *msg);
  void _NumberOfSourceClassesChanged(g3g_dbusmessage *msg);

  //VVD
  void _NewMainConnection(g3g_dbusmessage *msg);
  void _RemovedMainConnection(g3g_dbusmessage *msg);

  void _MainConnectionStateChanged(g3g_dbusmessage *msg);
  void _MainSinkSoundPropertyChanged(g3g_dbusmessage *msg);
  void _MainSourceSoundPropertyChanged(g3g_dbusmessage *msg);
  void _SinkAvailabilityChanged(g3g_dbusmessage *msg);
  void _SourceAvailabilityChanged(g3g_dbusmessage *msg);
  void _VolumeChanged(g3g_dbusmessage *msg);
  void _SinkMuteStateChanged(g3g_dbusmessage *msg);
  void _SystemPropertyChanged(g3g_dbusmessage *msg);
  void _TimingInformationChanged(g3g_dbusmessage *msg);

protected:
  DBusHandlerResult eDispatch_Signal(g3g_dbusmessage *msg);

public:
  audmgrproxy(g3g_dbusconnection* rfConnection,const char* sNodeName, const char* sObjectPath, const char* sInterfaceName);
  ~audmgrproxy();//Destructor
  /******************************************************************************
   * Methods
   ******************************************************************************/
    bool Connect(const uint16_t& sourceID, const uint16_t& sinkID, int16_t& result, uint16_t& mainConnectionID);
    bool Disconnect(uint16_t& mainConnectionID, int16_t& result);
    bool SetVolume(uint16_t& sinkID,uint16_t& Mode, int16_t& value, int16_t& result);
  bool VolumeStep(uint16_t& sinkID, int16_t& value, int16_t& result);
    bool SetSinkMuteState(uint16_t& sinkID, int16_t& muteState,int16_t& result);
    bool SetMainSinkSoundProperty(uint16_t& sinkID, generic_container<int16_t,int16_t>& soundProperty,int16_t& result);
  bool SetMainSourceSoundProperty(dbus_uint16_t & sourceID, generic_container< dbus_int16_t ,dbus_int16_t  > & soundProperty, dbus_int16_t & result);
  bool SetSystemProperty(generic_container< dbus_int16_t ,dbus_int16_t  >& Property, dbus_int16_t & result);
  bool GetListMainConnections(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t  >  > & listConnections);
  bool GetListMainSinks(int16_t result, std::vector< generic_container<uint16_t, std::string, generic_container<int16_t,int16_t>, int16_t,int16_t,uint16_t > > &resp);
  bool GetListMainSources(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,std::string ,generic_container< dbus_int16_t ,dbus_int16_t  > ,dbus_uint16_t  >  > & listMainSources);
  bool GetListMainSinkSoundProperties(dbus_uint16_t & sinkID, dbus_int16_t & result, std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > & listSoundProperties);
  bool GetListMainSourceSoundProperties(dbus_uint16_t & sourceID, dbus_int16_t & result, std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > & listSourceProperties);
  bool GetListSourceClasses(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  > & listSourceClasses);
  bool GetListSinkClasses(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  > & listSinkClasses);
  bool GetListSystemProperties(dbus_int16_t & result, std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > & listSystemProperties);
  bool GetTimingInformation(dbus_uint16_t & mainConnectionID, dbus_int16_t & result, dbus_int16_t & delay);

    /*******************************************************************************
     * Signals (PURE VIRTUAL)
     *******************************************************************************/
    virtual void NumberOfMainConnectionsChanged() = 0;
    virtual void SinkAdded(generic_container<uint16_t,std::string,generic_container<int16_t,int16_t>,int16_t,int16_t,uint16_t>& newSink) = 0;
    virtual void SinkRemoved(uint16_t& removedSinkID) =0;
    virtual void SourceAdded(generic_container<uint16_t,std::string,generic_container<int16_t,int16_t>,uint16_t>& newSource)=0;
    virtual void SourceRemoved(uint16_t& removedSourceID)=0;
    virtual void NumberOfSinkClassesChanged() =0;
    virtual void NumberOfSourceClassesChanged() =0;

    //VVD
    virtual void NewMainConnection(generic_container<dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t>& NewMainConnection)=0;
    virtual void RemovedMainConnection(uint16_t& connectionID)=0;

    virtual void MainConnectionStateChanged(uint16_t& connectionID, int16_t& connectionState)=0;
    virtual void MainSinkSoundPropertyChanged(uint16_t& sinkID, generic_container<int16_t,int16_t>& SoundProperty) =0;
    virtual void MainSourceSoundPropertyChanged(uint16_t& sourceID, generic_container<int16_t,int16_t>& SoundProperty) =0;
    virtual void SinkAvailabilityChanged(uint16_t& sinkID, generic_container<int16_t,int16_t>& availability)=0;
    virtual void SourceAvailabilityChanged(uint16_t& sourceID, generic_container<int16_t,int16_t>& availability)=0;
    virtual void VolumeChanged(uint16_t& sinkID,int16_t& volume)=0;
    virtual void SinkMuteStateChanged(uint16_t& sinkID,int16_t& muteState)=0;
    virtual void SystemPropertyChanged(generic_container<int16_t,int16_t>& availability)=0;
    virtual void TimingInformationChanged(uint16_t& mainConnection,int16_t& time)=0;
};




#endif /* TESTAPP_DBUSOBJECT_H_ */
