/******************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audiomanager.cpp
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audiomanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *******************************************************************************/

/*******************************************************************************
                        Includes
 *******************************************************************************/

#include "include/audiomanagertypes.h"

/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
/* Include AudioManager FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include <midw_fi_if.h>

#include "amcontrol_clienthandler_fc_audiomanager.h"
#include "CAmControlSenderBase.h"
//#include "CAmDltWrapper.h"
//#include "cca_if.h"

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/amcontrol_clienthandler_fc_audiomanager.cpp.trc.h"
#endif


#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/AudioSources/clGeniviAudioSource.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
using namespace AudioStack;
using namespace AudioStack::AudioSource;
using namespace SourceStateMachine;

/*******************************************************************************
                  Specific defines for this component
 *******************************************************************************/

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audiomanager
 *DESCRIPTION  : constructor for class amcontrol_clienthandler_fc_audiomanager
 *PARAMETER    : am::IAmRoutingReceiverShadow*
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
amcontrol_clienthandler_fc_audiomanager::amcontrol_clienthandler_fc_audiomanager(CAmControlSenderBase& controlSenderBase,
      am::IAmControlReceiverShadow& receiverShadow, am::IAmControlReceive& controlReceive)
   : CThreadSwitchingClient(MIDW_MASCFFI_C_U16_SERVICE_ID, MIDW_MASCFFI_C_SERVICE_VERSION_1_0, receiverShadow)
   , m_ControlSenderBase(controlSenderBase)
   , m_ControlReceive(controlReceive)
{
  bAudioDeviceAvailability = false;
  ANC_Availability=MSP_BOSE_ANC_ASC_SETTING_UNAVAILABLE;
  ASC_Availability=MSP_BOSE_ANC_ASC_SETTING_UNAVAILABLE;
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered in constructor amcontrol_clienthandler_fc_audiomanager()"));
}

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audiomanager
 *DESCRIPTION  : desructor for class amcontrol_clienthandler_fc_audiomanager
 *PARAMETER    : void
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
amcontrol_clienthandler_fc_audiomanager::~amcontrol_clienthandler_fc_audiomanager(void)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered in destructor amcontrol_clienthandler_fc_audiomanager()"));
}

/************************************************************************
 *FUNCTION     : bOnVolumeStatus
 *DESCRIPTION  : callback for property Volume
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_Volume
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnVolumeStatus (const FIMessaging::FIMessage& oMsg)
{
  //Get the data using Helper function
  midw_mascffi_tclMsgVolumeStatus oStatus;
  if ( ! oMsg.bPopulateFIData(oStatus))
  {
     ETG_TRACE_ERR(("bOnVolumeStatus() . E R R O R :  failed reading Volume.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
  }

  ETG_TRACE_USR4(("bOnVolumeStatus, VolumeMode= %d, Resource= %d", oStatus.VolumeMode.enType, oStatus.Resource.enType));

  ETG_TRACE_USR4(("bOnVolumeStatus,Channel= %d, Volume = %d, Source = %d", oStatus.Channel.enType,
        oStatus.Volume, oStatus.Source.enType));

  //vdu1kor:Ignoring volumeUpdate for Source 0 (Fix for SUZUKI-22946)
  if(oStatus.Source.enType == midw_fi_tcl_e8_AudSource::FI_EN_NONE)
  {
    ETG_TRACE_USR4(("CAmControlSenderBase::bOnVolumeStatus,Ignoring source(0)/midw_fi_tcl_e8_AudSource::FI_EN_NONE"));
    return true;
  }

  // update the Source to HMI before the volume
  sourceClassID enInternalSrcClass =
      clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(oStatus.Source.enType);
  const clSourceClass srcClass = clFactory_AudioSourceClass::GetSourceClass(enInternalSrcClass);

  clAudioSource* pAudioSource = AudioStack::AudioSource::clAudioSourceFactory::getAvailableAudioSource(srcClass.SourceClassID);

  if (pAudioSource)
  {
    SourceID SrcID = pAudioSource->sGetId();
    clGeniviAudioSource* pGamSource = clGeniviAudioCtrlAdapter::getAudioSource(SrcID);
    if(pGamSource!=NULL)
    {
      tU16 u16GamSrc = pGamSource->u16GetGeniviSourceID();
      ETG_TRACE_USR4(("CAmControlSenderBase::vResponse_Volume updating Property with Src %d",u16GamSrc));
      m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_SOURCE,u16GamSrc,oStatus.Resource.enType);
    }
    else
    {
      ETG_TRACE_ERR(("CAmControlSenderBase::vResponse_Volume pGamSource is NULL"));
      //m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_SOURCE,0);
    }
  }
  else
  {
    ETG_TRACE_ERR(("CAmControlSenderBase::vResponse_Volume clAudioSource is NULL"));
    //m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_SOURCE,0);
  }

  //m_ControlReceive.changeSinkMainVolumeDB(oStatus.Volume, 1);
  m_ControlReceive.changeSinkMainVolumeDB(oStatus.Volume, oStatus.Resource.enType);  //daw2hi 24.08.2018 use the sink information we got
  const clSourceClass* pSrcClass_ZeroVolMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_ZERO_VOLUME");
  if(pSrcClass_ZeroVolMute == NULL)
  {
    ETG_TRACE_ERR(("bOnVolumeStatus: ERROR no source class MUTE_ZERO_VOLUME"));
    return true;
  }

  if((clGeniviAudioCtrlAdapter::pcoGetTopOfStack((tU16)oStatus.Resource.enType) == NULL) && (NULL == clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource((tU16)oStatus.Resource.enType)))
  {
    ETG_TRACE_USR4(("bOnVolumeStatus,AudioStack is Empty !"));
    return true;
  }
  if(clGeniviAudioCtrlAdapter::pcoGetTopOfStack((tU16)oStatus.Resource.enType) != NULL)
  {
  SourceID topOfStackSrcID = clGeniviAudioCtrlAdapter::pcoGetTopOfStack((tU16)oStatus.Resource.enType)->sGetId();
  if((0 == oStatus.Volume) && (midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC == oStatus.Channel.enType))
  {
    //Paj5kor:Start: Fix for SUZUKI-20525. MUTE_ZERO_VOLUME is triggered only if volume 0 response received for entertainment sources.
      ETG_TRACE_USR4(("bOnVolumeStatus, topOfStackSourceId=%d, topOfStackSubSrcID=%d",topOfStackSrcID.enSourceClass, topOfStackSrcID.u16SubSource));
    if((topOfStackSrcID.enSourceClass == clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(oStatus.Source.enType)) &&
      (FALSE == clGeniviAudioCtrlAdapter::pcoGetTopOfStack((tU16)oStatus.Resource.enType)->getSourceType().stackable))
    {
      #if defined (VARIANT_S_FTR_ENABLE_VOLUME_0_NO_ENTERTAIN_PAUSE)
      ETG_TRACE_USR4(("bOnVolumeStatus, No MUTE_ZERO_VOLUME (project specific)"));
      #else
      ETG_TRACE_USR4(("bOnVolumeStatus, Trigger MUTE_ZERO_VOLUME"));
      clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID(pSrcClass_ZeroVolMute->getClassID(),0));
      #endif
    }
    else
    {
      ETG_TRACE_USR4(("bOnVolumeStatus, Zero volume is applied on Non-Entertainment source"));
    }
    //Paj5kor:End
  }
  else if( (oStatus.Volume > 0) && (midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC == oStatus.Channel.enType) )//TODO : Need to check
  {
    ETG_TRACE_USR4(("bOnVolumeStatus, Volume > 0 received !!"));

    clAudioSource* poMuteZeroVolSource = NULL;
    poMuteZeroVolSource = clAudioSourceFactory::getAudioSource(SourceID(pSrcClass_ZeroVolMute->getClassID(),0),0,false);

    if(NULL == poMuteZeroVolSource)
    {
      ETG_TRACE_USR4(("bOnVolumeStatus, Volume > 0,poMuteZeroVolSource is NULL"));
      return false;
    }

    /*
     *  Fix : PSARCCB-6427
     *  USE CASE where MUTE_ZERO_VOLUM is removed if volume > 0 is received
     *
     * UseCase1> MUTE_ZERO_VOLUM(on) / FM(Pause)
     * UseCase2> MUTE_ENTERTAIN(off) / MUTE_ZERO_VOLUM(Off) / FM(rampdownToPause) ==> PSARCCB-6427
     * UseCase3> MUTE_ENTERTAIN(off) / MUTE_ZERO_VOLUM(RampUp) / FM(rampdownToPause)
     * UseCase4> MUTE_ENTERTAIN(off) / MUTE_ZERO_VOLUM(RampUpInit) / FM(rampdownToPause)
     * UseCase5> MUTE_ENTERTAIN(off) / MUTE_ZERO_VOLUM(RampUpRequesting)/ FM(rampdownToPause)
     *
     *  USE CASE where MUTE_ZERO_VOLUM is not removed if volume > 0 is received
     *
     * UseCase1> FM_TA(RampUpInit/RampupRequesting/On) / MUTE_ZERO_VOLUM(Pause) / FM(Pause)
     *
     */
      if((clAudioSourceController::getInstance().bIsSourceOnStack(SourceID(pSrcClass_ZeroVolMute->getClassID(),0)))
        && (poMuteZeroVolSource->pclGetState() != clSrcStateFactory::pclCreatePause()))
      {
        ETG_TRACE_USR4(("bOnVolumeStatus, VolumeSet > 0,MUTE_ZERO_VOLUME is on stack,Calling clGeniviAudioCtrlAdapter::RequestSourceOff[MUTE_ZERO_VOLUME]"));
        clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass_ZeroVolMute->getClassID(), 0));
      }
    else
      ETG_TRACE_USR4(("bOnVolumeStatus, VolumeSet > 0,Either MUTE_ZERO_VOLUME isn't on stack OR it's in Pause state, Not removing !!"));
  }
  }
  return true;
}

/************************************************************************
 *FUNCTION     : bOnVolumeModeResult
 *DESCRIPTION  : callback for property VolumeMode
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnVolumeModeResult (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgVolumeModeMethodResult oVolumeModeMethodResult;

  //Get the data using Helper function
  if ( ! oMsg.bPopulateFIData(oVolumeModeMethodResult))
     return false;

  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::bHandleMethodResult, ServiceStatus= %d"
        , oVolumeModeMethodResult.ServiceStatus.enType));

   return true;
}


/************************************************************************
 *FUNCTION     : bOnAmpDeviceAudRouteResult
 *DESCRIPTION  : callback for method AmpDeviceAudRoute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_AudioRoute
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnAmpDeviceAudRouteResult (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult oResult;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oResult))
      return false;

   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vOnAmpDeviceAudRoute received, ServiceStatus= %d"
          , oResult.ServiceStatus.enType));
   return true;
}

/************************************************************************
 *FUNCTION     : bOnAudioSourceResult
 *DESCRIPTION  : callback for method AudioSource
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnAudioSourceResult (const FIMessaging::FIMessage& oMsg)
{
   //Get the data using Helper function
   midw_mascffi_tclMsgAudioSourceMethodResult oResult;
   if ( ! oMsg.bPopulateFIData(oResult))
      return false;

   ETG_TRACE_USR4(("bOnAudioSourceResult received Result: ServiceStatus= %d", oResult.ServiceStatus.enType));

   return true;
}

/************************************************************************
 *FUNCTION     : bOnLimitResult
 *DESCRIPTION  : callback for method status PerformVolLimit
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *22.10.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnLimitResult (const FIMessaging::FIMessage& /* oMsg */)
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnLimitResult"));

   return true;
}

/************************************************************************
 *FUNCTION     : bOnMuteResult
 *DESCRIPTION  : callback for method result for Mute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *04.08.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnMuteResult (const FIMessaging::FIMessage& oMsg)
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnMuteResult"));

   //Get the data using Helper function
   midw_mascffi_tclMsgMuteMethodResult oResult;
   if ( ! oMsg.bPopulateFIData(oResult))
     return false;

   //ETG_TRACE_USR4(("bOnMuteResult received Result: ServiceStatus= %d", oResult.ServiceStatus.enType));
   ETG_TRACE_USR4(("bOnMuteResult received Result: Requester= %d, Resource= %d, State= %d, Channel = %d",
       oResult.Requester.enType, oResult.Resource.enType, oResult.State.enType, oResult.Channel.enType));
   return true;
}

/************************************************************************
 *FUNCTION     : bOnEntertainmentMuteResult
 *DESCRIPTION  : callback for method result for EntertainmentMute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *21.06.2017   Rev 1.0     RBEI/ECO1 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnEntertainmentMuteResult (const FIMessaging::FIMessage& oMsg)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnEntertainmentMuteResult"));

  //Get the data using Helper function
  midw_mascffi_tclMsgEntertainmentMuteMethodResult oResult;
  if ( ! oMsg.bPopulateFIData(oResult))
    return false;

  ETG_TRACE_USR4(("bOnEntertainmentMuteResult received Result: Requester= %d, Resource= %d, State= %d",
      oResult.Requester.enType, oResult.Resource.enType, oResult.State.enType));
  return true;
}

/************************************************************************
 *FUNCTION     : bOnSystemMuteResult
 *DESCRIPTION  : callback for method result for Mute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *24.08.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnSystemMuteResult (const FIMessaging::FIMessage& oMsg)
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnSystemMuteResult"));

   //Get the data using Helper function
   midw_mascffi_tclMsgSystemMuteMethodResult oResult;
   if ( ! oMsg.bPopulateFIData(oResult))
     return false;

   ETG_TRACE_USR4(("bOnSystemMuteResult received Result: Requester= %d, Resource= %d, State= %d",
       oResult.Requester.enType, oResult.Resource.enType, oResult.State.enType));
   return true;
}

bool amcontrol_clienthandler_fc_audiomanager:: bOnAdasSettingSoundResult(const FIMessaging::FIMessage& oMsg)
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnAdasSettingSoundResult"));

   //Get the data using Helper function
   midw_mascffi_tclMsgADAS_SettingSoundMethodResult oResult;
   if ( ! oMsg.bPopulateFIData(oResult))
   return false;

   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::bOnAdasSettingSoundResult, ServiceStatus= %d"
         , oResult.ServiceStatus.enType));
   return true;
}

/************************************************************************
 *FUNCTION     : bOnBassStatus
 *DESCRIPTION  : callback for property Bass
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE merge CAmControlSenderBase::vResponse_SinkSndProp_Bass
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnBassStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgBassStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnBassStatus() . E R R O R :  failed reading Bass.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   ETG_TRACE_USR4(("bOnBassStatus received Status: Bass= %d, Resource= %d, Channel = %d",
      oStatus.Bass, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_BASS,oStatus.Bass);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnTrebleStatus
 *DESCRIPTION  : Callback method for property Treble
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_Treble
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnTrebleStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgTrebleStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnTrebleStatus() . E R R O R :  failed reading Treble.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   ETG_TRACE_USR4(("bOnTrebleStatus received Status: Treble= %d, Resource= %d, Channel = %d",
      oStatus.Treble, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_TREBLE, oStatus.Treble);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnMidRangeStatus
 *DESCRIPTION  : callback for property MidRange
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE -  merge CAmControlSenderBase::vResponse_SinkSndProp_MidRange
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnMidRangeStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgMidRangeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnMidRangeStatus() . E R R O R :  failed reading MidRange.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   ETG_TRACE_USR4(("bOnMidRangeStatus received Status, MidRange= %d, Resource= %d, Channel = %d",
      oStatus.MidRange, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_MIDDLE, oStatus.MidRange);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnLoudnessStatus
 *DESCRIPTION  : Callback method for property Loudness
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE -  merge CAmControlSenderBase::vResponse_SinkSndProp_Loudness
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnLoudnessStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgLoudnessStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnLoudnessStatus() . E R R O R :  failed reading Loudness.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   ETG_TRACE_USR4(("bOnLoudnessStatus received Status ,Loudness= %d, Resource= %d, Channel = %d",
      oStatus.Loudness, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_LOUDNESS, oStatus.Loudness);

   return true;
}
/************************************************************************
 *FUNCTION     : bOnMinimumEntVolumeStatus
 *DESCRIPTION  : Callback method for property min startup volume
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :

 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnMinimumEntVolumeStatus(const FIMessaging::FIMessage& oMsg )
{
  midw_mascffi_tclMsgMinimumOnVolumeSetupStatus oStatus;
  if(! oMsg.bPopulateFIData(oStatus))
  {
   ETG_TRACE_ERR(("bOnMinimumEntVolumeSetStatus() . E R R O R :  failed reading bOnEntVolumeSetStatus from %x with size %d"
               , oMsg.pPayload, oMsg.u32PayloadLength))
          return false;
  }
  ETG_TRACE_USR4(("bOnMinimumEntVolumeSetStatus received Status: EntOnVolume: %d",oStatus.LimitValue));
  m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ENTSTARTUPMINVOLUME , oStatus.LimitValue);
     return true;
}
/************************************************************************
 *FUNCTION     : bOnBalanceStatus
 *DESCRIPTION  : Callback method for property Balance
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE -  merge CAmControlSenderBase::vResponse_SinkSndProp_Balance
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnBalanceStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgBalanceStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnBalanceStatus() . E R R O R :  failed reading Balance.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   ETG_TRACE_USR4(("bOnBalanceStatus received Status, Balance= %d, Resource= %d, Channel= %d",
      oStatus.Balance, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_BALANCE, oStatus.Balance);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnFaderStatus
 *DESCRIPTION  : Callback method for property Fader
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE -  merge CAmControlSenderBase::vResponse_SinkSndProp_Fader
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnFaderStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgFaderStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnFaderStatus() . E R R O R :  failed reading Fader.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
           return false;
   }

   ETG_TRACE_USR4(("bOnFaderStatus received Status,Fader= %d, Resource= %d, Channel= %d",
       oStatus.Fader, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_FADER, oStatus.Fader);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnDynamicCompressionStatus
 *DESCRIPTION  : Callback method for property DynamicCompression
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_DynCompression
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnDynamicCompressionStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgDynamicCompressionStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnDynamicCompressionStatus() . E R R O R :  failed reading DynamicCompression.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnDynamicCompressionStatus received Status, DynCompression: %d, Resource: %d",
      oStatus.DynCompression.enType, oStatus.Resource.enType));

  m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_DYN_COMPRESSION, oStatus.DynCompression.enType);

  return true;
}

/************************************************************************
 *FUNCTION     : bOnEquPresetStatus
 *DESCRIPTION  : Callback method for property EquPreset
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_EquPreset
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnEquPresetStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgEqualiserPresetStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnEquPresetStatus() . E R R O R :  failed reading EqualiserPreset.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnEquPresetStatus received Status, EquPreset: %d, Resource: %d",
      oStatus.EquPreset.enType, oStatus.Resource.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_EQUALIZER_PRESET, oStatus.EquPreset.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnRoomEffectStatus
 *DESCRIPTION  : Callback method for property Room Effect
 *PARAMETER    : oMsg
 *RETURN VALUE : void
 *HISTORY      :
 *24.02.2015   Rev 1.0     RBEI/ECV3 - Ranjit Susal  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnRoomEffectStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgRoomEffectStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnRoomEffectStatus() . E R R O R :  failed reading RoomEffect.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnRoomEffectStatus received Status, RoomEffect: %d, Resource: %d",
      oStatus.RoomEffect.enType, oStatus.Resource.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_ROOM_EFFECT, oStatus.RoomEffect.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnRearMuteStatus
 *DESCRIPTION  : Callback method for property rear mute
 *PARAMETER    : oMsg
 *RETURN VALUE : void
 *HISTORY      :
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnRearMuteStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgRear_MuteStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnRearMuteStatus() . E R R O R :  failed reading RoomEffect.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnRearMuteStatus received mute type, RearMuteType: %d",
      oStatus.Rear_Mute.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_CHILDREN_SLEEP_MODE, oStatus.Rear_Mute.enType);

   return true;
}


/************************************************************************
 *FUNCTION     : bOnGeometry_ModeStatus
 *DESCRIPTION  : Callback method for property geometry mode
 *PARAMETER    : oMsg
 *RETURN VALUE : void
 *HISTORY      :
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnGeometry_ModeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgGeometry_ModeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnRearMuteStatus() . E R R O R :  failed reading RoomEffect.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnRearMuteStatus received mute type, RearMuteType: %d",
      oStatus.Geometry_Mode.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_GEOMETRY_MODE, oStatus.Geometry_Mode.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnSpeedDepVolumeStatus
 *DESCRIPTION  : Callback method for property GalaLevel
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_Gala
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnSpeedDepVolumeStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgGalaStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnSpeedDepVolumeStatus() . E R R O R :  failed reading Gala.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnSpeedDepVolumeStatus received Status: EquPreset: %d, Resource: %d",
      oStatus.GalaLevel.enType, oStatus.Resource.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SPEED_DEPENDENT_VOLUME, oStatus.GalaLevel.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : vOnPDCActiveStatus
 *DESCRIPTION  : Callback method for property PDCAttenuation
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_PDCActive
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnPDCActiveStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgPDCAttenuationStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnPDCActiveStatus() . E R R O R :  failed reading PDCAttenuation.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnPDCActiveStatus received Status: PDCAttenuation: %d",
      oStatus.PDCAttenuation.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_PDC_ACTIVE, oStatus.PDCAttenuation.enType);

   return true;
}


/************************************************************************
 *FUNCTION     : bOnPDCAttenuationLevelStatus
 *DESCRIPTION  : Callback method for property PDCAttenuationLevel
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_PDCAttenuationLevel
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnPDCAttenuationLevelStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgPDCAttenuationLevelStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnPDCAttenuationLevelStatus() . E R R O R :  failed reading PDCAttenuationLevel.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnPDCAttenuationLevelStatus received Status: PDCAttenuationLevel: %d",
      oStatus.PDCAttenuationLevel));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_PDC_ATTENUATION_LEVEL, oStatus.PDCAttenuationLevel);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnVolumeListStatus
 *DESCRIPTION  : Callback method for property VolumeList
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_VolumeList
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnVolumeListStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgVolumeListStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnVolumeListStatus() . E R R O R :  failed reading VolumeList.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnVolumeListStatus() for sink %d",oStatus.Resource.enType));

   std::vector<midw_fi_tcl_Aud_VolumeStatus>::const_iterator VolumeStatusIterator;

   if(oStatus.AudVolumeList.VolumeStatusList.empty())
   {
    ETG_TRACE_USR4(("bOnVolumeListStatus() - AudVolumeList is empty"));
   }
   else
   {
    for(VolumeStatusIterator = oStatus.AudVolumeList.VolumeStatusList.begin();
        VolumeStatusIterator != oStatus.AudVolumeList.VolumeStatusList.end();
        ++VolumeStatusIterator)
    {
      tU8 AudioVolumeType = (tU8)(*VolumeStatusIterator).AudVolumeType.enType;
      tU8 Volume = (tU8)(*VolumeStatusIterator).Volume;

      //check volume type
      switch(AudioVolumeType)
      {
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT :
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_ENTERTAINMENT %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_ENTERTAINMENT,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ONVOL:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_ONVOL %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_ONVOL,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE1:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_1 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_1,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE2:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_2 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_2,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE3:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_3 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_3,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE4:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_4 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_4,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE5:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_5 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_5,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE6:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_6 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_6,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE7:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_7 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_7,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE8:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_8 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_8,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE9:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_9 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_9,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE10:
      {
          ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_PHONE_10 %d for sink %d",Volume,oStatus.Resource.enType));
          m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_PHONE_10,Volume,oStatus.Resource.enType);
          break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_TASETUP %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_TA,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_BEEP:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_BEEP %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_BEEP,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_NAVIGATION %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_NAVIGATION,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SDS:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_SDS %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_SDS,Volume,oStatus.Resource.enType);
        break;
      }
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_RINGTONE:
      {
        ETG_TRACE_USR4(("bOnVolumeListStatus() VOLUME_RINGTONE %d for sink %d",Volume,oStatus.Resource.enType));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_RINGTONE,Volume,oStatus.Resource.enType);
        break;
      }
      //default
      default :
      {
        break;
      }
      }//end of switch
    }//end of for loop
   }//end of else

   return true;
}

/************************************************************************
 *FUNCTION     : bOnEngineeringDataStatus
 *DESCRIPTION  : Callback method for property EngineeringData
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_EngineeringData
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnEngineeringDataStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgEngineeringDataStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnEngineeringDataStatus() . E R R O R :  failed reading EngineeringData.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   std::vector<midw_fi_tcl_Aud_EDStatus>::const_iterator EDStatusIterator;

   if(oStatus.EngineeringDataList.EDStatusList.empty())
   {
     ETG_TRACE_USR4(("bOnEngineeringDataStatus() EngineeringDataList is empty"));
   }
   else
   {
     for(EDStatusIterator = oStatus.EngineeringDataList.EDStatusList.begin();
         EDStatusIterator != oStatus.EngineeringDataList.EDStatusList.end();
         ++EDStatusIterator)
     {
       tU8 AudEDType = (tU8)(*EDStatusIterator).AudEDType.enType;
       tS32 EDValue = (tS32)(*EDStatusIterator).EDValue;

       switch(AudEDType)
       {
       case midw_fi_tcl_e8_Aud_EDType::FI_EN_ED_GALA_GAIN :
       {
         ETG_TRACE_USR4(("bOnEngineeringDataStatus Received GALA_GAIN -> Value: %d", EDValue));
         m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_GALA_GAIN,(int16_t)EDValue);
         break;
       }
       //default
       default :
       {
         ETG_TRACE_ERR(("bOnEngineeringDataStatus data type Unknown ... AudEDType= %d, EDValue= %d", AudEDType, EDValue));
         break;
       }
       }//end of switch
     }//end of for loop
   }//end of else

   return true;
}

/************************************************************************
 *FUNCTION     : bOnLevelBTAudioInStatus
 *DESCRIPTION  : Callback method for property BTAudioInLevel
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnLevelBTAudioInStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgBTAudioInLevelStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnLevelBTAudioInStatus() . E R R O R :  failed reading PDCAttenuationLevel.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnLevelBTAudioInStatus received Status: BTAudioInLevel: %d",
      oStatus.BTAudioInLevel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_LEVEL_BTAUDIO_IN, oStatus.BTAudioInLevel.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnVolumeLockStatus
 *DESCRIPTION  : Callback method for property VolumeLock
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *21.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_VolumeLock
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnVolumeLockStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgVolumeLockStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnVolumeLockStatus() . E R R O R :  failed reading PDCAttenuationLevel.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR3(("bOnVolumeLockStatus received Status,VolumeLock: %d",
       oStatus.VolumeLockType.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_VOLUME_LOCK, oStatus.VolumeLockType.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnCenterStatus
 *DESCRIPTION  : Callback method for property Center
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *25.11.2014   Rev 1.0     RBEI/ECV3 - Vyankatesh VD  Initial Revision
 *10.02.2015   Martin Koch, Fa. ESE    merge CAmControlSenderBase::vResponse_SinkSndProp_Center
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnCenterStatus (const FIMessaging::FIMessage& oMsg)
{
    //Get the data using Helper function
    midw_mascffi_tclMsgCenterStatus oStatus;
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audiomanager:: bOnCenterStatus() . E R R O R :  failed reading Center.Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("CAmControlSenderBase::vResponse_SinkSndProp_Center received Status,Center= %d, Resource= %d, Channel = %d",
        oStatus.Center, oStatus.Resource.enType, oStatus.Channel.enType));

    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_LEVEL_CENTER, oStatus.Center);

    return true;
}

/************************************************************************
 *FUNCTION     : bOnSubWooferStatus
 *DESCRIPTION  : Callback method for status of property SubWoofer
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *25.11.2014   Rev 1.0     RBEI/ECV3 - Vyankatesh VD  Initial Revision
 *10.02.2015   Martin Koch, Fa. ESE    CAmControlSenderBase::vResponse_SinkSndProp_SubWoofer
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnSubWooferStatus (const FIMessaging::FIMessage& oMsg)
{
   //Get the data using Helper function
   midw_mascffi_tclMsgSubWooferStatus oStatus;
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audiomanager:: bOnSubWooferStatus() . E R R O R :  failed reading Center.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("CAmControlSenderBase::bOnSubWooferStatus received Status: SubWoofer= %d, Resource= %d, Channel = %d",
       oStatus.SubWoofer, oStatus.Resource.enType, oStatus.Channel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_LEVEL_SUBWOOFER,oStatus.SubWoofer);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnAudioDeviceStatus
 *DESCRIPTION  : Callback method for property AudioDeviceStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *10.03.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_AudioDeviceStatus
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnAudioDeviceStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgAudioDeviceStatusStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnAudioDeviceStatus() . E R R O R :  failed reading AudioDeviceStatus.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnAudioDeviceStatus, AudioDeviceAvailability= %d", oStatus.AudioDeviceAvailability.enType));

   const clSourceClass* pSrcClass_AudDevMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_NO_AUD_DEV");
   if(pSrcClass_AudDevMute == NULL)
   {
     ETG_TRACE_ERR(("bOnAudioDeviceStatus: ERROR no source class MUTE_NO_AUD_DEV"));
     return true;
   }

   switch(oStatus.AudioDeviceAvailability.enType)
   {
      case midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_NOTAVAILABLE:
      {
    bAudioDeviceAvailability = false;
        clGeniviAudioCtrlAdapter::RequestSourceOn(
            SourceID(pSrcClass_AudDevMute->getClassID(),0),1);
#ifdef VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV
       clGeniviAudioCtrlAdapter::RequestSourceOn(
           SourceID(pSrcClass_AudDevMute->getClassID(),0),2);
#endif
        break;
      }
      case midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_AVAILABLE:
      {
      bAudioDeviceAvailability = true;
        clGeniviAudioCtrlAdapter::RequestSourceOff(
            SourceID(pSrcClass_AudDevMute->getClassID(),0),1);
#ifdef VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV
        clGeniviAudioCtrlAdapter::RequestSourceOff(
           SourceID(pSrcClass_AudDevMute->getClassID(),0),2);
		clAudioSMEngine::vRestoreEntertainmentsource();
#endif
        break;
      }
      default :
      {
        ETG_TRACE_ERR(("bOnAudioDeviceStatus: Invalid Status %u", oStatus.AudioDeviceAvailability.enType));
        break;
      }
   }

   return true;
}

bool amcontrol_clienthandler_fc_audiomanager::bGetbAudioDeviceAvailability()
{
  ETG_TRACE_USR4(("bGetbAudioDeviceAvailability, AudioDeviceAvailability= %d", bAudioDeviceAvailability));
  return bAudioDeviceAvailability;
}

/************************************************************************
 *FUNCTION     : bOnMicConnectionStatus
 *DESCRIPTION  : Callback method for property MicrophoneConnectionStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : true if any of the microphones is configured and connected
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SrcSndProp_MicPhoneConn
 *03.06.2015   Martin Koch, Fa. ESE - accommodate multiple microphones
 *14.07.2015   Martin Koch, Fa. ESE - correct testing logic
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnMicConnectionStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgMicrophoneConnectionStatusStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnMicConnectionStatus() . E R R O R :  failed reading MicrophoneConnectionStatus.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

  std::vector<midw_fi_tcl_MicrophoneConnectionStatus, std::allocator<midw_fi_tcl_MicrophoneConnectionStatus> >& list
      = oStatus.MicrophoneConnectionStatusList.MicrophoneConnectionStatusList;

  ETG_TRACE_USR4(("bOnMicConnectionStatus received Status for %u microphones" , list.size()))

  bool retVal = false;
  for (size_t i = 0; i < list.size(); ++i)
  {
     ETG_TRACE_USR4(("\t\t%u: u16MicrophoneCurrent: %d, e8MicrophoneConnectionStatus: %u"
         , ETG_ENUM(midw_fi_tcl_e8_MicrophoneNumber, list[i].e8MicrophoneNumber.enType)
         , list[i].u16MicrophoneCurrent
         , ETG_ENUM(midw_fi_tcl_e8_MicrophoneConnectionStatus, list[i].e8MicrophoneConnectionStatus.enType)));

     // map microphone ID to audio source as defined in source_priorities_<prj>.xml
     const char* SourceName = "undefined microphone source";
     if (list[i].e8MicrophoneNumber.enType == midw_fi_tcl_e8_MicrophoneNumber::FI_EN_MIC_1)
        SourceName = "MICROPHONE";
     else if (list[i].e8MicrophoneNumber.enType == midw_fi_tcl_e8_MicrophoneNumber::FI_EN_MIC_2)
        SourceName = "MICROPHONE2";

     const clSourceClass* pSrcClass_Microphone = clFactory_AudioSourceClass::GetSourceClass(SourceName);
     if(pSrcClass_Microphone == NULL)
     {
        ETG_TRACE_ERR(("bOnMicConnectionStatus: ERROR no source class %s", SourceName))
        continue;
     }

     clGeniviAudioSource* pGAS = clGeniviAudioCtrlAdapter::getAudioSource(SourceID(pSrcClass_Microphone->SourceClassID,0));
     if(pGAS == NULL)
     {
       ETG_TRACE_ERR(("bOnMicConnectionStatus: ERROR no source instance found for %s", SourceName));
       continue;
     }

      m_ControlSenderBase.vUpdateSourceSoundPropertyDB(static_cast<am_sourceID_t>(pGAS->u16GetGeniviSourceID())
            ,MSP_MIC_STATUS_CONNECTION, list[i].u16MicrophoneCurrent);

      if (list[i].e8MicrophoneConnectionStatus.enType == midw_fi_tcl_e8_MicrophoneConnectionStatus::FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OK)
         retVal = true;
  }

   return retVal;
}


/************************************************************************
 *FUNCTION     : bOnSoundOptimizationStatus
 *DESCRIPTION  : Callback method for property SoundOptimizationStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_Optimization
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnSoundOptimizationStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgOptimizationStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnSoundOptimizationStatus() . E R R O R :  failed reading Optimization.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnSoundOptimizationStatus received Status: Optimization: %d, Resource: %d",
      oStatus.Optimization.enType, oStatus.Resource.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SOUND_OPTIMIZATION, oStatus.Optimization.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnSoundRoomEffectStatus
 *DESCRIPTION  : Callback method for property SoundOptimizationStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnSoundRoomEffectStatus (const FIMessaging::FIMessage& /* oMsg */) const
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnSoundRoomEffectStatus"));

  return true;
}

/************************************************************************
 *FUNCTION     : bOnAuxInLevelStatus
 *DESCRIPTION  : Callback method for property AuxInLevel
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_AuxInLevel
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnAuxInLevelStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgAuxInLevelStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnAuxInLevelStatus() . E R R O R :  failed reading AuxInLevel.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnAuxInLevelStatus received Status,AuxInLevel: %d",
       oStatus.AuxInLevel.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_LEVEL_AUX_IN, oStatus.AuxInLevel.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnBeepResult
 *DESCRIPTION  : Callback method for Method Beep
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnBeepResult (const FIMessaging::FIMessage& oMsg)
{
   //Get the data using Helper function
   midw_mascffi_tclMsgBeepMethodResult oResult;
   if ( ! oMsg.bPopulateFIData(oResult))
   {
     ETG_TRACE_ERR(("bOnBeepResult() . E R R O R :  failed reading Beep.MethodResult from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::bOnBeepResult: ServiceStatus= %d",
       oResult.ServiceStatus.enType));

   return true;
}

/************************************************************************
 *FUNCTION     : bOnLevelBeepStatus
 *DESCRIPTION  : Callback method for property Beep
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SysSndProp_BeepStatus
 *10.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SysSndProp_BeepLevel
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnBeepLevelStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgBeepLevelStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audiomanager:: bOnBeepLevelStatus() . E R R O R :  failed reading BeepLevel.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager:: bOnBeepLevelStatus received Status: BeepLevel::%d",
       oStatus.BeepLevel.enType));

   //since both sink property MSP_LEVEL_BEEP and system property SYP_BEEP are used to generate different Beep tones
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_LEVEL_BEEP, oStatus.BeepLevel.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : vOnBeepStatus
 *DESCRIPTION  : Callback method for property BeepStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *02.02.2015   Rev 1.1     RBEI/ECV3 - Ranjit Susal  Function name modified
 *10.02.2015   Martin Koch, Fa. ESE    merge CAmControlSenderBase::vResponse_SysSndProp_BeepStatus
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnBeepStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgBeepStatusStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audiomanager:: bOnBeepStatus() . E R R O R :  failed reading Beep.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("CAmControlSenderBase::vResponse_SysSndProp_BeepStatus received Status: BeepStatus::%d, Resource: %d",
         oStatus.BeepStatus.enType, oStatus.Resource.enType));

   m_ControlSenderBase.vUpdateSystemPropertyDB(SYP_BEEP, oStatus.BeepStatus.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnVolumeModeStatus
 *DESCRIPTION  : Callback method for property VolumeModeStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SysSndProp_VolumeMode
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnVolumeModeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgVolumeModeStatusStatus oStatus;
  if ( ! oMsg.bPopulateFIData(oStatus))
  {
     ETG_TRACE_ERR(("bOnVolumeModeStatus . E R R O R :  failed reading VolumeModeStatus.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
  }

  ETG_TRACE_USR4(("bOnVolumeModeStatus received,VolumeMode:%d, Resource: %d, Channel: %d",
      oStatus.VolumeMode.enType, oStatus.Resource.enType, oStatus.Channel.enType));

  am_CustomSystemPropertyType_t eSystemPropType = SYP_UNKNOWN;
  switch(oStatus.Channel.enType)
  {
  case midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC :
    eSystemPropType = SYP_VOLMODE_STREAM_MAIN_1;
    break;
  case midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX :
    eSystemPropType = SYP_VOLMODE_STREAM_MIX_1;
    break;
  case midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX2 :
    //Currently ignored, will be used in future
    ETG_TRACE_USR4(("bOnVolumeModeStatus, received VolumeMode Status for FI_EN_AUDIO_CHANNEL_MIX2, Ignoring.."));
    return true;
  default:
    break;
  }

  m_ControlSenderBase.vUpdateSystemPropertyDB(eSystemPropType ,oStatus.VolumeMode.enType);

  return true;
}

// -----------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audiomanager::bOnLevelCenterStatus (const FIMessaging::FIMessage& /* oMsg */) const
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnLevelCenterStatus"));

  return true;
}

// -----------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audiomanager:: bOnLevelSubWooferStatus (const FIMessaging::FIMessage& /* oMsg */) const
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered bOnLevelSubWooferStatus"))

   return true;
}

/************************************************************************
 *FUNCTION     : bOnSettingSurroundStatus
 *DESCRIPTION  : Callback method for property SettingSurroundStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *06.12.2013   Rev 1.0     RBEI/ECG4 - Puneeth M  Initial Revision
 *04.02.2015   Martin Koch, Fa. ESE               merge CAmControllerBase::vResponse_SinkSndProp_SurroundSetting
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnSettingSurroundStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgSurroundSettingStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnSettingSurroundStatus() . E R R O R :  failed reading SurroundSetting.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnSettingSurroundStatus received Status: Surround: %d",
         oStatus.Surround.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SETTING_SURROUND, oStatus.Surround.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnFaderActiveStatus
 *DESCRIPTION  : Callback method for property FaderActiveStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SysSndProp_FaderActivation
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnFaderActiveStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgFaderActivationStatusStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnSettingSurroundStatus() . E R R O R :  failed reading FaderActivationStatus.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnFaderActiveStatus received Status: FaderStatus:%d",
      oStatus.FaderStatus.enType));

   m_ControlSenderBase.vUpdateSystemPropertyDB(SYP_FADER_STATUS_ACTIVE, oStatus.FaderStatus.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnDiagAudioModeStatus
 *DESCRIPTION  : callback for Diagnosis AudioMode status
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *26.08.2013   Rev 1.0     RBEI/ECV3 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SinkSndProp_DiagAudioMode
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnDiagAudioModeStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgDiagAudModeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnDiagAudioModeStatus() . E R R O R :  failed reading DiagAudMode.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnDiagAudioModeStatus received Status: DiaAudioMode: %d",
       oStatus.DiagAudMode.enType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_MODE_AUDIO, oStatus.DiagAudMode.enType);

   return true;
}


/************************************************************************
 *FUNCTION     : bOnFMEnhancerStatus
 *DESCRIPTION  : callback for FM Enhancer status
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *15.12.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnFMEnhancerStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgFMEnhancerModeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnFMEnhancerStatus() . E R R O R :  failed reading FMEnhancer.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnFMEnhancerStatus received Status: FMEnhancer Mode: %d",
       oStatus.FMEnhancer));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_FM_ENHANCER, oStatus.FMEnhancer);

   return true;
}


/************************************************************************
*FUNCTION     : bOnDiagDefSetPhaseStatus
*DESCRIPTION  : callback for Diagnosis Defset Phase status
*PARAMETER    : amt_tclServiceData*
*RETURN VALUE : void
*HISTORY         :
*20.01.2016   Rev 1.0     RBEI/ECV2 - pmh7kor  Initial Revision
************************************************************************/

bool amcontrol_clienthandler_fc_audiomanager::bOnDiagDefSetPhaseStatus(const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgDiagDefSetPhaseStatus oStatus;


   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnDiagDefSetPhaseStatus() . E R R O R :  failed reading Diagnosis Def Set Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }
   ETG_TRACE_USR4(("bOnDiagDefSetPhaseStatus received Status: DefSetPhase : %d",
       oStatus.DefSetPhase.enType));

   const clSourceClass* pSrcClass_MutefactoryResetOn = clFactory_AudioSourceClass::GetSourceClass("MUTE_FACTORYRESET");
   if (pSrcClass_MutefactoryResetOn == NULL)
   {
     ETG_TRACE_ERR(("bOnDiagDefSetPhaseStatus(): ERROR no source class MUTE_FACTORYRESET"));
     return false;
   }

   if (oStatus.DefSetPhase.enType == midw_fi_tcl_e8_AudDiagDefSetPhase::FI_EN_AUDIO_DIAGDEFSET_PREPARE)
   {
     clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID(pSrcClass_MutefactoryResetOn->getClassID(), 0));

   }
  // connecting FM as active Source when Factory settings are reset
  else if(oStatus.DefSetPhase.enType == midw_fi_tcl_e8_AudDiagDefSetPhase::FI_EN_AUDIO_DIAGDEFSET_FINISH)
  {

    //load all settings 
    tU16 sinkId = 1 ;// only for one sink as of now
    clGeniviAudioCtrlAdapter::vLoadSettings(sinkId);

    sourceClassID enInternalSrcClass =
      clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(midw_fi_tcl_e8_AudSource::FI_EN_FM);
    const clSourceClass srcClass = clFactory_AudioSourceClass::GetSourceClass(enInternalSrcClass);

    clAudioSource* pAudioSource = AudioStack::AudioSource::clAudioSourceFactory::getAvailableAudioSource(srcClass.SourceClassID);

    if (pAudioSource)
    {
      SourceID SrcID = pAudioSource->sGetId();
      clGeniviAudioSource* pGamSource = clGeniviAudioCtrlAdapter::getAudioSource(SrcID);
      if (pGamSource != NULL)
      {
        tU16 u16GamSrc = pGamSource->u16GetGeniviSourceID();
        ETG_TRACE_USR4(("calling CAmControlSenderBase::  hookUserConnectionRequest with GAM Src %d", u16GamSrc));
        am_mainConnectionID_t mainConnectionID;
        m_ControlSenderBase.hookUserConnectionRequest(u16GamSrc, 1, mainConnectionID); //SinkID = 1
      clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass_MutefactoryResetOn->getClassID(), 0));
      }
      else
        ETG_TRACE_USR4(("bOnDiagDefSetPhaseStatus():No GAM Source available "));
    }
    else
      ETG_TRACE_USR4(("bOnDiagDefSetPhaseStatus():No Source available since pAudioSource is NULL" ));
  }
  else
  {
    //do nothing
  }
  return true;
}

/************************************************************************
 *FUNCTION     : bOnESEDriveModeStatus
 *DESCRIPTION  : Callback for ESEDriveMode status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnESEDriveModeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgESEDriveModeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnESEDriveModeStatus() . E R R O R :  failed reading ESEDriveModeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnESEDriveModeStatus received Status: DriveMode: %d",
       oStatus.DriveMode));

   m_ControlSenderBase.vUpdateSystemPropertyDB(SYP_ESE_DRIVE_MODE, oStatus.DriveMode);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnESESoundTypeStatus
 *DESCRIPTION  : callback for ESESoundType Status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnESESoundTypeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgESESoundTypeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnESESoundTypeStatus() . E R R O R :  failed reading ESESoundTypeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnESESoundTypeStatus received Status: ESE SoundType: %d",oStatus.SoundType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ESE_SOUND_TYPE, oStatus.SoundType);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnESEVolumeStatus
 *DESCRIPTION  : callback for ESEVolume Status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnESEVolumeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgESEVolumeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnESEVolumeStatus() . E R R O R :  failed reading ESEVolumeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnESEVolumeStatus received Status: ESE Volume: %d",oStatus.Volume));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ESE_VOLUME, oStatus.Volume);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnRSoundOnOffStatus
 *DESCRIPTION  : callback for RSoundOnOff Status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnRSoundOnOffStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgRSoundOnOffStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnRSoundOnOffStatus() . E R R O R :  failed reading RSoundOnOffStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnRSoundOnOffStatus received Status: RSoundOnOffStatus: %d",oStatus.RSound));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_R_SOUND_ON_OFF, oStatus.RSound);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnRSoundSoundTypeStatus
 *DESCRIPTION  : callback for RSoundSoundType Status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnRSoundSoundTypeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgRSoundSoundTypeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnRSoundSoundTypeStatus() . E R R O R :  failed reading RSoundSoundTypeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnRSoundSoundTypeStatus received Status: RSoundSoundTypeStatus: %d",oStatus.RSoundType));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_R_SOUND_SOUND_TYPE, oStatus.RSoundType);

   return true;
}
bool amcontrol_clienthandler_fc_audiomanager::bOnRSoundActivationStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgRSoundActivationStatus oStatus;

  //Get the data using Helper function
  if ( ! oMsg.bPopulateFIData(oStatus))
  {
    ETG_TRACE_ERR(("bOnRSoundActivationStatus() . E R R O R :  failed reading RSoundVolumeStatus from %x with size %d"
        , oMsg.pPayload, oMsg.u32PayloadLength))
        return false;
  }
  ETG_TRACE_USR4(("bOnRSoundActivationStatus received Status: RSoundActive: %d",oStatus.RSoundActive));
  m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_R_SOUND_ACTIVATE, oStatus.RSoundActive);
  return true;
}
/************************************************************************
 *FUNCTION     : bOnRSoundVolumeStatus
 *DESCRIPTION  : callback for RSoundVolume Status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager:: bOnRSoundVolumeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgRSoundVolumeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnRSoundVolumeStatus() . E R R O R :  failed reading RSoundVolumeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnRSoundVolumeStatus received Status: RSoundVolumeStatus: %d",oStatus.Volume));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_R_SOUND_VOLUME, oStatus.Volume);

   return true;
}

/************************************************************************
 *FUNCTION     : bOnArkamysAudioModeStatus
 *DESCRIPTION  : callback for Arkamys AudioMode Status
 *PARAMETER    : const FIMessaging::FIMessage&
 *RETURN VALUE : bool
 *HISTORY         :
 *04.07.2016   Rev 1.0     RBEI/ECO12 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audiomanager::bOnArkamysAudioModeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgAudioModeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnArkamysAudioModeStatus() . E R R O R :  failed reading Arkamys AudioModeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnArkamysAudioModeStatus received Status: Arkamys Audio Mode: %d",oStatus.AudioMode.enType));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ARKAMYS_AUDIO_MODE, oStatus.AudioMode.enType);
   return true;
}

bool amcontrol_clienthandler_fc_audiomanager::bOnArkamysAutoGainControlStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgAutomaticGainControlStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnArkamysAutoGainControlStatus() . E R R O R :  failed reading Arkamys AutomaticGainControlStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnArkamysAutoGainControlStatus received Status: Arkamys Automatic Gain Control Status: %d",oStatus.AutomaticGainControl));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL, oStatus.AutomaticGainControl);
   return true;
}
//bool bOnADAS_UPASoundTypeStatus (const FIMessaging::FIMessage& oMsg);
bool amcontrol_clienthandler_fc_audiomanager::bOnADAS_UPASoundTypeStatus (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgADAS_UPASoundTypeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnADAS_UPASoundTypeStatus() . E R R O R :  failed reading ADAS_UPASoundTypeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnADAS_UPASoundTypeStatus received Status: Arkamys Audio Mode: %d",oStatus.SoundType.enType));
   m_ControlSenderBase.vUpdateSystemPropertyDB(SYP_ADAS_UPA_SOUND_COLLECTION, oStatus.SoundType.enType);
   return true;
}

//bool bOnADAS_ParkAssistanceVolumeStatus (const FIMessaging::FIMessage& oMsg);
bool amcontrol_clienthandler_fc_audiomanager::bOnADAS_ParkAssistanceVolumeStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnADAS_ParkAssistanceVolumeStatus() . E R R O R :  failed reading ParkAssistanceVolumeStatus from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnADAS_ParkAssistanceVolumeStatus received Status: Volume level: %d",oStatus.VolumeLevel.enType));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ADAS_PARK_ASSISTANT_VOLUME, oStatus.VolumeLevel.enType);
   return true;
}

//bool bOnADAS_UPAMuteStatus (const FIMessaging::FIMessage& oMsg);
bool amcontrol_clienthandler_fc_audiomanager::bOnADAS_UPAMuteStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgADAS_UPAMuteStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnADAS_UPAMuteStatus() . E R R O R :  failed reading UPA Mute Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnADAS_UPAMuteStatus received Status: Mute status: %d",oStatus.bMuted));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ADAS_UPA_MUTE, oStatus.bMuted);
   return true;
}


bool amcontrol_clienthandler_fc_audiomanager::bOnANC_ASCSetting (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgANCASCSettingStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnANC_ASCSetting() . E R R O R :  failed reading  Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }
   ANC_Availability = oStatus.ANCAvailability;
   ASC_Availability = oStatus.ASCAvailability;
   ETG_TRACE_USR4(("bOnANC_ASCSetting received ANC: %d,ASC:%d",oStatus.ANCAvailability,oStatus.ASCAvailability));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_ANC_SETTING, oStatus.ANCAvailability);
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_ASC_SETTING, oStatus.ASCAvailability);
   return true;
}

bool amcontrol_clienthandler_fc_audiomanager::bOnUserProfileChange (const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgUserProfileChangeStatus oStatus;

    if(! oMsg.bPopulateFIData(oStatus))
    {
        ETG_TRACE_ERR(("bOnUserProfileChange() . E R R O R :  failed reading  Status from %x with size %d"
             , oMsg.pPayload, oMsg.u32PayloadLength))
        return false;
    }

    ETG_TRACE_USR4(("bOnUserProfileChange received UserProfileChange:%d",oStatus.UserProfileChange));
    clGeniviAudioCtrlAdapter::vUpdateMultiUsrDataPool(true);

    return true;
}

bool amcontrol_clienthandler_fc_audiomanager::bOnANC_ASC_ActiveTest_Status (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgANCASCActiveTestStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnANC_ASC_ActiveTest_Status() . E R R O R :  failed reading  Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnANC_ASC_ActiveTest_Status received Status: %d",oStatus.TestStatus));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_ANC_ASC_ACTIVETEST, oStatus.TestStatus);
   return true;
}


bool amcontrol_clienthandler_fc_audiomanager::bOnADAS_LDW_UserVolume (const FIMessaging::FIMessage& oMsg)
{
   midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnADAS_LDW_UserVolume() . E R R O R :  failed reading LDW User Volume Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnADAS_LDW_UserVolume received Status: LDW User Volume: %d",oStatus.VolumeLevel.enType));
   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_ADAS_LDW_USER_VOLUME, oStatus.VolumeLevel.enType);
   return true;
}

//Bose Amplifier Specific
bool amcontrol_clienthandler_fc_audiomanager::bOnAudioPilot(const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgAudioPilotModeStatus oStatus;

    //Get the data using Helper function
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("bOnAudioPilot() . E R R O R :  failed reading Audio Pilot Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("bOnAudioPilot received Status: Audio Pilot: %d",oStatus.AudPilotMode));
    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_AUDIO_PILOT, oStatus.AudPilotMode);
    return true;
}
bool amcontrol_clienthandler_fc_audiomanager::bOnCenterPoint(const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgSurroundModeStatus oStatus;

    //Get the data using Helper function
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("bOnCenterPoint() . E R R O R :  failed reading Center Point/Surround Mode Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("bOnCenterPoint received Status: CenterPoint/Surround Mode: %d",oStatus.SurroundMode));
    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_CENTER_POINT, oStatus.SurroundMode);
    return true;
}
bool amcontrol_clienthandler_fc_audiomanager::bOnSurroundVol(const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgSurroundVolStatus oStatus;

    //Get the data using Helper function
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("bOnSurroundVol() . E R R O R :  failed reading Surround Volume Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("bOnSurroundVol received Status: Channel: %d, Resource: %d, Surround Volume: %d",oStatus.Channel.enType, oStatus.Resource.enType,oStatus.SurroundVol));
    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_SURROUND_VOLUME, oStatus.SurroundVol);
    return true;
}
bool amcontrol_clienthandler_fc_audiomanager::bOnDriverSound(const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgDriverSoundModeStatus oStatus;

    //Get the data using Helper function
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("bOnDriverSound() . E R R O R :  failed reading Driver Sound Audio Stage Mode Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("bOnDriverSound received Status: Driver Sound Audio Stage Mode: %d",oStatus.DriverMode));
    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_DRIVER_AUDIO_STAGE, oStatus.DriverMode);
    return true;
}
bool amcontrol_clienthandler_fc_audiomanager::bOnRearSound(const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgRearSoundModeStatus oStatus;

    //Get the data using Helper function
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("bOnRearSound() . E R R O R :  failed reading Rear Sound Stage Mode Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("bOnRearSound received Status: Rear Sound Mode: %d",oStatus.RearMode));
    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_BOSE_REARSEAT_AUDIO_STAGE, oStatus.RearMode);
    return true;
}

bool amcontrol_clienthandler_fc_audiomanager::bOnSRSoundNotificationStatus(const FIMessaging::FIMessage& oMsg)
{
    midw_mascffi_tclMsgSRSoundNotificationStateStatus oStatus;

    //Get the data using Helper function
    if ( ! oMsg.bPopulateFIData(oStatus))
    {
       ETG_TRACE_ERR(("bOnSRSoundNotificationStatus() . E R R O R :  failed reading SR_SoundNotificationStatus  Status from %x with size %d"
            , oMsg.pPayload, oMsg.u32PayloadLength))
       return false;
    }

    ETG_TRACE_USR4(("bOnSRSoundNotificationStatus received Status: SR_SoundNotificationStatus : %d",oStatus.SR_SoundNotification_State));
    m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_SR_SOUND_NOTIFICATION, oStatus.SR_SoundNotification_State);
    return true;
}

bool amcontrol_clienthandler_fc_audiomanager::bOnAmpAvailabilityStatus (const FIMessaging::FIMessage& oMsg)
{
  midw_mascffi_tclMsgAmpAvailFunctionStatus oStatus;

   //Get the data using Helper function
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
      ETG_TRACE_ERR(("bOnAmpAvailabilityStatus() . E R R O R :  failed reading UPA Mute Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
      return false;
   }

   ETG_TRACE_USR4(("bOnAmpAvailabilityStatus received Status: AGC status: %d, AudioPilot: %d, Balance: %d, Bass: %d, Fader: %d, Gala: %d, Loudness: %d,ANC: %d ASC:%d",
                    oStatus.AGC,oStatus.AudioPilot,oStatus.Balance,oStatus.Bass,oStatus.Fader,oStatus.Gala,oStatus.Loudness,oStatus.ANC,oStatus.ASC));

   ETG_TRACE_USR4(("bOnAmpAvailabilityStatus received Status: Middle: %d, RoomEffect: %d, Staging: %d,SubWoofer: %d, SurroundMode: %d, Treble: %d, \
                    ,AmpDownMix:%d, SurroundVol:%d, DriverSoundMode:%d, RearSoundMode:%d",oStatus.Middle,oStatus.RoomEffect,oStatus.Staging,oStatus.SubWoofer,
                    oStatus.SurroundMode,oStatus.Treble,oStatus.AmpDownMix,oStatus.SurroundVol,oStatus.DriverSoundMode,oStatus.RearSoundMode));

   int16_t u16AmpAvailStatus = 0;

   //(oStatus.AGC == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_AGC)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_AGC));
   (oStatus.AudioPilot == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_AUDIO_PILOT)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_AUDIO_PILOT));
   (oStatus.Balance == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_BALANCE)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_BALANCE));
   (oStatus.Bass == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_BASS)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_BASS));
   (oStatus.Fader == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_FADER)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_FADER));
   (oStatus.Gala == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_GALA)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_GALA));
   //(oStatus.Loudness == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_LOUDNESS)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_LOUDNESS));
   (oStatus.Middle == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_MIDDLE)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_MIDDLE));
   //(oStatus.RoomEffect == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_ROOMEFFECT)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_ROOMEFFECT));
   //(oStatus.Staging == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_STAGING)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_STAGING));
   //(oStatus.SubWoofer == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_SUBWOOFER)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_SUBWOOFER));
   (oStatus.SurroundMode == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_SURROUNDMODE)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_SURROUNDMODE));
   (oStatus.Treble == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_TREBLE)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_TREBLE));
   (oStatus.AmpDownMix == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_AMPDOWNMIX)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_AMPDOWNMIX));
   (oStatus.SurroundVol == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_SURROUND_VOLUME)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_SURROUND_VOLUME));
   (oStatus.DriverSoundMode == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_DRIVER_AUDIO_STAGE)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_DRIVER_AUDIO_STAGE));
   (oStatus.RearSoundMode == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_REARSEAT_AUDIO_STAGE)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_REARSEAT_AUDIO_STAGE));
   (oStatus.ANC == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_ANC)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_ANC));
   (oStatus.ASC == 1) ? (SET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_ASC)) : (UNSET_STATUS(u16AmpAvailStatus, MSP_AMP_AVAILABILITY_ASC));

   m_ControlSenderBase.vUpdateSinkSoundPropertyDB(MSP_AMP_AVAILABILITY_FUNCTION_STATUS, u16AmpAvailStatus);
   return true;
}
bool amcontrol_clienthandler_fc_audiomanager::bOnEntVolumeStatus(const FIMessaging::FIMessage& oMsg )
{
  midw_mascffi_tclMsgEntOnVolumeSetupStatus oStatus;
  if(! oMsg.bPopulateFIData(oStatus))
  {


    ETG_TRACE_ERR(("bOnEntVolumeSetStatus() . E R R O R :  failed reading bOnEntVolumeSetStatus from %x with size %d"
               , oMsg.pPayload, oMsg.u32PayloadLength))
          return false;
  }

  ETG_TRACE_USR4(("bOnEntVolumeSetStatus received Status: EntOnVolume: %d",oStatus.LimitValue));
  m_ControlSenderBase.vUpdateSinkSoundPropertyDB( MSP_ENTSTARTUPVOLUME, oStatus.LimitValue);
     return true;
}

/*******************************************************************************
               Methods of this application
 *******************************************************************************/

/************************************************************************
 *FUNCTION     : vSetVolume
 *DESCRIPTION  : Function to post CCAMessage to setVolume
 *PARAMETER    : uint8_t u8VolumeType,uint8_t u8Resource,uint8_t u8Volume
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetVolume(uint8_t u8VolumeType,uint8_t u8Resource,uint8_t u8Volume)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetVolume called, u8VolumeType= %d, u8Resource= %d, u8Volume= %d", u8VolumeType, u8Resource, u8Volume));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    m_ControlSenderBase.vLoadVolumeContext(u8Resource);
    midw_mascffi_tclMsgVolumeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.VolumeType.enType = (midw_fi_tcl_e8_AudioVolumeType::tenType) u8VolumeType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Volume = u8Volume;

    if (m_pSender){
       ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetVolume: Posting VolumeSet message to fc_AudMgr sink %d",u8Resource));
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    }
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetVolume() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetVolume called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSystemSoundProperty_VolumeMode
 *DESCRIPTION  : Function to post CCAMessage to setVolumeMode
 *PARAMETER    : uint8_t u8VolumeMode,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_VolumeMode(uint8_t u8VolumeMode,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_VolumeMode called, u8VolumeMode= %d, u8Resource= %d", u8VolumeMode, u8Resource));
  if( true == m_bSeviceAvailable )
  {
    midw_mascffi_tclMsgVolumeModeMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.VolumeMode.enType = (midw_fi_tcl_e8_VolumeMode::tenType) u8VolumeMode;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeMode() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_VolumeMode called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetMute
 *DESCRIPTION  : Function to post CCAMessage to setMute
 *PARAMETER    : uint8_t ,uint8_t ,uint8_t ,uint8_t ,uint8_t
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetMute(uint8_t u8MuteRequester,uint8_t u8Resource,uint8_t u8MuteAction,uint8_t u8MuteReason,uint8_t u8Channel)
{
  (void)u8MuteReason;
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetMute called, u8MuteRequester= %d, u8Resource= %d, u8MuteAction= %d, u8Channel= %d", u8MuteRequester, u8Resource, u8MuteAction, u8Channel));
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgMuteMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Requester.enType = (midw_fi_tcl_e8_MuteRequester::tenType) u8MuteRequester;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.State.enType = (midw_fi_tcl_e8MuteAction::tenType) u8MuteAction;
    oFiDataObject1.Reason.vSetMUTE_REAS_USER_ACTION(true);

    //TODO -
    /*switch(u8MuteReason)
      {
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_USER_ACTION:
            oFiDataObject1.Reason.vSetMUTE_REAS_USER_ACTION(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK:
            oFiDataObject1.Reason.vSetMUTE_REAS_START_OF_TRACK(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL:
            oFiDataObject1.Reason.vSetMUTE_REAS_SOURCE_SEL(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_DIAG:
            oFiDataObject1.Reason.vSetMUTE_REAS_DIAG(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_OTHER:
            oFiDataObject1.Reason.vSetMUTE_REAS_OTHER(true);
            break;
         default:
            break;
      }*/

    //oFiDataObject1.Reason.bMUTE_REAS_USER_ACTION =  u8MuteReason;
    oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetMute() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetMute called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetEntertainmentMute
 *DESCRIPTION  : Function to post CCAMessage to setMute
 *PARAMETER    : uint8_t ,uint8_t ,uint8_t ,uint8_t ,uint8_t
 *RETURN VALUE : tVoid
 *HISTORY         :
 *21.08.2017   Rev 1.0     RBEI/ECO1 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetEntertainmentMute(uint8_t u8MuteRequester,uint8_t u8Resource,uint8_t u8MuteAction,uint8_t u8MuteReason)
{
  (void)u8MuteReason;
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetEntertainmentMute called, u8MuteRequester= %d, u8Resource= %d, u8MuteAction= %d", u8MuteRequester, u8Resource, u8MuteAction));
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgEntertainmentMuteMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Requester.enType = (midw_fi_tcl_e8_MuteRequester::tenType) u8MuteRequester;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.State.enType = (midw_fi_tcl_e8MuteAction::tenType) u8MuteAction;
    oFiDataObject1.Reason.vSetMUTE_REAS_USER_ACTION(true);

    //oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetEntertainmentMute() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetEntertainmentMute called,Service is not available"));
  }
}
/************************************************************************
 *FUNCTION     : vSetSystemMute
 *DESCRIPTION  : Function to post CCAMessage to setMute
 *PARAMETER    : uint8_t ,uint8_t ,uint8_t ,uint8_t ,uint8_t
 *RETURN VALUE : tVoid
 *HISTORY         :
 *24.08.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemMute(uint8_t u8MuteRequester,uint8_t u8Resource,uint8_t u8MuteAction,uint8_t u8MuteReason)
{
  (void)u8MuteReason;
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemMute called, u8MuteRequester= %d, u8Resource= %d, u8MuteAction= %d", u8MuteRequester, u8Resource, u8MuteAction));

  if(u8Resource > midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT)
  {
	  //should not be called for sinks from other domain
	  ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audiomanager::vSetSystemMute no action for sinks from other domain"));
	  return;
  }

  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgSystemMuteMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Requester.enType = (midw_fi_tcl_e8_MuteRequester::tenType) u8MuteRequester;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.State.enType = (midw_fi_tcl_e8MuteAction::tenType) u8MuteAction;
    oFiDataObject1.Reason.vSetMUTE_REAS_USER_ACTION(true);

    //oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSystemMute() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemMute called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Bass
 *DESCRIPTION  : Function to post CCAMessage to SetBass property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Bass
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Bass(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Bass)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Bass called, u8SoundType= %d, u8Resource= %d, i8Bass= %d", u8SoundType, u8Resource, i8Bass));

  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgBassSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Bass = i8Bass;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Bass() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Bass called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Treble
 *DESCRIPTION  : Function to post CCAMessage to Set Treble property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Treble
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Treble(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Treble)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Treble called, u8SoundType= %d, u8Resource= %d, i8Treble= %d", u8SoundType, u8Resource, i8Treble));

  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgTrebleSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Treble = i8Treble;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Treble() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Treble called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_MidRange
 *DESCRIPTION  : Function to post CCAMessage to Set MidRange property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8MidRange
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_MidRange(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8MidRange)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_MidRange called, u8SoundType= %d, u8Resource= %d, i8MidRange= %d", u8SoundType, u8Resource, i8MidRange));

  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgMidRangeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.MidRange = i8MidRange;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_MidRange() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_MidRange called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Loudness
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Loudness(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Loudness)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Loudness called, u8SoundType= %d, u8Resource= %d, i8Loudness= %d", u8SoundType, u8Resource, i8Loudness));

  // Check if Service of server is available
  if(m_bSeviceAvailable)
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgLoudnessSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Loudness = i8Loudness;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Loudness() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Loudness called,Service is not available"));
  }
}


/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Balance
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Balance(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Balance)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Balance called, i8Balance= %d, u8Resource= %d, u8SoundType= %d", i8Balance, u8Resource, u8SoundType));

  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgBalanceSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Balance = i8Balance;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Balance() - E R R O R : m_pSender is NULL"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Balance called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Fader
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Fader(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Fader)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Fader called, i8Fader= %d, u8Resource= %d, u8SoundType= %d", i8Fader, u8Resource, u8SoundType));

  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgFaderSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Fader = i8Fader;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_Fader(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Fader called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_EntMinimumStartupVolume
 *DESCRIPTION  : set min startup volume
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_EntMinimumStartupVolume(uint8_t u8SoundType, uint8_t EntMinimumStrtupVolume  )
{
  if( m_bSeviceAvailable )
  {
    midw_mascffi_tclMsgMinimumOnVolumeSetupSet oFiDataObject1;
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;

    oFiDataObject1.LimitValue  = EntMinimumStrtupVolume ;


      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);

     else
          ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))

  }
  else
  {
  ETG_TRACE_USR4(("Service is not available"));

  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_DynCompression
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_DynCompression(uint8_t u8DynComp,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered vSetSinkSoundProperty_DynCompression, u8DynComp= %d, u8Resource= %d", u8DynComp, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgDynamicCompressionSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.DynComp.enType = (midw_fi_tcl_e8_DynCompression::tenType) u8DynComp;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_DynCompression(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_DynCompression called,Service is not available"));
  }
}


/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_PresetEquilizer
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PresetEquilizer(uint8_t u8EquPresets,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered vSetSinkSoundProperty_PresetEquilizer, u8EquPresets= %d, u8Resource= %d", u8EquPresets, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgEqualiserPresetSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.EquPreset.enType = (midw_fi_tcl_e8_EquPresets::tenType) u8EquPresets;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_PresetEquilizer(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PresetEquilizer called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_RoomEffect
 *DESCRIPTION  : Function to post CCAMessage to Set Room Effect property
 *PARAMETER    : uint8_t u8RoomEffect,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *24.02.2015   Rev 1.0     RBEI/ECV3 - Ranjit Susal  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RoomEffect(uint8_t u8RoomEffect,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::Entered vSetSinkSoundProperty_RoomEffect, u8RoomEffect= %d, u8Resource= %d", u8RoomEffect, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgRoomEffectSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.RoomEffect.enType = (midw_fi_tcl_e8_RoomEffect::tenType) u8RoomEffect;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_RoomEffect(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RoomEffect called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_SpeedDepVolChange
 *DESCRIPTION  : Function to post CCAMessage to Set (SDVC/Gala) property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SpeedDepVolChange(uint8_t u8GalaLevel,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SpeedDepVolChange called, u8GalaLevel= %d, u8Resource= %d", u8GalaLevel, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgGalaSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.GalaLevel.enType = (midw_fi_tcl_e8_GalaLevel::tenType) u8GalaLevel;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_SpeedDepVolChange(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SpeedDepVolChange called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_PDCActive
 *DESCRIPTION  : Function to post CCAMessage to Set PDC Attenuation property
 *PARAMETER    : uint8_t u8PDCAttenution,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PDCActive(uint8_t u8PDCAttenution,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PDCActive called, u8PDCAttenution= %d, u8Resource= %d", u8PDCAttenution, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgPDCAttenuationSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.PDCAttenuationCommand.enType = (midw_fi_tcl_e8_PDCAttenuation::tenType) u8PDCAttenution;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_PDCActive(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PDCActive called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_PDCAttenuationLevel
 *DESCRIPTION  : Function to post CCAMessage to Set PDC Attenuation level property
 *PARAMETER    : uint8_t u8PDCAttLevel,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PDCAttenuationLevel(uint8_t u8PDCAttenutionLevel,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PDCAttenuationLevel called, u8PDCAttenutionLevel= %d, u8Resource= %d", u8PDCAttenutionLevel, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgPDCAttenuationLevelSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.PDCAttenutionLevel = u8PDCAttenutionLevel;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_PDCAttenuationLevel(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PDCAttenuationLevel called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_BTAudioInLevel
 *DESCRIPTION  : Function to post CCAMessage to Set BTAudioInLevel property
 *PARAMETER    : uint8_t u8BTAudioInLevel, uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *08.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_BTAudioInLevel(uint8_t u8BTAudioInLevel,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_BTAudioInLevel called, u8BTAudioInLevel= %d, u8Resource= %d", u8BTAudioInLevel, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgBTAudioInLevelSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.BTAudioInLevel.enType = (midw_fi_tcl_e8_BTAudioInLevel::tenType) u8BTAudioInLevel;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_BTAudioInLevel(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_BTAudioInLevel called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeLock
 *DESCRIPTION  : Function to post CCAMessage to Set VolumeLock property
 *PARAMETER    : uint8_t u8VolumeLockType
 *RETURN VALUE : tVoid
 *HISTORY      :
 *21.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeLock(uint8_t u8VolumeLockType)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeLock called, u8VolumeLockType= %d", u8VolumeLockType));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeLockSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.VolumeLockType.enType = (midw_fi_tcl_e8_VolumeLock::tenType) u8VolumeLockType;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeLock(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeLock called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_SoundOptimization
 *DESCRIPTION  : Function to post CCAMessage to Set Sound optimization property
 *PARAMETER    : uint8_t u8Optimization,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SoundOptimization(uint8_t u8Optimization,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SoundOptimization called, u8Optimization= %d, u8Resource= %d", u8Optimization, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgOptimizationSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Optimization.enType = (midw_fi_tcl_e8_Optimization::tenType) u8Optimization;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_SoundOptimization(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SoundOptimization called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_AuxInLevel
 *DESCRIPTION  : Function to post CCAMessage to Set AuxInLevel property
 *PARAMETER    : uint8_t u8AuxInLevel
 *RETURN VALUE : tVoid
 *HISTORY      :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2014 : Ranjit Susal modified as sink sound property.
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AuxInLevel(uint8_t u8AuxInLevel)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AuxInLevel called, u8AuxInLevel= %d", u8AuxInLevel));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgAuxInLevelSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.AuxInLevel.enType = (midw_fi_tcl_e8_AuxInLevel::tenType) u8AuxInLevel;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_AuxInLevel(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AuxInLevel called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_BeepLevel
 *DESCRIPTION  : Function to post CCAMessage to Set BeepLevel property
 *PARAMETER    : uint8_t u8BeepLevel
 *RETURN VALUE : tVoid
 *HISTORY      :
 *02.02.2015   Rev 1.0     RBEI/ECV3 - Ranjit Susal  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_BeepLevel(uint8_t u8BeepLevel)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_BeepLevel called, u8BeepLevel= %d", u8BeepLevel));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgBeepLevelSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.BeepLevel.enType = (midw_fi_tcl_e8_BeepLevel::tenType) u8BeepLevel;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_BeepLevel(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_BeepLevel called,Service is not available"));
  }
}
/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_RearMute
 *DESCRIPTION  : Function to post CCAMessage to Set Childsleep mode
 *PARAMETER    : uint8_t u8RearMute
 *RETURN VALUE : tVoid
 *HISTORY      :
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RearMute(uint8_t u8RearMute)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RearMute called, u8BeepLevel= %d", u8RearMute));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgRear_MuteSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Rear_Mute.enType = (midw_fi_tcl_e8_Rear_Mute::tenType) u8RearMute;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_RearMute(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RearMute called,Service is not available"));
  }
}
/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_GeometryMode
 *DESCRIPTION  : Function to post CCAMessage to Set geometry mode
 *PARAMETER    : uint8_t Mode
 *RETURN VALUE : tVoid
 *HISTORY      :
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_GeometryMode(uint8_t u8mode)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_GeometryMode called, mode= %d", u8mode));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgGeometry_ModeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Geometry_Mode.enType = (midw_fi_tcl_e8_Geometry_Mode::tenType) u8mode;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_GeometryMode(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_GeometryMode called,Service is not available"));
  }

}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_SurroundSetting
 *DESCRIPTION  : Function to post CCAMessage to Set Surround property
 *PARAMETER    : uint8_t u8Surround
 *RETURN VALUE : tVoid
 *HISTORY      :
 *06.12.2013   Rev 1.0     RBEI/ECG4 - Puneeth M  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SurroundSetting(uint8_t u8Surround)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SurroundSetting called, u8Surround= %d", u8Surround));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgSurroundSettingSet oSurroundSetting;

    //Fill the parameters into the (message related) FI data object.
    oSurroundSetting.Surround.enType = (midw_fi_tcl_e8_SurroundSetting::tenType) u8Surround;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oSurroundSetting);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_SurroundSetting(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SurroundSetting called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSystemSoundProperty_Beep
 *DESCRIPTION  : Function to post CCAMessage to Set Beep Sound property
 *PARAMETER    : uint8_t u8BeepType,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_Beep(uint8_t u8BeepType,uint8_t u8Resource)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_Beep called, u8BeepType= %d, u8Resource= %d", u8BeepType, u8Resource));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgBeepMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.BeepType.enType = (midw_fi_tcl_e8_AudioBeepType::tenType) u8BeepType;
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSystemSoundProperty_Beep(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_Beep called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeEntertainment
 *DESCRIPTION  : Function to post CCAMessage to Set Entertainment volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 18.01.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeEntertainment(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeEntertainment called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.

    /* Adding Entertainment Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeEntertainment(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeEntertainment called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumePhone
 *DESCRIPTION  : Function to post CCAMessage to Set Phone volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 18.01.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumePhone(uint8_t u8VolumeValue)
{ 
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumePhone called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    tU16 u16PrivateMode=0;
    clGeniviAudioCtrlAdapter::eGetPrivateMode(u16PrivateMode);
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.
    //set default sink
    oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    if(u16PrivateMode == 2 || u16PrivateMode == 3)
    {
       // for Phone Volume priv mode 2 and 3 we have to use sink 2 (not nice to have this logic here)
       oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
    }

    /* Adding Phone Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_Fader(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumePhone called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeONVolume
 *DESCRIPTION  : Function to post CCAMessage to Set ONVolume volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 18.01.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeONVolume(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeONVolume called, u8VolumeValue= %d", u8VolumeValue));

  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.

    /* Adding ON Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ONVOL;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeONVolume(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeONVolume called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeTASetup
 *DESCRIPTION  : Function to post CCAMessage to Set TASetup volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 18.01.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeTASetup(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeTASetup called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    tU16 u16PrivateMode=0;
    clGeniviAudioCtrlAdapter::eGetPrivateMode(u16PrivateMode);
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.
    //set default sink
    oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    if(u16PrivateMode == 3)
    {
       // for TA priv mode 3 we have to use sink 2 (not nice to have this logic here)
       oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
    }

    /* Adding ON Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeTASetup(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeTASetup called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeBeep
 *DESCRIPTION  : Function to post CCAMessage to Set Beep volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 18.01.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeBeep(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeBeep called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.

    /* Adding ON Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_BEEP;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeBeep(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeBeep called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeNavigation
 *DESCRIPTION  : Function to post CCAMessage to Set Navigation volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 20.06.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeNavigation(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeNavigation called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    tU16 u16PrivateMode=0;
    clGeniviAudioCtrlAdapter::eGetPrivateMode(u16PrivateMode);
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.

    /* Adding ON Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION;
    oAudVolSet.Volume = u8VolumeValue;

    //set default sink
    oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    if(u16PrivateMode==3)
    {
       // for Nav and priv mode 3 we have to use sink 2 (not nice to have this logic here)
       oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
    }

    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeNavigation(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeNavigation called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeSDS
 *DESCRIPTION  : Function to post CCAMessage to Set SDS volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 20.06.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeSDS(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeSDS called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    tU16 u16PrivateMode=0;
    clGeniviAudioCtrlAdapter::eGetPrivateMode(u16PrivateMode);
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.
    //set default sink
    oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    if(u16PrivateMode == 3)
    {
       // for SDS priv mode 3 we have to use sink 2 (not nice to have this logic here)
       oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
    }

    /* Adding ON Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SDS;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeSDS(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeSDS called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_VolumeRingtone
 *DESCRIPTION  : Function to post CCAMessage to Set Ringtone volume sound property
 *PARAMETER    : uint8_t u8VolumeValue
 *RETURN VALUE : tVoid
 *HISTORY      : 20.06.2014 Rev 1.0 Ranjit Susal RBEI/ECG4 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeRingtone(uint8_t u8VolumeValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeRingtone called, u8VolumeValue= %d", u8VolumeValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgVolumeListSet oFiDataObject1;
    midw_fi_tcl_Aud_VolumeStatus oAudVolSet;

    //Fill the parameters into the (message related) FI data object.

    /* Adding ON Volume to the List */
    oAudVolSet.AudVolumeType.enType = midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_RINGTONE;
    oAudVolSet.Volume = u8VolumeValue;
    oFiDataObject1.AudVolumeList.VolumeStatusList.push_back(oAudVolSet);

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_VolumeRingtone(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_VolumeRingtone called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_AudioMode
 *DESCRIPTION  : Function to post CCAMessage to Set Diagnosis Audio Mode
 *PARAMETER    : uint8_t u8AudioMode
 *RETURN VALUE : tVoid
 *HISTORY      : 25.08.2014 Rev 1.0 Vyankatesh VD RBEI/ECV3 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AudioMode(uint8_t u8AudioMode)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AudioMode called, u8AudioMode= %d", u8AudioMode));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgDiagAudModeSet oFiDataObject1;

    if(u8AudioMode == midw_fi_tcl_e8_DiagAudMode::FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_ON)
    {
      oFiDataObject1.DiagAudMode.enType = (midw_fi_tcl_e8_DiagAudMode::tenType)u8AudioMode;
      oFiDataObject1.OnVolLimiterMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF;//FI_EN_NORMAL_MODE;// FI_EN_NOT_DEFINED;
      oFiDataObject1.MuteRampMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF;
      oFiDataObject1.VolumeRampMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF;
      oFiDataObject1.clippingMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF;
      oFiDataObject1.clippingMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF;
    }
    else
    {
      oFiDataObject1.DiagAudMode.enType = (midw_fi_tcl_e8_DiagAudMode::tenType)u8AudioMode;
      oFiDataObject1.OnVolLimiterMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_NORMAL_MODE;
      oFiDataObject1.MuteRampMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_NORMAL_MODE;
      oFiDataObject1.VolumeRampMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_NORMAL_MODE;
      oFiDataObject1.clippingMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_NORMAL_MODE;
      oFiDataObject1.clippingMode.enType = midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_NORMAL_MODE;
    }

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_AudioMode(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AudioMode called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_FMEnhancerMode
 *DESCRIPTION  : Function to post CCAMessage to Set FMEnhancerMode Audio Mode
 *PARAMETER    : uint8_t u8AudioMode
 *RETURN VALUE : tVoid
 *HISTORY      : 15.12.2015 Rev 1.0 Vyankatesh VD RBEI/ECV2 Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_FMEnhancerMode(uint8_t u8FMEnhancerMode)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_FMEnhancerMode called, u8AudioMode= %d", u8FMEnhancerMode));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgFMEnhancerModeSet oFiDataObject1;

  switch(u8FMEnhancerMode)
  {
    case AM_MSP_FM_ENHANCER_OFF :
    {
      ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_FMEnhancerMode, AM_MSP_FM_ENHANCER_OFF "));
      oFiDataObject1.FMEnhancer = false;
      break;
    }
    case AM_MSP_FM_ENHANCER_ON :
    {
      ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_FMEnhancerMode, AM_MSP_FM_ENHANCER_ON "));
      oFiDataObject1.FMEnhancer = true;
      break;
    }
    default:
    {
      ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_FMEnhancerMode, Invalid value ! "));
      return;
    }
  }

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_FMEnhancerMode(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_FMEnhancerMode called,Service is not available"));
  }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ArkamysAutoGainControlSet(uint8_t u8AutoGainCtrlMode)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ArkamysAutoGainControlSet called, u8AudioMode= %d", u8AutoGainCtrlMode));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
  midw_mascffi_tclMsgAutomaticGainControlSet oFiDataObject1;

  switch(u8AutoGainCtrlMode)
  {
    case MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_OFF :
    {
      ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_ArkamysAutoGainControlSet, MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_OFF "));
      oFiDataObject1.AutomaticGainControl = false;
      break;
    }
    case MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_ON :
    {
      ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_ArkamysAutoGainControlSet, MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_ON "));
      oFiDataObject1.AutomaticGainControl = true;
      break;
    }
    default:
    {
      ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_ArkamysAutoGainControlSet, Invalid value ! "));
      return;
    }
  }

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetSinkSoundProperty_ArkamysAutoGainControlSet(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ArkamysAutoGainControlSet called,Service is not available"));
  }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SRSoundNotificationState(uint8_t u8SRSoundNotState)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SRSoundNotificationState called, u8SRSoundNotState= %d", u8SRSoundNotState));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
        // Create the (message related) FI data object
        midw_mascffi_tclMsgSRSoundNotificationStateSet oFiDataObject1;

        switch(u8SRSoundNotState)
        {
            case MSP_SR_SOUND_NOTIFICATION_OFF :
            {
                ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_SRSoundNotificationState, MSP_SR_SOUND_NOTIFICATION_OFF "));
                oFiDataObject1.SR_SoundNotification_State = false;
                break;
            }
            case MSP_SR_SOUND_NOTIFICATION_ON :
            {
                ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_SRSoundNotificationState, MSP_SR_SOUND_NOTIFICATION_ON "));
                oFiDataObject1.SR_SoundNotification_State = true;
                break;
            }
            default:
            {
                ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_SRSoundNotificationState, Invalid value ! "));
                return;
            }
        }

        if (m_pSender)
            (void) m_pSender->u16PostFICommand(oFiDataObject1);
        else
            ETG_TRACE_FATAL(("vSetSinkSoundProperty_SRSoundNotificationState(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SRSoundNotificationState called,Service is not available"));
    }
}

/************************************************************************
 *FUNCTION     : vPerformOnVolLimit
 *DESCRIPTION  : Function to post CCAMessage to start method OnVolLimit
 *PARAMETER    : NA
 *RETURN VALUE : tVoid
 *HISTORY      :
 *22.10.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vPerformOnVolLimit()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vPerformOnVolLimit entered"));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    m_ControlSenderBase.vLoadVolumeContext();
    // Create the (message related) FI data object
    midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart oFiDataObject1;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vPerformOnVolLimit(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vPerformOnVolLimit called,Service is not available"));
  }
}

/************************************************************************
 * FUNCTION     : vSetAmpDeviceAudioRoute
 * DESCRIPTION  : function to set am device audio route
 *
 * PARAMETER    : uint8_t u8Resource,uint8_t u8Channel,uint8_t u8Source
 * RETURNVALUE  : tVoid
 * HISTORY      :
 * 10.09.12 Vyankatesh VD   Initial Revision.
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetAmpDeviceAudioRoute(uint8_t u8Resource,uint8_t u8Channel,uint8_t u8Source)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetAmpDeviceAudioRoute called, u8Resource= %d, u8Channel= %d, u8Source= %d", u8Resource, u8Channel, u8Source));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;
    oFiDataObject1.Source.enType = (midw_fi_tcl_e8_RouteNo::tenType) u8Source;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetAmpDeviceAudioRoute(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetAmpDeviceAudioRoute called,Service is not available"));
  }
}

/************************************************************************
 * FUNCTION     : vSetAudioSource
 * DESCRIPTION  : function to set audio source
 *
 * PARAMETER    : uint8_t u8Resource,uint8_t u8Source,uint8_t u8Channel
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              10.09.12 Vyankatesh VD  Initial Revision.
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetAudioSource(uint8_t u8Resource,uint8_t u8Source,uint8_t u8Channel)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetAudioSource called, u8Resource= %d, u8Source= %d, u8Channel= %d", u8Resource, u8Source, u8Channel));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgAudioSourceMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
    oFiDataObject1.Source.enType = (midw_fi_tcl_e8_AudSource::tenType) u8Source;
    oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;;

    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetAudioSource(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetAudioSource called,Service is not available"));
  }
}

/************************************************************************
 * FUNCTION     : vSetSinkSoundProperty_Center
 * DESCRIPTION  : function to set Center sound property
 * PARAMETER    : uint8_t,uint8_t,uint16_t
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              21.11.14 Vyankatesh VD  Initial Revision.
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Center(uint8_t u8SoundType,uint8_t u8Resource,uint16_t i16Center)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Center called, u8SoundType= %d, u8Resource= %d, i16Center= %d", u8SoundType, u8Resource, i16Center));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgCenterSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Center = i16Center;

      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);
      else
         ETG_TRACE_FATAL(("vSetSinkSoundProperty_Center(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Center called,Service is not available"));
    }
}
/************************************************************************
 * FUNCTION     : vSetSinkSoundProperty_SubWoofer
 * DESCRIPTION  : function to set SubWoofer property
 * PARAMETER    : uint8_t,uint8_t,uint16_t
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              21.11.14 Vyankatesh VD  Initial Revision.
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SubWoofer(uint8_t u8SoundType,uint8_t u8Resource,uint16_t u16SubWoofer)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SubWoofer called, u8SoundType= %d, u8Resource= %d, u16SubWoofer= %d", u8SoundType, u8Resource, u16SubWoofer));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
      // Create the (message related) FI data object
    midw_mascffi_tclMsgSubWooferSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.SubWoofer = u16SubWoofer;

      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);
      else
         ETG_TRACE_FATAL(("vSetSinkSoundProperty_SubWoofer(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SubWoofer called,Service is not available"));
    }
}
/************************************************************************
 * FUNCTION     : vSetSinkSoundProperty_ANC_ASC_ActiveTest
 * DESCRIPTION  : function to set ANCASCActive test
 * PARAMETER    : uint8_t
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              8/18/2017 : Swati A N
 ************************************************************************/


tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ANC_ASC_ActiveTest(uint8_t u8Value)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ANC_ASC_ActiveTest called, u8Value= %d", u8Value));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgANCASCActiveTestSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.Request = u8Value;

      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);
      else
         ETG_TRACE_FATAL(("vSetSinkSoundProperty_ANC_ASC_ActiveTest(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ANC_ASC_ActiveTest called,Service is not available"));
    }
}
/************************************************************************
 * FUNCTION     : vSetSinkSoundProperty_ANC_Setting
 * DESCRIPTION  : function to set ANC Setting
 * PARAMETER    : uint8_t
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              8/18/2017 : Swati A N
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ANC_Setting(uint8_t u8Value)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ANC_Setting called, u8Value= %d", u8Value));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgANCASCSettingSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.ANCAvailability = u8Value;
      oFiDataObject1.ASCAvailability = (tU8)ASC_Availability;

      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);
      else
         ETG_TRACE_FATAL(("vSetSinkSoundProperty_ANC_Setting(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ANC_Setting called,Service is not available"));
    }
}
/************************************************************************
 * FUNCTION     : vSetSinkSoundProperty_ASC_Setting
 * DESCRIPTION  : function to set ASC Setting
 * PARAMETER    : uint8_t
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              8/18/2017 : Swati A N
 ************************************************************************/

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ASC_Setting(uint8_t u8Value)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ASC_Setting called, u8Value= %d", u8Value));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgANCASCSettingSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.ASCAvailability = u8Value;
      oFiDataObject1.ANCAvailability = (tU8)ANC_Availability;

      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);
      else
         ETG_TRACE_FATAL(("vSetSinkSoundProperty_ASC_Setting(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ASC_Setting called,Service is not available"));
    }
}
/************************************************************************
 *FUNCTION     : vSetSystemSoundProperty_ESEDriveMode
 *DESCRIPTION  : Function to post CCAMessage to set property ESEDriveMode
 *PARAMETER    : uint8_t u8DriveMode
 *RETURN VALUE : tVoid
 *HISTORY         :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_ESEDriveMode(uint8_t u8DriveMode)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_ESEDriveMode called, u8DriveMode= %d", u8DriveMode));
    // Check if Service of server is available
    if( m_bSeviceAvailable )
    {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgESEDriveModeSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.DriveMode = u8DriveMode;

      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);
      else
         ETG_TRACE_FATAL(("vSetSystemSoundProperty_ESEDriveMode(): E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
      ETG_TRACE_USR4(("vSetSystemSoundProperty_ESEDriveMode::vSetSinkSoundProperty_ESEDriveMode called,Service is not available"));
    }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_ESESoundType
 *DESCRIPTION  : Function to post CCAMessage to set property ESESoundType
 *PARAMETER    : uint8_t u8ESESoundType
 *RETURN VALUE : tVoid
 *HISTORY      :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ESESoundType(uint8_t u8ESESoundType)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ESESoundType called, u8ESESoundType= %d", u8ESESoundType));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgESESoundTypeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType = u8ESESoundType;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_ESESoundType(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ESESoundType called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_ESEVolume
 *DESCRIPTION  : Function to post CCAMessage to set property ESEVolume
 *PARAMETER    : uint8_t u8ESEVolume
 *RETURN VALUE : tVoid
 *HISTORY      :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ESEVolume(uint8_t u8ESEVolume)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ESEVolume called, u8ESEVolume= %d", u8ESEVolume));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgESEVolumeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Volume = u8ESEVolume;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_ESEVolume(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ESEVolume called,Service is not available"));
  }
}
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundActivate(uint8_t u8RSoundActValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundActivate called, u8RSoundActValue= %d", u8RSoundActValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgRSoundActivationSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.RSoundActive = u8RSoundActValue;
    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_RSoundOnOff(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundActivate called,Service is not available"));
  }
}
/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_RSoundOnOff
 *DESCRIPTION  : Function to post CCAMessage to set property RSoundOnOff
 *PARAMETER    : uint8_t u8RSoundValue
 *RETURN VALUE : tVoid
 *HISTORY      :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundOnOff(uint8_t u8RSoundValue)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundOnOff called, u8RSoundValue= %d", u8RSoundValue));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgRSoundOnOffSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.RSound = u8RSoundValue;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_RSoundOnOff(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundOnOff called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_RSoundSoundType
 *DESCRIPTION  : Function to post CCAMessage to set property RSoundSoundType
 *PARAMETER    : uint8_t u8RSoundType
 *RETURN VALUE : tVoid
 *HISTORY      :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundSoundType(uint8_t u8RSoundType)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundSoundType called, u8ESESoundType= %d", u8RSoundType));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgRSoundSoundTypeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.RSoundType = u8RSoundType;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_RSoundSoundType(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundSoundType called,Service is not available"));
  }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_RSoundVolume
 *DESCRIPTION  : Function to post CCAMessage to set property RSoundVolume
 *PARAMETER    : uint8_t u8RSoundVolume
 *RETURN VALUE : tVoid
 *HISTORY      :
 *19.04.2016   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundVolume(uint8_t u8RSoundVolume)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundVolume called, u8RSoundVolume= %d", u8RSoundVolume));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgRSoundVolumeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.Volume = u8RSoundVolume;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_RSoundVolume(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RSoundVolume called,Service is not available"));
  }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_ADAS_UPASoundType(uint8_t u8RSoundType)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_ADAS_UPASoundType called, u8RSoundType= %d", u8RSoundType));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
  midw_mascffi_tclMsgADAS_UPASoundTypeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_ADAS_UPA_SoundType::tenType) u8RSoundType;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSystemSoundProperty_ADAS_UPASoundType(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_ADAS_UPASoundType called,Service is not available"));
  }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_ParkAssistanceVolume(uint8_t u8Volume)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_ParkAssistanceVolume called, u8Volume= %d", u8Volume));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgADAS_ParkAssistVolumeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.VolumeLevel.enType = (midw_fi_tcl_e8_ADAS_ParkAssist_Volume::tenType) u8Volume;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_ADAS_ParkAssistanceVolume(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_ParkAssistanceVolume called,Service is not available"));
  }
}
//Sink Property 'ADAS_UPAMute'
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_UPAMute(uint8_t u8Mute)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_UPAMute called, u8Mute= %d", u8Mute));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgADAS_UPAMuteSet oFiDataObject1;

    switch(u8Mute)
    {
      case MSP_ADAS_UPA_MUTE_OFF :
      {
        ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_ADAS_UPAMute, MSP_ADAS_UPA_MUTE_OFF "));
        oFiDataObject1.bMute = false;
        break;
      }
      case MSP_ADAS_UPA_MUTE_ON :
      {
        ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_ADAS_UPAMute, MSP_ADAS_UPA_MUTE_ON "));
        oFiDataObject1.bMute = true;
        break;
      }
      default:
      {
        ETG_TRACE_USR4(("CAmControlSenderBase::vSetSinkSoundProperty_ADAS_UPAMute, Invalid value ! "));
        return;
      }
    }

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_ADAS_UPAMute(): E R R O R - invalid pointer to m_pSender"))

  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_UPAMute called,Service is not available"));
  }
}

//Sink Property 'ADAS_LDW_UserVolume'
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_LDW_UserVolume(uint8_t u8VolumeLevel)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_LDW_UserVolume called, Volume Level= %d", u8VolumeLevel));
  //Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    //Create the (message related) FI data object
    midw_mascffi_tclMsgADAS_LDW_UserVolumeSet oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.VolumeLevel.enType = (midw_fi_tcl_e8_ADAS_LDW_UserVolume::tenType) u8VolumeLevel;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vSetSinkSoundProperty_ADAS_LDW_UserVolume(): E R R O R - invalid pointer to m_pSender"))

  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_ADAS_LDW_UserVolume called,Service is not available"));
  }
}
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_EntStartupVolume(uint8_t u8SoundType, uint8_t EntStrtupVolume )
{
  if( m_bSeviceAvailable )
  {
       // Create the (message related) FI data object
    midw_mascffi_tclMsgEntOnVolumeSetupSet  oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;

    oFiDataObject1.LimitValue  = EntStrtupVolume;


      if (m_pSender)
         (void) m_pSender->u16PostFICommand(oFiDataObject1);

     else
          ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))

  }
  else
  {
  ETG_TRACE_USR4(("Service is not available"));

  }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AudioPilotMode(uint8_t u8ModeType)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_AudioPilotMode called, Audio Pilot Mode= %d", u8ModeType));

    if (m_bSeviceAvailable)
    {
        midw_mascffi_tclMsgAudioPilotModeSet oFiDataObject1;

        oFiDataObject1.AudPilotMode = u8ModeType;

        if (m_pSender)
            (void) m_pSender->u16PostFICommand(oFiDataObject1);
        else
            ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("Service is not available"));
    }
}

//CenterPoint & SurroundMode are same
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_CenterPointMode(uint8_t u8ModeType)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_CenterPointMode called, CenterPoint/Surround Mode = %d", u8ModeType));
    if (m_bSeviceAvailable)
    {
        midw_mascffi_tclMsgSurroundModeSet oFiDataObject1;

        oFiDataObject1.SurroundMode = u8ModeType;
        if (m_pSender)
            (void) m_pSender->u16PostFICommand(oFiDataObject1);
        else
            ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("Service is not available"));
    }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SurroundVol(uint8_t u8SoundType, uint8_t u8Resource, uint8_t u8Volume)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SurroundVol called, SoundType = %d, Resource = %d, volume = %d ", u8SoundType,u8Resource,u8Volume));
    if (m_bSeviceAvailable)
    {
        midw_mascffi_tclMsgSurroundVolSet oFiDataObject1;

        //Fill the parameters into the (message related) FI data object.
        oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
        oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
        oFiDataObject1.SurroundVol = u8Volume;

        if (m_pSender)
            (void) m_pSender->u16PostFICommand(oFiDataObject1);
        else
            ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("Service is not available"));
    }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_DriverSoundMode(uint8_t u8ModeType)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_DriverSoundMode called, Driver Sound Mode = %d", u8ModeType));
    if (m_bSeviceAvailable)
    {
        midw_mascffi_tclMsgDriverSoundModeSet oFiDataObject1;
        oFiDataObject1.DriverMode = u8ModeType;
        if (m_pSender)
            (void) m_pSender->u16PostFICommand(oFiDataObject1);
        else
            ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("Service is not available"));
    }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RearSoundMode(uint8_t u8ModeType)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_RearSoundMode called, Rear Sound Mode = %d", u8ModeType));
    if (m_bSeviceAvailable)
    {
        midw_mascffi_tclMsgRearSoundModeSet oFiDataObject1;
        oFiDataObject1.RearMode = u8ModeType;
        if (m_pSender)
            (void) m_pSender->u16PostFICommand(oFiDataObject1);
        else
            ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("Service is not available"));
    }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vPrivateModeAttenuateMainSpeakers(bool bAttenuate,int u16PMMixVol)
{
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vPrivateModeAttenuateMainSpeakers bAttenuate = %d", bAttenuate));

  if (m_bSeviceAvailable)
    {
    midw_mascffi_tclMsgPrivateModeMixVolumeSet oFiDataObject1;
    if(!bAttenuate)
    {
      u16PMMixVol = 0;
    }
    ETG_TRACE_USR4(("vPrivateModeAttenuateMainSpeakers u16PMMixVol = %d", u16PMMixVol));
    oFiDataObject1.PMMixVolume = (tS16)u16PMMixVol;
    ETG_TRACE_USR4(("vPrivateModeAttenuateMainSpeakers Main Sink Attenuate dBValue = %d", oFiDataObject1.PMMixVolume));
    if (m_pSender)
    {
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
       ETG_TRACE_USR3(("vPrivateModeAttenuateMainSpeakers"));
    }
    else
        ETG_TRACE_FATAL((" E R R O R - invalid pointer to m_pSender"))
    }
    else
    {
        ETG_TRACE_USR4(("Service is not available"));
    }
}

tVoid amcontrol_clienthandler_fc_audiomanager::vAdasSettingSound_MethodStart(uint8_t u8SoundType)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vAdasSettingSound_MethodStart called, u8SoundType= %d", u8SoundType));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
  midw_mascffi_tclMsgADAS_SettingSoundMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SettingSound.enType = (midw_fi_tcl_e8_ADAS_Setting_Sound::tenType) u8SoundType;

    if (m_pSender)
      (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
      ETG_TRACE_FATAL(("vAdasSettingSound_MethodStart(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vAdasSettingSound_MethodStart called,Service is not available"));
  }
}

/************************************************************************
 * FUNCTION     : vOnConnect
 * DESCRIPTION  : Callback function to get status that fc_audiomanager
 *             service is available
 * PARAMETER    : void
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              10.09.12 Vyankatesh VD  Initial Revision.
 ************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager:: Service fc_audiomanager connected ... "))

  SET_STATUS(m_ControlReceiverShadow.m_u8StatusReady,STATUS_FC_AM_SRV_AVLB);
  //m_ControlSenderBase.sendControllerResponse();

  m_ControlSenderBase.response_startup();
}
/************************************************************************
 * FUNCTION     : vOnDisconnect
 * DESCRIPTION  : Callback function to get status of fc_audiomanager
 *                service is unavailable
 * PARAMETER    : void
 * RETURNVALUE  : tVoid
 * HISTORY      :
 *              21.01.2014 Vyankatesh VD  Initial Revision.
 ************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager:: vOnServiceUnavailable"));

  m_ControlSenderBase.m_eGAM_ServiceAvailability = SYP_AM_SRV_STS_UNAVAILABLE;
  UNSET_STATUS(m_ControlReceiverShadow.m_u8StatusReady,STATUS_FC_AM_SRV_AVLB);

  m_ControlSenderBase.vUpdateSystemPropertyDB(SYP_AM_SRV_STS, SYP_AM_SRV_STS_UNAVAILABLE);
}


/************************************************************************
* FUNCTION     : vRegisterForProperties
* DESCRIPTION  : Register for FC AudioManager properties to get the status
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 03.09.2015 Vyankatesh VD  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vRegisterForProperties()
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vRegisterForProperties entered"));

     /**
   * Fix for NCG3D-1154 - vdu1kor
   * These properties are registered when GAM is completely ready and all sink sound properties are registered with GAM
   **/
   static tU16 u16PropertyIDs[]
    = {
         MIDW_MASCFFI_C_U16_VOLUME
       , MIDW_MASCFFI_C_U16_AUDIODEVICESTATUS
       , MIDW_MASCFFI_C_U16_BASS
       , MIDW_MASCFFI_C_U16_TREBLE
       , MIDW_MASCFFI_C_U16_MIDRANGE

       , MIDW_MASCFFI_C_U16_LOUDNESS
       , MIDW_MASCFFI_C_U16_BALANCE
       , MIDW_MASCFFI_C_U16_FADER
       , MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION
       , MIDW_MASCFFI_C_U16_EQUALISERPRESET
       , MIDW_MASCFFI_C_U16_GALA
       , MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS
       , MIDW_MASCFFI_C_U16_OPTIMIZATION
       , MIDW_MASCFFI_C_U16_AUXINLEVEL
       , MIDW_MASCFFI_C_U16_BEEPLEVEL
       , MIDW_MASCFFI_C_U16_BEEPSTATUS
       , MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS
       , MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS
       , MIDW_MASCFFI_C_U16_SURROUNDSETTING
       , MIDW_MASCFFI_C_U16_PDCATTENUATION
       , MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL
       , MIDW_MASCFFI_C_U16_VOLUMELIST
       , MIDW_MASCFFI_C_U16_BTAUDIOINLEVEL
       , MIDW_MASCFFI_C_U16_ENGINEERINGDATA
       , MIDW_MASCFFI_C_U16_VOLUMELOCK

       , MIDW_MASCFFI_C_U16_CENTER
       , MIDW_MASCFFI_C_U16_SUBWOOFER
       , MIDW_MASCFFI_C_U16_ROOMEFFECT
       , MIDW_MASCFFI_C_U16_REAR_MUTE
       , MIDW_MASCFFI_C_U16_GEOMETRY_MODE
       , MIDW_MASCFFI_C_U16_FMENHANCERMODE
       , MIDW_MASCFFI_C_U16_DIAGDEFSETPHASE

       , MIDW_MASCFFI_C_U16_ESEDRIVEMODE
       , MIDW_MASCFFI_C_U16_ESESOUNDTYPE
       , MIDW_MASCFFI_C_U16_ESEVOLUME
       , MIDW_MASCFFI_C_U16_RSOUNDONOFF
       , MIDW_MASCFFI_C_U16_RSOUNDSOUNDTYPE
       , MIDW_MASCFFI_C_U16_RSOUNDVOLUME
       , MIDW_MASCFFI_C_U16_AUDIOMODE

     , MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE
     , MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME
     , MIDW_MASCFFI_C_U16_ADAS_UPAMUTE
     , MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME
     , MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION
     , MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL
     , MIDW_MASCFFI_C_U16_RSOUNDACTIVATION
     , MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP
     , MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP
     , MIDW_MASCFFI_C_U16_AUDIOPILOTMODE
     , MIDW_MASCFFI_C_U16_SURROUNDMODE
     , MIDW_MASCFFI_C_U16_SURROUNDVOL
     , MIDW_MASCFFI_C_U16_DRIVERSOUNDMODE
     , MIDW_MASCFFI_C_U16_REARSOUNDMODE
     , MIDW_MASCFFI_C_U16_ANCASCSETTING
     , MIDW_MASCFFI_C_U16_ANCASCACTIVETEST
     , MIDW_MASCFFI_C_U16_USERPROFILECHANGE
     , MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE
   , MIDW_MASCFFI_C_U16_PRIVATEMODEMIXVOLUME
    };

   for (tU8 i=0; i<sizeof(u16PropertyIDs)/sizeof(u16PropertyIDs[0]); i++)
   {
     // send UpReg message for properties
     ETG_TRACE_USR1(("vRegisterForProperties(): %u> Sending UpReg Message for property : %u ",i,u16PropertyIDs[i]))

     FIMessaging::FunctionInfo info(GetServiceInfo(), u16PropertyIDs[i] , FIMessaging::enUpreg);
     FIMessaging::fi_tclEmptyMsg oUpreg(info);
     if (m_pSender)
      (void) m_pSender->u16PostFICommand(oUpreg);
   }
}

// =============================================================================
//
//      ITarget implementation

/* virtual */ FIMessaging::ITarget::AutoRegisterList amcontrol_clienthandler_fc_audiomanager:: GetAutoRegisterList ()
{
   // disclose list of properties which should be UpReg'ed automatically
  /**
   * Fix for NCG3D-1154 - vdu1kor
   * If properties are registered here, then all property update will be sent immediateley after fc_audiomanager become available
   * irrespective of GAM is fully ready and all properties are registered, Hence UpReg should be done once GAM is ready
  **/
   static tU16 u16PropertyIDs[]
    = {
       /*  MIDW_MASCFFI_C_U16_VOLUME
       , MIDW_MASCFFI_C_U16_AUDIODEVICESTATUS
       , MIDW_MASCFFI_C_U16_BASS
       , MIDW_MASCFFI_C_U16_TREBLE
       , MIDW_MASCFFI_C_U16_MIDRANGE

       , MIDW_MASCFFI_C_U16_LOUDNESS
       , MIDW_MASCFFI_C_U16_BALANCE
       , MIDW_MASCFFI_C_U16_FADER
       , MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION
       , MIDW_MASCFFI_C_U16_EQUALISERPRESET
       , MIDW_MASCFFI_C_U16_GALA
       , MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS
       , MIDW_MASCFFI_C_U16_OPTIMIZATION
       , MIDW_MASCFFI_C_U16_AUXINLEVEL
       , MIDW_MASCFFI_C_U16_BEEPLEVEL
       , MIDW_MASCFFI_C_U16_BEEPSTATUS
       , MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS
       , MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS
       , MIDW_MASCFFI_C_U16_SURROUNDSETTING
       , MIDW_MASCFFI_C_U16_PDCATTENUATION
       , MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL
       , MIDW_MASCFFI_C_U16_VOLUMELIST
       , MIDW_MASCFFI_C_U16_BTAUDIOINLEVEL
       , MIDW_MASCFFI_C_U16_ENGINEERINGDATA
       , MIDW_MASCFFI_C_U16_VOLUMELOCK

       , MIDW_MASCFFI_C_U16_CENTER
       , MIDW_MASCFFI_C_U16_SUBWOOFER
       , MIDW_MASCFFI_C_U16_ROOMEFFECT
       , MIDW_MASCFFI_C_U16_REAR_MUTE*/

    };

   return AutoRegisterList(u16PropertyIDs, sizeof(u16PropertyIDs) / sizeof(u16PropertyIDs[0]));
}

// --------------------------------------------------------------------------

/* virtual */ void amcontrol_clienthandler_fc_audiomanager:: vDispatchMessage (FIMessaging::FIMessage oMsg)
{
   // callback function invoked from Genivi deamon main thread

   ETG_TRACE_USR1(("vDispatchMessage(): FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))

   bool bSuccess = false;
   switch (oMsg.u8OpCode)
   {
      case CCA_C_U8_OPCODE_STATUS:
         bSuccess = bHandleStatus(oMsg);
         break;

      case CCA_C_U8_OPCODE_METHODRESULT:
         bSuccess = bHandleMethodResult(oMsg);
         break;

      case CCA_C_U8_OPCODE_ERROR:
         bSuccess = bHandleError(oMsg);
         break;

      case CCA_C_U8_OPCODE_ABORTRESULT:
      default:
         break;
   }

   if ( ! bSuccess)
      ETG_TRACE_ERR(("vDispatchMessage() - E R R O R :  unhandled FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))
}

// --------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audiomanager:: bHandleStatus (const FIMessaging::FIMessage& oMsg)
{
   // delegate to dedicated message handlers

   switch (oMsg.u16FunctionID)
   {
      case MIDW_MASCFFI_C_U16_VOLUME                     : return bOnVolumeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_VOLUMELOCK                 : return bOnVolumeLockStatus(oMsg);
      case MIDW_MASCFFI_C_U16_VOLUMELIST                 : return bOnVolumeListStatus(oMsg);
      case MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS           : return bOnVolumeModeStatus(oMsg);

      case MIDW_MASCFFI_C_U16_BASS                       : return bOnBassStatus(oMsg);
      case MIDW_MASCFFI_C_U16_TREBLE                     : return bOnTrebleStatus(oMsg);
      case MIDW_MASCFFI_C_U16_MIDRANGE                   : return bOnMidRangeStatus(oMsg);

      case MIDW_MASCFFI_C_U16_LOUDNESS                   : return bOnLoudnessStatus(oMsg);
      case MIDW_MASCFFI_C_U16_BALANCE                    : return bOnBalanceStatus(oMsg);
      case MIDW_MASCFFI_C_U16_FADER                      : return bOnFaderStatus(oMsg);
      case MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS      : return bOnFaderActiveStatus(oMsg);

      case MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION         : return bOnDynamicCompressionStatus (oMsg);
      case MIDW_MASCFFI_C_U16_EQUALISERPRESET            : return bOnEquPresetStatus (oMsg);
      case MIDW_MASCFFI_C_U16_GALA                        :return bOnSpeedDepVolumeStatus (oMsg);
      case MIDW_MASCFFI_C_U16_OPTIMIZATION               : return bOnSoundOptimizationStatus (oMsg);
      case MIDW_MASCFFI_C_U16_SURROUNDSETTING            : return bOnSettingSurroundStatus (oMsg);
      case MIDW_MASCFFI_C_U16_PDCATTENUATION             : return bOnPDCActiveStatus (oMsg);
      case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL        : return bOnPDCAttenuationLevelStatus (oMsg);
      case MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS : return bOnMicConnectionStatus(oMsg);
      case MIDW_MASCFFI_C_U16_AUXINLEVEL                 : return bOnAuxInLevelStatus(oMsg);
      case MIDW_MASCFFI_C_U16_BEEPLEVEL                  : return bOnBeepLevelStatus(oMsg);
      case MIDW_MASCFFI_C_U16_BEEPSTATUS                 : return bOnBeepStatus(oMsg);

      case MIDW_MASCFFI_C_U16_ENGINEERINGDATA            : return bOnEngineeringDataStatus(oMsg);
      case MIDW_MASCFFI_C_U16_AUDIODEVICESTATUS          : return bOnAudioDeviceStatus(oMsg);
      case MIDW_MASCFFI_C_U16_DIAGAUDMODE                : return bOnDiagAudioModeStatus(oMsg);

      case MIDW_MASCFFI_C_U16_CENTER                     : return bOnCenterStatus(oMsg);
      case MIDW_MASCFFI_C_U16_SUBWOOFER                  : return bOnSubWooferStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ROOMEFFECT                 : return bOnRoomEffectStatus(oMsg);
      case MIDW_MASCFFI_C_U16_REAR_MUTE                : return bOnRearMuteStatus(oMsg);
      case MIDW_MASCFFI_C_U16_FMENHANCERMODE            : return bOnFMEnhancerStatus(oMsg);
      case MIDW_MASCFFI_C_U16_DIAGDEFSETPHASE            : return bOnDiagDefSetPhaseStatus(oMsg);

      case MIDW_MASCFFI_C_U16_ESEDRIVEMODE               : return bOnESEDriveModeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ESESOUNDTYPE               : return bOnESESoundTypeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ESEVOLUME                  : return bOnESEVolumeStatus(oMsg);

      case MIDW_MASCFFI_C_U16_RSOUNDONOFF              : return bOnRSoundOnOffStatus(oMsg);
      case MIDW_MASCFFI_C_U16_RSOUNDSOUNDTYPE          : return bOnRSoundSoundTypeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_RSOUNDVOLUME               : return bOnRSoundVolumeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_GEOMETRY_MODE              : return bOnGeometry_ModeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_AUDIOMODE              : return bOnArkamysAudioModeStatus(oMsg);

      case MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE      : return bOnADAS_UPASoundTypeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME    : return bOnADAS_ParkAssistanceVolumeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ADAS_UPAMUTE        : return bOnADAS_UPAMuteStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME  : return bOnADAS_LDW_UserVolume(oMsg);
      case MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION    : return bOnAmpAvailabilityStatus(oMsg);
      case MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL  : return bOnArkamysAutoGainControlStatus(oMsg);
      case MIDW_MASCFFI_C_U16_RSOUNDACTIVATION   : return bOnRSoundActivationStatus(oMsg);
      case MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP    : return bOnEntVolumeStatus(oMsg);
      case MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP : return bOnMinimumEntVolumeStatus(oMsg);

      case MIDW_MASCFFI_C_U16_AUDIOPILOTMODE    : return bOnAudioPilot(oMsg);
      case MIDW_MASCFFI_C_U16_SURROUNDMODE    : return bOnCenterPoint(oMsg);
      case MIDW_MASCFFI_C_U16_SURROUNDVOL    : return bOnSurroundVol(oMsg);
      case MIDW_MASCFFI_C_U16_DRIVERSOUNDMODE    : return bOnDriverSound(oMsg);
      case MIDW_MASCFFI_C_U16_REARSOUNDMODE    : return bOnRearSound(oMsg);
      case MIDW_MASCFFI_C_U16_ANCASCACTIVETEST    : return bOnANC_ASC_ActiveTest_Status(oMsg);
      case MIDW_MASCFFI_C_U16_ANCASCSETTING : return bOnANC_ASCSetting(oMsg);
      case MIDW_MASCFFI_C_U16_USERPROFILECHANGE : return bOnUserProfileChange(oMsg);
      case MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE : return bOnSRSoundNotificationStatus(oMsg);
      case MIDW_MASCFFI_C_U16_PRIVATEMODEMIXVOLUME : return true;

      default                                            : return false;
   }
}

// --------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audiomanager:: bHandleMethodResult (const FIMessaging::FIMessage& oMsg)
{
   // delegate to dedicated message handlers

   switch (oMsg.u16FunctionID)
   {
      case MIDW_MASCFFI_C_U16_VOLUMEMODE                 : return bOnVolumeModeResult(oMsg);
      case MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE        : return bOnAmpDeviceAudRouteResult(oMsg);
      case MIDW_MASCFFI_C_U16_AUDIOSOURCE                : return bOnAudioSourceResult(oMsg);
      case MIDW_MASCFFI_C_U16_BEEP                       : return bOnBeepResult(oMsg);
      case MIDW_MASCFFI_C_U16_PERFORMONVOLUMELIMIT       : return bOnLimitResult(oMsg);
      case MIDW_MASCFFI_C_U16_MUTE                    : return bOnMuteResult(oMsg);
      case MIDW_MASCFFI_C_U16_SYSTEMMUTE                 : return bOnSystemMuteResult(oMsg);
      case MIDW_MASCFFI_C_U16_ADAS_SETTINGSOUND         : return bOnAdasSettingSoundResult(oMsg);

      default                                            : return false;
   }

   return true;
}

// --------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audiomanager:: bHandleError (const FIMessaging::FIMessage& oMsg)
{
   // no special action on error responses, just trace out

   FIMessaging::fi_tclErrorMsg oError(oMsg.oFunctionInfo());
   if ( ! oMsg.bPopulateFIData(oError))
   {
      ETG_TRACE_FATAL(("amcontrol_clienthandler_fc_audiomanager::vHandleError() - ERROR : failed to populate Error for Function %x.%x.%u"
                    , oError.u16GetServiceID(), oError.u16GetFunctionID(), oError.u8GetOpCode()))
      return false;
   }

   ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audiomanager::vHandleError(): Error message received for Function %x.%x.%u with error-code: %u"
              , oError.u16GetServiceID(), oError.u16GetFunctionID(), oError.u8GetOpCode(), oError.u16ErrorCode))
   return true;
}
