/*******************************************************************************
 *
 * FILE:          SoundHandler.cpp
 *
 * SW-COMPONENT:  SoundHandler application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "include/audiomanagertypes.h"
#include "common.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links "osal_if.h"


#include "../config/dp/AudioUserDpIfSelect.h"

#include "../include/SoundHandler.h"

//#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_audio_if.h"

//#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
//check if needed for gen3armmake
//#define DP_DATAPOOL_ID =0xE880  //??? place it in prod xml ??
//#endif

#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_if.h"
#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
#include "dp_e880_if.h"
#else
#include "dp_e880_mock_if.h"
#endif
//#include "dp_audio_if.h"


#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/SoundHandler.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_SMART)
#define DEACTIVE 0
#define ACTIVE 1
#define ERROR 2
#define US 0
#define CAN 1
#define MEX 2
#define UK 3
#define TKY 4
#define EUR 6
#define TWN 8
#define HKG 9
#endif


namespace Sound
{
/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/
// Static self reference to be used in function callbacks.
//bool             SoundHandler::RemoteControlFlag=false;
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/
// HMI Index                                -9   -8   -7   -6   -5   -4   -3   -2   -1  0   1   2   3   4    5   6   7   8   9
// CMA Gain values                       /*-18, -16, -14, -12, -10,  -8,  -6,  -4,  -2, 0,  2,  4,  6,  8,  10, 12, 14, 16, 18*/

static const tS16 TrebleMappingTable[] = { 238, 240, 242, 244, 246, 248, 250, 252, 254, 0,  2,  4,  6,  8,  10, 12, 14, 16, 18};
static const tS16 BassMappingTable[]   = { 238, 240, 242, 244, 246, 248, 250, 252, 254, 0,  2,  4,  6,  8,  10, 12, 14, 16, 18};

/*-120, -35, -25, -15, -10,  -8,  -6,  -4,  -2, 0,  2,  4,  6,  8,  10, 15, 25, 35, 120*/
static const tS16 BalanceMappingTable[]= { 136, 221, 231, 241, 246, 248, 250, 252, 254, 0,  2,  4,  6,  8,  10, 15, 25, 35, 120};

/*-120, -35, -25, -15, -10,  -8,  -6,  -4,  -2, 0,  2,  4,  6,  8,  10, 15, 25, 35, 120*/
static const tS16 FaderMappingTable[]=   { 136, 221, 231, 241, 246, 248, 250, 252, 254, 0,  2,  4,  6,  8,  10, 15, 25, 35, 120};

/*******************************************************************************
 *
 * FUNCTION: SoundHandler::SoundHandler()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initialize static self reference to be used in function
 *              callbacks.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
SoundHandler::SoundHandler(void)
{
    ETG_TRACE_USR4(("SoundHandler() entered."));
    //SoundHandler::m_poSoundHandler = this;

    bPropertyChanged = false; //we do not need this
    for(int i=0;i<Number_of_Sinks;i++)
    {
        m_s8Fader[i] = 0;
        m_s8Treble[i] = 0;
        m_s8Balance[i] = 0;
        m_s8Bass[i] = 0;
        m_u8Gala[i] = 0;
        m_u8AuxIn[i] = 0;
        m_s8MidRange[i] = 0;
        m_u8Loudness[i] = 0;
        m_u8DynCompression[i] = 0;
        m_u8EquPreset[i] = 0;
        m_u8Optimization[i] = 0;
        m_u8BeepLevel[i] = 0;
        m_u8RoomEffect[i] = 0;
        m_u8GeometryMode[i] = 0;
        m_s8MinBass[i] = 0;
        m_s8MinTreble[i] = 0;
        m_s8MinMidRange[i] = 0;
        m_s8MinFader[i] = 0;
        m_s8MinBalance[i] = 0;
        m_s8MinAuxIn[i] = 0;
        m_s8MinLoudness[i] = 0;
        m_AudioMode[i] = 0;
        m_s8MaxBass[i] = 0;
        m_s8MaxTreble[i] = 0;
        m_s8MaxMidRange[i] = 0;
        m_s8MaxFader[i] = 0;
        m_s8MaxBalance[i] = 0;
        m_s8MaxGala[i] = 0;
        m_s8MaxAuxIn[i] = 0;
        m_s8MaxLoudness[i] = 0;
        m_s8MaxDynCompression[i] = 0;
        m_s8MaxEquPreset[i] = 0;
        m_s8MaxOptimization[i] = 0;
        m_s8MaxRoomEffect[i] = 0;

        //m_DiagDefsetPhase = EN_DEFSET_UNDEF; //setting to undef as in fi definition
        m_s16ANCDbvalue[i] = -120;  // ANC default scaler value x 4

        m_s8MixBassMic1[i]=0;
        m_s8MixBassMic2[i]=0;
        m_s8MixBassMic3[i]=0;

        m_s8MixTrebleMic1[i]=0;
        m_s8MixTrebleMic2[i]=0;
        m_s8MixTrebleMic3[i]=0;


    }
    //ToDO what is reasonable here? different for every sink or common for all? Should it go into Project specific header?
    m_bSDVCAvailability = TRUE;
    m_bBassAvailability = TRUE;

    m_bMixBassAvailability = TRUE;

    m_bTrebleAvailability = TRUE;
    m_bMixTrebleAvailability = TRUE;

    m_bBalanceAvailability = TRUE;
    m_bSurroundModeAvailability = TRUE;
    m_bAudioPilotAvailability = FALSE;
    m_bStagingAvailability = TRUE;
    m_bLoudnessAvailability = TRUE;
    m_bRoomEffectAvailability = TRUE;
    m_bAGCAvailability = FALSE;
    m_bFaderAvailability = TRUE;
    m_bMidRangeAvailability = TRUE;
    m_bSubWooferAvailability = FALSE;


    pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
}

/*******************************************************************************
 *
 * FUNCTION: SoundHandler::~SoundHandler()
 *
 * DESCRIPTION: Destructor.
 *
 *              Invalidate static self reference.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
SoundHandler::~SoundHandler()
{
    //SoundHandler::m_poSoundHandler = 0;
    return;
}

#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
//ToDo: currently no sink specific ranges
tS16 SoundHandler::getMappedBassValue(tS16 hmiVal, am_Error_e& error)
{
    if(    ((hmiVal + 9) >= 0)
            && ((hmiVal + 9) < sizeof(BassMappingTable)/sizeof(tS16)) )
    {
        ETG_TRACE_USR4(("mapped bass value %d",BassMappingTable[hmiVal + 9]));
        error=E_OK;
        return BassMappingTable[hmiVal + 9];

    }
    else
    {
        error=E_OUT_OF_RANGE;
        ETG_TRACE_ERR(("getMappedBassValue out of range, value %d can not be mapped",hmiVal));
        return 0;
    }
}

tS16 SoundHandler::getMappedTrebleValue(tS16 hmiVal, am_Error_e& error)
{
    if(    ((hmiVal + 9) >= 0)
            && ((hmiVal + 9) < sizeof(TrebleMappingTable)/sizeof(tS16)) )
    {
        ETG_TRACE_USR4(("mapped treble %d",TrebleMappingTable[hmiVal + 9]));
        error=E_OK;
        return TrebleMappingTable[hmiVal + 9];
    }
    else
    {
        ETG_TRACE_ERR(("getMappedTrebleValue out of range, value %d can not be mapped",hmiVal));
        error=E_OUT_OF_RANGE;
        return 0;
    }
}
tS16 SoundHandler::getMappedBalanceValue(tS16 hmiVal, am_Error_e& error)
{
    if(    ((hmiVal + 9) >= 0)
            && ((hmiVal + 9) < sizeof(BalanceMappingTable)/sizeof(tS16)) )
    {
        ETG_TRACE_USR4(("mapped balance %d",BalanceMappingTable[hmiVal + 9]));
        error=E_OK;
        return BalanceMappingTable[hmiVal + 9];
    }
    else
    {
        ETG_TRACE_ERR(("getMappedBalanceValue out of range, value %d can not be mapped",hmiVal));
        error=E_OUT_OF_RANGE;
        return 0;
    }
}
tS16 SoundHandler::getMappedFaderValue(tS16 hmiVal, am_Error_e& error)
{
    if(    ((hmiVal + 9) >= 0)
            && ((hmiVal + 9) < sizeof(FaderMappingTable)/sizeof(tS16)) )
    {
        ETG_TRACE_USR4(("mapped balance %d",FaderMappingTable[hmiVal + 9]));
        error=E_OK;
        return FaderMappingTable[hmiVal + 9];
    }
    else
    {
        ETG_TRACE_ERR(("getMappedFaderValue out of range, value %d can not be mapped",hmiVal));
        error=E_OUT_OF_RANGE;
        return 0;
    }
}
#else
tS16 SoundHandler::getMappedBassValue(tS16 hmiVal, am_Error_e& error)
{
    error=E_OK;
    return hmiVal;
}
tS16 SoundHandler::getMappedTrebleValue(tS16 hmiVal, am_Error_e& error)
{
    error=E_OK;
    return hmiVal;
}
tS16 SoundHandler::getMappedBalanceValue(tS16 hmiVal, am_Error_e& error)
{
    error=E_OK;
    return hmiVal;
}
#endif

/********************************************************************************
 * vCheckMidRangeAvailablility().
 *******************************************************************************/
tVoid SoundHandler::vCheckSWAvailabilility()
{
    ETG_TRACE_USR4(("SoundHandler vCheckSWAvailabilility () entered, no action"));

}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid SoundHandler::vInit()const
{
    ETG_TRACE_USR4(("SoundHandler vInit() entered."));
    return;
}

tVoid SoundHandler::vOnLoadSettings(tU16 u16FunctionId)
{
    ETG_TRACE_USR4(("Overloaded vOnLoadSettings no action for u16FunctionId %d",u16FunctionId));

}

tVoid SoundHandler::vOnLoadSettings()
{
    ETG_TRACE_USR4(("SoundHandler entered."));
    //  FILE* dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
    //  fprintf (dbg_write_ptr, "Controller: SoundHandler::vOnLoadSettings \n");
    //  fclose(dbg_write_ptr);

    tS32 s32Res = 0;

#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
    DP_vCreateDatapool();
#endif

    vCheckSWAvailabilility();
    // Here we load from Persistent Manager
    vLoadSingleUsrDP();

    //Load first number of defined sinks
    tU8 u8Sinks=0;
    if(pAudUsrDpIf)
    {
        s32Res = pAudUsrDpIf->s32GetNumberOfSinks(u8Sinks);
    }
    if(u8Sinks != Number_of_Sinks)
    {
        ETG_TRACE_ERR(("SoundHandler mismatch check Number_of_Sinks (%d) and datapool definitons Number_of_Sinks (%d)",Number_of_Sinks,u8Sinks));
    }

    //  dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
    //  fprintf (dbg_write_ptr, "Controller: SoundHandler::vOnLoadSettings number of Sinks %d\n",u8Sinks);
    //  fclose(dbg_write_ptr);

    //dp_tclAudioStackDPAuxInLevel oAuxInLevel;
    dp_tclAudioStackMultiUsrDPAuxInLevel oAuxInLevel;

    s32Res = oAuxInLevel.s32GetData(m_u8AuxIn,(tU32)sizeof(m_u8AuxIn));
    if((s32Res != sizeof(m_u8AuxIn)) || (sizeof(m_u8AuxIn) != Number_of_Sinks))
    {
        //error
    }

    //Get all minimum and maximum value and property value of all sound properties
    //Bass
    tS32 s32Res1=0;
    tS32 s32Res2=0;
    tS32 s32Res3=0;
    if(pAudUsrDpIf)
    {
        s32Res1 = pAudUsrDpIf->s32GetBassMax(m_s8MaxBass,sizeof(m_s8MaxBass));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxBass[]=%d, %d, ...,  Result=%d",
                (tS16)m_s8MaxBass[0],(tS16)m_s8MaxBass[1],s32Res1));

        s32Res2 = pAudUsrDpIf->s32GetBassMin(m_s8MinBass,sizeof(m_s8MinBass));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinBass[]=%d, %d, ...,  Result=%d",(tS16)m_s8MinBass[0],(tS16)m_s8MinBass[1],s32Res2));

        s32Res3 = pAudUsrDpIf->s32GetBass(m_s8Bass,sizeof(m_s8Bass));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8Bass[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8Bass);i++)
        {
            ETG_TRACE_USR4(("m_s8Bass[%d]=%d",i,(tS16)m_s8Bass[i]));
        }

        //MixBass mic 1
        s32Res3 = pAudUsrDpIf->s32GetMixBass(m_s8MixBassMic1,sizeof(m_s8MixBassMic1),1);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MixBassMic1[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8MixBassMic1);i++)
        {
            ETG_TRACE_USR4(("m_s8MixBassMic1[%d]=%d",i,(tS16)m_s8MixBassMic1[i]));
        }
        //MixBass mic 2
        s32Res3 = pAudUsrDpIf->s32GetMixBass(m_s8MixBassMic2,sizeof(m_s8MixBassMic2),2);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MixBassMic2[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8MixBassMic2);i++)
        {
            ETG_TRACE_USR4(("m_s8MixBassMic2[%d]=%d",i,(tS16)m_s8MixBassMic2[i]));
        }
        //MixBass mic 3
        s32Res3 = pAudUsrDpIf->s32GetMixBass(m_s8MixBassMic3,sizeof(m_s8MixBassMic3),3);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MixBassMic3[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8MixBassMic3);i++)
        {
            ETG_TRACE_USR4(("m_s8MixBassMic3[%d]=%d",i,(tS16)m_s8MixBassMic3[i]));
        }
    }

    //Treble
    if(pAudUsrDpIf)
    {
        s32Res1 = pAudUsrDpIf->s32GetTrebleMax(m_s8MaxTreble,sizeof(m_s8MaxTreble));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxTreble[]=%d, %d, ...,  Result=%d",(tS16)m_s8MaxTreble[0],(tS16)m_s8MaxTreble[1],s32Res1));

        s32Res2 = pAudUsrDpIf->s32GetTrebleMin(m_s8MinTreble,sizeof(m_s8MinTreble));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinTreble[]=%d ...,  Result=%d",(tS16)m_s8MinTreble[0],s32Res2));

        s32Res3 = pAudUsrDpIf->s32GetTreble(m_s8Treble,sizeof(m_s8Treble));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8Treble[] Result=%d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8Treble);i++)
        {
            ETG_TRACE_USR4(("m_s8Treble[%d]=%d",i,(tS16)m_s8Treble[i]));
        }

        //MixTreble mic 1
        s32Res3 = pAudUsrDpIf->s32GetMixTreble(m_s8MixTrebleMic1,sizeof(m_s8MixTrebleMic1),1);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MixBassMic1[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8MixTrebleMic1);i++)
        {
            ETG_TRACE_USR4(("m_s8MixTrebleMic1[%d]=%d",i,(tS16)m_s8MixTrebleMic1[i]));
        }
        //MixTreble mic 2
        s32Res3 = pAudUsrDpIf->s32GetMixTreble(m_s8MixTrebleMic2,sizeof(m_s8MixTrebleMic2),2);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MixTrebleMic2[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8MixTrebleMic2);i++)
        {
            ETG_TRACE_USR4(("m_s8MixTrebleMic2[%d]=%d",i,(tS16)m_s8MixTrebleMic2[i]));
        }
        //MixTreble mic 3
        s32Res3 = pAudUsrDpIf->s32GetMixTreble(m_s8MixTrebleMic3,sizeof(m_s8MixTrebleMic3),3);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MixTrebleMic3[] Result %d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8MixTrebleMic3);i++)
        {
            ETG_TRACE_USR4(("m_s8MixTrebleMic3[%d]=%d",i,(tS16)m_s8MixTrebleMic3[i]));
        }
    }

    //Fader
    if(pAudUsrDpIf)
    {
        s32Res1 = pAudUsrDpIf->s32GetFaderMax(m_s8MaxFader,(tU8)sizeof(m_s8MaxFader));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxFader[]=%d, %d ...,  Result=%d",(tS16)m_s8MaxFader[0],(tS16)m_s8MaxFader[1],s32Res1));

        s32Res2 = pAudUsrDpIf->s32GetFaderMin(m_s8MinFader,(tU8)sizeof(m_s8MinFader));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinFader[]=%d ...,  Result=%d",(tS16)m_s8MinFader[0],s32Res2));

        s32Res3 = pAudUsrDpIf->s32GetFader(m_s8Fader,(tU8)sizeof(m_s8Fader));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8Fader[] Result=%d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8Fader);i++)
        {
            ETG_TRACE_USR4(("m_s8Fader[%d]=%d",i,(tS16)m_s8Fader[i]));
        }
    }

    //Balance
    if(pAudUsrDpIf)
    {
        s32Res1 = pAudUsrDpIf->s32GetBalanceMax(m_s8MaxBalance,(tU8)sizeof(m_s8MaxBalance));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxBalance[]=%d, %d ...,  Result=%d",(tS16)m_s8MaxBalance[0],(tS16)m_s8MaxBalance[1],s32Res1));

        s32Res2 = pAudUsrDpIf->s32GetBalanceMin(m_s8MinBalance,(tU8)sizeof(m_s8MinBalance));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinBalance[]=%d ...,  Result=%d",(tS16)m_s8MinBalance[0],s32Res2));

        s32Res3 = pAudUsrDpIf->s32GetBalance(m_s8Balance,(tU8)sizeof(m_s8Balance));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8Balance[] Result=%d",s32Res3));
        for(unsigned int i=0;i<sizeof(m_s8Balance);i++)
        {
            ETG_TRACE_USR4(("m_s8Balance[%d]=%d",i,(tS16)m_s8Balance[i]));
        }
    }

    return;
}



tBool SoundHandler::bGetBass(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("bGetBass() for sinkID %d",set.sinkID));
    if((set.mainSoundProperty.type == MSP_SOUND_BASS) && (set.sinkID < Number_of_Sinks))
    {
        ETG_TRACE_USR4(("gives %d",m_s8Bass[set.sinkID]));
        set.mainSoundProperty.value = m_s8Bass[set.sinkID];
        return true;
    }
    ETG_TRACE_USR4(("NOK"));
    return false;
}

#if 0
tBool SoundHandler::bGetMixBass(rMainSinkSoundPropertySet &set, unsigned char mic)
{
    ETG_TRACE_USR4(("bGetMixBass() for sinkID %d and mic %d",set.sinkID,mic));
    if((set.mainSoundProperty.type == MSP_AVB_MIX_BASS) && (set.sinkID < Number_of_Sinks))
    {
        ETG_TRACE_USR4(("gives %d",m_s8MixBassMic1[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixBassMic1[set.sinkID];
        return true;
    }
    ETG_TRACE_USR4(("NOK"));
    return false;
}
#endif

tBool SoundHandler::bSetBass(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("bSetBass() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle, set.mainSoundProperty.value));

    //      FILE* dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
    //      fprintf (dbg_write_ptr, "Controller: SoundHandler::bSetBass sinkID %d, value (%d) m_s8Bass %d, m_s8MaxBass %d, m_s8MinBass %d \n",
    //          set.sinkID, set.mainSoundProperty.value, m_s8Bass[set.sinkID], m_s8MaxBass[set.sinkID], m_s8MinBass[set.sinkID]);
    //      fclose(dbg_write_ptr);

    tBool bResult =false;
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_SOUND_BASS_RELATIVE)
    {
        tS32 s32TempBass = m_s8Bass[set.sinkID];
        s32TempBass = s32TempBass + set.mainSoundProperty.value;
        if(s32TempBass > m_s8MaxBass[set.sinkID]) m_s8Bass[set.sinkID]= m_s8MaxBass[set.sinkID]; //Limit to max
        else if(s32TempBass < m_s8MinBass[set.sinkID]) m_s8Bass[set.sinkID]= m_s8MinBass[set.sinkID]; //Limit to min
        else m_s8Bass[set.sinkID] = (tS8)s32TempBass; // Take over value in range

        //      dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
        //       fprintf (dbg_write_ptr, "Controller: SoundHandler::bSetBass (%d) m_s8Bass %d MSP_SOUND_BASS_RELATIVE \n",
        //                set.mainSoundProperty.value, m_s8Bass[set.sinkID]);
        //      fclose(dbg_write_ptr);
    }
    //ABS
    else if(set.mainSoundProperty.type == MSP_SOUND_BASS)
    {
        if(set.mainSoundProperty.value > m_s8MaxBass[set.sinkID]) m_s8Bass[set.sinkID]= m_s8MaxBass[set.sinkID]; //Limit to max
        else if(set.mainSoundProperty.value < m_s8MinBass[set.sinkID]) m_s8Bass[set.sinkID]= m_s8MinBass[set.sinkID]; //Limit to max
        else m_s8Bass[set.sinkID] = (tS8)set.mainSoundProperty.value; // Take over value in range

        //        dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
        //        fprintf (dbg_write_ptr, "Controller: SoundHandler::bSetBass sinkID %d, value (%d) m_s8Bass %d MSP_SOUND_BASS \n",
        //                set.sinkID, set.mainSoundProperty.value, m_s8Bass[set.sinkID]);
        //       fclose(dbg_write_ptr);

    }
    else
    {
        //called with wrong property
        ETG_TRACE_ERR(("bSetBass() called with wrong property"));
        return bResult;
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendBassPOMsg(set.sinkID);
    ETG_TRACE_USR4(("Updating Bass mainSoundProperty to %d",m_s8Bass[set.sinkID]));

    set.mainSoundProperty.value = m_s8Bass[set.sinkID];

    return bResult;
}



tBool SoundHandler::bSetMixBass(rMainSinkSoundPropertySet &set, unsigned char mic)
{
    ETG_TRACE_USR4(("bSetMixBass() sinkID %d, handle=(%d,%d), value=%d, for mic %d",
            set.sinkID, set.handle.handleType, set.handle.handle, set.mainSoundProperty.value,mic));
    ETG_TRACE_USR4(("Property type %d, value %d",set.mainSoundProperty.type, set.mainSoundProperty.value));

    //ToDo: for which Mic: 1,2,3 we maintain separate members, currently only for Mic1

    tBool bResult =false;
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_AVB_MIX_BASS)
    {
        if(mic==1)
        {
            ETG_TRACE_USR4(("m_s8MixBassMic1[%d] = %d",set.sinkID,m_s8MixBassMic1[set.sinkID]));

            tS32 s32TempBass = m_s8MixBassMic1[set.sinkID];
            s32TempBass = s32TempBass + set.mainSoundProperty.value;

            ETG_TRACE_USR4(("s32TempBass = %d",s32TempBass));

            if(s32TempBass > m_s8MaxBass[set.sinkID]) m_s8MixBassMic1[set.sinkID]= m_s8MaxBass[set.sinkID]; //Limit to max
            else if(s32TempBass < m_s8MinBass[set.sinkID]) m_s8MixBassMic1[set.sinkID]= m_s8MinBass[set.sinkID]; //Limit to min
            else m_s8MixBassMic1[set.sinkID] = (tS8)s32TempBass; // Take over value in range

            ETG_TRACE_USR4(("m_s8MixBassMic1[%d] = %d",set.sinkID,m_s8MixBassMic1[set.sinkID]));
        }
        else if(mic==2)
        {
            ETG_TRACE_USR4(("m_s8MixBassMic2[%d] = %d",set.sinkID,m_s8MixBassMic2[set.sinkID]));

            tS32 s32TempBass = m_s8MixBassMic2[set.sinkID];
            s32TempBass = s32TempBass + set.mainSoundProperty.value;

            ETG_TRACE_USR4(("s32TempBass = %d",s32TempBass));

            if(s32TempBass > m_s8MaxBass[set.sinkID]) m_s8MixBassMic2[set.sinkID]= m_s8MaxBass[set.sinkID]; //Limit to max
            else if(s32TempBass < m_s8MinBass[set.sinkID]) m_s8MixBassMic2[set.sinkID]= m_s8MinBass[set.sinkID]; //Limit to min
            else m_s8MixBassMic2[set.sinkID] = (tS8)s32TempBass; // Take over value in range

            ETG_TRACE_USR4(("m_s8MixBassMic2[%d] = %d",set.sinkID,m_s8MixBassMic2[set.sinkID]));
        }
        else if(mic==3)
        {
            ETG_TRACE_USR4(("m_s8MixBassMic3[%d] = %d",set.sinkID,m_s8MixBassMic3[set.sinkID]));

            tS32 s32TempBass = m_s8MixBassMic3[set.sinkID];
            s32TempBass = s32TempBass + set.mainSoundProperty.value;

            ETG_TRACE_USR4(("s32TempBass = %d",s32TempBass));

            if(s32TempBass > m_s8MaxBass[set.sinkID]) m_s8MixBassMic3[set.sinkID]= m_s8MaxBass[set.sinkID]; //Limit to max
            else if(s32TempBass < m_s8MinBass[set.sinkID]) m_s8MixBassMic3[set.sinkID]= m_s8MinBass[set.sinkID]; //Limit to min
            else m_s8MixBassMic3[set.sinkID] = (tS8)s32TempBass; // Take over value in range

            ETG_TRACE_USR4(("m_s8MixBassMic3[%d] = %d",set.sinkID,m_s8MixBassMic3[set.sinkID]));
        }
    }
    else
    {
        //called with wrong property
        ETG_TRACE_ERR(("bSetMixBass() called with wrong property %d",set.mainSoundProperty.type));
        return bResult;
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendMixBassPOMsg(set.sinkID,mic);


    //write back value
    if(mic==1)
    {
        ETG_TRACE_USR4(("Updating Mix Bass mainSoundProperty for mic %d to %d",mic,m_s8MixBassMic1[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixBassMic1[set.sinkID];
    }
    else if(mic==2)
    {
        ETG_TRACE_USR4(("Updating Mix Bass mainSoundProperty for mic %d to %d",mic,m_s8MixBassMic2[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixBassMic2[set.sinkID];
    }
    else if(mic==3)
    {
        ETG_TRACE_USR4(("Updating Mix Bass mainSoundProperty for mic %d to %d",mic,m_s8MixBassMic3[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixBassMic3[set.sinkID];
    }
    return bResult;
}

tBool SoundHandler::bGetBalance(rMainSinkSoundPropertySet &set)
{
    if((set.mainSoundProperty.type == MSP_SOUND_BALANCE) && (set.sinkID < (am_sinkID_t)Number_of_Sinks))
    {
        set.mainSoundProperty.value = (int16_t)m_s8Balance[set.sinkID];
        return true;
    }
    return false;
}

tBool SoundHandler::bSetBalance(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("bSetBalance() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));

    tBool bResult =false;
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_SOUND_BALANCE_RELATIVE)
    {
        tS32 s32TempBalance = m_s8Balance[set.sinkID];
        s32TempBalance = s32TempBalance + set.mainSoundProperty.value;
        if(s32TempBalance > m_s8MaxBalance[set.sinkID]) m_s8Balance[set.sinkID]= m_s8MaxBalance[set.sinkID]; //Limit to max
        else if(s32TempBalance < m_s8MinBalance[set.sinkID]) m_s8Balance[set.sinkID]= m_s8MinBalance[set.sinkID]; //Limit to min
        else m_s8Balance[set.sinkID] = (tS8)s32TempBalance; // Take over value in range
    }
    //ABS
    else if(set.mainSoundProperty.type == MSP_SOUND_BALANCE)
    {
        if(set.mainSoundProperty.value > m_s8MaxBalance[set.sinkID]) m_s8Balance[set.sinkID]= m_s8MaxBalance[set.sinkID]; //Limit to max
        else if(set.mainSoundProperty.value < m_s8MinBalance[set.sinkID]) m_s8Balance[set.sinkID]= m_s8MinBalance[set.sinkID]; //Limit to max
        else m_s8Balance[set.sinkID] = (tS8)set.mainSoundProperty.value; // Take over value in range
    }
    else
    {
        //called with wrong property
        ETG_TRACE_ERR(("bSetBalance() called with wrong property"));
        return bResult;
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendBalancePOMsg(set.sinkID);
    ETG_TRACE_USR4(("Updating Balance mainSoundProperty to %d",m_s8Balance[set.sinkID]));

    set.mainSoundProperty.value = m_s8Balance[set.sinkID];

    return bResult;

}

tBool SoundHandler::bGetTreble(rMainSinkSoundPropertySet &set)
{
    if((set.mainSoundProperty.type == MSP_SOUND_TREBLE) && (set.sinkID < Number_of_Sinks))
    {
        set.mainSoundProperty.value = m_s8Treble[set.sinkID];
        return true;
    }
    return false;
}

tBool SoundHandler::bSetTreble(rMainSinkSoundPropertySet &set)
{
    tBool bResult = false;
    ETG_TRACE_USR4(("bSetTreble() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_SOUND_TREBLE_RELATIVE)
    {
        tS32 s32TempTreble = m_s8Treble[set.sinkID];
        s32TempTreble = s32TempTreble + set.mainSoundProperty.value;
        if(s32TempTreble > m_s8MaxTreble[set.sinkID]) m_s8Treble[set.sinkID]= m_s8MaxTreble[set.sinkID]; //Limit to max
        else if(s32TempTreble < m_s8MinTreble[set.sinkID]) m_s8Treble[set.sinkID]= m_s8MinTreble[set.sinkID]; //Limit to min
        else m_s8Treble[set.sinkID] = (tS8)s32TempTreble; // Take over value in range
    }
    //ABS
    else if(set.mainSoundProperty.type == MSP_SOUND_TREBLE)
    {
        if(set.mainSoundProperty.value > m_s8MaxTreble[set.sinkID]) m_s8Treble[set.sinkID]= m_s8MaxTreble[set.sinkID]; //Limit to max
        else if(set.mainSoundProperty.value < m_s8MinTreble[set.sinkID]) m_s8Treble[set.sinkID]= m_s8MinTreble[set.sinkID]; //Limit to min
        else m_s8Treble[set.sinkID] = (tS8)set.mainSoundProperty.value; // Take over value in range
    }
    else
    {
        //called with wrong property
        ETG_TRACE_ERR(("bSetTreble() called with wrong property"));
        return bResult;
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendTreblePOMsg(set.sinkID);
    ETG_TRACE_USR4(("Updating Treble mainSoundProperty to %d",m_s8Treble[set.sinkID]));

    set.mainSoundProperty.value = m_s8Treble[set.sinkID];

    return bResult;
}

tBool SoundHandler::bSetMixTreble(rMainSinkSoundPropertySet &set, unsigned char mic)
{
    ETG_TRACE_USR4(("bSetMixTreble() sinkID %d, handle=(%d,%d), value=%d, for mic %d",
            set.sinkID, set.handle.handleType, set.handle.handle, set.mainSoundProperty.value,mic));
    ETG_TRACE_USR4(("Property type %d, value %d",set.mainSoundProperty.type, set.mainSoundProperty.value));

    //ToDo: for which Mic: 1,2,3 we maintain separate members, currently only for Mic1

    tBool bResult =false;
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_AVB_MIX_TREBLE)
    {
        if(mic==1)
        {
            ETG_TRACE_USR4(("m_s8MixTrebleMic1[%d] = %d",set.sinkID,m_s8MixTrebleMic1[set.sinkID]));

            tS32 s32TempTreble = m_s8MixTrebleMic1[set.sinkID];
            s32TempTreble = s32TempTreble + set.mainSoundProperty.value;

            ETG_TRACE_USR4(("s32TempTreble = %d",s32TempTreble));

            if(s32TempTreble > m_s8MaxTreble[set.sinkID]) m_s8MixTrebleMic1[set.sinkID]= m_s8MaxTreble[set.sinkID]; //Limit to max
            else if(s32TempTreble < m_s8MinTreble[set.sinkID]) m_s8MixTrebleMic1[set.sinkID]= m_s8MinTreble[set.sinkID]; //Limit to min
            else m_s8MixTrebleMic1[set.sinkID] = (tS8)s32TempTreble; // Take over value in range

            ETG_TRACE_USR4(("m_s8MixTrebleMic1[%d] = %d",set.sinkID,m_s8MixTrebleMic1[set.sinkID]));
        }
        else if(mic==2)
        {
            ETG_TRACE_USR4(("m_s8MixTrebleMic2[%d] = %d",set.sinkID,m_s8MixTrebleMic2[set.sinkID]));

            tS32 s32TempTreble = m_s8MixTrebleMic2[set.sinkID];
            s32TempTreble = s32TempTreble + set.mainSoundProperty.value;

            ETG_TRACE_USR4(("s32TempTreble = %d",s32TempTreble));

            if(s32TempTreble > m_s8MaxTreble[set.sinkID]) m_s8MixTrebleMic2[set.sinkID]= m_s8MaxTreble[set.sinkID]; //Limit to max
            else if(s32TempTreble < m_s8MinTreble[set.sinkID]) m_s8MixTrebleMic2[set.sinkID]= m_s8MinTreble[set.sinkID]; //Limit to min
            else m_s8MixTrebleMic2[set.sinkID] = (tS8)s32TempTreble; // Take over value in range

            ETG_TRACE_USR4(("m_s8MixTrebleMic2[%d] = %d",set.sinkID,m_s8MixTrebleMic2[set.sinkID]));
        }
        else if(mic==3)
        {
            ETG_TRACE_USR4(("m_s8MixTrebleMic3[%d] = %d",set.sinkID,m_s8MixTrebleMic3[set.sinkID]));

            tS32 s32TempTreble = m_s8MixTrebleMic3[set.sinkID];
            s32TempTreble = s32TempTreble + set.mainSoundProperty.value;

            ETG_TRACE_USR4(("s32TempTreble = %d",s32TempTreble));

            if(s32TempTreble > m_s8MaxTreble[set.sinkID]) m_s8MixTrebleMic3[set.sinkID]= m_s8MaxTreble[set.sinkID]; //Limit to max
            else if(s32TempTreble < m_s8MinTreble[set.sinkID]) m_s8MixTrebleMic3[set.sinkID]= m_s8MinTreble[set.sinkID]; //Limit to min
            else m_s8MixTrebleMic3[set.sinkID] = (tS8)s32TempTreble; // Take over value in range

            ETG_TRACE_USR4(("m_s8MixTrebleMic3[%d] = %d",set.sinkID,m_s8MixTrebleMic3[set.sinkID]));
        }
    }
    else
    {
        //called with wrong property
        ETG_TRACE_ERR(("bSetMixTreble() called with wrong property %d",set.mainSoundProperty.type));
        return bResult;
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendMixTreblePOMsg(set.sinkID,mic);


    //write back value
    if(mic==1)
    {
        ETG_TRACE_USR4(("Updating Mix Treble mainSoundProperty for mic %d to %d",mic,m_s8MixTrebleMic1[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixTrebleMic1[set.sinkID];
    }
    else if(mic==2)
    {
        ETG_TRACE_USR4(("Updating Mix Treble mainSoundProperty for mic %d to %d",mic,m_s8MixTrebleMic2[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixTrebleMic2[set.sinkID];
    }
    else if(mic==3)
    {
        ETG_TRACE_USR4(("Updating Mix Treble mainSoundProperty for mic %d to %d",mic,m_s8MixTrebleMic3[set.sinkID]));
        set.mainSoundProperty.value = m_s8MixTrebleMic3[set.sinkID];
    }
    return bResult;
}

tBool SoundHandler::bGetFader(rMainSinkSoundPropertySet &set)
{
    if((set.mainSoundProperty.type == MSP_SOUND_FADER) && (set.sinkID < Number_of_Sinks))
    {
        set.mainSoundProperty.value = m_s8Fader[set.sinkID];
        return true;
    }
    return false;
}
tBool SoundHandler::bSetFader(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("bSetFader() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));

    tBool bResult =false;
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_SOUND_FADER_RELATIVE)
    {
        tS32 s32TempFader = m_s8Fader[set.sinkID];
        s32TempFader = s32TempFader + set.mainSoundProperty.value;
        if(s32TempFader > m_s8MaxFader[set.sinkID]) m_s8Fader[set.sinkID]= m_s8MaxFader[set.sinkID]; //Limit to max
        else if(s32TempFader < m_s8MinFader[set.sinkID]) m_s8Fader[set.sinkID]= m_s8MinFader[set.sinkID]; //Limit to min
        else m_s8Fader[set.sinkID] = (tS8)s32TempFader; // Take over value in range
    }
    //ABS
    else if(set.mainSoundProperty.type == MSP_SOUND_FADER)
    {
        if(set.mainSoundProperty.value > m_s8MaxFader[set.sinkID]) m_s8Fader[set.sinkID]= m_s8MaxFader[set.sinkID]; //Limit to max
        else if(set.mainSoundProperty.value < m_s8MinFader[set.sinkID]) m_s8Fader[set.sinkID]= m_s8MinFader[set.sinkID]; //Limit to min
        else m_s8Fader[set.sinkID] = (tS8)set.mainSoundProperty.value; // Take over value in range
    }
    else
    {
        //called with wrong property
        ETG_TRACE_ERR(("bSetFader() called with wrong property"));
        return bResult;
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendFaderPOMsg(set.sinkID);
    ETG_TRACE_USR4(("Updating Fader mainSoundProperty to %d",m_s8Fader[set.sinkID]));

    set.mainSoundProperty.value = m_s8Fader[set.sinkID];

    return bResult;
}

tBool SoundHandler::bSetMidRange(rMainSinkSoundPropertySet &set)
{

    tBool bResult = false;
    ETG_TRACE_USR4(("SoundHandler vSetMidRange() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_SOUND_MIDDLE_RELATIVE)
    {
        tS32 s32TempMidRange = m_s8MidRange[set.sinkID];
        s32TempMidRange = s32TempMidRange + set.mainSoundProperty.value;
        if(s32TempMidRange > m_s8MaxMidRange[set.sinkID]) m_s8MidRange[set.sinkID]= m_s8MaxMidRange[set.sinkID]; //Limit to max
        else if(s32TempMidRange < m_s8MinMidRange[set.sinkID]) m_s8MidRange[set.sinkID]= m_s8MinMidRange[set.sinkID]; //Limit to min
        else m_s8MidRange[set.sinkID] = (tS8)s32TempMidRange; // Take over value in range
    }
    //ABS
    else if(set.mainSoundProperty.type == MSP_SOUND_MIDDLE)
    {
        if(set.mainSoundProperty.value > m_s8MaxMidRange[set.sinkID]) m_s8MidRange[set.sinkID]= m_s8MaxMidRange[set.sinkID]; //Limit to max
        else if(set.mainSoundProperty.value < m_s8MinMidRange[set.sinkID]) m_s8MidRange[set.sinkID]= m_s8MinMidRange[set.sinkID]; //Limit to min
        else m_s8MidRange[set.sinkID] = (tS8)set.mainSoundProperty.value; // Take over value in range
    }
    else
    {
        //called with wrong property
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    bResult = bStoreAndSendMidRangePOMsg(set.sinkID);

    return bResult;

}
tBool SoundHandler::bSetGala(rMainSinkSoundPropertySet &set)
{
    (void)set;
#if 0
    ETG_TRACE_USR4(("bSetGala() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));
    // only ABS ??
    if(set.mainSoundProperty.type == MSP_GALA_GAIN)
    {
        if(set.mainSoundProperty.value > m_s8MaxGala[set.sinkID]) m_u8Gala[set.sinkID]= m_s8MaxGala[set.sinkID]; //Limit to max
        else m_u8Gala[set.sinkID] = (tU8)set.mainSoundProperty.value; // Take over value in range
    }
    else
    {
        //called with wrong property
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    return bStoreAndSendGalaPOMsg(sinkID);
#endif
    return true;
}

tBool SoundHandler::bStoreAndSendGalaPOMsg(tU16 sinkID)
{
    (void)sinkID;
#if 0
    if(m_bAudioPilotAvailability == TRUE && m_u8Gala[sinkID] != 0)
        m_u8Gala[sinkID] = 1;
    else if(vCheckPropertyAvailablility((tS8&)m_u8Gala[sinkID],m_bSDVCAvailability) == TRUE)
        ETG_TRACE_USR4(("Gala available"));
    //store persistent
    if(m_bAudioPilotAvailability == TRUE || m_bSDVCAvailability == TRUE)
    {
        tS32 s32Res=0;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
        dp_tclAudioManagerDPPSA_Gala oGala;
#else
        dp_tclAudioManagerDPGala oGala;
#endif
        tU8 u8TmpGala[sizeof(m_u8Gala)];
        s32Res = oGala.s32GetData(u8TmpGala,sizeof(m_u8Gala));
        u8TmpGala[sinkID] = m_u8Gala[sinkID];
        s32Res = oGala.s32SetData(u8TmpGala,sizeof(m_u8Gala));
        (tVoid)s32Res;
        ETG_TRACE_USR4(("Persistent Memory storage Result for Gala = %x",s32Res));//to solve compiler error
    }

#endif
    return TRUE;
}



tBool SoundHandler::bSetAuxInLevel(rMainSinkSoundPropertySet &set)
{
    bPropertyChanged = (m_u8AuxIn[set.sinkID] != set.mainSoundProperty.value);
    m_u8AuxIn[set.sinkID] = (tU8)set.mainSoundProperty.value; // Take over value in range

    //store persistent
    tS32 s32Res=0;
    //dp_tclAudioStackDPAuxInLevel oAuxInLevel;
    dp_tclAudioStackMultiUsrDPAuxInLevel oAuxInLevel;

    tU8 u8TmpAuxIn[sizeof(m_u8AuxIn)];
    s32Res = oAuxInLevel.s32GetData(u8TmpAuxIn,(tU32)sizeof(m_u8AuxIn));
    u8TmpAuxIn[set.sinkID]=m_u8AuxIn[set.sinkID];
    s32Res = oAuxInLevel.s32SetData(u8TmpAuxIn,(tU32)sizeof(m_u8AuxIn));
    (tVoid)s32Res;

    ETG_TRACE_USR4(("Persistent Memory storage Result for oAuxInLevel = %x",s32Res));//to solve compiler error

    return TRUE;
}

tBool SoundHandler::bSetBeepLevel(rMainSinkSoundPropertySet  &set)
{
    (void)set;
    //    bPropertyChanged = (m_u8BeepLevel != set.mainSoundProperty.value);
    //    m_u8BeepLevel = set.mainSoundProperty.value;
    //
    //    vStoreBeepLevel(m_u8BeepLevel);
    return TRUE;
}




//tBool SoundHandler::bSetLoudness(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
tBool SoundHandler::bSetLoudness(rMainSinkSoundPropertySet &set)
{
    (void)set;
#if 0
    ETG_TRACE_USR4(("SoundHandler bSetLoudness() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));
    //for INC and DEC
    if(set.mainSoundProperty.type == MSP_SOUND_LOUDNESS_RELATIVE)
    {
        tS16 s16TempLoudness = m_u8Loudness[set.sinkID];
        s16TempLoudness = s16TempLoudness + set.mainSoundProperty.value;
        if(s16TempLoudness > m_s8MaxLoudness[set.sinkID]) m_u8Loudness[set.sinkID]= m_s8MaxLoudness[set.sinkID]; //Limit to max
        else if(s16TempLoudness < m_s8MinLoudness[set.sinkID]) m_u8Loudness[set.sinkID]= m_s8MinLoudness[set.sinkID]; //Limit to min
        else m_u8Loudness[set.sinkID] = (tU8)s16TempLoudness; // Take over value in range
    }
    //ABS
    else if(set.mainSoundProperty.type == MSP_SOUND_LOUDNESS)
    {
        if(set.mainSoundProperty.value > m_s8MinLoudness[set.sinkID]) m_u8Loudness[set.sinkID]= m_s8MaxLoudness[set.sinkID]; //Limit to max
        else if(set.mainSoundProperty.value < m_s8MinLoudness[set.sinkID]) m_u8Loudness[set.sinkID]= m_s8MinLoudness[set.sinkID]; //Limit to min
        else m_u8Loudness[set.sinkID] = (tU8)set.mainSoundProperty.value; // Take over value in range
    }
    else
    {
        //called with wrong property
    }

    //we do not send PO message anymore but we need to store in DP (multi sink !)
    return bStoreAndSendLoudnessPOMsg(set.sinkID);
#endif
    return TRUE;

}

tBool SoundHandler::bStoreAndSendLoudnessPOMsg(tU16 sinkID)
{
    (void)sinkID;
#if 0
    if(vCheckPropertyAvailablility((tS8&)m_u8Loudness[sinkID],m_bLoudnessAvailability))
    {
        //store persistent
        tS32 s32Res=0;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
        dp_tclAudioManagerDPLoudness_TEF oLoudness;
#else
        dp_tclAudioManagerDPLoudness oLoudness;
#endif

        tU8 u8TmpLoudness[sizeof(m_u8Loudness)];
        s32Res = oLoudness.s32GetData(u8TmpLoudness,sizeof(m_u8Loudness);
        u8TmpLoudness[sinkID] = m_u8Loudness[sinkID];
        s32Res = oLoudness.s32SetData(u8TmpLoudness,sizeof(m_u8Loudness));
        (tVoid)s32Res;
        ETG_TRACE_USR4(("Persistent Memory storage Result for Loudness = %x",s32Res));
    }

#endif
    return TRUE;
}

tBool SoundHandler::bSetDynamicCompression(rMainSinkSoundPropertySet &set)
{
    (void)set;
#if 0
    ETG_TRACE_USR4(("SoundHandler bSetDynamicCompression() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));


    bPropertyChanged = (m_u8DynCompression != (tU8)set.mainSoundProperty.value);
    m_u8DynCompression = (tU8)set.mainSoundProperty.value;

    if(set.mainSoundProperty.value > m_s8MaxDynCompression)
    {
        //u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
        return FALSE;
    }
    //store persistent
    tS32 s32Res=0;
    dp_tclAudioManagerDPDynCompression oDynaCompression;
    s32Res = oDynaCompression.s32SetData(m_u8DynCompression);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Dynamic Copmression = %x",s32Res));
#endif
    return TRUE;
}

tBool SoundHandler::bSetEquPreset(rMainSinkSoundPropertySet &set)
{
    (void)set;
#if 0
    ETG_TRACE_USR4(("SoundHandler bSetEquPreset() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle, set.mainSoundProperty.value));


    bPropertyChanged = (m_u8EquPreset != (tU8)set.mainSoundProperty.value);
    m_u8EquPreset = (tU8)set.mainSoundProperty.value;

    if(set.mainSoundProperty.value > m_s8MaxEquPreset)
    {
        //u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
        return FALSE; //was outcommented ???
    }

    vStoreAndSendEquPresetPOMsg(m_u8EquPreset);
#endif
    return TRUE;
}



tBool SoundHandler::bSetOptimization(rMainSinkSoundPropertySet &set)
{
    (void)set;
#if 0
    ETG_TRACE_USR4(("SoundHandler bSetOptimization() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));


    bPropertyChanged = (m_u8Optimization != (tU8)set.mainSoundProperty.value);
    m_u8Optimization = (tU8)set.mainSoundProperty.value;

    if(set.mainSoundProperty.value > m_s8MaxOptimization)
    {
        //u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
        return FALSE; //was outcommented ???
    }

    vStoreAndSendOptimizationPOMsg(m_u8Optimization);
#endif
    return TRUE;
}


tBool SoundHandler::bSetRearMuteStatus(rMainSinkSoundPropertySet &set)
{
    (void)set;
#if 0
    ETG_TRACE_USR4(("SoundHandler bSetRearMuteStatus() sinkID %d, handle=(%d,%d), value=%d",
            set.sinkID, set.handle.handleType, set.handle.handle,set.mainSoundProperty.value));


    bPropertyChanged = (m_u8RearMute != (tU8)set.mainSoundProperty.value);
    m_u8RearMute = (tU8)set.mainSoundProperty.value;
#endif
    return TRUE;
}

tBool SoundHandler::bProcessGeometry_mode()
{
#if 0
    switch(m_u8GeometryMode)
    {
    case midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_MANUAL://manual mode , fader and balance can be set by user
        ETG_TRACE_USR4((" received geometry mode to manual"));
        vLoadBalanceFaderSettings();
        break;
    case midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_CHILD_SLEEP://child sleep , fader to front position and balance to middle
        ETG_TRACE_USR4((" received geometry mode Value child sleep"));
        //set fader to front
        if(vCheckPropertyAvailablility(m_s8Fader,m_bFaderAvailability))
            m_s8Fader = FaderMax_Value;
        // balance is set to middle i.e,0
        m_s8Balance = 0; //generally it is 0 , but need to be defined if the value set is changed
        break;
    case midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_ALL_CAR:// fader and balance set to middle position
        ETG_TRACE_USR4((" received geometry mode Value All cars"));
        //set fader to middle i.e,0
        m_s8Fader = 0;
        // balance is set to middle i.e,0
        m_s8Balance = 0; //generally it is 0 , but need to be defined if the value set is changed
        break;

    default : // exit
        return FALSE;

    }
#endif
    return TRUE;
}

tBool SoundHandler::bSetGeometryModeStatus(rMainSinkSoundPropertySet &set)
{
    (void)set;
    return TRUE;
}

tBool SoundHandler::bSetRoomEffect(rMainSinkSoundPropertySet &set)
{
    (void)set;
    return true;
}

tBool SoundHandler::bStoreAndSendRoomEffectPOMsg(tS8)
{
    return TRUE;
}


tBool SoundHandler::bSetFMEnhancer(rMainSinkSoundPropertySet &set)
{
    (void)set;
    return TRUE;
}


tBool SoundHandler::bSetSubWoofer(rMainSinkSoundPropertySet &set)
{
    (void)set;
    return TRUE;
}

tBool SoundHandler::bSetAutomaticGainControl(rMainSinkSoundPropertySet &set)
{
    (void)set;
    return TRUE;
}


/********************************************************************************
 * vOnApplicationClose().
 *******************************************************************************/
tVoid SoundHandler::vOnApplicationClose()
{

    ETG_TRACE_USR4(("vOnApplicationClose() entered."));

    return;
}



#if 0
tVoid SoundHandler::vLoadBalanceFaderSettings()
{
    tS32 s32Res1=0,s32Res2=0;
    if(vCheckPropertyAvailablility(m_s8Fader,m_bFaderAvailability))
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_USR_DP
        dp_tclAudioManagerUsrDPFader_Multi oFader;
#else
        dp_tclAudioManagerDPFader oFader;
#endif
        s32Res1 = oFader.s32GetData(m_s8Fader);
    }
    if(vCheckPropertyAvailablility(m_s8Balance,m_bBalanceAvailability))
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_USR_DP
        dp_tclAudioManagerUsrDPBalance_Multi oBalance;
#else
        dp_tclAudioManagerDPBalance oBalance;
#endif
        s32Res2 = oBalance.s32GetData(m_s8Balance);
    }
    ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Fader=%d Result=%d",(tS16)m_s8Fader,s32Res1));
    ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Balance=%d Result=%d",(tS16)m_s8Balance,s32Res2));
}
#endif

tBool SoundHandler::bStoreAndSendBassPOMsg(tU16 sinkID)
{
    if(vCheckPropertyAvailablility(m_s8Bass[sinkID],m_bBassAvailability))
    {

        if(pAudUsrDpIf)
        {
            //tS32 s32Res = pAudUsrDpIf->s32SetBass(m_s8Bass[sinkID],sinkID);
            (void)pAudUsrDpIf->s32SetBass(m_s8Bass[sinkID],sinkID);

            ETG_TRACE_USR4(("Store ADR Bass value = %d for sink %d",m_s8Bass[sinkID],sinkID));
            return true;
        }
    }
    ETG_TRACE_ERR(("Could not store ADR Bass for sink %d",sinkID));
    return false;

}

// sinkID is a sinkIndex here
tBool SoundHandler::bStoreAndSendMixBassPOMsg(tU16 sinkID, unsigned char mic)
{
    tS8 s8Data = 0;

    if(mic==1)      s8Data=m_s8MixBassMic1[sinkID];
    else if(mic==2) s8Data=m_s8MixBassMic2[sinkID];
    else if(mic==3) s8Data=m_s8MixBassMic3[sinkID];
    else
    {
        ETG_TRACE_USR4(("bStoreAndSendMixBassPOMsg mic number %d out of range (max 3)",mic));
        return false;
    }
    ETG_TRACE_USR4(("bStoreAndSendMixBassPOMsg sink %d, mic %d, s8Data %d",sinkID,mic,s8Data));
    if(vCheckPropertyAvailablility(s8Data,m_bMixBassAvailability))
    {

        if(pAudUsrDpIf)
        {
            //tS32 s32Res = pAudUsrDpIf->s32SetBass(m_s8Bass[sinkID],sinkID);
            (void)pAudUsrDpIf->s32SetMixBass(s8Data,sinkID,mic);

            ETG_TRACE_USR4(("Stored Mix Bass value = %d for sink %d, mic %d",s8Data,sinkID,mic));
            return true;
        }
    }
    ETG_TRACE_ERR(("Could not store MixBassMic%d for sink %d",mic,sinkID));
    return false;

}



tBool SoundHandler::bStoreAndSendTreblePOMsg(tU16 sinkID)
{
    if(vCheckPropertyAvailablility(m_s8Treble[sinkID],m_bTrebleAvailability))
    {
        if(pAudUsrDpIf)
        {
            //tS32 s32Res = pAudUsrDpIf->s32SetTreble(m_s8Treble[sinkID],sinkID);
            (void)pAudUsrDpIf->s32SetTreble(m_s8Treble[sinkID],sinkID);
#if 0
            tS8 s8TmpTreble[Number_of_Sinks];
            tS32 s32Res = pAudUsrDpIf->s32GetTreble(s8TmpTreble,Number_of_Sinks);
            //change value for this sink
            s8TmpTreble[sinkID] = m_s8Treble[sinkID];
            //write back
            s32Res = pAudUsrDpIf->s32SetTreble(s8TmpTreble,Number_of_Sinks);
#endif
            ETG_TRACE_USR4(("Store ADR Treble value = %d for sink %d",m_s8Treble[sinkID],sinkID));
            return true;

        }
    }
    ETG_TRACE_ERR(("Could not store ADR Treble for sink = %d",sinkID));
    return false;

}

// sinkID is a sinkIndex here
tBool SoundHandler::bStoreAndSendMixTreblePOMsg(tU16 sinkID, unsigned char mic)
{
    tS8 s8Data = 0;

    if(mic==1)      s8Data=m_s8MixTrebleMic1[sinkID];
    else if(mic==2) s8Data=m_s8MixTrebleMic2[sinkID];
    else if(mic==3) s8Data=m_s8MixTrebleMic3[sinkID];
    else
    {
        ETG_TRACE_USR4(("bStoreAndSendMixTreblePOMsg mic number %d out of range (max 3)",mic));
        return false;
    }

    if(vCheckPropertyAvailablility(s8Data,m_bMixTrebleAvailability))
    {

        if(pAudUsrDpIf)
        {
            (void)pAudUsrDpIf->s32SetMixTreble(s8Data,sinkID,mic);

            ETG_TRACE_USR4(("Stored Mix Treble value = %d for sink %d, mic %d",s8Data,sinkID,mic));
            return true;
        }
    }
    ETG_TRACE_ERR(("Could not store MixTrebleMic%d for sink %d",mic,sinkID));
    return false;

}



tBool SoundHandler::bStoreAndSendBalancePOMsg(tU16 sinkID)
{
    //  FILE* dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
    //  fprintf (dbg_write_ptr, "Controller: SoundHandler::vStoreAndSendBalancePOMsg avail %d\n",
    //      vCheckPropertyAvailablility(m_s8Balance[sinkID],m_bBalanceAvailability));
    //  fclose(dbg_write_ptr);

    if(vCheckPropertyAvailablility(m_s8Balance[sinkID],m_bBalanceAvailability))
    {
        if(pAudUsrDpIf)
        {
            //tS32 s32Res = pAudUsrDpIf->s32SetBalance(m_s8Balance[sinkID],sinkID);
            (void)pAudUsrDpIf->s32SetBalance(m_s8Balance[sinkID],sinkID);

#if 0
            tS8 s8TmpBalance[Number_of_Sinks];
            tS32 s32Res = pAudUsrDpIf->s32GetBalance(s8TmpBalance,Number_of_Sinks);
            //change value for this sink
            s8TmpBalance[sinkID] = m_s8Balance[sinkID];
            //write back
            s32Res = pAudUsrDpIf->s32SetBalance(s8TmpBalance,Number_of_Sinks);
#endif
            ETG_TRACE_USR4(("Store ADR Balance value = %d for sink %d",m_s8Balance[sinkID],sinkID));
            return true;

        }
    }
    ETG_TRACE_ERR(("Could not store ADR Balance for sink %d",sinkID));
    return false;
}

tBool SoundHandler::bStoreAndSendFaderPOMsg(tU16 sinkID)
{
    //  FILE* dbg_write_ptr = fopen(LOGFILE_DBUS,"a");
    //  fprintf (dbg_write_ptr, "Controller: SoundHandler::vStoreAndSendFaderPOMsg avail %d\n",
    //      vCheckPropertyAvailablility(m_s8Fader[sinkID],m_bFaderAvailability));
    //  fclose(dbg_write_ptr);

    if(vCheckPropertyAvailablility(m_s8Fader[sinkID],m_bFaderAvailability))
    {
        if(pAudUsrDpIf)
        {
            //tS32 s32Res = pAudUsrDpIf->s32SetFader(m_s8Fader[sinkID],sinkID);
            (void) pAudUsrDpIf->s32SetFader(m_s8Fader[sinkID],sinkID);

#if 0
            tS8 s8TmpFader[Number_of_Sinks];
            tS32 s32Res = pAudUsrDpIf->s32GetFader(s8TmpFader,Number_of_Sinks);
            //change value for this sink
            s8TmpFader[sinkID] = m_s8Fader[sinkID];
            //write back
            s32Res = pAudUsrDpIf->s32SetFader(s8TmpFader,Number_of_Sinks);
#endif
            ETG_TRACE_USR4(("Store ADR Fader value = %d for sink %d",m_s8Fader[sinkID],sinkID));
            return true;
        }
    }
    ETG_TRACE_ERR(("Could not store ADR Fader for sink %d",sinkID));
    return false;
}

tBool SoundHandler::bStoreAndSendMidRangePOMsg(tU16 sinkID)
{
    if(vCheckPropertyAvailablility(m_s8MidRange[sinkID],m_bMidRangeAvailability))
    {
        if(pAudUsrDpIf)
        {
            //tS32 s32Res = pAudUsrDpIf->s32SetMidRange(m_s8MidRange[sinkID],sinkID);
            (void)pAudUsrDpIf->s32SetMidRange(m_s8MidRange[sinkID],sinkID);
            ETG_TRACE_USR4(("Store ADR MidRange value = %d for sink %d",m_s8MidRange[sinkID],sinkID));
            return true;
        }
    }
    ETG_TRACE_ERR(("Could not store ADR MidRange for sink %d",sinkID));
    return false;
}

tVoid SoundHandler::vStoreBeepLevel(tU8)
{
    ;
}

tVoid SoundHandler::vStoreAndSendEquPresetPOMsg(tU8)
{
    ;
}

tVoid SoundHandler::vStoreAndSendOptimizationPOMsg(tU8)
{
    ;
}


tVoid SoundHandler::vLoadSingleUsrDP()
{
    tS32 s32Res = 0;
    if(pAudUsrDpIf == NULL) return;

    if(vCheckPropertyAvailablility(m_s8Treble[1],m_bTrebleAvailability))
    {

        pAudUsrDpIf->s32GetTreble(m_s8Treble,sizeof(m_s8Treble));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Treble Result=%d",s32Res));
    }

    if(vCheckPropertyAvailablility(m_s8Bass[1],m_bBassAvailability))
    {
        pAudUsrDpIf->s32GetTreble(m_s8Bass,sizeof(m_s8Bass));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Bass Result=%d",s32Res));
    }

    if(vCheckPropertyAvailablility(m_s8Fader[1],m_bFaderAvailability))
    {
        pAudUsrDpIf->s32GetFader(m_s8Fader,sizeof(m_s8Fader));
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Fader Result=%d",s32Res));
    }

    if(vCheckPropertyAvailablility(m_s8Balance[1],m_bBalanceAvailability))
    {
        pAudUsrDpIf->s32GetFader(m_s8Balance,sizeof(m_s8Balance));
    }
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Balance Result=%d",s32Res));
}


tBool SoundHandler::vCheckPropertyAvailablility(tS8& sPtyValue,tBool sPtyAvail)
{
    if(!sPtyAvail)
    {
        sPtyValue = 0;
        return FALSE;
    }
    return TRUE;
}

} //namespace

