/**
 *  Copyright (c) 2012 BMW
 *
 *  \author Christian Mueller, christian.ei.mueller@bmw.de BMW 2011,2012
 *
 *  \copyright
 *  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction,
 *  including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
 *  subject to the following conditions:
 *  The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 *  THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *  For further information see http://www.genivi.org/.
 */

#include "IAmControlReceiverShadow.h"
#include "IAmControl.h"
#include "CAmControlSenderBase.h"

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/IAmControlReceiverShadow.cpp.trc.h"
#endif
//#include "AudioStack/clStackRules.h"
//#include "AudioStack/clGeniviAudioCtrlAdapter.h"


namespace am
{

IAmControlReceiverShadow*  IAmControlReceiverShadow::mpIAmControlReceiverShadow = NULL;
CAmSocketHandler*          IAmControlReceiverShadow::mpCAmSocketHandler = NULL;

IAmControlReceiverShadow::IAmControlReceiverShadow(IAmControlReceive *iReceiveInterface, CAmSocketHandler *iSocketHandler) :
            m_cnt_inserted(0),
            m_cnt_removed(0),
            mpIAmControlReceiver(iReceiveInterface),
            enRequestType(REQUEST_UNKNOWN),
			mCAmSerializer(iSocketHandler),
            m_u8StatusReady(0),
            m_bRoutingReady(false),
            m_bControllerReady(false),
            m_bServiceReady_fcAudioMgr(false),
            m_bServiceReady_fcAudioRouteMgr(false),
            mListOpenConnections(0)
{
   ETG_TRACE_USR4(("IAmControlReceiverShadow::IAmControlReceiverShadow constructor called"));
  mpIAmControlReceiverShadow = this;
   mpCAmSocketHandler = iSocketHandler;
}

IAmControlReceiverShadow::~IAmControlReceiverShadow()
{
   ETG_TRACE_USR4(("IAmControlReceiverShadow::IAmControlReceiverShadow destructor called"));
   mpIAmControlReceiver = NULL;
   mpIAmControlReceiverShadow = NULL;
   mpCAmSocketHandler = NULL;
}

IAmControlReceiverShadow* IAmControlReceiverShadow::getInstance()
{
   ETG_TRACE_USR4(("IAmControlReceiverShadow::getInstance called"));
  return mpIAmControlReceiverShadow;
}

am_Error_e IAmControlReceiverShadow::getRoute(bool onlyfree, am_sourceID_t sourceID, am_sinkID_t sinkID, std::vector<am_Route_s> & returnList)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getRoute called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getRoute, error, onlyfree, sourceID, sinkID, returnList);
   //mCAmSerializer.syncCall<IAmControlReceive,am_Error_e, const am_sourceID_t, const am_sinkID_t, std::vector<am_Route_s> &, bool, am_sourceID_t, am_sinkID_t, std::vector<am_Route_s> >(mpIAmControlReceiver, &IAmControlReceive::getRoute, error, onlyfree, sourceID, sinkID, returnList);

    return (error);
}

am_Error_e IAmControlReceiverShadow::connect(am_Handle_s & handle, am_connectionID_t & connectionID, am_CustomConnectionFormat_t format, am_sourceID_t sourceID, am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::connect called"));
  am_Error_e error;
   // mCAmSerializer.syncCall<IAmControlReceive, am_Error_e, am_Handle_s &, am_connectionID_t &, const am_CustomConnectionFormat_t, const am_sourceID_t, const am_sinkID_t, am_Handle_s, am_connectionID_t, am_CustomConnectionFormat_t, am_sourceID_t, am_sinkID_t>(mpIAmControlReceiver, &IAmControlReceive::connect, error, handle, connectionID, format, sourceID, sinkID);
  mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::connect, error, handle, connectionID, format, sourceID, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::disconnect(am_Handle_s & handle, am_connectionID_t connectionID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::disconnect called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::disconnect, error, handle, connectionID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::crossfade(am_Handle_s & handle, am_HotSink_e hotSource, am_crossfaderID_t crossfaderID, am_CustomRampType_t rampType, am_time_t rampTime)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::crossfade called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::crossfade, error, handle, hotSource, crossfaderID, rampType, rampTime);
    return (error);
}

am_Error_e IAmControlReceiverShadow::abortAction(am_Handle_s handle)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::abortAction called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::abortAction, error, handle);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setSourceState(am_Handle_s & handle, am_sourceID_t sourceID, am_SourceState_e state)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSourceState called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSourceState, error, handle, sourceID, state);
    return (error);

}

am_Error_e IAmControlReceiverShadow::setSinkVolume(am_Handle_s & handle, am_sinkID_t sinkID, am_volume_t volume, am_CustomRampType_t ramp, am_time_t time)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSinkVolume called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSinkVolume, error, handle, sinkID, volume, ramp, time);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setSourceVolume(am_Handle_s & handle, am_sourceID_t sourceID, am_volume_t volume, am_CustomRampType_t rampType, am_time_t time)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSourceVolume called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSourceVolume, error, handle, sourceID, volume, rampType, time);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setSinkSoundProperties(am_Handle_s & handle, am_sinkID_t sinkID, std::vector<am_SoundProperty_s> & soundProperty)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSinkSoundProperties called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSinkSoundProperties, error, handle, sinkID, soundProperty);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setSinkSoundProperty(am_Handle_s & handle, am_sinkID_t sinkID, am_SoundProperty_s & soundProperty)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSinkSoundProperty called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSinkSoundProperty, error, handle, sinkID, soundProperty);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setSourceSoundProperties(am_Handle_s & handle, am_sourceID_t sourceID, std::vector<am_SoundProperty_s> & soundProperty)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSourceSoundProperties called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSourceSoundProperties, error, handle, sourceID, soundProperty);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setSourceSoundProperty(am_Handle_s & handle, am_sourceID_t sourceID, am_SoundProperty_s & soundProperty)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setSourceSoundProperty called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setSourceSoundProperty, error, handle, sourceID, soundProperty);
    return (error);
}

am_Error_e IAmControlReceiverShadow::setDomainState(am_domainID_t domainID, am_DomainState_e domainState)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setDomainState called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::setDomainState, error, domainID, domainState);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterDomainDB(am_Domain_s & domainData, am_domainID_t & domainID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterDomainDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterDomainDB, error, domainData, domainID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterMainConnectionDB(am_MainConnection_s & mainConnectionData, am_mainConnectionID_t & connectionID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterMainConnectionDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterMainConnectionDB, error, mainConnectionData, connectionID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterSinkDB(am_Sink_s & sinkData, am_sinkID_t & sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterSinkDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterSinkDB, error, sinkData, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterCrossfaderDB(am_Crossfader_s & crossfaderData, am_crossfaderID_t & crossfaderID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterCrossfaderDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterCrossfaderDB, error, crossfaderData, crossfaderID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterGatewayDB(am_Gateway_s & gatewayData, am_gatewayID_t & gatewayID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterGatewayDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterGatewayDB, error, gatewayData, gatewayID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterSourceDB(am_Source_s & sourceData, am_sourceID_t & sourceID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterSourceDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterSourceDB, error, sourceData, sourceID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterSinkClassDB(am_SinkClass_s & sinkClass, am_sinkClass_t & sinkClassID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterSinkClassDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterSinkClassDB, error, sinkClass, sinkClassID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterSourceClassDB(am_sourceClass_t & sourceClassID, am_SourceClass_s & sourceClass)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterSourceClassDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterSourceClassDB, error, sourceClassID, sourceClass);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSinkClassInfoDB(am_SinkClass_s & sinkClass)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSinkClassInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSinkClassInfoDB, error, sinkClass);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSourceClassInfoDB(am_SourceClass_s & sourceClass)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSourceClassInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSourceClassInfoDB, error, sourceClass);
    return (error);
}

am_Error_e IAmControlReceiverShadow::enterSystemPropertiesListDB(std::vector<am_SystemProperty_s> & listSystemProperties)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::enterSystemPropertiesListDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::enterSystemPropertiesListDB, error, listSystemProperties);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeMainConnectionRouteDB(am_mainConnectionID_t mainconnectionID, std::vector<am_connectionID_t> & listConnectionID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeMainConnectionRouteDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeMainConnectionRouteDB, error, mainconnectionID, listConnectionID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeMainConnectionStateDB(am_mainConnectionID_t mainconnectionID, am_ConnectionState_e connectionState)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeMainConnectionStateDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeMainConnectionStateDB, error, mainconnectionID, connectionState);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSinkMainVolumeDB(am_mainVolume_t mainVolume, am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSinkMainVolumeDB called"));
    am_Error_e error;
    //mCAmSerializer.syncCall<IAmControlReceive, am_Error_e, const am_mainVolume_t, const am_sinkID_t, am_mainVolume_t, am_sinkID_t>(mpIAmControlReceiver, &IAmControlReceive::changeSinkMainVolumeDB, error, mainVolume, sinkID);
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSinkMainVolumeDB, error, mainVolume, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListMainConnections(std::vector<am_MainConnection_s> & listMainConnections)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListMainConnections called"));
  am_Error_e error;
   mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListMainConnections, error, listMainConnections);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListDomains(std::vector<am_Domain_s> & listDomains)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListDomains called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListDomains, error, listDomains);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListConnections(std::vector<am_Connection_s> & listConnections)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListConnections called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListConnections, error, listConnections);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSinks(std::vector<am_Sink_s> & listSinks)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSinks called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSinks, error, listSinks);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSources(std::vector<am_Source_s> & listSources)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSources called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSources, error, listSources);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSourceClasses(std::vector<am_SourceClass_s> & listSourceClasses)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSourceClasses called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSourceClasses, error, listSourceClasses);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListHandles(std::vector<am_Handle_s> & listHandles)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListHandles called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListHandles, error, listHandles);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListCrossfaders(std::vector<am_Crossfader_s> & listCrossfaders)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListCrossfaders called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListCrossfaders, error, listCrossfaders);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListGateways(std::vector<am_Gateway_s> & listGateways)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListGateways called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListGateways, error, listGateways);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSinkClasses(std::vector<am_SinkClass_s> & listSinkClasses)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSinkClasses called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSinkClasses, error, listSinkClasses);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSystemProperties(std::vector<am_SystemProperty_s> & listSystemProperties)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSystemProperties called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSystemProperties, error, listSystemProperties);
    return (error);
}

void IAmControlReceiverShadow::setCommandReady()
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setCommandReady called"));
  mCAmSerializer.asyncCall(mpIAmControlReceiver, &IAmControlReceive::setCommandReady);
}

void IAmControlReceiverShadow::setCommandRundown()
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setCommandRundown called"));
  mCAmSerializer.asyncCall(mpIAmControlReceiver, &IAmControlReceive::setCommandRundown);
}

void IAmControlReceiverShadow::setRoutingReady()
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setRoutingReady called"));
  mCAmSerializer.asyncCall(mpIAmControlReceiver, &IAmControlReceive::setRoutingReady);
}

void IAmControlReceiverShadow::setRoutingRundown()
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::setRoutingRundown called"));
  mCAmSerializer.asyncCall(mpIAmControlReceiver, &IAmControlReceive::setRoutingRundown);
}
//modified
void IAmControlReceiverShadow::confirmControllerReady(am_Error_e error)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::confirmControllerReady called"));
  mCAmSerializer.asyncCall(mpIAmControlReceiver, &IAmControlReceive::confirmControllerReady, error);
}
//modified
void IAmControlReceiverShadow::confirmControllerRundown(am_Error_e error)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::confirmControllerRundown called"));
  mCAmSerializer.asyncCall(mpIAmControlReceiver, &IAmControlReceive::confirmControllerRundown, error);
}

am_Error_e IAmControlReceiverShadow::getSocketHandler(CAmSocketHandler *& socketHandler)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getSocketHandler called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getSocketHandler, error, socketHandler);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSinkAvailabilityDB(am_Availability_s& availability, am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSinkAvailabilityDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSinkAvailabilityDB, error, availability, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changDomainStateDB(am_DomainState_e domainState, am_domainID_t domainID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changDomainStateDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changDomainStateDB, error, domainState, domainID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSinkMuteStateDB(am_MuteState_e muteState, am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSinkMuteStateDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSinkMuteStateDB, error, muteState, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeMainSinkSoundPropertyDB(am_MainSoundProperty_s& soundProperty, am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeMainSinkSoundPropertyDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeMainSinkSoundPropertyDB, error, soundProperty, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeMainSourceSoundPropertyDB(am_MainSoundProperty_s& soundProperty, am_sourceID_t sourceID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeMainSourceSoundPropertyDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeMainSourceSoundPropertyDB, error, soundProperty, sourceID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSourceAvailabilityDB(am_Availability_s& availability, am_sourceID_t sourceID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSourceAvailabilityDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSourceAvailabilityDB, error, availability, sourceID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::changeSystemPropertyDB(am_SystemProperty_s& property)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::changeSystemPropertyDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::changeSystemPropertyDB, error, property);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeMainConnectionDB(am_mainConnectionID_t mainConnectionID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeMainConnectionDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeMainConnectionDB, error, mainConnectionID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeSinkDB(am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeSinkDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeSinkDB, error, sinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeSourceDB(am_sourceID_t sourceID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeSourceDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeSourceDB, error, sourceID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeGatewayDB(am_gatewayID_t gatewayID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeGatewayDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeGatewayDB, error, gatewayID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeCrossfaderDB(am_crossfaderID_t crossfaderID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeCrossfaderDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeCrossfaderDB, error, crossfaderID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeDomainDB(am_domainID_t domainID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeDomainDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeDomainDB, error, domainID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeSinkClassDB(am_sinkClass_t sinkClassID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeSinkClassDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeSinkClassDB, error, sinkClassID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::removeSourceClassDB(am_sourceClass_t sourceClassID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::removeSourceClassDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::removeSourceClassDB, error, sourceClassID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getSourceClassInfoDB(am_sourceID_t sourceID, am_SourceClass_s& classInfo)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getSourceClassInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getSourceClassInfoDB, error, sourceID, classInfo);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getSinkClassInfoDB(am_sinkID_t sinkID, am_SinkClass_s& sinkClass)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getSinkClassInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getSinkClassInfoDB, error, sinkID, sinkClass);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getSinkInfoDB(am_sinkID_t sinkID, am_Sink_s& sinkData)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getSinkInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getSinkInfoDB, error, sinkID, sinkData);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getSourceInfoDB(am_sourceID_t sourceID, am_Source_s& sourceData)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getSourceInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getSourceInfoDB, error, sourceID, sourceData);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getGatewayInfoDB(am_gatewayID_t gatewayID, am_Gateway_s& gatewayData)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getGatewayInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getGatewayInfoDB, error, gatewayID, gatewayData);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getCrossfaderInfoDB(am_crossfaderID_t crossfaderID, am_Crossfader_s& crossfaderData)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getCrossfaderInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getCrossfaderInfoDB, error, crossfaderID, crossfaderData);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getMainConnectionInfoDB(am_mainConnectionID_t mainConnectionID, am_MainConnection_s& mainConnectionData)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getMainConnectionInfoDB called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getMainConnectionInfoDB, error, mainConnectionID, mainConnectionData);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSinksOfDomain(am_domainID_t domainID, std::vector<am_sinkID_t>& listSinkID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSinksOfDomain called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSinksOfDomain, error, domainID, listSinkID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListSourcesOfDomain(am_domainID_t domainID, std::vector<am_sourceID_t>& listSourceID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListSourcesOfDomain called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListSourcesOfDomain, error, domainID, listSourceID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListCrossfadersOfDomain(am_domainID_t domainID, std::vector<am_crossfaderID_t>& listCrossfadersID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListCrossfadersOfDomain called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListCrossfadersOfDomain, error, domainID, listCrossfadersID);
    return (error);
}

am_Error_e IAmControlReceiverShadow::getListGatewaysOfDomain(am_domainID_t domainID, std::vector<am_gatewayID_t>& listGatewaysID)
{
    ETG_TRACE_USR4(("IAmControlReceiverShadow::getListGatewaysOfDomain called"));
  am_Error_e error;
    mCAmSerializer.syncCall(mpIAmControlReceiver, &IAmControlReceive::getListGatewaysOfDomain, error, domainID, listGatewaysID);
    return (error);
}




} /* namespace am */
