/*
 * aud_diag_defset_adaptor_IF.cpp
 *
 *  Created on: Mar 11, 2016
 *      Author: rjk2kor
 */


#include "aud_diag_defset_adaptor_IF_types.h"
#include "aud_diag_defset_adaptor_IF.h"

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN_DIAGNOSIS
#include "trcGenProj/Header/aud_diag_defset_adaptor_IF.cpp.trc.h"
#endif

#include <string>
#include <vector>
#include <sstream>
using namespace std;


DBusObjectPathVTable g_vTable={0,0,0,0,0,0};


/**
   This is the constructor of the class

   @param[in] pConnect Pointer to opaque DBusConnection object
   @return None
*/
aud_diag_defset_adaptor_IF::aud_diag_defset_adaptor_IF(DBusConnection* pConnect)
:m_ptrconnection(pConnect)
{
  //Setup dispatcher table
  m_dispatchtable["PrepareSystemSetting"]= &aud_diag_defset_adaptor_IF::_vOnPrepareSystemSetting;
  m_dispatchtable["ExecuteSystemSetting"]= &aud_diag_defset_adaptor_IF::_vOnExecuteSystemSetting;
  m_dispatchtable["FinalizeSystemSetting"]= &aud_diag_defset_adaptor_IF::_vOnFinalizeSystemSetting;

  //Register object path on this connection
  g_vTable.message_function = &aud_diag_defset_adaptor_IF::eDispatchMsg;
  if(dbus_connection_register_object_path(m_ptrconnection,AUD_GAM_DESFET_OBJ_PATH,&g_vTable,this))
  {
    ETG_TRACE_USR3(("Registered object path: %s ",AUD_GAM_DESFET_OBJ_PATH));
  }
  else
  {
    ETG_TRACE_ERR(("Failed to register object path %s",AUD_GAM_DESFET_OBJ_PATH));
  }
}

/**
   This is the destructor of the class
*/
aud_diag_defset_adaptor_IF::~aud_diag_defset_adaptor_IF()
{
  dbus_connection_unregister_object_path(m_ptrconnection,AUD_GAM_DESFET_OBJ_PATH);
  m_ptrconnection = NULL;
}

void vPrintData(string s1, string s2m, vector<defset_ext_data> datalist,uint32_t cookie)
{
  ETG_TRACE_USR4((" ++++++++++++++++DATA BEGIN ++++++++++++++++ "));
  ETG_TRACE_USR4(("Defset Setting      : %s",s1.c_str()));
  ETG_TRACE_USR4(("Defset Setting Type : %s",s2m.c_str()));
  ETG_TRACE_USR4(("Extended data Begin : "));
  stringstream x;
  for(size_t i = 0; i< datalist.size();i++)
  {
    x<< (int)datalist[i].uParam1<<" >> ";
    for(size_t j=0;j<datalist[i].uParamList.size();j++)
    {
      x<<" "<< (int)datalist[i].uParamList[j];
    }
    x<<endl;
  }
  ETG_TRACE_USR4(("%s",x.str().c_str()));
  ETG_TRACE_USR4(("Extended data End "));
  ETG_TRACE_USR4(("Cookie : %x",cookie));
  ETG_TRACE_USR4((" ++++++++++++++++ DATA ENDS ++++++++++++++++ "));
}

/**
   This is the dispatcher function.

   @param[in] conn Pointer to dbus connection
   @param[in] msg Pointer to incoming message
   @param[in] ptrx User data provided while registering object path
   @return RESULT_HANDLED if the message is passed to corresponding dispatchers, else NOT_YET_HANDLED
*/
DBusHandlerResult aud_diag_defset_adaptor_IF::eDispatchMsg(DBusConnection */*conn*/, DBusMessage *msg, void *ptrx)
{
  aud_diag_defset_adaptor_IF* ptrSelf = static_cast<aud_diag_defset_adaptor_IF*>(ptrx);
  if(ptrSelf)
  {
    //Check if the message belongs to this path, interface
    if(dbus_message_has_path(msg,AUD_GAM_DESFET_OBJ_PATH))
    {
      if(dbus_message_has_interface(msg,AUD_GAM_DESFET_INTERFACE_NAME))
      {
        ///Message belongs to this interface
        if(dbus_message_get_type(msg) == DBUS_MESSAGE_TYPE_METHOD_CALL)
        {
          std::map<std::string,aud_dbus_DispatchFunc>::iterator it= ptrSelf->m_dispatchtable.find(dbus_message_get_member(msg));
          if(it != ptrSelf->m_dispatchtable.end())
          {
            (ptrSelf->*(it->second))(msg);
            return DBUS_HANDLER_RESULT_HANDLED;
          }
        }
      }
    }
  }
  return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

/**
   This is a helper function which helps validate the methodcall for its expected signature and method name.

   @param[in] pMsg Pointer to opaque DBusMessage object
   @param[in] expected_signature Expected signature of the method call
   @return TRUE if the validation successful, or False

*/
bool aud_diag_defset_adaptor_IF::bValidateMethodCall(DBusMessage* pMsg, const char* expected_signature)
{
  if((pMsg == NULL)||(expected_signature == NULL))
  {
    ETG_TRACE_ERR(("bValidateMethodCall > Input parmaters invalid"));
    return false;
  }

  ///Verify if the signature of the message matches, to that is specified in the interface XML
  ///Signature of method_call is ssa(yay)u
  if(!dbus_message_has_signature(pMsg,expected_signature))
  {
    ETG_TRACE_FATAL(("bValidateMethodCall > Signature mismatch, Expected: %s",expected_signature));
    ETG_TRACE_FATAL(("bValidateMethodCall > Signature mismatch, Received: %s",dbus_message_get_signature(pMsg)));
    return false;
  }
  return true;
}

bool aud_diag_defset_adaptor_IF::bUnMarshallDefsetData ( DBusMessage* pmsg,
                 std::string& rfsyssetid,
               std::string& rfsyssettype,
               std::vector<defset_ext_data>& rfextdatalist,
               uint32_t& rfU32cookie)
{
  //Create a iterator *read only mode* to parse the data
  DBusMessageIter rootiter;
  (void)dbus_message_iter_init(pmsg,&rootiter);

  char* param = NULL;

  ///1. read Parameter 1: sysSetID , signature : s
  ///dbus_message_iter_get_basic, for int32 it should be a "dbus_int32_t*" and for string a "const char**"
  dbus_message_iter_get_basic(&rootiter, &param);
  rfsyssetid= param;
  dbus_message_iter_next(&rootiter);//Move to next element

  ///2. read Parameter 2: sysSetType , signature : s
  dbus_message_iter_get_basic(&rootiter, &param);
  rfsyssettype=param;
  dbus_message_iter_next(&rootiter);//Move to next element

  ///3. Read Parameter 3: Extended data , signature : a(yay)
  {
    /**
    Now the tricky part, this element is an array of structures.
    First we get an iterator to parse different elements of the array.
    Then we will need a structure iterator to parse the element of the array.
    Then we use the structure iterator to read first element of the structure.
    To parse the second element of the structure, it is a list again, so you need a array iterator
     */
    DBusMessageIter arrayiter_l0;//Level 0 array iterator, this iterator can parse (yay)
    dbus_message_iter_recurse(&rootiter,&arrayiter_l0);
    while(DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&arrayiter_l0))
    {
      ///Inside the array we have a structure
      DBusMessageIter structiter;
      dbus_message_iter_recurse(&arrayiter_l0,&structiter);

      //it is redundant to check if the structure is empty

      defset_ext_data temp;
      dbus_message_iter_get_basic(&structiter,&temp.uParam1);
      dbus_message_iter_next(&structiter);//Move to next element
      ///Read the list of items there , signature : ay
      {
        DBusMessageIter arrayiter_l1;//Level 1 array iterator
        dbus_message_iter_recurse(&structiter,&arrayiter_l1);
        while(DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&arrayiter_l1))
        {
          uint8_t t1;
          dbus_message_iter_get_basic(&arrayiter_l1,&t1);
          temp.uParamList.push_back(t1);
          dbus_message_iter_next(&arrayiter_l1);//Move to next element of l1 iterator
        }//while(DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&arrayiter_l0))
      }
      rfextdatalist.push_back(temp);//Copy it to the list
      dbus_message_iter_next(&arrayiter_l0);//Move to next element of l0 iterator
    }//while(DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&arrayiter_l0))
    dbus_message_iter_next(&rootiter);//Move to next element
  }
  ///Read Parameter 4, Cookie , signature : u
  dbus_message_iter_get_basic(&rootiter, &rfU32cookie);
  //Done parsing the message

  vPrintData(rfsyssetid,rfsyssettype,rfextdatalist,rfU32cookie);

  return true;
}

bool aud_diag_defset_adaptor_IF::bMarshallDefsetData   (DBusMessage* pmsg,
                std::string& rfsyssetid,
               std::string& rfsyssettype,
               std::vector<defset_ext_data>& rfextdatalist,
               uint32_t& rfu32ReturnCode,
               uint32_t& rfU32cookie)
{
  vPrintData(rfsyssetid,rfsyssettype,rfextdatalist,rfU32cookie);

  bool bsuccess = true;
  //Create a iterator *read write mode* to parse the data
  DBusMessageIter rootiter;
  dbus_message_iter_init_append(pmsg,&rootiter);

  const char *x = rfsyssetid.c_str();
  const char *y = rfsyssettype.c_str();

  bsuccess = bsuccess && dbus_message_iter_append_basic(&rootiter, DBUS_TYPE_STRING, &x);//Add syssetid
  bsuccess = bsuccess && dbus_message_iter_append_basic(&rootiter, DBUS_TYPE_STRING, &y);//add sysset type

  ///Add extended data
  DBusMessageIter subiter;
  bsuccess = bsuccess && dbus_message_iter_open_container(&rootiter,DBUS_TYPE_ARRAY,"(yay)",&subiter);
  for(std::vector<defset_ext_data>::iterator it = rfextdatalist.begin(); it != rfextdatalist.end();it++)
  {
    DBusMessageIter subiter1;
    bsuccess = bsuccess && dbus_message_iter_open_container(&subiter,DBUS_TYPE_STRUCT,NULL,&subiter1);
    bsuccess = bsuccess && dbus_message_iter_append_basic(&subiter1, DBUS_TYPE_BYTE, &it->uParam1);
    DBusMessageIter subiter2;
    bsuccess = bsuccess && dbus_message_iter_open_container(&subiter1,DBUS_TYPE_ARRAY,"y",&subiter2);
    for(std::vector<uint8_t>::iterator it1 = it->uParamList.begin(); it1 != it->uParamList.end();it1++)
    {
      bsuccess = bsuccess && dbus_message_iter_append_basic(&subiter2, DBUS_TYPE_BYTE, &*it1);
    }
    bsuccess = bsuccess && dbus_message_iter_close_container(&subiter1,&subiter2);
    bsuccess = bsuccess && dbus_message_iter_close_container(&subiter,&subiter1);
  }
  bsuccess = bsuccess && dbus_message_iter_close_container(&rootiter,&subiter);

  //Done adding extended data, add return code
  bsuccess = bsuccess && dbus_message_iter_append_basic(&rootiter, DBUS_TYPE_UINT32, &rfu32ReturnCode);//add return code
  bsuccess = bsuccess && dbus_message_iter_append_basic(&rootiter, DBUS_TYPE_UINT32, &rfU32cookie);//add cookie

  return bsuccess;
}
/**
   This function is called from the method dispatcher. This function de marshals the wire message data and extracts
   the data to the parameters specified in the introspection data. It invokes the corresponding interface function
   for further processing.
   This function handles the demarshalling and processing of the method_call "PrepareSystemSetting"

   @param[in] pMsg Pointer to opaque DBusMessage object
   @return None
*/
void aud_diag_defset_adaptor_IF::_vOnPrepareSystemSetting(DBusMessage* pMsg)
{
  if(m_ptrconnection == NULL)
  {
    ETG_TRACE_ERR(("_vOnPrepareSystemSetting > DBusConnection is NULL "));
    return;
  }
  aud_dbus_error err(m_ptrconnection, pMsg);
  if(!bValidateMethodCall(pMsg,"ssa(yay)u"))
  {
    err.sErrorName = DBUS_ERROR_INVALID_SIGNATURE;
    ETG_TRACE_ERR(("_vOnPrepareSystemSetting > Message Validation Failed"));
    return;
  }
  string sysSetID;
  string sysSetType;
  vector<defset_ext_data> ext_data_list;
  //Create a iterator to parse the message.
  uint32_t u32Cookie=0;
  uint32_t u32Result = 0;
  if(bUnMarshallDefsetData(pMsg,sysSetID,sysSetType,ext_data_list,u32Cookie))
  {
    u32Result = u32OnPrepareSystemSetting(sysSetID,sysSetType);

    //Create a method reply
    DBusMessage* pReply = dbus_message_new_method_return(pMsg);

    ///Marshal the data to reply and send the result
    if(bMarshallDefsetData(pReply,sysSetID,sysSetType,ext_data_list,u32Result,u32Cookie))
    {
      dbus_uint32_t serial = dbus_message_get_serial(pMsg);
      ///Successfully marshalled the data, send the result to diagnosis
      ///While replying to a method call, it is important to set the serial
      if(!dbus_connection_send(m_ptrconnection,pReply,&serial))
      {
        ETG_TRACE_FATAL(("_vOnPrepareSystemSetting > Message Send Failed ! ! !"));
      }
      else
      {
        ///Successfully posted, disable error
        err.disable();
      }
    }
    else
    {
      ETG_TRACE_FATAL(("Failed to marshall data for message PrepareSystemSetting, out of memory ! !"));
    }
    dbus_message_unref(pReply);//Free resources allocated for reply
  }
  else
  {
    err.sErrorName = DBUS_ERROR_FAILED;
    ETG_TRACE_FATAL(("Failed to Unmarshall data for message PrepareSystemSetting"));
  }
}

/**
   This function is called from the method dispatcher. This function de marshals the wire message data and extracts
   the data to the parameters specified in the introspection data. It invokes the corresponding interface function
   for further processing.
   This function handles the demarshalling and processing of the method_call "ExecuteSystemSetting"

   @param[in] pMsg Pointer to opaque DBusMessage object
   @return None
*/
void aud_diag_defset_adaptor_IF::_vOnExecuteSystemSetting(DBusMessage* pMsg)
{
  if(m_ptrconnection == NULL)
  {
    ETG_TRACE_ERR(("_vOnExecuteSystemSetting > DBusConnection is NULL "));
    return;
  }
  aud_dbus_error err(m_ptrconnection, pMsg);
  if(!bValidateMethodCall(pMsg,"ssa(yay)u"))
  {
    ETG_TRACE_ERR(("_vOnExecuteSystemSetting > Message Validation Failed"));
    return;
  }
  string sysSetID;
  string sysSetType;
  vector<defset_ext_data> ext_data_list;
  //Create a iterator to parse the message.
  uint32_t u32Cookie=0;
  uint32_t u32Result = 0;
  if(bUnMarshallDefsetData(pMsg,sysSetID,sysSetType,ext_data_list,u32Cookie))
  {
    u32Result = u32OnExecuteSystemSetting(sysSetID,sysSetType);

    //Create a method reply
    DBusMessage* pReply = dbus_message_new_method_return(pMsg);

    ///Marshal the data to reply and send the result
    if(bMarshallDefsetData(pReply,sysSetID,sysSetType,ext_data_list,u32Result,u32Cookie))
    {
      dbus_uint32_t serial = dbus_message_get_serial(pMsg);
      ///Successfully marshalled the data, send the result to diagnosis
      ///While replying to a method call, it is important to set the serial
      if(!dbus_connection_send(m_ptrconnection,pReply,&serial))
      {
        ETG_TRACE_ERR(("_vOnExecuteSystemSetting > Message Send Failed ! ! !"));
      }
      else
      {
        err.disable();
      }
    }
    else
    {
      ETG_TRACE_FATAL(("Failed to marshall data for message ExecuteSystemSetting, out of memory ! !"));
    }
    dbus_message_unref(pReply);
  }
  else
  {
    err.sErrorName = DBUS_ERROR_FAILED;
    ETG_TRACE_ERR(("Failed to Unmarshall data for message ExecuteSystemSetting"));
   }
}

/**
   This function is called from the method dispatcher. This function de marshals the wire message data and extracts
   the data to the parameters specified in the introspection data. It invokes the corresponding interface function
   for further processing.
   This function handles the demarshalling and processing of the method_call "PrepareSystemSetting"

   @param[in] pMsg Pointer to opaque DBusMessage object
   @return None
*/
void aud_diag_defset_adaptor_IF::_vOnFinalizeSystemSetting(DBusMessage* pMsg)
{
  if(m_ptrconnection == NULL)
  {
    ETG_TRACE_ERR(("_vOnFinalizeSystemSetting > DBusConnection is NULL "));
    return;
  }
  aud_dbus_error err(m_ptrconnection, pMsg);

  if(!bValidateMethodCall(pMsg,"ssa(yay)u"))
  {
    ETG_TRACE_ERR(("_vOnFinalizeSystemSetting > Message Validation Failed"));
    return;
  }
  string sysSetID;
  string sysSetType;
  vector<defset_ext_data> ext_data_list;
  //Create a iterator to parse the message.
  uint32_t u32Cookie=0;
  uint32_t u32Result = 0;
  if(bUnMarshallDefsetData(pMsg,sysSetID,sysSetType,ext_data_list,u32Cookie))
  {
    u32Result = u32OnFinalizeSystemSetting(sysSetID,sysSetType);

    //Create a method reply
    DBusMessage* pReply = dbus_message_new_method_return(pMsg);

    ///Marshal the data to reply and send the result
    if(bMarshallDefsetData(pReply,sysSetID,sysSetType,ext_data_list,u32Result,u32Cookie))
    {
      dbus_uint32_t serial = dbus_message_get_serial(pMsg);
      ///Successfully marshalled the data, send the result to diagnosis
      ///While replying to a method call, it is important to set the serial
      if(!dbus_connection_send(m_ptrconnection,pReply,&serial))
      {
        ETG_TRACE_ERR(("_vOnFinalizeSystemSetting > Message Validation Failed"));
      }
      else
      {
        err.disable();
      }
    }
    else
    {
      ETG_TRACE_FATAL(("Failed to marshall data for message FinalizeSystemSetting, out of memory ! !"));
    }
    dbus_message_unref(pReply);
  }
  else
  {
    ETG_TRACE_ERR(("Failed to Unmarshall data for message FinalizeSystemSetting"));
  }
}


