//
// CThreadSwitchingClient.cpp
//
//  Created on: Feb 26, 2015
//      Author: Martin Koch, Fa. ESE
//


#include "controllerplugin_Trace.h"  // links generic <etrace_if.h> and <osal_if.h>

#include "CThreadSwitchingClient.h"
// - - - - - - - - - - - - - - - - -

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/CThreadSwitchingClient.cpp.trc.h"


// for Linux specific gettid (get thread-ID) syscall
#include <unistd.h>
#include <sys/syscall.h>


// --------------------------------------------------------------------------
//
//                T h r e a d - S w i t c h i n g   C l i e n t
//

/* constructor */ CThreadSwitchingClient:: CThreadSwitchingClient (tU16 serviceID, tFIVersionInfo serviceVersion, am::IAmControlReceiverShadow& receiverShadow)
   : FIMessaging::ITarget()
   , FIMessaging::IRxPollingThread()
   , m_ServiceInfo(FIMessaging::ServiceInfo(serviceID, serviceVersion))
   , m_pMessagingNode(NULL)
   , m_NativeThreadID((pid_t)syscall(SYS_gettid))
   , m_ControlReceiverShadow(receiverShadow)
   , m_pSender(NULL)
   , m_bSeviceAvailable(false)
{
   ETG_TRACE_USR3(("CThreadSwitchingClient<%u> established, Linux ThreadID = %u"
      , ETG_ENUM(ail_u16ServiceId, serviceID), m_NativeThreadID))

   m_pMessagingNode = FIMessaging::CCA::pGetNodeInstance (CCA_C_U16_APP_GENIVIAUDIO
      , "/dev/root/opt/bosch/base/registry/gam_plugins.reg", *this);

   if ( ! m_pMessagingNode)
   {
      ETG_TRACE_FATAL(("CThreadSwitchingClient<%u>  - E R R O R :  failed attaching CCA_Node"
           , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID)))
      return;
   }

   m_pSender = m_pMessagingNode->poAddTarget(*this);
}

// --------------------------------------------------------------------------

/* destructor */ CThreadSwitchingClient:: ~CThreadSwitchingClient ()
{

   ETG_TRACE_USR4(("CThreadSwitchingClient<%u> terminating ... "
         , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID)))

   if (m_pMessagingNode)
   {
      m_pMessagingNode->vRemoveTarget(*this);
      m_pMessagingNode->vReleaseInstance();
      m_pMessagingNode = NULL;
   }
   m_pSender = NULL;
}

// --------------------------------------------------------------------------

/* virtual */ bool CThreadSwitchingClient:: bProvidesService () const
{
   // distinguish us from services:

   return false;
}

// --------------------------------------------------------------------------

/* virtual */ void CThreadSwitchingClient:: vSetAssociatedSender (FIMessaging::ISender* pSender)
{
   // callback function to obtain message sender interface provided by Node

   m_pSender = pSender;

   ETG_TRACE_USR4(("CThreadSwitchingClient<%u>::vSetAssociatedSender() m_pSender assigned as 0x%08x"
         , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID), m_pSender))
}

// --------------------------------------------------------------------------

/* virtual */ FIMessaging::ServiceInfo CThreadSwitchingClient:: GetServiceInfo () const
{
   // return ID and version of either provided or requested service

//   ETG_TRACE_USR4(("CThreadSwitchingClient<%u>::GetServiceInfo() returning ID = 0x%x, version = {%u, %u}"
//         , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID)
//         , m_ServiceInfo.u16ServiceID, m_ServiceInfo.fiVersion.u16MajorVersion, m_ServiceInfo.fiVersion.u16MinorVersion))

   return m_ServiceInfo;
}

// --------------------------------------------------------------------------

/* virtual */ void CThreadSwitchingClient:: vOnConnect ()
{
   ETG_TRACE_USR2(("CThreadSwitchingClient<%u>::vOnConnect()"
         , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID)))

   m_bSeviceAvailable = true;

   // delegate to derived class
   vOnServiceAvailable();
}

// --------------------------------------------------------------------------

/* virtual */ void CThreadSwitchingClient:: vOnDisconnect ()
{
   ETG_TRACE_USR2(("CThreadSwitchingClient<%u>::vOnDisconnect()"
         , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID)))

   m_bSeviceAvailable = false;

   // delegate to derived class
   vOnServiceUnavailable();
}

// --------------------------------------------------------------------------

/* virtual */ void CThreadSwitchingClient:: vOnNewMessage (const FIMessaging::FIMessage& oMsg)
{
   // callback function for incoming messages

   ETG_TRACE_USR4(("CThreadSwitchingClient<%u>::vOnNewMessage(): delegating FIMessage %x.%x.%u"
         , ETG_ENUM(ail_u16ServiceId, m_ServiceInfo.u16ServiceID)
         , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))

   if (NULL == m_pSender)
   {
       ETG_TRACE_FATAL(("CThreadSwitchingClient::vOnNewMessage() - E R R O R : invalid pointer m_pSender=0x%X"
              , m_pSender))
        return;
   }

   // delegate to derived classes dispatcher
   vDispatchMessage (oMsg);
}

// --------------------------------------------------------------------------
//
//            I R x - P o l l i n g - T h r e a d   implementation
//
// --------------------------------------------------------------------------
//
//        A                                                        |
//        |  Genivi            Context Switch             Rx-Loop  |
//        |                                                        V
//
// --------------------------------------------------------------------------

/* virtual */ void CThreadSwitchingClient:: vRxNotificationCallback ()
{
   // if thread context does not match, call again this function from Genivi worker thread
   pid_t  currentThreadID = (pid_t)syscall(SYS_gettid);
   //pid_t  currentThreadID = syscall(SYS_gettid);

   if (m_NativeThreadID != currentThreadID)
   {
      ETG_TRACE_USR4(("CThreadSwitchingClient:: vRxNotificationCallback() : Switching Thread %u ==> %u"
            , currentThreadID, m_NativeThreadID))

      m_ControlReceiverShadow.vSwitchThreadContext <CThreadSwitchingClient> (this, &CThreadSwitchingClient::vRxNotificationCallback);

      return;
   }

   // Get and process message
   ETG_TRACE_USR4(("CThreadSwitchingClient:: vRxNotificationCallback() : Polling Message from Thread %u"
         , currentThreadID))

   (void) m_pMessagingNode->bPollAndDispatchMessage();
}

// --------------------------------------------------------------------------

