#include "string.h"
#include "AudioStack/clStackRules.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clStackRules.cpp.trc.h"
#endif


//VVD lint fix
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES_FUNCTIONIDS

/* Include server interface */
#include "midw_fi_if.h"

/* sources - qualifier */
//#define NOT(a) (a | 0x0800)
//#define KICK(a) (a | 0x1000)
//#define SRC_GROUP(a) (a | 0x2000)
///* sources - checker */
//#define CHECK_NOT(a) (a & NOT(0))
//#define CHECK_KICK(a)   (a & KICK(0))
//#define MASK(a) (a & 0x07ff)
//#define CHECK_GRP(a) (a & 0x2000)
/* sources */
// not using defines are ...... removed for lint

//#define SRC_Click       17     //lint !e750 PQM_authorized_multi_266  Intentionally not corrected, reviewed and not critical  //lint !e830 PQM_authorized_multi_263  Intentionally not corrected, reviewed and not critical
//#define SRC_Beep        18     //lint !e750 PQM_authorized_multi_266  Intentionally not corrected, reviewed and not critical  //lint !e830 PQM_authorized_multi_263  Intentionally not corrected, reviewed and not critical
/* sources - specials */
//#define SRC_END      0xff
//#define SRC_ALL      0xfe


/* actions */
//#define ACTION_ABORT(a)    (clStackRules::actions_t)(a | clStackRules::/*actions_t::*/action_abort)
// comment out until not used to make Lint happy
//#define ACTION_SETRULE(a)   (clStackRules::actions_t)(a | clStackRules::/*actions_t::*/newRule) /* not implemented */
// comment out until not used to make Lint happy
//#define ACTION_END         (clStackRules::/*actions_t::*/end)
//#define ACTION_WAIT_FOR(a) (clStackRules::actions_t)(a | clStackRules::/*actions_t::*/action_waitFor)

using namespace am;


namespace AudioStack
{
using namespace AudioSource;

void clSourceClass::setDynSinkID(int index, int sinkID)
{
  if(sinkID>=100)
  {
    if((unsigned int)index < mySinks.size())
    {
      ETG_TRACE_USR4(("clSourceClass %s",SrcClassName.c_str()));
      ETG_TRACE_USR4(("updating sinkID %d, this %p,  at mySinks[index].first =%x",sinkID, this, &mySinks[index].first));
      mySinks[index].first = (am_sinkID_t)sinkID;
    }
    else
    {
      ETG_TRACE_ERR(("Can not add dyn Sink ID %d for k= %d size = %d to SourceClass %s mySinks vector",
            sinkID,index,mySinks.size(),SrcClassName.c_str()));
    }
    if((unsigned int)index < Sinks.size())
    {
      ETG_TRACE_USR4(("clSourceClass %s",SrcClassName.c_str()));
      ETG_TRACE_USR4(("updating sinkID %d, this %p,  at Sinks[%d] =%p",sinkID, this, index, &Sinks[index]));

      Sinks[index]=(tU16)sinkID;
    }
    else
    {
      ETG_TRACE_ERR(("Can not add dyn Sink ID %d for k= %d size = %d to SourceClass %s Sinks vector",
            sinkID,index,Sinks.size(),SrcClassName.c_str()));
    }
  }
  else
  {
    ETG_TRACE_ERR(("setDynSinkID called for sinkID %d which is below boarder of dynID 100",sinkID));
  }
}

clSourceClass::actions_t clSourceClass::getPushAction(int index)
{              //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
    if(PushActions.size() > static_cast<tU16>(index))
       return PushActions[index];
    else
        return action_abort;
} //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical

clSourceClass::actions_t clSourceClass::getPopAction(int index)
{              //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
    if(PopActions.size() > static_cast<tU16>(index))
       return PopActions[index];
    else
        return action_abort;
}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical

//int clStackRules::ruleIndex(SourceID srcId)
//{
//   return ruleIndex(srcId.enSourceClass);
//}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical
//
//
//int clStackRules::ruleIndex(AudioSources::enAudioSources srcClass)
//{
//   int index ;    //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
//   for(index = 0; rules[index].src != AudioSources::LAST; index++) {
//      if( rules[index].src == srcClass)
//      {
//         return index;
//      }
//   }
//   NORMAL_M_ASSERT_ALWAYS();
//   return -1;
//}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical


//clStackRules::clStackRules(SourceID srcID) :
//    m_rules(&rules[ruleIndex(srcID)])
//    , m_type(rules[ruleIndex(srcID)].type)
//    , m_group(rules[ruleIndex(srcID)].group)
//    , m_srcReg(rules[ruleIndex(srcID)].sourceRegistration)
//    , m_availabilityTimeout(rules[ruleIndex(srcID)].availabilityTimeout)
//    , m_autoPlay(rules[ruleIndex(srcID)].autoPlay)
//{}

//bool clStackRules::setRules(SourceID srcID)
//{
//   int index;     //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
//
//   /* get rule index */
//   index = ruleIndex(srcID);
//   if (index == -1) return false;
//
//   /* set the individual rules */
//   m_rules = &rules[index];
//   /* set the type */
//   m_type = rules[index].type; //sources[m_srcNameIndex].type;
//   // set the group
//   m_group = rules[index].group; //sources[m_srcNameIndex].group;
//   m_srcReg = rules[index].sourceRegistration;
//   m_autoPlay = rules[index].autoPlay;
//   m_availabilityTimeout = rules[index].availabilityTimeout;
//   return true;
//}

clSourceClass::allow_t clSourceClass::allowOnTop(SourceID enSrcId) const
{
   //VVD lint fix
  clAudioSource* poNewSrc  = clAudioSourceFactory::getAudioSource(enSrcId);
  /*
   * vdu1kor 18/03/2016
   * Condition to check if background source change is undergoing
   * if so then no need to check for allowance rule
   * If background source is denied then it may end up in situation where no source is active
   * Ex : PHONE(off)/MEDIA_PLAYER(SrcAvailCheck_P)
   *       case1> if usb device is removed then background source change is triggered
   *       case2> if on startup, availability is not received within defined time then
   *           background source change is triggered (NCG3D-11300)
   * In both use case, MediaPlayer source should be replaced with FM(pause)
   * Ex : PHONE(on)/FM(pause)
   *     case1> if Usb is inserted, then background src exchange is triggered but MEDIA
   *         is not allowed on the top of Phone hence FM will not be replaced by Media
   */
  if((poNewSrc) && (true == poNewSrc->bIsSourceBG()) && (true == poNewSrc->bIsPrevSourceRemoved()))
  {
    ETG_TRACE_USR4(("allowOnTop: New source is BackGround Source Exchange due to SrcRemoved, No need to check allowance, SourceClass: %d subID %d"
        , (poNewSrc->sGetId()).enSourceClass
        , (poNewSrc->sGetId()).u16SubSource));

    return clSourceClass::allowed;
  }
   for(tU16 i=0; i < Rules.size(); ++i)
   {
      //GroupMask?
      if(RuleQualifier::GetQualifier(Rules[i]) == RuleQualifier::ALLOW_GROUP)
      {
         tU8 groupID = tU8(Rules[i] & 0xFF);
         if(clFactory_AudioSourceClass::GetGroupID(enSrcId) == groupID)
         {
            ETG_TRACE_USR4(("Allow Group ID %d", groupID));
            return allowed;
         }
      }
      /* source allows a particular source (in general) */
      if (RuleQualifier::GetSourceClass(Rules[i])== enSrcId.enSourceClass)
      {
            //RuleCheck_GetValue(Rules[i]) == enSrcId.enSourceClass) {
         /* but this source is flagged NOT - so disallow */
         if (RuleQualifier::GetQualifier(Rules[i]) == RuleQualifier::NOT_SRC)
         {
            //ETG_TRACE_USR4(("DENY SourceClass ID: %d", Rules[i])); //daw2hi: missleading ?
            ETG_TRACE_USR4(("DENY SourceClass ID: %d, Rule: 0x%x", RuleQualifier::GetSourceClass(Rules[i]),Rules[i]));
            return kicked;
         }else{
            /* not flagged with NOT - allow */
            //ETG_TRACE_USR4(("Allow SourceClass ID: %d", Rules[i])); //daw2hi: missleading ?
            ETG_TRACE_USR4(("Allow SourceClass ID: %d, Rule: 0x%x", RuleQualifier::GetSourceClass(Rules[i]),Rules[i]));
            return allowed;
         }
      }
      /* source allows all other sources? */
      if (RuleQualifier::GetQualifier(Rules[i]) == RuleQualifier::ALL_SOURCES) {
         ETG_TRACE_USR4(("Allow All Sources"));
         return allowed; /* allow */
      }
   }
   ETG_TRACE_USR4(("DENY because no rule matches"));
   return disallowed;
}        //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical



}
