#include "string.h"
#include "AudioStack/clStackRules.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/clGateway.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clGateway.cpp.trc.h"
#endif

using namespace am;

namespace AudioStack
{

namespace AudioSource
{

clGateway::clGateway(am_Gateway_s gateway_s)
{
  ETG_TRACE_USR4(("clGateway::clGateway Constructor for %s",gateway_s.name.c_str()));
  m_Gateway = gateway_s;
  m_registered = false;
}

void clGateway::update(am_Gateway_s aGateway)
{
  ETG_TRACE_USR4(("clGateway::update %s",aGateway.name.c_str()));

  ETG_TRACE_USR4(("clGateway::update sourceID %d",aGateway.sourceID));
  ETG_TRACE_USR4(("clGateway::update sinkID %d",aGateway.sinkID));

  ETG_TRACE_USR4(("clGateway::update domainSinkID %d",aGateway.domainSinkID));
  ETG_TRACE_USR4(("clGateway::update domainSourceID %d",aGateway.domainSourceID));

  ETG_TRACE_USR4(("clGateway::update controlDomainID %d",aGateway.controlDomainID));

//  m_Gateway.sinkID = aGateway.sinkID;
//  m_Gateway.domainSinkID = aGateway.domainSinkID;
//
//  m_Gateway.sourceID = aGateway.sourceID;
//  m_Gateway.domainSourceID = aGateway.domainSourceID;

  m_Gateway = aGateway;

}

bool clGateway::tryRegister()
{
	//if already registered, return false
  if(m_registered) return false;

  if(bIsDataComplete())
  {
    clGeniviAudioCtrlAdapter::registerGateway(m_Gateway);
    m_registered=true;
    return true;
  }
  //return false if data is not complete
  return false;
}

//void clGateway::setDynSinkID(am_sinkID_t sinkID, std::string name)
void clGateway::setDynSinkID(am_sinkID_t sinkID, const am_Sink_s& gam_sink_s)
{
  ETG_TRACE_USR4(("clGateway::setDynSinkID sinkID %d, gam_sink_s.sinkID %d, gam_sink_s.name %s",sinkID, gam_sink_s.sinkID, gam_sink_s.name.c_str()));
  //if this is already registered, nothing to do
  if(m_registered) return;

  //now enter data if needed and check if gateway can be registered
  if((m_Gateway.sinkID==0) && (gam_sink_s.name.compare(m_sinkName)==0))
  {
    //This is the sink we are waiting for
    m_Gateway.sinkID=sinkID;

    if(bIsDataComplete())
    {
      //register this gateway
      clGeniviAudioCtrlAdapter::registerGateway(m_Gateway);
      //mark as registered
      m_registered=true;
    }
  }
  else
  {
    ETG_TRACE_USR4(("clGateway::setDynSinkID not for this gateway"));
  }
}

//void clGateway::setDynSourceID(am_sourceID_t sourceID, std::string name)
void clGateway::setDynSourceID(am_sourceID_t sourceID, const am_Source_s& gam_source_s)
{
  ETG_TRACE_USR4(("clGateway::setDynSourceID sourceID %d, gam_source_s.sourceID %d, gam_source_s.name %s",sourceID, gam_source_s.sourceID, gam_source_s.name.c_str()));
  //if this is already registered, nothing to do
  if(m_registered) return;

  //now enter data if needed and check if gateway can be registered
  if((m_Gateway.sourceID==0) && (gam_source_s.name.compare(m_sourceName)==0))
  {
    //This the source we are waiting for
    m_Gateway.sourceID=sourceID;
    m_Gateway.domainSourceID=gam_source_s.domainID;

    if(bIsDataComplete())
    {
      //register this gateway
      clGeniviAudioCtrlAdapter::registerGateway(m_Gateway);
      //mark as registered
      m_registered=true;
    }
  }
  else
  {
    ETG_TRACE_USR4(("clGateway::setDynSourceID not for this gateway"));
  }
}

bool clGateway::bIsDataComplete()
{
  //check for all the data
  if(   (m_Gateway.sourceID != 0)
    &&(m_Gateway.sinkID != 0)
  )
  {
    ETG_TRACE_USR4(("clGateway:bIsDataComplete yes"));
    return true;
  }
  ETG_TRACE_USR4(("clGateway:bIsDataComplete no"));
  return false;
}

}
}
