#include "AudioStack/SMT/clSrcState_WaitFor.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

//******************************************************************
//************************ WAIT FOR ********************************
//******************************************************************


void clSrcState_WaitFor::vEnter(clAudioSource* , tU32 , tU8 , tU16 /* SinkID */)
{
}

void clSrcState_WaitFor::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // simple transition from waitFor to off
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData, ENTRYCONDITION_NONE, SinkID);
}

void clSrcState_WaitFor::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // should be called when the source that we'll waited for is gone
   // cause we'll init now as same as we do from Off state
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData, SinkID);
}

void clSrcState_WaitFor::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   if (NULL != pclAudioSource)
   {
      pclAudioSource->vMW_Pause(pclAudioSource->u8GetNextSource(),SinkID);
   }
   // simple transition from off to pause is just used to differentiate background and foreground-states
   // of sources in MW. No intermediate state required.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_Pause(), u32UserData, SinkID);
}

}}//namespace

