#include "AudioStack/SMT/clSrcState_RampUpRequesting.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

//--- Sub-State: RampUpRequesting ----------------------------------------------------------------------------
void clSrcState_RampUpRequesting::vEnter(clAudioSource* pclAudioSource, tU32 , tU8, tU16 SinkID )
{

   if (NULL != pclAudioSource)
   {
      // invoke play on MW-interface
      pclAudioSource->vMW_On(SinkID);
   }
}

void clSrcState_RampUpRequesting::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // sat2hi, 12.01.10: go to RampDown2Off to send the Off message to fc_audio, because the playcommand has been send at this point
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData,SinkID);
}

void clSrcState_RampUpRequesting::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // sat2hi, 12.01.10: go to RampDown2Pause to send the Off message to fc_audio, because the playcommand has been send at this point
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData,SinkID);
}

void clSrcState_RampUpRequesting::vMsg_On(clAudioSource* pclAudioSource, tU32 , tU16 SinkID )
{


   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (NULL != pclAudioSource &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_On(SinkID);
   }
}

void clSrcState_RampUpRequesting::vMsg_RequestConfirmed(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampUp(), u32UserData,SinkID);
}

void clSrcState_RampUpRequesting::vMsg_OnDone(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // in normal flow, the RequestConfirmation is provided first.
   // but e.g. in Simu we skip the RequestConfirmation an go directly to On_Done
   //vSetState(pclAudioSource, clSrcStateFactory::pclCreateOn(), u32UserData);
  vSetState(pclAudioSource, clSrcStateFactory::pclCreateStartUnMute(), u32UserData,SinkID);
}

void clSrcState_RampUpRequesting::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // begin sequence again with init
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData,SinkID);
}

}}//namespace

