#include "AudioStack/SMT/clSrcState_RampUpInit.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

//--- Sub-State: RampUpInit ----------------------------------------------------------------------------
void clSrcState_RampUpInit::vEnter(clAudioSource* pclAudioSource, tU32 , tU8, tU16 SinkID )
{
   if (NULL != pclAudioSource)
   {
      pclAudioSource->vNotifyInitStarted(SinkID);

      // invoke play on MW-interface
      pclAudioSource->vMW_Init(SinkID);
   }
}

void clSrcState_RampUpInit::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // go directly to off instead of rampDown because the rampup was not yet started
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData,SinkID);
}

void clSrcState_RampUpInit::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // go directly to pause instead of rampDown because the rampup was not yet started
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData,SinkID);
}

void clSrcState_RampUpInit::vMsg_InitDone(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampUpRequesting(), u32UserData,SinkID);
}

void clSrcState_RampUpInit::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{


   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData,SinkID);
   // begin sequence again with init
//   if (NULL != pclAudioSource)
//   {
//      pclAudioSource->vNotifyInitStarted();
//
//      // invoke play on MW-interface
//      pclAudioSource->vMW_Init();
//   }
}

}}//namespace

