#include "AudioStack/SMT/clSrcState_RampUp.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

//--- Sub-State: RampUp ----------------------------------------------------------------------------
void clSrcState_RampUp::vMsg_OnDone(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   //vSetState(pclAudioSource, clSrcStateFactory::pclCreateOn(), u32UserData);
  vSetState(pclAudioSource, clSrcStateFactory::pclCreateStartUnMute(), u32UserData,SinkID);
}

void clSrcState_RampUp::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData,SinkID);
}

void clSrcState_RampUp::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData,SinkID);
}

void clSrcState_RampUp::vMsg_On(clAudioSource* pclAudioSource, tU32 , tU16 SinkID )
{


   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (NULL != pclAudioSource &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_On(SinkID);
   }
}

void clSrcState_RampUp::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // begin sequence again with init
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData,SinkID);
}

}}//namespace


