#include "AudioStack/SMT/clSrcState_RampDownToOff.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

void clSrcState_RampDownToOff::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 , tU16 SinkID )
{
   if (NULL != pclAudioSource)
   {
      // invoke command on MW-interface
      pclAudioSource->vMW_Off(pclAudioSource->u8GetNextSource(),SinkID);
   }
}

void clSrcState_RampDownToOff::vMsg_OffDone(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData,SinkID);
}

void clSrcState_RampDownToOff::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData,SinkID);
}

void clSrcState_RampDownToOff::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData,SinkID);
}

void clSrcState_RampDownToOff::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   // set manually to off because the off-done was lost in undervoltage
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff() , u32UserData,SinkID);
}

}}//namespace

