#include "AudioStack/SMT/clSrcState_On.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{
using namespace AudioSource;

void clSrcState_On::vEnter(clAudioSource* pclAudioSource, tU32 , tU8,tU16 SinkID )
{
  if (NULL != pclAudioSource)
   {
      pclAudioSource->vNotifyOnDone(SinkID);
   }
}

void clSrcState_On::vMsg_On(clAudioSource* pclAudioSource, tU32 ,tU16 SinkID )
{
   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (NULL != pclAudioSource &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_On(SinkID);
   }
}

void clSrcState_On::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
   //vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData);
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateStartMute(), u32UserData, SinkID);
}

void clSrcState_On::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData , tU16 SinkID )
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData, SinkID);
}

void clSrcState_On::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData , tU16 SinkID )
{
   // begin sequence again with init, because the play event was lost
    vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampUpInit(), u32UserData, SinkID);
}

}}//namespace
