/*
 * clExtGeniviAudioSource.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 *
 */

#include "include/audiomanagertypes.h"
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clExtGeniviAudioSource.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include <utility> 


using namespace am;

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clExtGeniviAudioSource.cpp.trc.h"
#endif

namespace AudioStack
{
namespace AudioSource
{

using namespace SourceStateMachine;


clExtGeniviAudioSource::clExtGeniviAudioSource(SourceID srcId, am_sourceID_t gam_sourceID, const am_Source_s* pSourceData) :
          clAudioSource(srcId),
          m_gam_handle(new am_Handle_s()),
          m_gam_SinkHandle(new am_Handle_s()),
          m_gam_connectionId(0)
          //m_activeSinkID(0)
{
    const clSourceClass& srcClass = clFactory_AudioSourceClass::GetSourceClass(srcId.enSourceClass);
    am_SourceClass_s am_SrcClass;
    am_sourceClass_t srcClassID = static_cast<am_sourceClass_t>(srcId.enSourceClass);
    am_SrcClass.sourceClassID = srcClassID;
    am_SrcClass.name          = srcClass.getName();
 
    ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource SrcClassID %d, SrcClassName %s \n",srcClassID,am_SrcClass.name.c_str()));

    if(pSourceData != NULL)
    {
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource assigned domainID: %d",pSourceData->domainID));
       m_gam_source_s.domainID = pSourceData->domainID;
       m_gam_source_s.name = pSourceData->name;  //daw2hi 17.08.2018 fixted after first check with avdecc. Should not use source class name

       m_gam_source_s.visible = pSourceData->visible; //daw2hi 11.09.2018 use what we get
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource visible %d",pSourceData->visible));
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource name %s",pSourceData->name.c_str()));
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource avail %d",pSourceData->available.availability));
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource reason %d",pSourceData->available.availabilityReason));
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource sourceID %d",pSourceData->sourceID));
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource sourceClassID %d",pSourceData->sourceClassID));
    }
    else
    {
       ETG_TRACE_USR4(("Controller: clExtGeniviAudioSource::clExtGeniviAudioSource domainID hardcoded to 1 !!!!!"));
       m_gam_source_s.domainID = 1;  //daw2hi 31.05.2017 all sources of this type are on the other RoutingPlugin. Can we find the domain of that? Cuurently hardcoded.
       m_gam_source_s.visible = true; 
       m_gam_source_s.name = srcClass.getName();
    }

    if(pSourceData != NULL)
    {
       m_gam_source_s.available.availability = pSourceData->available.availability;
       m_gam_source_s.available.availabilityReason = pSourceData->available.availabilityReason;
    }
    else
    {
       ETG_TRACE_ERR(("pSourceData is NULL"));
       m_gam_source_s.available.availability = A_UNAVAILABLE; // or should we put unknonw?
       m_gam_source_s.available.availabilityReason = AR_GENIVI_NOMEDIA; // or AR_UNKNOWN
    }
    am_MainSoundProperty_s msp = {MSP_MIC_STATUS_CONNECTION,(int16_t)0};
    m_gam_source_s.listMainSoundProperties.push_back(msp);
    am_MainSoundProperty_s msp_A = {MSP_MIC_STATUS_LEVEL,(int16_t)0};
    m_gam_source_s.listMainSoundProperties.push_back(msp_A);

    if(pSourceData != NULL)
       m_gam_source_s.name = pSourceData->name;  //daw2hi 17.08.2018 fixed after first check with avdecc. Should not use source class name

    if((srcClass.getRegistrationMode() == clSourceClass::registerExtDynamic) && (srcClass.bSupressSubSource == false))
    {
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
       char subSrc = (char)(0x30+srcId.u16SubSource);
       m_gam_source_s.name.insert(m_gam_source_s.name.end(),'#');
       m_gam_source_s.name.insert(m_gam_source_s.name.end(),subSrc);
#endif
    }
    m_gam_source_s.sourceID = 0;
    m_gam_source_s.visible = pSourceData->visible; //daw2hi 11.09.2018 use what we get

    if(srcClass.getRegistrationMode() == clSourceClass::registerExtStatic)
    {
		m_gam_source_s.available.availability = A_AVAILABLE;
        m_gam_source_s.available.availabilityReason = AR_UNKNOWN;
        if(gam_sourceID!=0)
        {
           m_gam_source_s.sourceID = gam_sourceID;
        }
        else
        {
         //For static source we'll provide a SourceID
           m_gam_source_s.sourceID = static_cast<am_sourceID_t>(srcClass.SourceClassID); //take fixed ids to make things easy
        }
    }

    //only when SubIDs are used we'll register with SubID(alias DeviceTag) as Genivi Name
    
    ETG_TRACE_USR4(("clExtGeniviAudioSource: Name %s", m_gam_source_s.name.c_str()));
    delete[] m_pacName;
    char *cstr = new char[m_gam_source_s.name.length() + 1];

    //VVD lint fix
    if(cstr){
       strcpy(cstr, m_gam_source_s.name.c_str());
       m_pacName = cstr;
    }
    ETG_TRACE_USR4(("clAudioSource: Changed Name %s", clAudioSource::pacGetName()));
    m_gam_source_s.sourceState = SS_OFF;
    m_gam_source_s.sourceClassID = srcId.enSourceClass;
    m_gam_source_s.volume = 0;
    m_gam_source_s.listConnectionFormats.push_back(CF_GENIVI_STEREO);
    m_gam_source_s.sourceID = clGeniviAudioCtrlAdapter::AddSource(m_SrcId, m_gam_source_s);
}

clExtGeniviAudioSource::~clExtGeniviAudioSource()
{
  clGeniviAudioCtrlAdapter::RemoveSource(m_gam_source_s.sourceID);
  delete(m_gam_handle);
  delete(m_gam_SinkHandle);
}

void clExtGeniviAudioSource::vPrint()
{
  ETG_TRACE_USR4(("%s", m_pacName));
  ETG_TRACE_USR4(("  | SourceClass: 0x%02x(%03d), SubID 0x%02x(%03d),"
      , m_SrcId.enSourceClass
      , m_SrcId.enSourceClass
      , m_SrcId.u16SubSource
      , m_SrcId.u16SubSource));
  ETG_TRACE_USR4(("  | MidwID 0x%02x(%03d)"
      , (tU16)clFactory_AudioSourceClass::GetExternalID(sGetId())
  , (tU16)clFactory_AudioSourceClass::GetExternalID(sGetId())));
  ETG_TRACE_USR4(("  | GeniviSrcID 0x%02x(%03d)"
      , m_gam_source_s.sourceID
      , m_gam_source_s.sourceID));

  //daw2hi: 8.8.2016 print only for sink 1
  const tChar* pStateName = pacGetState(1);
  ETG_TRACE_USR2(("  | State: %d (%s)"
      , ETG_CENUM(AudioStates::enAudioStates, pclGetState(1)->m_enStateID),pStateName));

  ETG_TRACE_USR4(("  | State: %d", ETG_CENUM(AudioStates::enAudioStates, m_pclState->m_enStateID)));
  ETG_TRACE_USR4(("  | Availability: %d", ETG_CENUM(clAudioSource::enSourceAvailability, m_availability)));
  ETG_TRACE_USR4(("  | AutoPlay: %d", ETG_CENUM(clSourceClass::autoplay_t, clFactory_AudioSourceClass::GetAutoPlayMode(sGetId()))));
  ETG_TRACE_USR4(("                "));
}

// ############################### new overrides ##################
//virtual
const am::am_Handle_s* clExtGeniviAudioSource::getHandle(const am_Handle_s* pHandle)
{
  if(pHandle == NULL) return NULL;
  std::map<tU16,am_sinkID_t>::iterator it;
  for(it = m_handleSourceSinkMap.begin(); it != m_handleSourceSinkMap.end(); it++)
  {
    if(it->first == pHandle->handle)
    {
      ETG_TRACE_USR4(("handle %d, type %d, sinkID %d, (m_curActSinkID %d), clExtGeniviAudioSource: %s",
          pHandle->handle,pHandle->handleType,it->second,m_curActSinkID,m_pacName));
      return pHandle;
    }
  }
  return NULL;
}

//virtual
const am::am_Handle_s* clExtGeniviAudioSource::getSinkHandle(const am_Handle_s* pHandle)
{
  if(pHandle == NULL) return NULL;
  std::map<tU16,am_sinkID_t>::iterator it;
  for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
  {
    if(it->first == pHandle->handle)
    {
      ETG_TRACE_USR4(("getSinkHandle: handle %d, type %d, m_curActSinkID %d, clExtGeniviAudioSource: %s",
          pHandle->handle,pHandle->handleType,m_curActSinkID,m_pacName));
      return pHandle;
    }
  }
  return NULL;
}

//only for debug
bool clExtGeniviAudioSource::print_handleSinkSinkMap(void)
{
	ETG_TRACE_USR4(("print_handleSinkSinkMap for source %s",m_pacName));
	for(auto it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
	{
		ETG_TRACE_USR4(("print_handleSinkSinkMap handle %d sink %d",it->first,it->second));
	}
	ETG_TRACE_USR4(("print_handleSinkSinkMap done"));
}
//virtual
bool clExtGeniviAudioSource::eraseSinkHandle(am_Handle_s handle)
{
	ETG_TRACE_USR4(("eraseSinkHandle for source %s",m_pacName));
	for(auto it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
	{
		if(it->first == handle.handle)
		{
			ETG_TRACE_USR4(("eraseSinkHandle for source %s",m_pacName));
			ETG_TRACE_USR4(("eraseSinkHandle from m_handleSinkSinkMap handle %d for sinkID %d",it->first,it->second));
			m_handleSinkSinkMap.erase(it);
			ETG_TRACE_USR4(("after erase, m_handleSinkSinkMap.size()=%d",m_handleSinkSinkMap.size()));
			//only for debug
			if(m_handleSinkSinkMap.size() > 0) print_handleSinkSinkMap();
			return true;
		}
	}
	ETG_TRACE_ERR(("handle %d.%d not found, can not erase",handle.handleType,handle.handle));
	return false;
}

//virtual
am::am_sinkID_t clExtGeniviAudioSource::getSinkIDByHandle(const am_Handle_s* pHandle)
{
	  if(pHandle == NULL) return (am_sinkID_t)0;
	  std::map<tU16,am_sinkID_t>::iterator it;
	  for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
	  {
	    if(it->first == pHandle->handle)
	    {
	      ETG_TRACE_USR4(("getSinkIDByHandle: handle %d, type %d, sinkID %d, (m_curActSinkID %d), clExtGeniviAudioSource: %s",
	          pHandle->handle,pHandle->handleType,it->second,m_curActSinkID,m_pacName));
	      return it->second;
	    }
	  }
	  return (am_sinkID_t)0;
}

#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
//virtual
tVoid clExtGeniviAudioSource::vMW_StartUnMute(const am_Handle_s* pHandle,tU16 SinkID)
{
    am_Handle_s tmpHandle;
    tmpHandle.handleType = H_UNKNOWN;
    tmpHandle.handle = 0;

    if(pHandle)
    {
        tmpHandle.handleType = pHandle->handleType;
        tmpHandle.handle = pHandle->handleType;
        ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute we have pHandle: %d.%d",pHandle->handleType,pHandle->handleType));
    }

    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_gam_SinkHandle);

    ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute we have m_gam_SinkHandle: %d.%d",m_gam_SinkHandle->handleType,m_gam_SinkHandle->handle));

    // we lost the handle here. Now consider current active sink instead

    (void)eraseHandleSinkSinkMap(SinkID);

    ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute() for Source %s", clAudioSource::pacGetName()));
    ETG_TRACE_USR4(("active Sink %d, in state %s",SinkID,this->pacGetState(SinkID)));
    ETG_TRACE_USR4(("m_gam_handle (type %d/%d)",m_gam_handle->handleType,m_gam_handle->handle));


    if(m_gam_SinkHandle->handleType == H_SETSINKVOLUME)
    {
        ETG_TRACE_USR4(("handleType == H_SETSINKVOLUME change type before setSinkVolume"));
        m_gam_SinkHandle->handleType =H_UNKNOWN;
    }

    am::am_Sink_s sinkData;
    am_Error_e err;
    if(clGeniviAudioCtrlAdapter::GetGeniviCtrlIF() != NULL)
        err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(static_cast<am_sinkID_t>(m_curActSinkID), sinkData);
    if(clGeniviAudioCtrlAdapter::getVolumeManager() != NULL)
    {
        //clGeniviAudioCtrlAdapter::getVolumeManager()->vClearMute(sinkData.name);
        //ETG_TRACE_USR4(("****** GeniviAudioCtrlAdapter::vMW_StartUnMute after ClearMute, before vSetAudioSource"));
        if(sinkData.name != "AMP_A" && sinkData.name != "AMP_B")
        {
            //VolumeManager has only handling for AMP_A and AMP_B so we have to call for own volume
            const am_volume_t volume = 30;
            const am_CustomRampType_t ramp = RAMP_GENIVI_NO_PLOP;
            const am_time_t timeToMute = 10;
            ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartUnMute call setSinkVolume (temp solution for Glass:  m_curActSinkID %d, SinkID %d)",m_curActSinkID, SinkID));
            err = clGeniviAudioCtrlAdapter::setSinkVolume(*m_gam_SinkHandle, m_curActSinkID, volume, ramp, timeToMute); //daw2hi use sink handle
            m_handleSinkSinkMap[m_gam_SinkHandle->handle] = SinkID;
        }
        else
        {
            ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartUnMute call vSetAudioSource"));
            //if this is a gateway, we need to fetch for the source of corresponding main
            std::string nameOfMainSource=m_gam_source_s.name;
            if(m_gam_source_s.name.compare("AMP_AnalogIn_A")==0)
            {
                clGeniviAudioCtrlAdapter::getTopOfGatewaySink(nameOfMainSource);

                if(nameOfMainSource.find('#') != -1)
                {
                    nameOfMainSource = nameOfMainSource.erase(nameOfMainSource.find('#'));
                }
            }

            //ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartUnMute audioSourceRequest with DEMUTE for source %s",nameOfMainSource.c_str()));
            //ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartUnMute audioSourceRequest with DEMUTE for sink %s",sinkData.name.c_str()));
            ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartUnMute audioSourceRequest with DEMUTE"));
            clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(nameOfMainSource, "DEMUTE", sinkData.name);
        }
    }

    ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute we have tmpHandle: %d.%d",tmpHandle.handleType,tmpHandle.handle));
    if(pHandle)
    {
        ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute we have pHandle: %d.%d",pHandle->handleType,pHandle->handleType));
    }

    //need to store handle, but delete old one
    ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartUnMute m_gam_SinkHandle %d, sinkID %d",m_gam_SinkHandle->handle, SinkID));
    //m_handleSinkSinkMap[m_gam_SinkHandle->handle] = SinkID;

    ETG_TRACE_USR4(("vMW_StartUnMute after setSinkVolume m_gam_SinkHandle(type %d/%d), m_gam_handle(type %d/%d)",
            m_gam_SinkHandle->handleType, m_gam_SinkHandle->handle, m_gam_handle->handleType,m_gam_handle->handle));

}
#else //for DBus ARL
//virtual
tVoid clExtGeniviAudioSource::vMW_StartUnMute(const am_Handle_s* pHandle,tU16 SinkID)
{
  (void)pHandle;
  for_each(m_handleSinkSinkMap.begin(), m_handleSinkSinkMap.end(), [](std::pair <tU16,am_sinkID_t> it) {ETG_TRACE_USR4(("clExtGeniviAudioSource m_handleSinkSinkMap we have handle %d with sink %d",it.first,it.second));});
  
  std::map<tU16,am_sinkID_t>::iterator it;
  for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
  {  
	if(it->second == SinkID)
    {
      ETG_TRACE_USR4(("clExtGeniviAudioSource we have handle %d with sink %d",it->first,it->second));
      m_handleSinkSinkMap.erase(it);
      break;
    }
  }
  
  ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute() for Source %s", clAudioSource::pacGetName()));
  ETG_TRACE_USR4(("active Sink %d, in state %s",SinkID,this->pacGetState(SinkID)));
  ETG_TRACE_USR4(("m_gam_handle (type %d/%d)",m_gam_handle->handleType,m_gam_handle->handle));

  unsigned short newSinkVolume=0;
  const am_volume_t volume = 10;
  const am_time_t timeToMute = 10;

  //Mute to be done with setting Volume 0
  SourceID NextSrc = this->u8GetNextSource();
  const am_CustomRampType_t ramp = this->getSourceClass().getRampType();

  clAudioSource* pAudSrc = NULL;
  pAudSrc = NULL;
  pAudSrc = clAudioSourceFactory::getAudioSource(NextSrc);
  if(pAudSrc != NULL)
  {
	  ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute() bGetVolumeStatus for source %s",pAudSrc->pacGetName()));
  }
 
  ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartUnMute() bGetVolumeStatus for gave volume %d ramp %d",newSinkVolume,ramp));
  clGeniviAudioCtrlAdapter::setSourceVolume(*m_gam_handle,u16GetGeniviSourceID(),volume,ramp,timeToMute);
  m_handleSinkSinkMap[m_gam_handle->handle] = SinkID;

}
#endif

//virtual
void clExtGeniviAudioSource::setSinkHandle(const am_Handle_s* pHandle, tU16 sinkID)
{
	if(pHandle)
	{
		ETG_TRACE_USR4(("clExtGeniviAudioSource::setSinkHandle for source %s",m_pacName));
		m_handleSinkSinkMap[pHandle->handle]=sinkID;
		ETG_TRACE_USR4(("clExtGeniviAudioSource::setSinkHandle handle %d, sinkID %d stored in m_handleSinkSinkMap with size %d",
				pHandle->handle, sinkID,m_handleSinkSinkMap.size()));

	}
	else
	{
		ETG_TRACE_USR4(("clExtGeniviAudioSource::setSinkHandle handle is NULL!!!"));
	}
}

//virtual
tVoid clExtGeniviAudioSource::vMW_UnMuted(const am_Handle_s* pHandle ,tU16 SinkID)
{
    if(pHandle == NULL) return;

    ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_UnMuted with handle %d and sinkID %d for source %s",pHandle->handle,SinkID,m_pacName));

    // check for the sink handle
    //bool bFound = false;
    // Map for handle.handle -> sinkID
    std::map<tU16,am_sinkID_t>::iterator it;

    for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
    {
        ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_UnMuted m_handleSinkSinkMap we have handle %d with sink %d",it->first,it->second));
    }

    for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
    {
        if(it->first == pHandle->handle)
        {
            ETG_TRACE_USR4(("clExtGeniviAudioSource vMW_UnMuted found handle %d with sinkID %d",pHandle->handle,it->second));
            m_curActSinkID = it->second;

            //we have it
            std::map<tU16,SourceStateMachine::clSrcState*>::iterator itState = sinkStateMap.find(it->second);

            if(itState!=sinkStateMap.end())
            {
                if((*itState).second != NULL)
                {
                    ETG_TRACE_USR4(("vMW_UnMuted Source: %d, SubSource %d, %s",this->m_SrcId.enSourceClass,this->m_SrcId.u16SubSource,this->m_pacName));
                    (*itState).second->vMsg_UnMuted(this, 0,m_curActSinkID);

                    ETG_TRACE_USR4(("vMW_UnMuted Source  will Set %d to CONNECTED",m_gam_source_s.sourceID));
                    if((m_gam_source_s.name.compare("CMP1_USB_VIDEO") == 0) || (m_gam_source_s.name.compare("CMP1_HDMI_Class") == 0))
                    {
                       am_Error_e  err = clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,m_curActSinkID,CS_CONNECTED);
                       ETG_TRACE_USR4(("vMW_UnMuted Source gave err %d, will Set to CONNECTED m_curActSinkID %d",err,m_curActSinkID));
                    }

                    //clear a possible mute???
                    if(false == bIsMuteEnetrtainOnStackInOnState(SinkID))
                    {
                        am::am_Sink_s sinkData;
                        if(clGeniviAudioCtrlAdapter::GetGeniviCtrlIF() != NULL)
                        {
                            (void)clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(static_cast<am_sinkID_t>(SinkID), sinkData);
                            ETG_TRACE_USR4(("Call changeSinkMuteStateDB mute state %d, sinkID %d",MS_UNMUTED,sinkData.sinkID));
                            clGeniviAudioCtrlAdapter::changeSinkMuteStateDB(MS_UNMUTED,sinkData.sinkID); //daw2hi not sure if needed
                        }
                    }
                }
            }
            //delete the handle entry
            if(it->first == pHandle->handle)
                m_handleSinkSinkMap.erase(it);
            else
            {
                ETG_TRACE_USR2(("Forgot to erase???"));
            }
            break;
        }

    }
}

// m_handleSinkSinkMap keeps handles in sink context
// if handle was found that matches the sink we erase the entry.

bool clExtGeniviAudioSource::eraseHandleSinkSinkMap(tU16 SinkID)
{

    std::map<tU16,am_sinkID_t>::iterator it;
    bool bErased=false;

    ETG_TRACE_USR4(("clExtGeniviAudioSource eraseHandleSinkSinkMap %s",m_gam_source_s.name.c_str()));

    for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
    {
        ETG_TRACE_USR4(("m_handleSinkSinkMap we have handle %d with sink %d",it->first,it->second));
    }
    //erase existing handle
    for(it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
    {
        if(it->second == SinkID)
        {
          ETG_TRACE_USR4(("we erase handle %d with sink %d",it->first,it->second));
          m_handleSinkSinkMap.erase(it);
          bErased=true;
          break;
        }
    }
    return bErased;
}
bool clExtGeniviAudioSource::bIsMuteEnetrtainOnStackInOnState(am_sinkID_t sinkID)
{
	clAudioSource* pSrc = clGeniviAudioCtrlAdapter::pcoGetTopOfStack(sinkID);
	std::string muteEntertain("MUTE_ENTERTAIN");
	std::string onState("on");
	if(pSrc != NULL)
	{
		if( (muteEntertain == pSrc->pacGetName()) && (onState == pSrc->pacGetState(sinkID)) )
		{
			ETG_TRACE_USR4(("We have MUTE_ENTERTAIN ON for sinkID %d", sinkID));
			return true;
		}
	}
	return false;

}

//virtual
tVoid clExtGeniviAudioSource::vMW_StartMute(const am_Handle_s* ,tU16 SinkID)
{
  //std::map<tU16,am_sinkID_t>::iterator it;
  
  ETG_TRACE_USR4(("clExtGeniviAudioSource vMW_StartMute %s",m_gam_source_s.name.c_str()));

  (void)eraseHandleSinkSinkMap(SinkID);
  
  vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_gam_SinkHandle);
  ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_StartMute() called for source %s", clAudioSource::pacGetName()));
  ETG_TRACE_USR4(("active Sink %d in state %s",SinkID,pacGetState(SinkID)));
  ETG_TRACE_USR4(("m_gam_SinkHandle(type %d/%d), m_gam_handle (type %d/%d)",
      m_gam_SinkHandle->handleType, m_gam_SinkHandle->handle, m_gam_handle->handleType,m_gam_handle->handle));
  ETG_TRACE_USR4(("calling clGeniviAudioCtrlAdapter::setSinkVolume with volume %d",MUTE_VOLUME));

  //Mute to be done with setting Volume 0
  const am_volume_t volume = MUTE_VOLUME;
 // SourceID NextSrc = this->u8GetNextSource();
  am_CustomRampType_t ramp;
  const am_time_t timeToMute = 10;
  am::am_Sink_s sinkData;
  am_Error_e err = E_UNKNOWN;
  
  if(clGeniviAudioCtrlAdapter::GetGeniviCtrlIF() != NULL)
    err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(static_cast<am_sinkID_t>(m_curActSinkID), sinkData);

  if(err != E_OK)
    {
	  ETG_TRACE_USR4(("Sink database error"));
	  return;
    }
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
  if(sinkData.name != "AMP_A" && sinkData.name != "AMP_B")
  {
    m_gam_SinkHandle->handleType =H_UNKNOWN;
    m_gam_SinkHandle->handle = 0;

    //VolumeManager has only handling for AMP_A and AMP_B so we have to call for own volume
    ramp = RAMP_GENIVI_NO_PLOP;
    ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartMute call setSinkVolume (temp solution for Glass)"));
    err = clGeniviAudioCtrlAdapter::setSinkVolume(*m_gam_SinkHandle, m_curActSinkID, volume, ramp, timeToMute); //daw2hi use sink handle
  }
  else if(clGeniviAudioCtrlAdapter::getVolumeManager() != NULL)
  {
		//if this is a gateway, we need to fetch for the source of corresponding main
		std::string nameOfMainSource=m_gam_source_s.name;
		if(m_gam_source_s.name.compare("AMP_AnalogIn_A")==0)
		{
		   clGeniviAudioCtrlAdapter::getTopOfGatewaySink(nameOfMainSource);

		   if(nameOfMainSource.find('#') != -1)
		   {
			   nameOfMainSource = nameOfMainSource.erase(nameOfMainSource.find('#'));
		   }
		}

        //Hack to overcome bug in Volume
		bool bMuteSent=false;
		ETG_TRACE_USR4(("nameOfMainSource %s",nameOfMainSource.c_str()));
        if(   nameOfMainSource != "AMP_AnalogIn_A"
           && nameOfMainSource != "AVB_Mic2"
           && nameOfMainSource != "AVB_Mic3")
        {
        	ETG_TRACE_USR4(("Hit the Hack"));
        	//clAudioSource* pTopSrc = clGeniviAudioCtrlAdapter::pcoGetTopOfStack(sinkData.sinkID);
        	clAudioSource* pTopMixSrc = clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(sinkData.sinkID);
        	if(pTopMixSrc != NULL)
        	{
        		std::string topSrcName = pTopMixSrc->pacGetName();
        		ETG_TRACE_USR4(("Hit the Hack source is %s",topSrcName.c_str()));
        		if(topSrcName == "AVB_Mic2" || topSrcName == "AVB_Mic3")
        		{
        			ETG_TRACE_USR4(("Hack to overcome VolumeManager bug: send MuteVolume %d to sinkID %d with name %s",
        					MUTE_VOLUME,m_curActSinkID,sinkData.name.c_str()));
        			err = clGeniviAudioCtrlAdapter::setSinkVolume(*m_gam_SinkHandle, m_curActSinkID, MUTE_VOLUME, ramp, timeToMute); //daw2hi use sink handle
        			bMuteSent=true;
        		}
        	}
        	else
			{
        		ETG_TRACE_USR4(("pTopSrc is NULL"));
			}
        }

        if(bMuteSent==false)
        {
            //ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartMute audioSourceRequest with MUTE for source %s",nameOfMainSource.c_str()));
            //ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartMute audioSourceRequest with MUTE for sink %s",sinkData.name.c_str()));
            ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartMute audioSourceRequest with MUTE"));
            clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(nameOfMainSource,"MUTE",sinkData.name);
        }

        // end of hack

        //ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartMute vSetMute to sink %s",sinkData.name.c_str()));
        //clGeniviAudioCtrlAdapter::getVolumeManager()->vClearMuteFlag(sinkData.name);
        //clGeniviAudioCtrlAdapter::getVolumeManager()->vSetMute(sinkData.name);
  }
#else
  // for dbus-arl
  else
  {
	SourceID NextSrc = this->u8GetNextSource();
    clAudioSource* pNextAudSrc = clAudioSourceFactory::getAudioSource(NextSrc);
    if(pNextAudSrc)
	  ramp = pNextAudSrc->getSourceClass().getRampType();
    else
	  ramp = RAMP_SLOW;
  
    m_gam_SinkHandle->handleType =H_UNKNOWN;
    clGeniviAudioCtrlAdapter::setSourceVolume(*m_gam_SinkHandle,u16GetGeniviSourceID(),volume,ramp,timeToMute);
  }
#endif
  ETG_TRACE_USR4(("GeniviAudioCtrlAdapter::vMW_StartMute sinkHandle %d, sinkID %d with err %d",m_gam_SinkHandle->handle, SinkID, err));
  m_handleSinkSinkMap[m_gam_SinkHandle->handle] = SinkID;

  ETG_TRACE_USR4(("vMW_StartMute after setSinkVolume m_gam_SinkHandle(type %d/%d), m_gam_handle (type %d/%d)",
      m_gam_SinkHandle->handleType, m_gam_SinkHandle->handle, m_gam_handle->handleType, m_gam_handle->handle));
	  
}

// m_handleSourceSinkMap keeps handles in source context
// if handle was found and erased we have copied handle and sink to our members
//bool clExtGeniviAudioSource::eraseHandleSourceSinkMap(const am_Handle_s* pHandle, std::string calledFrom)
bool clExtGeniviAudioSource::eraseHandleSourceSinkMap(const am_Handle_s* pHandle)
{
    bool bErased = false;
    std::map<tU16,am_sinkID_t>::iterator it;

    for(it = m_handleSourceSinkMap.begin(); it != m_handleSourceSinkMap.end(); it++)
    {
        //ETG_TRACE_USR4(("%s",calledFrom.c_str()));
        ETG_TRACE_USR4(("eraseHandleSourceSinkMap found handle %d, sinkID is %d, clExtGeniviAudioSource: %s",it->first,it->second,m_pacName));
    }

    for(it = m_handleSourceSinkMap.begin(); it != m_handleSourceSinkMap.end(); it++)
    {
        if(it->first == pHandle->handle)
        {
            ETG_TRACE_USR4(("Found handle %d, sinkID is %d (will be erased)",it->first,it->second));
            m_curActSinkID = it->second;
            *m_gam_handle = *pHandle;
            // erase it from active handle
            m_handleSourceSinkMap.erase(it);
            bErased = true;
            break;
        }
    }
    return bErased;
}

tVoid clExtGeniviAudioSource::vCbAckSetSourceState_PAUSE()
{
    ETG_TRACE_USR4(("m_logicalSourceStates in SS_PAUSED, will call changeMainConnectionStateDB source %d, sink %d, CS_SUSPENDED",m_gam_source_s.sourceID,m_curActSinkID));
    am_Error_e err = clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,m_curActSinkID,CS_SUSPENDED);
    ETG_TRACE_USR4(("m_logicalSourceStates in SS_PAUSED, will call vMW_CCAResponse with Pause error : %d",(int)err));
    vMW_CCAResponse(0,0,Pause,m_curActSinkID); //context is always O.K.
    return;
}

tVoid clExtGeniviAudioSource::vCbAckSetSourceState_ON()
{
    am_Error_e err = E_UNKNOWN;
    ETG_TRACE_USR4(("changeMainConnectionStateDB will call vMW_OnDone %d",m_gam_source_s.sourceID));
    if(!((m_gam_source_s.name.compare("CMP1_USB_VIDEO") == 0) || (m_gam_source_s.name.compare("CMP1_HDMI_Class") == 0)))
    {//For Bug_2073611 Need to Avoid Early CONNECTED State for CMP1_USB will Connected during vMW_UnMuted
      err = clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,m_curActSinkID,CS_CONNECTED);
      ETG_TRACE_USR4(("changeMainConnectionStateDB gave err %d, will call vMW_OnDone",err));
    }

    //ToDo: add the connection to the List
    //get sink from handle
    std::vector<am_Connection_s> listUpdatedConnections;
    err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections(listUpdatedConnections);
    std::vector<mainConnectionEntry_s> mainConnectionEntries =clGeniviAudioCtrlAdapter::getMainConnectionEntries();
    am::am_mainConnectionID_t mainID=0;
    am_connectionID_t connectionID =0;
    for(size_t i=0;i<mainConnectionEntries.size();i++)
    {
        for(size_t k=0;k<mainConnectionEntries[i].subConnectionList.size();k++)
        {
            if(   (mainConnectionEntries[i].subConnectionList[k].sinkID == m_curActSinkID)
               && (mainConnectionEntries[i].subConnectionList[k].sourceID == m_gam_source_s.sourceID) )
            {
                mainID = mainConnectionEntries[i].mainID;
                connectionID = mainConnectionEntries[i].subConnectionList[k].connectionID;
                break;
            }
        }
        if(mainID!=0) break;
    }
    std::vector<am_MainConnection_s> listMainConnections;
    std::vector<am_connectionID_t>::iterator conIt;
    clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListMainConnections(listMainConnections);
    for(size_t i=0;i<listMainConnections.size();i++)
    {
        if(listMainConnections[i].mainConnectionID == mainID)
        {
            //do not add twice, so check first if already existing
            if(listMainConnections[i].listConnectionID.end() ==
                    std::find(listMainConnections[i].listConnectionID.begin(),listMainConnections[i].listConnectionID.end(),connectionID))
            {
                listMainConnections[i].listConnectionID.push_back(connectionID);
                err =clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->changeMainConnectionRouteDB(mainID, listMainConnections[i].listConnectionID);
            }
            else
            {
                ETG_TRACE_USR4(("already in list, we do not add again"));
            }
            break;
        }
    }
    vMW_OnDone(m_curActSinkID); //This should bring the source in ON state
}


tVoid clExtGeniviAudioSource::vCbAckSetSourceState_OFF()
{
	//daw2hi 22.08.2018 add the disconnect here after SoureState is Off
	std::vector<am_Connection_s> listUpdatedConnections;
	std::vector<am_Connection_s>::const_iterator subIt;
	am_Error_e err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections(listUpdatedConnections);
	bool bDisconnect = false ;
	for(subIt=listUpdatedConnections.begin();subIt!=listUpdatedConnections.end();subIt++)
	{
		ETG_TRACE_USR4(("SubConID %d: SrcID %d -> SinkID %d",subIt->connectionID,subIt->sourceID,subIt->sinkID));
		if((subIt->sourceID == u16GetGeniviSourceID()) && (subIt->sinkID == m_curActSinkID))
		{
			if(m_gam_handle->handleType == H_DISCONNECT && (m_logicalSourceStates[m_curActSinkID] == am::SS_PAUSED))
			{
				ETG_TRACE_USR4(("handleType == H_DISCONNECT change type before disconnect"));
				m_gam_handle->handleType =H_UNKNOWN;
			}

			//this is the connection we need to disconnect
			ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect"));

			//need to check if we have to inform VoluemManager
			err = clGeniviAudioCtrlAdapter::informVolumeManager(subIt->connectionID);

			err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect(*m_gam_handle,subIt->connectionID);
			ETG_TRACE_USR4(("called clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect handle %d (type: %d/%d), ID %d with err %d",
					m_gam_handle->handle,m_gam_handle->handleType,m_gam_handle->handle,subIt->connectionID,err));
			m_handleSourceSinkMap[m_gam_handle->handle] = m_curActSinkID;
			bDisconnect = true;
			return;
		}
	} // for()

	vMW_OffDone(m_curActSinkID); //This should bring the source in OFF state and remove it from stack
	err = clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID,m_curActSinkID);
	ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeMainConnection (sourceID %d - sinkID %d) returns Error %d",m_gam_source_s.sourceID,m_curActSinkID,err));
}

// ############################### new overrides end ##################

// virtual
tVoid clExtGeniviAudioSource::vCbAckSetSourceState(const am_Handle_s* pHandle)
{
  if(pHandle == NULL) return;

  // if handle was found and erased we have handle and sink in our members
  // m_gam_handle and m_gam_handle
  //if(false == eraseHandleSourceSinkMap(pHandle, std::string("vCbAckSetSourceState")))
  if(false == eraseHandleSourceSinkMap(pHandle))
  {
      ETG_TRACE_USR4(("handle (%d/%d) not found, not for this source, return",pHandle->handleType, pHandle->handle));
      return;
  }


  ETG_TRACE_USR4(("%s called with vCbAckSetSourceState",pacGetName()));
  ETG_TRACE_USR4(("in state %s",this->pacGetState(m_curActSinkID)));
  ETG_TRACE_USR4(("m_logicalSourceStates[%d]=%d",m_curActSinkID,m_logicalSourceStates[m_curActSinkID]));
  ETG_TRACE_USR4(("handle is (type: %d/%d)",m_gam_handle->handleType,m_gam_handle->handle));

  //check the state for this sink. Are we SS_ON or SS_OFF
  if(m_logicalSourceStates[m_curActSinkID] == am::SS_ON)  //ToDo: make this safe
  {
      vCbAckSetSourceState_ON();

  }
  else if(m_logicalSourceStates[m_curActSinkID] == am::SS_PAUSED)
  {
      vCbAckSetSourceState_PAUSE();
  }
  else
  {
	  //is this always SS_OFF
	  vCbAckSetSourceState_OFF();
  }
  return;

}

bool clExtGeniviAudioSource::findHandleSourceSinkMap(const am_Handle_s* pHandle)
{
    bool bMyHandle =false;
    for(auto it = m_handleSourceSinkMap.begin(); it != m_handleSourceSinkMap.end(); it++)
    {
//      ETG_TRACE_USR4(("vCbAckDisconnect found handle %d, sinkID is %d, (m_curActSinkID %d), clExtGeniviAudioSource: %s",
//              it->first,it->second,m_curActSinkID,m_pacName));
      if(it->first == pHandle->handle) bMyHandle=true;
    }
    return bMyHandle;
}


// virtual
tVoid clExtGeniviAudioSource::vCbAckDisconnect(const am_Handle_s* pHandle)
{
  if(pHandle == NULL) return;
  //ETG_TRACE_USR4(("Got vCbAckDisconnect with handle %d, type %d, clExtGeniviAudioSource: %s",pHandle->handle,pHandle->handleType,m_pacName));

  if(true == findHandleSourceSinkMap(pHandle))
  {
      ETG_TRACE_USR4(("Got vCbAckDisconnect with handle %d, type %d, clExtGeniviAudioSource: %s",pHandle->handle,pHandle->handleType,m_pacName));
  }


  //if(false == eraseHandleSourceSinkMap(pHandle, std::string("vCbAckDisconnect"))) return;
  if(false == eraseHandleSourceSinkMap(pHandle)) return;


  //ToDo: this could be wrong, because m_curActSinkID might be wrong. Better to search for the handle
  if(m_logicalSourceStates[m_curActSinkID] == am::SS_PAUSED)
  {
      vMW_PauseDone(m_curActSinkID);
      return;
  }

  ETG_TRACE_USR4(("will call vMW_OffDone for SinkID %d (%s)",m_curActSinkID,m_pacName));
  vMW_OffDone(m_curActSinkID); //This should bring the source in OFF state and remove it from stack

  ETG_TRACE_USR4(("Got vCbAckDisconnect for sink %d in state %s",m_curActSinkID,this->pacGetState(m_curActSinkID)));
  ETG_TRACE_USR4(("m_gam_connectionId %d",m_gam_connectionId));
  am_Error_e err = clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID,m_curActSinkID);
  ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeMainConnection (sourceID %d - sinkID %d) returns Error %d",m_gam_source_s.sourceID,m_curActSinkID,err));
}

// virtual
tVoid clExtGeniviAudioSource::vCbAckConnect(const am_Handle_s* pHandle)
{
  if(pHandle == NULL) return;
  if(m_handleSourceSinkMap.size() == 0) return;

  ETG_TRACE_USR4(("Got vCbAckConnect with handle %d, type %d, m_curActSinkID(%d), clExtGeniviAudioSource: %s",
		  pHandle->handle,pHandle->handleType,m_curActSinkID,m_pacName));



  if(false == eraseHandleSourceSinkMap(pHandle)) return;



  ETG_TRACE_USR4(("Got vCbAckConnect for sink %d in state %s",m_curActSinkID,this->pacGetState()));
  //25.07.2016 daw2hi check if we have already an ON
  tBool bAlreadyOn = false, bPause = false;
  for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
  {
    if((it->first != m_curActSinkID) && (it->second == SS_ON))
    {
      //source is in SS_ON on another sink
      bAlreadyOn = true;
      break;
    }
    if((it->first == m_curActSinkID) && (it->second == SS_PAUSED))
    {
        //source is in SS_PAUSED on this sink
    	bPause = true;
      break;
    }
  }
   ETG_TRACE_USR4(("vCbAckConnect called call setSourceState with  SS_PAUSED : %d",(int)bPause));
  clSourceClass sourceClass = clFactory_AudioSourceClass::GetSourceClass((sourceClassID)m_gam_source_s.sourceClassID);

  if(!bAlreadyOn)
  {
    ETG_TRACE_USR4(("vCbAckConnect called call setSourceState with SS_ON"));
  }
  else
  {
    //if already on what should we do? daw2hi: 26.06.2017
    ETG_TRACE_USR4(("vCbAckConnect called when already on, call again setSourceState with SS_ON"));
  }

  am_SourceState_e state = SS_ON;
  vSetSourceState(state);
}

tVoid clExtGeniviAudioSource::vSetSourceState(am_SourceState_e state)
{
    m_gam_handle->handleType = H_UNKNOWN;
    am_Error_e err = clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_ON);
    ETG_TRACE_USR4(("clExtGeniviAudioSource::vSetSourceState state %d for %s",state,m_pacName));
    ETG_TRACE_USR4(("state %s",pclGetState()->m_pacName));
    ETG_TRACE_USR4(("after clGeniviAudioCtrlAdapter::setSourceState handleType %d, handle %d, err %d",m_gam_handle->handleType, m_gam_handle->handle,err));
    //need to store handle
    m_handleSourceSinkMap[m_gam_handle->handle] = m_curActSinkID;
}

// virtual
tVoid clExtGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, tU16 subSrc, enSourceActivity activity)
{
  tU8 sinkID = (tU8)1;
  // use m_curActSinkID instead ??
  ETG_TRACE_ERR(("called vMW_CCAResponse without SinkID, using SinkID 1"));
  vMW_CCAResponse(extSourceId,subSrc,activity, sinkID);
}

//virtual
// daw2hi we need the sinkID also to identify for which sink the CCA Response was called
tVoid clExtGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, tU16 subSrc, enSourceActivity activity, tU16 sinkID)
{
  //VVD lint fix
  if(NULL == m_gam_handle)
    return;

  am_Error_e err = E_UNKNOWN;
  //SourceStateMachine::clSrcState* clActSrcState = pclGetState(m_curActSinkID);
  SourceStateMachine::clSrcState* clActSrcState = pclGetState(sinkID);

  ETG_TRACE_USR4(("vMW_CCAResponse: Ext-SourceID: %d, SubID: %d Activity: %d Sink %d clExtGeniviAudioSource: %s", extSourceId, subSrc, activity, sinkID, m_pacName));
  switch(activity)
  {
  case clExtGeniviAudioSource::On:
    ETG_TRACE_USR4(("vMW_CCAResponse: On sourceID %d --> sinkID %d, m_gam_connectionId %d",m_gam_source_s.sourceID,sinkID,m_gam_connectionId));
    ETG_TRACE_USR4(("handle %d, type %d",(*m_gam_handle).handle, (*m_gam_handle).handleType));

    if( clActSrcState == clSrcStateFactory::pclCreateRampUpRequesting())
    {
      if(m_gam_handle->handleType == H_CONNECT) m_gam_handle->handleType = H_UNKNOWN;
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
	  
	  bool bConnectionExisting = false;
	  std::vector<am_Connection_s> listUpdatedConnections;
      std::vector<am_Connection_s>::const_iterator subIt;
	  err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections(listUpdatedConnections);
	  for(unsigned int i =0;i<listUpdatedConnections.size();i++)
	  {
		if(   (listUpdatedConnections[i].sourceID == m_gam_source_s.sourceID)
		   && (listUpdatedConnections[i].sinkID == sinkID) )
		{
			//ups we have this connection already.
			ETG_TRACE_ERR(("Connection sourceID %d - sinkID %d existing as ID %d",m_gam_source_s.sourceID,sinkID,listUpdatedConnections[i].connectionID));
			bConnectionExisting=true;
		}
		else
		{
			ETG_TRACE_USR4(("Other Connection sourceID %d - sinkID %d existing as ID %d",m_gam_source_s.sourceID,sinkID,listUpdatedConnections[i].connectionID));
		}
	  }

	  if(!bConnectionExisting)
	  {
		  err = clGeniviAudioCtrlAdapter::connect((*m_gam_handle), m_gam_connectionId,
			  CF_GENIVI_STEREO,
			  m_gam_source_s.sourceID,
			  static_cast<am_sinkID_t>(sinkID));
		  if(err != E_OK)
		  {
			  ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::connect source ID %d - sinkIS %d gave err %d",m_gam_source_s.sourceID,sinkID,err));
		  }
	  }
	  else
	  {
		  ETG_TRACE_ERR(("Skip Connect because already existing. Call SetSourceState"));
		  //should set state to ON
		  err = clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_ON);
	  }
#else

      err = clGeniviAudioCtrlAdapter::connect((*m_gam_handle), m_gam_connectionId,
          CF_GENIVI_STEREO,
          m_gam_source_s.sourceID,
          static_cast<am_sinkID_t>(sinkID));
      if(err != E_OK)
      {
    	  ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::connect source ID %d - sinkIS %d gave err %d",m_gam_source_s.sourceID,sinkID,err));
      }
      if(err==E_ALREADY_EXISTS)
      {
        am_SourceState_e state = SS_ON;
        vSetSourceState(state);
      }
#endif
      //daw2hi 21.08.2018: check if we could also combine sinkID with handle to know for which sinkID the ack will be.
      m_curActSinkID = sinkID;

      //lets store the handle
      m_handleSourceSinkMap[m_gam_handle->handle] = sinkID;
      ETG_TRACE_USR4(("vMW_CCAResponse: On stored handle %d -> sink %d",m_gam_handle->handle, sinkID));
      ETG_TRACE_USR4(("vMW_CCAResponse: On before changeMainConnectionRouteDB"));
      ETG_TRACE_USR4(("adding m_gam_connectionId %d to empty connectionList",m_gam_connectionId));
      std::vector<am_connectionID_t> connectionList;
      std::vector<am::am_Connection_s> tempConnectionList;
      //      connectionList.push_back(m_gam_connectionId);

      //Need to check if we have additional subconnections
      std::vector<mainConnectionEntry_s> mainConnectionEntries =clGeniviAudioCtrlAdapter::getMainConnectionEntries();
      for(unsigned int mainID = 0;mainID<mainConnectionEntries.size();mainID++ )
      {
        for(unsigned int subID=0;subID<mainConnectionEntries[mainID].subConnectionList.size();subID++)
        {
          ETG_TRACE_USR4(("Checking mainID %d",mainConnectionEntries[mainID].mainID));
          ETG_TRACE_USR4(("mainConnectionEntries[%d].subConnectionList[%d] sourceID %d, sinkID %d, MainConID %d, subConID %d ",
              mainID,subID,
              mainConnectionEntries[mainID].subConnectionList[subID].sourceID,
              mainConnectionEntries[mainID].subConnectionList[subID].sinkID,
              mainConnectionEntries[mainID].mainID,
              mainConnectionEntries[mainID].subConnectionList[subID].connectionID));

          if(  (mainConnectionEntries[mainID].subConnectionList[subID].sourceID == m_gam_source_s.sourceID)
              && (mainConnectionEntries[mainID].subConnectionList[subID].sinkID == sinkID) )
          {
            ETG_TRACE_USR4(("This is for mainID %d and subConnectionList size is %d",
                mainConnectionEntries[mainID].mainID,
                mainConnectionEntries[mainID].subConnectionList.size()));
            tempConnectionList = mainConnectionEntries[mainID].subConnectionList;
            break;
          }
        }
        if(tempConnectionList.size()>0) break;
      }

      for(unsigned int i=0;i<tempConnectionList.size();i++)
      {
        ETG_TRACE_USR4(("tempConnectionList[%d]=%d",i,tempConnectionList[i].connectionID));
        if(tempConnectionList[i].connectionID != 0)
        {
          ETG_TRACE_USR4(("pushing ID %d for Source %d -> Sink %d to connectionList",
              tempConnectionList[i].connectionID, tempConnectionList[i].sourceID,tempConnectionList[i].sinkID));
          connectionList.push_back(tempConnectionList[i].connectionID);
        }
      }
      err = clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(m_gam_source_s.sourceID, sinkID, connectionList); //daw2hi 24.10.2017 added param sinkID
      //err = clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID),CS_CONNECTED);

      vSetCurActSink(sinkID); //daw2hi 21.07.2016
      m_logicalSourceStates[sinkID]=SS_ON; //22.07.2016

      //vMW_OnDone(sinkID); //should be done when we call set source state or even when ackSetSOurceState is received
    }
    break;
  case clExtGeniviAudioSource::Pause:
    {
      vSetCurActSink(sinkID); //daw2hi 21.07.2016
      m_logicalSourceStates[sinkID]=SS_PAUSED; //22.07.2016
      m_gam_handle->handleType =H_UNKNOWN;
      //this is the connection we need to disconnect
      //ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect"));


      // ???? Set source to Pause here ?????
      vMW_PauseDone(sinkID);


	}
    break;
  case clExtGeniviAudioSource::Off:
    ETG_TRACE_USR4(("clExtGeniviAudioSource::Off clActSrcState: %s",clActSrcState->m_pacName));
    ETG_TRACE_USR4(("updating m_gam_connectionId %d",m_gam_connectionId));
    clGeniviAudioCtrlAdapter::getSubConID(m_gam_source_s.sourceID,sinkID,m_gam_connectionId);
    ETG_TRACE_USR4(("to m_gam_connectionId %d",m_gam_connectionId));
    if(  (clActSrcState == clSrcStateFactory::pclCreateRampDownToOff())
        ||(clActSrcState == clSrcStateFactory::pclCreateOff()))
    {
      //25.07.2016 daw2hi check if we have already an ON
      tBool bAnotherOn = false;
      for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
      {
        if((it->first != sinkID) && (it->second == SS_ON))
        {
          bAnotherOn = true;
          break;
        }
      }
      am_Error_e err = E_UNKNOWN;
      if(!bAnotherOn)
      {
        ETG_TRACE_USR4(("vMW_CCAResponse: Off handle %d -> sink %d in state %s",m_gam_handle->handle, sinkID, clActSrcState->m_pacName));
        clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_OFF);
        //lets store the handle
        m_handleSourceSinkMap[m_gam_handle->handle] = sinkID;
        ETG_TRACE_USR4(("vMW_CCAResponse: Off stored handle %d -> sink %d",m_gam_handle->handle, sinkID));
      }

      am::am_Sink_s sinkData;
      err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(static_cast<am_sinkID_t>(sinkID), sinkData);
      if((m_gam_source_s.visible) && (sinkData.visible))
      {
        ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_CCAResponse for visible sourceID %d",m_gam_source_s.sourceID));
        ETG_TRACE_USR4(("assume it is a main connection -> we should call disconnect and removeMainConnection"));
      }
      else
      {
        ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_CCAResponse for non visible sourceID %d (vis %d), sinkID %d (vis %d)",
            m_gam_source_s.sourceID,m_gam_source_s.visible,sinkID,sinkData.visible));
      }
      //daw2hi 12.03.2018 should this come after cbAckSetSourceState
      if(bAnotherOn)
      {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::disconnect we have another ON, m_gam_connectionId %d is not correct",m_gam_connectionId));

        err = clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::disconnect for connectionId %d, returns Error %d",m_gam_connectionId,err));
        //lets store the handle
        m_handleSourceSinkMap[m_gam_handle->handle] = sinkID;
        ETG_TRACE_USR4(("vMW_CCAResponse called disconnect: stored handle %d -> sink %d",m_gam_handle->handle, sinkID));
      }

      //we will dump some data daw2hi 8.3.2018
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::disconnect dump data start ##########"));
      {
        std::vector<am_MainConnection_s> listUpdatedMainConnections;
        err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListMainConnections(listUpdatedMainConnections);
        std::vector<am_MainConnection_s>::const_iterator dumpIt;
        for(dumpIt=listUpdatedMainConnections.begin();dumpIt!=listUpdatedMainConnections.end();dumpIt++)
        {

          ETG_TRACE_USR4(("MainConID %d: SrcID %d -> SinkID %d, subCon size %d",
              dumpIt->mainConnectionID,dumpIt->sourceID,dumpIt->sinkID,dumpIt->listConnectionID.size()));
          for(unsigned int k=0;k<dumpIt->listConnectionID.size();k++)
          {
            ETG_TRACE_USR4(("SubCon ID %d",dumpIt->listConnectionID[k]));
          }
          ETG_TRACE_USR4(("--------------------------------------------------"));
        }
        ETG_TRACE_USR4(("Dump All Connections"));
        std::vector<am_Connection_s> listUpdatedConnections;
        std::vector<am_Connection_s>::const_iterator subIt;
        err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections(listUpdatedConnections);
        for(subIt=listUpdatedConnections.begin();subIt!=listUpdatedConnections.end();subIt++)
        {
          ETG_TRACE_USR4(("SubConID %d: SrcID %d -> SinkID %d",
              subIt->connectionID,subIt->sourceID,subIt->sinkID));
        }
      }
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::disconnect dump data end ##########"));

      vSetCurActSink(sinkID); //daw2hi 21.07.2016
      m_logicalSourceStates[sinkID]=SS_OFF; //22.07.2016
      // do this when cbAckSetSourceState was received
      //vMW_OffDone(sinkID);
    }
    break;
  default:
    break;
  }
}

// virtual
tVoid clExtGeniviAudioSource::vMW_Pause(SourceID possibleNextSrc,tU16 sinkID)
{
  ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_Pause()"));
  am_mainConnectionID_t mainConnectionID;
  clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();


  ETG_TRACE_USR4(("GAS vMW_Pause: SourceClass: %d subID %d, ExtId %d, PNSClass %d PNSsubID %d"
      , sGetId().enSourceClass
      , sGetId().u16SubSource
      , myExtID
      , possibleNextSrc.enSourceClass
      , possibleNextSrc.u16SubSource));

  vMW_StartMute(NULL,sinkID);
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
  if(clGeniviAudioCtrlAdapter::getVolumeManager() != NULL)
  {
	  //we might have to set the audio source here
	  if(m_gam_source_s.name == "AVB_Mic2" || m_gam_source_s.name == "AVB_Mic3")
	  {
		  vMW_PauseDone(sinkID);
		  am_Error_e err = clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,sinkID,CS_SUSPENDED);

	  }
  }

#endif


}

tVoid clExtGeniviAudioSource::vMW_Off(SourceID possibleNextSrc,tU16 sinkID)
{
  clSourceClass::externalID extID = clFactory_AudioSourceClass::GetSourceClass(possibleNextSrc.enSourceClass).getExtID();
  clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
  ETG_TRACE_USR4(("GAS vMW_Off: SourceClass: %d subID %d, ExtId %d, PNSClass %d PNSsubID %d PNSextID %d"
      , sGetId().enSourceClass
      , (tU16)sGetId().u16SubSource
      , myExtID
      , possibleNextSrc.enSourceClass
      , possibleNextSrc.u16SubSource
      , extID));

  // If our logical state for this sink is SS_PAUSED and we get off check if we need to call disconnect from this sink
  if(m_logicalSourceStates[sinkID] == SS_PAUSED)
  {
      disconnect(m_gam_source_s.sourceID,sinkID);
  }
  //don't interact with AudioRouteMgr
  am_Error_e err = clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID),CS_DISCONNECTING);
  if(err != E_OK)
  {
	  ETG_TRACE_ERR(("GAS vMW_Off: changeMainConnectionStateDB sourceID %d - sinkID %d gave err %d",m_gam_source_s.sourceID,sinkID,err));
  }

  vMW_CCAResponse(0,0,Off,sinkID);//extSrcID and subSrc not needed, set to 0
  ETG_TRACE_USR4(("GAS vMW_Off: after vMW_CCAResponse() we have m_logicalSourceStates[%d] = %d",sinkID,m_logicalSourceStates[sinkID]));

}

// virtual
tVoid clExtGeniviAudioSource::vMW_On(tU16 sinkID)
{
  ETG_TRACE_USR4(("clExtGeniviAudioSource::vMW_On() for Src %d --> Sink %d",m_gam_source_s.sourceID, sinkID));
  am_mainConnectionID_t mainConnectionID=0;
  //clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
  //Check if we have a MainConnection
  //if(clGeniviAudioCtrlAdapter::getMainConnectionOfSource(m_gam_source_s.sourceID, m_curActSinkID, mainConnectionID) != E_OK)
  //daw2hi 9.3.2018 changed
  if(clGeniviAudioCtrlAdapter::getMainConnectionOfSourceSink(m_gam_source_s.sourceID, sinkID, mainConnectionID) != E_OK)
  {
    ETG_TRACE_USR4(("vMW_On(): Add MainConnection for Source %d, Sink %d", m_gam_source_s.sourceID, sinkID));
    //e.g. restore LSM we need to add a connection initiation by our own
    // skip addMainConnection if source not visible
    const AudioStack::clSourceClass srcClass = clFactory_AudioSourceClass::GetSourceClass((sourceClassID)m_gam_source_s.sourceClassID);
    am_Error_e retVal = E_OK;

    if(retVal != E_OK)
    {
      ETG_TRACE_ERR(("vMW_On(): ERROR %d Add MainConnection for Source %d"
          , ETG_CENUM(am::am_Error_e, retVal)
          , m_gam_source_s.sourceID));
    }
  }
  vMW_CCAResponse(0,0,On,sinkID);//extSrcID and subSrc not needed, set to 0
}

// virtual
void clExtGeniviAudioSource::vReset()
{
  ETG_TRACE_USR1(("vReset: Reset SourceClass: %d subID %d "
      , m_SrcId.enSourceClass
      , m_SrcId.u16SubSource));
  //TODO
  //remove Genivi Connections
  //remove Genivi MainConnection
  //ToDo consider also all connected sinks
  am_Error_e err = clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID);
  if(err != E_OK)
  {
	  ETG_TRACE_ERR(("vReset(): removeMainConnection for sourceID %d gave err %d",m_gam_source_s.sourceID,err));
  }
  //finally call reset within base class
  clAudioSource::vReset();
}


clAudioSource::enSourceAvailability clExtGeniviAudioSource::mapAvailability(am_Availability_e avail)
{
  enSourceAvailability retVal = unkonwn;
  switch(avail)
  {
  case A_AVAILABLE:
    retVal = available;
    break;
  case A_UNAVAILABLE:
    retVal = not_available;
    break;
  case A_UNKNOWN:
    retVal = unkonwn;
    break;
  default:
    ETG_TRACE_FATAL(("clExtGeniviAudioSource::enIsSourceAvailable unkown value in m_gam_source_s.available.availability: %d",
        avail));
    break;
  }
  return retVal;
}

am_Availability_e clExtGeniviAudioSource::mapAvailability(clAudioSource::enSourceAvailability avail)
{
  for(tU16 i = static_cast<tU16>(A_MAX)-1; i!=0; --i)
  {
    if(mapAvailability(static_cast<am_Availability_e>(i)) ==  avail)
      return static_cast<am_Availability_e>(i);
  }
  ETG_TRACE_FATAL(("clExtGeniviAudioSource::enIsSourceAvailable unkown value in clAudioSource::enSourceAvailability: %d",
      avail));
  return A_UNKNOWN;
}

clAudioSource::enSourceAvailability clExtGeniviAudioSource::enIsSourceAvailable()
{
  clAudioSource::enSourceAvailability retVal = mapAvailability(m_gam_source_s.available.availability);
  ETG_TRACE_USR4(("enIsSourceAvailable: SourceClass: %d subID %d Available: %d"
      , m_SrcId.enSourceClass
      , (tU16)m_SrcId.u16SubSource
      , ETG_CENUM(enSourceAvailability, retVal)));
  return retVal;
}

tVoid clExtGeniviAudioSource::vSourceAvailablilityChange(enSourceAvailability availability,
    enSourceAvailabilityReason availabilityReason)
{
  m_gam_source_s.available.availability = mapAvailability(availability);

  //VVD lint fix
  //am_Availability_e e;
  //am_AvailabilityReason_e r;
  am_Availability_s GAM_availability;
  switch(availability)
  {
  case clAudioSource::available:
    GAM_availability.availability = A_AVAILABLE;
    break;
  case clAudioSource::not_available:
    GAM_availability.availability = A_UNAVAILABLE;
    break;
  case clAudioSource::unkonwn:
    GAM_availability.availability = A_UNKNOWN;
    break;
  default:
    ETG_TRACE_ERR(("vSourceAvailablilityChange: availability %d is not handled"
        , availability));
    GAM_availability.availability = A_UNKNOWN;
    break;
  }
  switch(availabilityReason)
  {
  case clAudioSource::voltage:
    GAM_availability.availabilityReason = AR_GENIVI_VOLTAGE;
    break;
  case clAudioSource::newmedia:
    GAM_availability.availabilityReason = AR_GENIVI_NEWMEDIA;
    break;
  case clAudioSource::samemedia:
    GAM_availability.availabilityReason = AR_GENIVI_SAMEMEDIA;
    break;
  case clAudioSource::nomedia:
    GAM_availability.availabilityReason = AR_GENIVI_NOMEDIA;
    break;
  case clAudioSource::temperature:
    GAM_availability.availabilityReason = AR_GENIVI_TEMPERATURE;
    break;
  case clAudioSource::error:
    GAM_availability.availabilityReason = AR_GENIVI_ERRORMEDIA;
    break;
  case clAudioSource::no_content:
    GAM_availability.availabilityReason = AR_GENIVI_MEDIA_NOCONTENT;
    break;
  case clAudioSource::overcurrent:
    GAM_availability.availabilityReason = AR_GENIVI_OVER_CURRENT;
    break;
  case clAudioSource::internaldisconnect:
    GAM_availability.availabilityReason = AR_GENIVI_INTERNAL_DISCONNECT;
    break;
  default:
    ETG_TRACE_ERR(("vSourceAvailablilityChange: availabilityReason %d is not handled"
        , availabilityReason));
    GAM_availability.availabilityReason = AR_UNKNOWN;
    break;
  }
  am_Error_e err = clGeniviAudioCtrlAdapter::changeSourceAvailabilityDB(GAM_availability, m_gam_source_s.sourceID);
  if(err != E_OK)
  {
	  ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::changeSourceAvailabilityDB for sourceID %d, gave err %d",m_gam_source_s.sourceID, err));
  }

  //Call base class implementation
  clAudioSource::vSourceAvailablilityChange(availability, availabilityReason);
}

//virtual
void clExtGeniviAudioSource::setMainSourceSoundProperty()
{
  ETG_TRACE_ERR(("ExtGeniviAudioSource %s",m_gam_source_s.name.c_str()));
  ETG_TRACE_ERR(("setMainSourceSoundProperty we could use this as trigger for delayed ON state"));

  am_Error_e err = clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_ON);
  ETG_TRACE_ERR(("setSourceState gave err %d",err));
  return;
}

void clExtGeniviAudioSource::cbAckSetVolumeChange(const am_Handle_s* pHandle,tU16 SinkID)
{

	if((pHandle != NULL) && (m_gam_handle != NULL))
	{
		ETG_TRACE_USR4(("Got cbAckSetVolumeChange with handle %d, type %d, SinkID %d, clExtGeniviAudioSource: %s",
				pHandle->handle,pHandle->handleType,SinkID,m_pacName));
		ETG_TRACE_USR4(("m_gam_handle %d.%d",m_gam_handle->handleType,m_gam_handle->handleType));
	}
	else
	{
		ETG_TRACE_ERR(("ERROR: cbAckSetVolumeChange NULLPOINTER: pHandle %p, m_gam_handle %p",pHandle,m_gam_handle));
	}

	for(auto it = m_handleSourceSinkMap.begin(); it != m_handleSourceSinkMap.end(); it++)
	{
		ETG_TRACE_USR4(("cbAckSetVolumeChange found m_handleSourceSinkMap with handle %d, sinkID is %d, (m_curActSinkID %d), clExtGeniviAudioSource: %s",
				it->first,it->second,m_curActSinkID,m_pacName));
	}
	for(auto it = m_handleSinkSinkMap.begin(); it != m_handleSinkSinkMap.end(); it++)
	{
		ETG_TRACE_USR4(("cbAckSetVolumeChange found m_handleSinkSinkMap with handle %d, sinkID is %d, (m_curActSinkID %d), clExtGeniviAudioSource: %s",
				it->first,it->second,m_curActSinkID,m_pacName));
	}

#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
  if(m_gam_source_s.name == "AVB_Mic2" || m_gam_source_s.name == "AVB_Mic3")
   {
		  vCbAckSetSourceState(pHandle);
   }
  else
#endif
    {
       // All of them are synchronously
       am_Error_e err = clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_PAUSED);
       ETG_TRACE_USR4(("vMW_CCAResponse: Pause stored handle %d -> sink %d, (err = %d)",m_gam_handle->handle, SinkID,err));
    }
    m_handleSourceSinkMap[m_gam_handle->handle] = SinkID;
	m_handleSinkSinkMap[m_gam_handle->handle] = SinkID;
	m_logicalSourceStates[SinkID] = am::SS_PAUSED;
    ETG_TRACE_USR4(("vMW_CCAResponse: Pause stored handle %d -> sink %d",m_gam_handle->handle, SinkID));

}

void clExtGeniviAudioSource::disconnect( am_sourceID_t sourceID,  am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("clExtGeniviAudioSource::disconnect sourceID %d, sinkID %d (m_curActSinkID %d)",sourceID,sinkID,m_curActSinkID));

    std::vector<am_Connection_s> listUpdatedConnections;
    std::vector<am_Connection_s>::const_iterator subIt;
    am_Error_e err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections(listUpdatedConnections);
    //bool bDisconnect = false ;
    for(subIt=listUpdatedConnections.begin();subIt!=listUpdatedConnections.end();subIt++)
    {
      ETG_TRACE_USR4(("SubConID %d: SrcID %d -> SinkID %d",subIt->connectionID,subIt->sourceID,subIt->sinkID));
      if((subIt->sourceID == u16GetGeniviSourceID()) && (subIt->sinkID == sinkID))
      {
          m_gam_handle->handleType =H_UNKNOWN;
          m_gam_handle->handle=0;
          //this is the connection we need to disconnect
          ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect"));

          //need to check if we have to inform VoluemManager
          //err = clGeniviAudioCtrlAdapter::informVolumeManager(subIt->connectionID);

          err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect(*m_gam_handle,subIt->connectionID);
          ETG_TRACE_USR4(("called clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->disconnect handle %d (type: %d/%d), ID %d with err %d",
              m_gam_handle->handle,m_gam_handle->handleType,m_gam_handle->handle,subIt->connectionID,err));
          m_handleSourceSinkMap[m_gam_handle->handle] = m_curActSinkID;
          //bDisconnect = true;
          return;
      }
     }


}

}
} //namespace


