
/************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audioroutemanager.h
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audioroutemanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/

#ifndef INCLUDE_AMCONTROL_CLIENT_FC_AUD_ROUTE_MGR_HANDLER_H_IF
#define INCLUDE_AMCONTROL_CLIENT_FC_AUD_ROUTE_MGR_HANDLER_H_IF


class CAmControlSenderBase;

#include "CThreadSwitchingClient.h"

using namespace am;


class amcontrol_clienthandler_fc_audioroutemanager  : public CThreadSwitchingClient
{
private:
    struct rConnectionSet
    {
      am_Handle_s handle;
      am_sourceID_t sourceID;
      am_connectionID_t connectionID;
    };

   CAmControlSenderBase& m_ControlSenderBase;
   am::IAmControlReceive&        m_ControlReceive;
   uint16_t m_RoutingReadyHandle;

   // dedicated handlers for incoming mesages
   bool bOnSourceRouteActivityStatus (const FIMessaging::FIMessage& oMsg);
   bool bOnSourceRouteActivityError (const FIMessaging::FIMessage& oMsg);
   bool bOnRequestAudioRouteStatus (const FIMessaging::FIMessage& oMsg);
   bool bOnSourceAvailabilityStatus (const FIMessaging::FIMessage& oMsg);

protected:
   //Default Constructor (to be used in testing environments only)
   amcontrol_clienthandler_fc_audioroutemanager(tVoid);

public:
    //Wrapper function
  void vRegisterForProperties();

   amcontrol_clienthandler_fc_audioroutemanager(CAmControlSenderBase&, am::IAmControlReceiverShadow&, am::IAmControlReceive& controlReceive);

   virtual ~amcontrol_clienthandler_fc_audioroutemanager(tVoid);

   /****************************************************************************
                  Methods of this application
   ****************************************************************************/

   /****************************************************************************
   ** FUNCTION:   tVoid vSourceRouteActivity_Set();
   ****************************************************************************/
   /* DESCRIPTION:
   *   This function is called by AMRoutingPlugin to change the source
   *   by calling set property of "SourceRouteActivity" of fc_audioroutingManager
   ****************************************************************************/
   //tVoid vSourceRouteActivity_Set(uint8_t source,uint8_t nextSource,uint8_t Resource,uint8_t Activity);
   virtual tVoid vSourceRouteActivity_Set(uint8_t source, tU16 subSource,uint8_t nextSource,uint8_t Resource,uint8_t Activity);

   // - - - - - - - - - - - - - - - - - - - -
   //
   //      ITarget implementation

   // disclose list of properties which should be UpReg'ed automatically
   virtual FIMessaging::ITarget::AutoRegisterList GetAutoRegisterList (void);

   // - - - - - - - - - - - - - - - - - - - -

   // callback functions for new messages invoked from Genivi Audiomanager thread
   virtual void vOnServiceAvailable (void);
   virtual void vOnServiceUnavailable (void);
   virtual void vDispatchMessage (FIMessaging::FIMessage oMsg);

   bool bHandleStatus (const FIMessaging::FIMessage& oMsg);
   bool bHandleError (const FIMessaging::FIMessage& oMsg);

   // - - - - - - - - - - - - - - - - - - - -

};

#endif //INCLUDE_AMCONTROL_CLIENT_FC_AUD_ROUTE_MGR_HANDLER_H_IF
