/*******************************************************************************
 *
 * FILE:          SoundHandler.h
 *
 * SW-COMPONENT:  SoundHandler application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _SOUND_HANLDER_H_
#define _SOUND_HANLDER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
//#define AHL_S_IMPORT_INTERFACE_GENERIC
//#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
//#include <ahl_if.h>

//#include "../fc_audiomanager_trace_input.h"
#include "audiomanagertypes.h"
#include "../config/dp/AudioStack_dp_if.h"
#include "../config/dp/AudioUserDpIf.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*
*/

#define LOGFILE "/var/opt/bosch/dynamic/ffs/RoutingPlugin_Debug.log"
#define LOGFILE_DBUS "/var/opt/bosch/dynamic/ffs/RoutingDbus.log"
#define LOGFILE_CTRL "/var/opt/bosch/dynamic/ffs/Controller.log"


enum tenArkamysMode
{
  EN_ARKAMYS_OFF          = 0x00,
  EN_ARKAMYS_BYPASS       = 0x01,
  EN_ARKAMYS_CLASSIC      = 0x02,
  EN_ARKAMYS_AUDITORIUM   = 0x03,
  //used only for setting arkamys mode not to be sent to ADR3
  EN_ARKAMYS_PREMIUM1     = 0x04,
  EN_ARKAMYS_PREMIUM2     = 0x05
};


namespace Sound
{
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
struct DataSet_s
{
     tS8 m_s8Fader;
     tS8 m_s8Treble;
     tS8 m_s8Balance;
     tS8 m_s8Bass;
     tU8 m_u8Gala;
     tU8 m_u8AuxIn;
     tU8 m_u8BeepLevel;
     tS8 m_s8MidRange;
     tU8 m_u8Loudness;
     tU8 m_u8DynCompression;
     tU8 m_u8EquPreset;
     tU8 m_u8Optimization;
     tU8 m_u8RoomEffect;
     tU8 m_u8RearMute;
     tU8 m_u8GeometryMode;
     //tU8 m_DiagDefsetPhase;  // added to send the DiagDefset value to Controller plugin
     tU8 m_AudioMode;
     tS16 m_s16ANCDbvalue;

     //Minimum value for all sound properties
     tS8 m_s8MinBass;
     tS8 m_s8MinTreble;
     tS8 m_s8MinMidRange;
     tS8 m_s8MinFader;
     tS8 m_s8MinBalance;
     tS8 m_s8MinAuxIn;
     tS8 m_s8MinLoudness;

     //Maximum value for all sound properties
     tS8 m_s8MaxBass;
     tS8 m_s8MaxTreble;
     tS8 m_s8MaxMidRange;
     tS8 m_s8MaxFader;
     tS8 m_s8MaxBalance;
     tS8 m_s8MaxGala;
     tS8 m_s8MaxAuxIn;
     tS8 m_s8MaxLoudness;
     tS8 m_s8MaxDynCompression;
     tS8 m_s8MaxEquPreset;
     tS8 m_s8MaxOptimization;
     tS8 m_s8MaxRoomEffect;

     tBool m_bSDVCAvailability;
     tBool m_bBassAvailability;
     tBool m_bMixBassAvailability;

     tBool m_bTrebleAvailability;
     tBool m_bMixTrebleAvailability;

     tBool m_bBalanceAvailability;
     tBool m_bSurroundModeAvailability;
     tBool m_bAudioPilotAvailability;
     tBool m_bStagingAvailability;
     tBool m_bLoudnessAvailability;
     tBool m_bRoomEffectAvailability;
     tBool m_bAGCAvailability;
     tBool m_bMidRangeAvailability;
     tBool m_bFaderAvailability;
     tBool m_bSubWooferAvailability;
};

class SoundHandler
{
  //static SoundHandler* m_poSoundHandler;
  //static bool RemoteControlFlag;
public:
  //SoundHandler(fc_audiomanager_tclApp* poMainAppl, fc_audiomanager_tclService_Audio_Function* poService);
  SoundHandler(void);
  virtual ~SoundHandler(void);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  tVoid vInit()const;
  static tVoid vOnApplicationClose();

    tBool vCheckPropertyAvailablility(tS8& sPtyValue,tBool sPtyAvail);
    tVoid vOnLoadSettings();
    tVoid vOnLoadSettings(tU16 u16FunctionId);

   //tBool bGetStatusMessage(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   //tBool bProcessSet(tU16 u16FunctionID, fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);


  /**************************************************************************
   *
   **************************************************************************/

   //tBool bSetBass(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   //tBool bSetBass(rMainSinkSoundPropertySet &set);
//    am_sinkID_t sinkID;
//    am_Handle_s handle;
//    am_MainSoundProperty_s mainSoundProperty;

    //tBool bSetBass(am_sinkID_t sinkID, am_Handle_s& handle, am_MainSoundProperty_s& mainSoundProperty);
    tBool bSetBass(rMainSinkSoundPropertySet &set);
    tBool bGetBass(rMainSinkSoundPropertySet &set);

    tBool bSetMixBass(rMainSinkSoundPropertySet &set, unsigned char mic);
    //tBool bGetMixBass(rMainSinkSoundPropertySet &set, unsigned char mic);


   tBool bSetMixTreble(rMainSinkSoundPropertySet &set, unsigned char mic);
   tBool bGetMixTreble(rMainSinkSoundPropertySet &set, unsigned char mic);

   tBool bSetTreble(rMainSinkSoundPropertySet &set);
   tBool bGetTreble(rMainSinkSoundPropertySet &set);

   tBool bSetBalance(rMainSinkSoundPropertySet &set);
   tBool bGetBalance(rMainSinkSoundPropertySet &set);


   tBool bSetFader(rMainSinkSoundPropertySet &set);
   tBool bGetFader(rMainSinkSoundPropertySet &set);

   tBool bSetGala(rMainSinkSoundPropertySet &set);
   tBool bSetAuxInLevel(rMainSinkSoundPropertySet &set);
   tBool bSetBeepLevel(rMainSinkSoundPropertySet &set);
   tBool bSetMidRange(rMainSinkSoundPropertySet &set);

   tBool bSetLoudness(rMainSinkSoundPropertySet &set);
   tBool bSetDynamicCompression(rMainSinkSoundPropertySet &set);
   tBool bSetEquPreset(rMainSinkSoundPropertySet &set);
   tBool bSetOptimization(rMainSinkSoundPropertySet &set);
   tBool bSetRoomEffect(rMainSinkSoundPropertySet &set);
   tBool bSetRearMuteStatus(rMainSinkSoundPropertySet &set);
   tBool bSetGeometryModeStatus(rMainSinkSoundPropertySet &set);


    //below 3 functions are used only in A-IVI
  /***************************************************************************************************/
  //tBool bSetFMEnhancer(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSetFMEnhancer(rMainSinkSoundPropertySet &set);
  //tBool bSendFMEnhancerStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

  //tBool bSetSubWoofer(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSetSubWoofer(rMainSinkSoundPropertySet &set);
  //tBool bSetAutomaticGainControl(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSetAutomaticGainControl(rMainSinkSoundPropertySet &set);

  //tBool bSendAutomaticGainControlStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  /****************************************************************************************************/
private:
  tBool bStoreAndSendBassPOMsg(tU16 sinkID);
  tBool bStoreAndSendMixBassPOMsg(tU16 sinkID, unsigned char mic);

  tBool bStoreAndSendTreblePOMsg(tU16 sinkID);
  tBool bStoreAndSendMixTreblePOMsg(tU16 sinkID, unsigned char mic);

  tBool bStoreAndSendBalancePOMsg(tU16 sinkID);
  tBool bStoreAndSendFaderPOMsg(tU16 sinkID);
  tBool bStoreAndSendMidRangePOMsg(tU16 sinkID);

  tBool bStoreAndSendLoudnessPOMsg(tU16 sinkID);
  tBool bStoreAndSendRoomEffectPOMsg(tS8);
  tBool bStoreAndSendGalaPOMsg(tU16 sinkID);
  tVoid vStoreBeepLevel(tU8);
  tVoid vStoreAndSendEquPresetPOMsg(tU8);
  tVoid vStoreAndSendOptimizationPOMsg(tU8);
  tBool bProcessGeometry_mode();


  tVoid vLoadSingleUsrDP();

  //tVoid vLoadBalanceFaderSettings();

public:
  // inbox for TTFis
  //virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);

  // PostOffice
  //virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  //void vAddObserver();
  bool gala_availability_changed(bool availability, tU16 sinkID);

  tS16 getMappedBassValue(tS16 hmiVal, am_Error_e& error);
  tS16 getMappedTrebleValue(tS16 hmiVal, am_Error_e& error);
  tS16 getMappedBalanceValue(tS16 hmiVal, am_Error_e& error);
  tS16 getMappedFaderValue(tS16 hmiVal, am_Error_e& error);

//#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
//  tU8 KDSAvailability();
//#endif

private:
  //static fc_audiomanager_tclApp *poCcaMainApp;
  //fc_audiomanager_tclService_Audio_Function *poAudioService;

   tS8 m_s8Fader[Number_of_Sinks];
   tS8 m_s8Treble[Number_of_Sinks];

   tS8 m_s8MixTrebleMic1[Number_of_Sinks];
   tS8 m_s8MixTrebleMic2[Number_of_Sinks];
   tS8 m_s8MixTrebleMic3[Number_of_Sinks];

   tS8 m_s8Balance[Number_of_Sinks];
   tS8 m_s8Bass[Number_of_Sinks];

   tS8 m_s8MixBassMic1[Number_of_Sinks];
   tS8 m_s8MixBassMic2[Number_of_Sinks];
   tS8 m_s8MixBassMic3[Number_of_Sinks];

   tU8 m_u8Gala[Number_of_Sinks];
   tU8 m_u8AuxIn[Number_of_Sinks];
   tU8 m_u8BeepLevel[Number_of_Sinks];
   tS8 m_s8MidRange[Number_of_Sinks];
   tU8 m_u8Loudness[Number_of_Sinks];
   tU8 m_u8DynCompression[Number_of_Sinks];
   tU8 m_u8EquPreset[Number_of_Sinks];
   tU8 m_u8Optimization[Number_of_Sinks];
   tU8 m_u8RoomEffect[Number_of_Sinks];
   tU8 m_u8RearMute[Number_of_Sinks];
   tU8 m_u8GeometryMode[Number_of_Sinks];
   //tU8 m_DiagDefsetPhase;  // added to send the DiagDefset value to Controller plugin
   tU8 m_AudioMode[Number_of_Sinks];
   tS16 m_s16ANCDbvalue[Number_of_Sinks];

   //Minimum value for all sound properties
   tS8 m_s8MinBass[Number_of_Sinks];
   tS8 m_s8MinTreble[Number_of_Sinks];
   tS8 m_s8MinMidRange[Number_of_Sinks];
   tS8 m_s8MinFader[Number_of_Sinks];
   tS8 m_s8MinBalance[Number_of_Sinks];
   tS8 m_s8MinAuxIn[Number_of_Sinks];
   tS8 m_s8MinLoudness[Number_of_Sinks];

   //Maximum value for all sound properties
   tS8 m_s8MaxBass[Number_of_Sinks];
   tS8 m_s8MaxTreble[Number_of_Sinks];
   tS8 m_s8MaxMidRange[Number_of_Sinks];
   tS8 m_s8MaxFader[Number_of_Sinks];
   tS8 m_s8MaxBalance[Number_of_Sinks];
   tS8 m_s8MaxGala[Number_of_Sinks];
   tS8 m_s8MaxAuxIn[Number_of_Sinks];
   tS8 m_s8MaxLoudness[Number_of_Sinks];
   tS8 m_s8MaxDynCompression[Number_of_Sinks];
   tS8 m_s8MaxEquPreset[Number_of_Sinks];
   tS8 m_s8MaxOptimization[Number_of_Sinks];
   tS8 m_s8MaxRoomEffect[Number_of_Sinks];

   //should we have this as a single
   tBool m_bSDVCAvailability;
   tBool m_bBassAvailability;
   tBool m_bMixBassAvailability;


   tBool m_bTrebleAvailability;
   tBool m_bMixTrebleAvailability;

   tBool m_bBalanceAvailability;
   tBool m_bSurroundModeAvailability;
   tBool m_bAudioPilotAvailability;
   tBool m_bStagingAvailability;
   tBool m_bLoudnessAvailability;
   tBool m_bRoomEffectAvailability;
   tBool m_bAGCAvailability;
   tBool m_bMidRangeAvailability;
   tBool m_bFaderAvailability;
   tBool m_bSubWooferAvailability;

   tVoid vCheckSWAvailabilility();
   tVoid vHandleTraceAmpAvailabilityInput(tPCUChar pcu8Data);

   tBool bPropertyChanged; //we do not need this anymore

   AudioUserDpIf* pAudUsrDpIf;


};

} //namespace

#endif //_PERSISTENT_MGR_H_

