#ifndef _GATEWAY_H_
#define _GATEWAY_H_

#include "IAmControlReceiverShadow.h"
#include "AudioStack/clGateway.h"

namespace AudioStack
{
namespace AudioSource
{
class clGateway
{
public:
  clGateway()
  : m_registered(false)
  {
  }

  clGateway(am_Gateway_s gateway_s);

  void update(am_Gateway_s aGateway);

  //void setDynSinkID(am_sinkID_t sinkID, std::string name);
  void setDynSinkID(am_sinkID_t sinkID, const am_Sink_s& gam_sink_s);

  //void setDynSourceID(am_sourceID_t sourceID, std::string name);
  void setDynSourceID(am_sourceID_t sourceID, const am_Source_s& gam_source_s);

  bool bIsRegistered() {return m_registered;}

  bool tryRegister();

  std::string getSinkName() {return m_sinkName;}
  std::string getSourceName() {return m_sourceName;}

  bool setSinkName(std::string sinkName)
  {
    m_sinkName = sinkName;
    return true;
  }
  bool setSourceName(std::string sourceName)
  {
    m_sourceName = sourceName;
    return true;
  }

private:

  bool bIsDataComplete();

  std::string m_sinkName;
  std::string m_sourceName;
  am_Gateway_s m_Gateway;
  bool m_registered;
};
}
}
#endif
