#ifndef _AUDIOSOURCEFACTORY_H_
#define _AUDIOSOURCEFACTORY_H_
#include "osal_if.h"
// needed includes
//
#include "AudioStack/AudioSources/clAudioSource.h"



#ifdef _BOSCH_DIAG_KDS_
#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"
#endif

#ifndef _DO_NOT_USE_BOSCH_OSAL_
#include <map>
#include <algorithm>

#else
#include <map>
#endif

// see precompiled.hh    #define TRACE_WITHOUT_OSAL
#define USE_DEBUG_INTERFACE
// see precompiled.hh    #include "hmicca_pif.h"

namespace AudioStack
{
namespace AudioSource
{

/**
 * @Brief
 * This class provides access to AudioSources.
 * Instantiation and destruction is handled, as well as
 * maintenance.
 * Members and methods are static, so no instance is needed
 */
class clAudioSourceFactory
{
private:
  clAudioSourceFactory();
   ~clAudioSourceFactory(){};

   /**
    * Map of AudioSources
    * Key is the AudioSource Enumeration that identifies to
    * Object, that is the Value of this map.
    */
   static std::map<SourceID, clAudioSource*> audioSourceMap;
   static tU8 SourceObjectCounter;
   static clAudioSource* createAudioSourceObj(SourceID audioSource);
   static clAudioSource* createAudioSourceObj(SourceID audioSource,am_sourceID_t sourceID);
   static clAudioSource* createAudioSourceObj(SourceID audioSource,am_sourceID_t sourceID, const am_Source_s* pSourceData);

   static tBool m_rulesLoaded;

#ifdef _BOSCH_DIAG_KDS_
   static tBool bGetKDSEntry(tsKDSEntry *prKDSEntry);
#endif

public:
   static tVoid Invalidate();
   static tBool Init();
   static tVoid ListSources();
   //static AudioSources::enAudioSources mapVirtualToLogicalSource(AudioSources::enAudioSources audioSource);
   static tBool isSourceInstanceValid(SourceID srcID);
   static tVoid  resetAudioSources();

   /**
    * Deletes AudioSource
    */
   static tVoid removeAudioSources(SourceID srcID);
   /**
    * Returns an Instance of AudioSource if possible
    * it will create an Instance if there hasn't been
    * already created one
    * return NULL if source is not allowed or available
    */
   static clAudioSource* getAudioSource(sourceClassID audioSourceClass, tU8 SubSourceID=0);
   /**
    * Returns an Instance of AudioSource if possible
    * it will create an Instance if there hasn't been
    * already created one
    * return NULL if source is not allowed or available
    */
   //No need to create new source object if it's dynamic source vdu1kor SUZUKI-15832
   static clAudioSource* getAudioSource(SourceID audioSource,tBool bCreateNewSource=true);


   static clAudioSource* getAudioSource(SourceID audioSource,am_sourceID_t sourceID,tBool bCreateNewSource=true);

   //static clAudioSource* getAudioSource(SourceID audioSource,am_sourceID_t sourceID,tBool bCreateNewSource, am_Source_s* pSourceData);
   static clAudioSource* getAudioSource(SourceID audioSource,am_sourceID_t sourceID,tBool bCreateNewSource, const am_Source_s* pSourceData);

   /**
    * returns a available AudioSource of given SourceClass,
    * or NULL if none of the class is available
    */
   static clAudioSource* getAvailableAudioSource(sourceClassID sourceClass);
   static clAudioSource* getAvailableAudioSource();


   /**
    * Check if the source was already instantiated
    * returns NULL if the source was not instantiated before
    */
   static clAudioSource* isSourceInstantiated(SourceID srcId);

   static tVoid deleteInstances();
};

}}//namespace

#endif // _AUDIOSOURCEFACTORY_H_
