#ifndef _AMMULTIDOMAINCONTROLBASE_
#define _AMMULTIDOMAINCONTROLBASE_


#include "include/audiomanagertypes.h"
#include "CAmControlSenderBase.h"

#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "common.h"

#include "../GAMVolumeManager/VolumeManager/Volume/VolumeManager.h"
#include "PostOffice/Message.h"
#include "../GAMVolumeManager/PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_SinkDetail.h"
#include "../GAMVolumeManager/PostOfficeAdapter/InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../GAMVolumeManager/PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/ID_Amp_SetVolume.h"
#include "../include/SoundHandler.h"

#include "PostOffice/IF_MessageObserver.h"
#include "MessageConfig.h"

#define G3G_DEFAULT_SYP_SND_PROPERTY_VALUE 0

#define AVB_MIX_PROPERTIES_OFF false
#define AVB_MIX_PROPERTIES_ON  true

#define MIC_1   1
#define MIC_2   2
#define MIC_3   3
#define MIC_MAX 4


class amcontrol_clienthandler_fc_audiomanager;
class amcontrol_clienthandler_LCM;
class amcontrol_clienthandler_DiagLog;
class amcontrol_clienthandler_fc_audioroutemanager;
class CAmControlCvm;
class CAmControlSenderBase;

class AMMultiDomainControlBase : public CAmControlSenderBase,public IF_MessageObserver<PO_MessageConfig::enID>
{

private :
    Sound::SoundHandler* m_pSoundHandler;
    VolumeManager::VolumeManager* pVolumeManager;
    bool sinkIDinList(am_sinkID_t sinkID, std::vector<am_sinkID_t>& sinkListTuner);
	void applyMic1Gain(const AmpVolumeData& ampData, unsigned int dBLevel,bool bMicGainLevel = false);

	void createSourceMapForGain();
	void applySourceSpecificGain(const AmpVolumeData& ampData);
	void applyExtSourceGain(const AmpVolumeData& ampData, unsigned int dBLevel);

	void updateExtAmpSinkSoundProperties(am_Sink_s sinkData, am_sinkID_t sinkID);

	void switchAvbMixProperties(bool bOn, am_sinkID_t sinkID);


    am_Handle_s m_VolumeHandle;
    am_Handle_s m_AVBMicVolumeHandle;
    am_Handle_s m_AVBMic1GainHandle;

    am_Handle_s m_AVBMixBassHandle;
    am_Handle_s m_AVBMixTrebleHandle;

    am_Handle_s m_startUpHandle;
    // force an initial volume 0 to Amp at startup when its sink(s) is registered
    std::map<am_sinkID_t,bool>m_bVolumeZeroToAmpAtStartUpMap;

    bool m_AvbMixProperties_On[MIC_MAX];
    std::map<std::string,int> m_SourceMapForGain;

public :
    AMMultiDomainControlBase();
    virtual ~AMMultiDomainControlBase();
    //static am_SoundProperty_s soundProperty;
    static am_SoundProperty_s soundPropertyAVB_MicVolume;
    static am_SoundProperty_s soundPropertyAVB_Mic1Gain;
    static bool bExtSourceGain;

    //added as virtual, because of different content
    virtual am_Error_e hookUserDisconnectionRequest(const am_mainConnectionID_t mainConnectionID);

    virtual am_Error_e hookUserConnectionRequest(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t & mainConnectionID);
    virtual am_Error_e hookUserConnectionRequestNoConflict(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t & mainConnectionID);
    bool checkConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID);
    bool checkTunerConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID,am_Source_s sourceData, am_Sink_s sinkData, am_Source_s activeSourceData, std::vector<am_sinkID_t> sinkList);
    bool checkGatewayConflict(am_Source_s sourceData, am_Sink_s sinkData);
    bool checkCamPortConflict(am_Source_s sourceData, am_Sink_s sinkData);

    bool checkSrcChangeOnPausedSource(am_Source_s sourceData, am_Sink_s sinkData);

    am_Error_e checkForMainConnectionOnGatewayConnection(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t & mainConnectionID);
    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    virtual am_Error_e startupController(IAmControlReceive *controlreceiveinterface);
    virtual void vHandleSinkSoundProperty_Bass(rMainSinkSoundPropertySet &);
    virtual void vHandleSinkSoundProperty_Treble(rMainSinkSoundPropertySet &);
    virtual void vHandleSinkSoundProperty_Balance(rMainSinkSoundPropertySet &);
    virtual void vHandleSinkSoundProperty_Fader(rMainSinkSoundPropertySet &);
    virtual am_Error_e hookUserVolumeChange(const am_sinkID_t SinkID, const am_mainVolume_t newVolume);
    virtual am_Error_e hookSystemRegisterSink(const am_Sink_s & sinkData, am_sinkID_t & sinkID);
    virtual am_Error_e hookUserVolumeStep_Other_Projects(const am_sinkID_t SinkID, const int16_t i16Step);
    virtual am_Error_e hookUserSetSinkMuteState(const am_sinkID_t sinkID, const am_MuteState_e muteState);
    virtual void cbAckSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error);
    am_Error_e setDynamicSinkMuteState(const am_sinkID_t &sinkID, const am_MuteState_e &muteState);
    //  bool checkConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID);
    void getActiveTunerAndSinkList(am_Source_s& sourceData, std::vector<am_sinkID_t>& sinkListTuner);

    bool checkMediaPlayerConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID,
            am_Source_s sourceData, am_Sink_s sinkData, am_Source_s activeSourceData, std::vector<am_sinkID_t> sinkList);

    bool isMediaPlayerSourceClass(std::string sourceName);
    void getActiveMediaPlayerAndSinkList(am_Source_s& sourceData, std::vector<am_sinkID_t>& sinkList);

    void getMainConnectionConflictList(const am_sourceID_t sourceID, std::vector<am_sinkID_t> sinkList, std::vector<am_connectionID_t>& mainConIDList, std::vector<am_sinkID_t>& mainConIDSinkList);
    bool bIsSubIdInOtherMainID(const am_connectionID_t connectionID, const am_mainConnectionID_t mainConnectionID, am_mainConnectionID_t& otherMainConnectionID);
    am_sourceID_t getSourceID(std::string SrcName);
    am_sinkID_t getSinkID(std::string SinkName);

    bool bIsSourceSinkInDifferentDomain(am_sourceID_t sourceID, am_sinkID_t sinkID);
    am_Error_e checkForAdditionalConnectionActions(am_MainConnection_s& mainConnectionData, std::vector<am_MainConnection_s> listMainConnections);
    am_Error_e moveConnectionFromMainToOtherMain(am_MainConnection_s& fromMainConnectionData, am_MainConnection_s& toMainConnectionData);

    virtual void vHandleSinkSoundProperty_EntMinimumStartupVolume(rMainSinkSoundPropertySet &set);
    virtual void vHandleSinkSoundProperty_EntStartupVolume(rMainSinkSoundPropertySet &);

    //only to forward the reload to SoundHandler (used after factory reset)
    virtual void vLoadSoundSettings();
    am_Error_e muteOnOtherSinkNeeded(const am_sinkID_t sinkID, const am_MuteState_e muteState);
    bool bIsSourceAsMainConOnOtherSink(const am_sourceID_t sourceID, const am_sinkID_t sinkID,std::vector<am_MainConnection_s>& listMainConnections);

    //void setAVBMixBassTreble(am_sinkID_t sinkID);
    bool bIsAnyMicActive(unsigned char& mic);

    am_Error_e sendVolumeZeroToAvbAmp(const am_sinkID_t sinkID);

};
#endif
