/*
 * AudioUserDpIfSelect.cpp
 *
 * Helper class to select the Audio Usr Dp interface based on the project and variant.
 * Author : prm4kor
 */


#include "../../include/controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

//#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/AudioUserDpIfSelect.cpp.trc.h"
#endif

#define DP_S_IMPORT_INTERFACE_FI
#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
#include "dp_e880_if.h"
#else
#include "dp_e880_mock_if.h"
#endif

#include "AudioUserDpIfSelect.h"
//#include "AudioUserDpBase.h"
#include "AudioUserDpINF4CV.h"
#include "AudioUserDpSMART.h"

#if 0
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
#include "AudioUserDpPSA.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#include "AudioUserDpPIVI.h"
#include "AudioUserDpAIVI.h"
#endif

#ifdef __AUDIO_UNIT_TESTING__
#include "AudioUserDpMock.h"
#endif

#endif

#define OEM_TYPE_INFINITI     0x16

// ToDO: take this from the dp init file ??
#define NUMBER_OF_SINKS 6

AudioUserDpIf* AudioUserDpIfSelect::m_pAudioUsrDpIf = NULL;

AudioUserDpIf* AudioUserDpIfSelect::pGetAudUsrDpIf()
{
  ETG_TRACE_USR1(("AudioUserDpIf called from Task %d",OSAL_ThreadWhoAmI()));
 #if defined VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_SMART
  ETG_TRACE_USR1(("AudioUserDpIf::pGetAudUsrDpIf for SMART"));
  #endif

#if defined VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV
  ETG_TRACE_USR1(("AudioUserDpIf::pGetAudUsrDpIf for INF4CV"));
 #endif


   if(NULL == m_pAudioUsrDpIf)
   {

#if 0

#if defined __AUDIO_UNIT_TESTING__
      m_pAudioUsrDpIf = new AudioUserDpMock();
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
      m_pAudioUsrDpIf = new AudioUserDpPSA();
      ETG_TRACE_USR1(("AudioUserDpIf created for PSA"));
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
      tU8 u8VariantInfo;
      if(DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding","OEMType", &u8VariantInfo, 1))
      {
         if(OEM_TYPE_INFINITI == u8VariantInfo)
         {
            m_pAudioUsrDpIf = new AudioUserDpPIVI();
            ETG_TRACE_USR1(("AudioUserDpIf created for P-IVI"));
         }
         else
         {
            m_pAudioUsrDpIf = new AudioUserDpAIVI();
            ETG_TRACE_USR1(("AudioUserDpIf created for A-IVI"));
         }
      }
      else
      {
         m_pAudioUsrDpIf = new AudioUserDpBase();
         ETG_TRACE_ERR(("reading OEMType failed"));
      }
#else
      m_pAudioUsrDpIf = new AudioUserDpBase();
      ETG_TRACE_USR1(("AudioUserDpIf created for G3G projects"));
#endif


#endif
      //m_pAudioUsrDpIf = new AudioUserDpBase();
      //ETG_TRACE_USR1(("AudioUserDpIf created for G3G projects (AudioUserDpBase)"));

#if(defined VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)

      m_pAudioUsrDpIf = new AudioUserDpINF4CV();
      ETG_TRACE_USR1(("AudioUserDpIf created for INF4CV projects (AudioUserDpINF4CV)"));
#endif 
	  
#if defined VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_SMART	  
   	  m_pAudioUsrDpIf = new AudioUserDpSMART();
      ETG_TRACE_USR1(("AudioUserDpIf created for SMART projects (AudioUserDpSMART)"));
	  
#endif 

#if defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
      tU8 u8VariantInfo;
      if(DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding","OEMType", &u8VariantInfo, 1))
      {
         if(OEM_TYPE_INFINITI == u8VariantInfo)
         {
            //m_pAudioUsrDpIf = new AudioUserDpPIVI();
            ETG_TRACE_USR1(("AudioUserDpIf created for P-IVI (not done)"));
         }
         else
         {
            //m_pAudioUsrDpIf = new AudioUserDpAIVI();
            ETG_TRACE_USR1(("AudioUserDpIf created for A-IVI (not done)"));
         }
      }
      else
      {
         //m_pAudioUsrDpIf = new AudioUserDpBase();
         ETG_TRACE_ERR(("reading OEMType failed (not done)"));
      }
#else
      ETG_TRACE_ERR(("eles path (not action)"));
#endif
   }

   ETG_TRACE_USR1(("AudioUserDpIf ret m_pAudioUsrDpIf= 0x%p end from Task %d",m_pAudioUsrDpIf,OSAL_ThreadWhoAmI()));
   return m_pAudioUsrDpIf;
}

tVoid AudioUserDpIfSelect::vDeleteAudUsrDpIf()
{
   if(NULL != m_pAudioUsrDpIf)
   {
      delete m_pAudioUsrDpIf;
      m_pAudioUsrDpIf = NULL;
   }
}
