/*
 * AudioUserDpBase.h
 *
 * Base implementation of AudioUserDpIf interface
 * Can be directly used by G3G, Suzuki etc. (where there is no "multi" user storage is needed)
 *
 * Author : prm4kor
 */
#ifndef AUDIOUSERDPBASE_H_
#define AUDIOUSERDPBASE_H_

#include "AudioUserDpIf.h"

#define LOGFILE "/var/opt/bosch/dynamic/ffs/RoutingPlugin_Debug.log"
#define LOGFILE_DBUS "/var/opt/bosch/dynamic/ffs/RoutingDbus.log"
#define LOGFILE_CTRL "/var/opt/bosch/dynamic/ffs/Controller.log"

class AudioUserDpINF4CV : public AudioUserDpIf
{
public:
   virtual ~AudioUserDpINF4CV() {}

   virtual tS32 s32GetPrivateMode(tU16& u16PrivateMode);
   virtual tS32 s32SetPrivateMode(tU16 u16PrivateMode);


   virtual tS32 s32GetSinkID(tU16& u16PrivateMode);
   virtual tS32 s32SetSinkID(tU16 u16PrivateMode);


   virtual tS32 s32GetLastSourceClassOfSink(std::string &sLastSrc, tU16 sink);
   virtual tS32 s32GetLastSourceSubIDOfSink(tU16& u16SubID, tU16 Sink);

   virtual tS32 s32GetNumberOfSinks(tU8& u8Sinks);

   virtual tS32 s32GetTrebleMin(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetTrebleMax(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetTreble(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetTreble(tS8& s8Value);
   virtual tS32 s32GetTreble(tS8& s8Value, tU16 sink);

   virtual tS32 s32GetMixTreble(tS8* ps8Value, tU8 u8Size, unsigned char mic);

   virtual tS32 s32GetBassMin(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetBassMax(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetBass(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetBass(tS8& s8Value);
   virtual tS32 s32GetBass(tS8& s8Value, tU16 sink);

   virtual tS32 s32GetMixBass(tS8* ps8Value, tU8 u8Size, unsigned char mic);

   virtual tS32 s32GetMidRangeMin(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetMidRangeMax(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetMidRange(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetMidRange(tS8& s8Value);
   virtual tS32 s32GetMidRange(tS8& s8Value, tU16 sink);

   virtual tS32 s32GetBalanceMin(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetBalanceMax(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetBalance(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetBalance(tS8& s8Value);
   virtual tS32 s32GetBalance(tS8& s8Value, tU16 sink);

   virtual tS32 s32GetFaderMin(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetFaderMax(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetFader(tS8* ps8Value, tU8 u8Size);
   virtual tS32 s32GetFader(tS8& s8Value);
   virtual tS32 s32GetFader(tS8& s8Value, tU16 sink);

   // not yet supported
   virtual tS32 s32GetBeepLevel(tU8& u8Value);
   virtual tS32 s32GetBeepLevel(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetEquPreset(tU8& u8Value);
   virtual tS32 s32GetEquPreset(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetOptimization(tU8& u8Value);
   virtual tS32 s32GetOptimization(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetGala(tU8& u8Value);
   virtual tS32 s32GetGala(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetLoudness(tU8& u8Value);
   virtual tS32 s32GetLoudness(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetSurroundLevel(tU8& u8Value);
   virtual tS32 s32GetSurroundLevel(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetCenterGain(tS16& s16Value);
   virtual tS32 s32GetCenterGain(tS16& s16Value, tU16 sink);

   virtual tS32 s32GetSubwoofer(tS16& s16Value);
   virtual tS32 s32GetSubwoofer(tS16& s16Value, tU16 sink);

   virtual tS32 s32GetAutomaticGainControl(tBool& bValue);
   virtual tS32 s32GetAutomaticGainControl(tBool& bValue, tU16 sink);

   virtual tS32 s32GetRoomEffect(tU8& u8Value);
   virtual tS32 s32GetRoomEffect(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetSoundStaging(tU8& u8Value);
   virtual tS32 s32GetSoundStaging(tU8& u8Value, tU16 sink);

   virtual tS32 s32GetGeometryMode(tU8& u8Value);
   virtual tS32 s32GetGeometryMode(tU8& u8Value, tU16 sink);

   virtual tS32 s32SetLastSourceClassOfSink(tString u8LastSource, tU16 Sink);
   virtual tS32 s32SetLastSourceSubIDOfSink(tU16 u16SubID, tU16 Sink);

   virtual tS32 s32SetTreble(tS8 s8Value);
   virtual tS32 s32SetTreble(tS8 s8Value, tU16 sink);

   virtual tS32 s32SetMixTreble(tS8 s8Value, tU16 sink, unsigned char mic);

   virtual tS32 s32SetBass(tS8 s8Value);
   virtual tS32 s32SetBass(tS8 s8Value, tU16 sink);

   virtual tS32 s32SetMixBass(tS8 s8Value, tU16 sink, unsigned char mic);

   virtual tS32 s32SetMidRange(tS8 s8Value);
   virtual tS32 s32SetMidRange(tS8 s8Value, tU16 sink);

   virtual tS32 s32SetBalance(tS8 s8Value);
   virtual tS32 s32SetBalance(tS8 s8Value, tU16 sink);

   virtual tS32 s32SetFader(tS8 s8Value);
   virtual tS32 s32SetFader(tS8 s8Value, tU16 sink);

   virtual tS32 s32SetBeepLevel(tU8 u8Value);
   virtual tS32 s32SetBeepLevel(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetEquPreset(tU8 u8Value);
   virtual tS32 s32SetEquPreset(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetOptimization(tU8 u8Value);
   virtual tS32 s32SetOptimization(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetGala(tU8 u8Value);
   virtual tS32 s32SetGala(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetLoudness(tU8 u8Value);
   virtual tS32 s32SetLoudness(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetSurroundLevel(tU8 u8Value);
   virtual tS32 s32SetSurroundLevel(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetCenterGain(tS16 s16Value);
   virtual tS32 s32SetCenterGain(tS16 s16Value, tU16 sink);

   virtual tS32 s32SetSubwoofer(tS16 s16Value);
   virtual tS32 s32SetSubwoofer(tS16 s16Value, tU16 sink);

   virtual tS32 s32SetAutomaticGainControl(tBool bValue);
   virtual tS32 s32SetAutomaticGainControl(tBool bValue, tU16 sink);

   virtual tS32 s32SetRoomEffect(tU8 u8Value);
   virtual tS32 s32SetRoomEffect(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetSoundStaging(tU8 u8Value);
   virtual tS32 s32SetSoundStaging(tU8 u8Value, tU16 sink);

   virtual tS32 s32SetGeometryMode(tU8 u8Value);
   virtual tS32 s32SetGeometryMode(tU8 u8Value, tU16 sink);

   //privatemodemix volume based on sink
   virtual tS32 u32GetPrivateModeMixVolume(tU16& u16SubID, tU16 Sink);
   virtual tS32 s32SetPrivateModeMixVolume(tU16 u16SubID, tU16 Sink);

   //keep a member for number of sinks ?
   //tU8 m_u8NumberOfSinks;
};

#endif //AUDIOUSERDPBASE_H_
