#ifndef __POST_OFFICE_MSGMAPITEM__
#define __POST_OFFICE_MSGMAPITEM__

#include "IF_MessageObserver.h"

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
#include <stl_pif.h>



/**
   * @brief Used as value of the key/value pair of the MessageMap Member
   */
template <typename Ident>
class MessageMapItem{
  public:
  /**
   * List of observers that want receive this Message
   */
    list<IF_MessageObserver<Ident> *> observerList;
    /**
     * Configuration of this Message type
     */
    MessageConfigItem<Ident>*              msgConf;
    /**
     * @brief Points to the last informed Observer
     * @details When there's a higher prio Message incoming
     * that interrupts distribution, the distribution needs to
     * be continued with the next oberserver in observer list
     * (to prevent duplicate notifications).
     * If this is NULL the distribution is started from
     * observer list beginning.
     * If this points to a registered observer the next observer
     * of the list gets informed after the higher prior Messages
     * are distributed
     */
    IF_MessageObserver<Ident>* lastNotifiedObserver;

    /**
     * Copy constructor declaration, no implementation
     * should prevent of using default copy constructor
     */
    //MessageMapItem(const MessageMapItem &cSource);
    /**
     * Assignment Operator declaration, no implementation
     * should prevent of using default copy constructor
     */
    //MessageMapItem& operator= (const MessageMapItem &cSource);

    /**
     *Constructs a MessageMapItem Object based on given configuration item
     * @param msgConfig MessageConfiguration Item, this is getting cloned here so thst source
     * Object could be temporary and/or deleted after this constructor call
     */
    MessageMapItem(MessageConfigItem<Ident>* msgConfig) :
      observerList(list<IF_MessageObserver<Ident>*>()),
      msgConf(msgConfig->clone()),
      lastNotifiedObserver(NULL)
    {  }
  };
#endif //__POST_OFFICE_MSGMAPITEM__

