#pragma once

#include "Utilities/Uncopyable.h"

#include "../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"

#include<string>

class AmpVolumeData;
class fc_audiomanager_tclService_Audio_Function_Stub;

namespace VolumeManager {

// --------------------------------------------------------------------------

class Engine;
class StreamSet;
class PropertyStore;
class Configuration;
class Attenuation;

// --------------------------------------------------------------------------

class VolumeManager: private Uncopyable {

    public:
        VolumeManager(fc_audiomanager_tclService_Audio_Function_Stub& parent);
        virtual ~VolumeManager();

        void vSetVolume(tU8 u8VolumeType, tU8 u8Resource, tU16 u16Volume);
        void vSetVolume(tU8 u8VolumeType, const std::string & sinkName, tU16 u16Volume);
        void vSetAudioSource(tU8 u8Resource, tU8 u8Source, tU8 u8Channel);
        void vSetAudioSource(const std::string & sinkName, const std::string & sourceName, tU8 u8Channel);
        void vSetMute(const std::string & sink);
        void vClearMute(const std::string & sink);
        void vClearMuteFlag(const std::string& sink);
        static void vLaunchAmplifierCommand(const AmpVolumeData& AmpData);
        tBool bGetVolumeStatus(tU16 u16FunctionId, tU16* pu16NewVolume);
        void vDisconnectAudioSource(const std::string & sinkName, const std::string & sourceName);

        void audioSourceRequest(const std::string & sourceName,
                const std::string & muteState, const std::string & sinkName);

        //OnVolume Limit
        void vhandleVolume_OnVolume_Min (tU8 u8VolumeType, const std::string& sinkName, tU16 u16Value);
        void vhandleVolume_OnVolume_Max (tU8 u8VolumeType, const std::string& sinkName, tU16 u16Value);
        tU8 computeCurrentVolBasedOnMinAndMaxVolLimit(tU8 minlimitval, tU8 CurrentVol, tU8 maxlimitval);
        void setOnVolumeLimit(void);

        tU16 getOnVolumeMinLimit(std::string sinkname);
        tU16 getOnVolumeMaxLimit(std::string sinkname);

        tU8 getEntVolumeForSink(std::string sinkname);

        void fetchOnVolumeLimitProperties(void);

        //attenuation
        void enableMixSourceAttenuation(std::string sinkname, int db);
        void disableMixSourceAttenuation(std::string sinkname);
        void restoreSource(const std::string & sinkName);

        void vSetMuteEntertainment(const std::string& sinkName);

    private:

        fc_audiomanager_tclService_Audio_Function_Stub& _parent;
        Configuration* _pConfiguration;
        PropertyStore* _pProperties;
        Engine* _pEngine;
        Attenuation* _pAttenuation;
        int attenuationdb_ampa, attenuationdb_ampb;

        std::string getVolumeConfigurationXMLFilePath();
        bool validateSourceChangeRequest(const std::string & sourceName,
                const std::string & muteState, const std::string & sinkName);
};

}   // namespace VolumeManager

