//
// Main.cpp   for sub-component VolumeManager
//
//  Created on: Jun 16, 2014
//      Author: Martin Koch, Fa. ESE
//

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h> // implicitly links <osal_if.h>



#include <vector>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define OEM_TYPE_INFINITI     0x16

#include "./Types.h"
#include "./VolumeManager.h"
#include <map>
// - - - - - - - - - - - -

//Include public FI interface of this service.
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include <midw_fi_if.h>

#include "Configuration/Configuration.h"
#include "./PropertyStore.h"
//#include "vd_adr3Msg_If.h"
#include "./CCAListener.h"
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "../../PostOfficeAdapter/InternalComponentCommunication/MessageConfig.h"
#include "Volume/Engine/Engine.h"
#include "Volume/Attenuation/Attenuation.h"
#include "Messages/Volume/VolumeManager/ID_Attenuation.h"

#include "../fc_audiomanager_service_Audio_Stub.h"

// PO framework for amplifier command
#include "../../PostOfficeAdapter/InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/ID_Amp_SetVolume.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Source/IDCCAStartAudioSource.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Source/IDIntSource.h"


#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/VolumeManager.cpp.trc.h"

#include "Configuration/dBCalculator.h"
#include "DynamicSinkStore.h"
#include<iostream>

namespace VolumeManager
{

tU8 CabMaxVolMaxVal = 0;
tU8 CabMaxVolMinVal = 0;
tU8 CabMinVolMaxVal = 0;
tU8 CabMinVolMinVal = 0;

enum limits{
   MAX_MIN_VOl_LIMIT =15,
   MAX_MAX_VOl_LIMIT= 30,
   MIN_MIN_VOL_LIMIT= 0,
   MIN_MAX_VOL_LIMIT =15
};

   // --------------------------------------------------------------------------

   /* constructor */ VolumeManager::VolumeManager(fc_audiomanager_tclService_Audio_Function_Stub& parent)
      : _parent(parent)
      , _pProperties(new PropertyStore(parent))
      , _pEngine(NULL)
   {

 //    ET_TRACE_OPEN;
       InternalCommunicationAdapter::getInstance();

     if (NULL == _pProperties)
     {
        ETG_TRACE_FATAL(("VolumeManager - Main: E R R O R :  failed to create PropertyStore"));
     }

       std::string filename = getVolumeConfigurationXMLFilePath();
      _pConfiguration = new Configuration(filename.c_str());

      if (NULL == _pConfiguration)
      {
         ETG_TRACE_FATAL(("VolumeManager - Main: E R R O R :  failed to create Configuration database"));
      }

      if (_pConfiguration && _pProperties)
      {
         _pAttenuation = new Attenuation(*_pProperties, *_pConfiguration);
         _pProperties->setAttenuation(_pAttenuation);
         _pProperties->setConfiguration(_pConfiguration);
      }


      if (_pConfiguration && _pProperties )
      {
        // _pProperties->vInitAll(*_pConfiguration);
         _pEngine = new Engine(*_pProperties, *_pConfiguration,  parent.m_pFading);  // implicitly instantiates InternalCommunicationAdapter
      }
      if (NULL == _pEngine)
      {
         ETG_TRACE_FATAL(("VolumeManager - Main: E R R O R :  failed to create Engine"));
      }

      ETG_TRACE_USR1(("VolumeManager - Main: established"));

  parent.setVolumeManager(this);

      //For OnVolume Limit
      fetchOnVolumeLimitProperties();
      setOnVolumeLimit();

      attenuationdb_ampa = attenuationdb_ampb = 0;

   }

   // --------------------------------------------------------------------------

   /* destructor */ VolumeManager:: ~VolumeManager ()
   {
      ETG_TRACE_USR1(("VolumeManager - Main: terminating ..."))

      // cleanup, but prevent throwing exceptions on failure
      delete _pEngine;
      delete _pProperties;
      delete _pConfiguration;
      delete _pAttenuation;
   }

   // --------------------------------------------------------------------------
   // add some interface function


   void VolumeManager::vSetAudioSource(tU8 u8Resource, tU8 u8Source, tU8 u8Channel)
   {
       ETG_TRACE_USR1(("vSetAudioSource not supported for this parameters. No more used"));
   }

   void VolumeManager::vSetVolume(tU8 u8VolumeType, tU8 u8Resource, tU16 u16Volume)
   {
      ETG_TRACE_USR1(("vSetVolume not supported for this parameters. No more used"));
   }

    void VolumeManager::vSetVolume(tU8 u8VolumeType, const std::string& sinkName, tU16 u16Volume)
    {
        VolumeData out;
        out.setVolume((tU8)u16Volume);
       // out.setResource((midw_fi_tcl_e8_ResourceNo::tenType)u8Resource);
        out.sinkName = sinkName;
        out.setVolumeType((midw_fi_tcl_e8_AudioVolumeType::tenType)u8VolumeType);
        out.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

        if(_pProperties->isDynamicSinkMuteActive(sinkName))
        {
            _pProperties->clearDynamicSinkMuteflag(sinkName);
            out.setVolume(_pProperties->getPersistentVolume(_pProperties->getCurrentSource(sinkName), sinkName));
            out.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS);
        }

        ID_CCA_Start_Volume outMsg(out);
        InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

    }

    void VolumeManager::vSetAudioSource(const std::string& sinkName, const std::string& sourceName, tU8 u8Channel)
    {
    	ETG_TRACE_ERR(("VolumeManager::vSetAudioSource sink %s",sinkName.c_str()));
    	ETG_TRACE_ERR(("VolumeManager::vSetAudioSource source %s",sourceName.c_str()));
    	VolumeSourceData DataSet;
    	//  DataSet.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType) u8Resource);
    	std::string src = "AMP_AnalogIn_A";
    	if(sourceName == src)
    	{
    		ETG_TRACE_ERR(("vSetAudioSource for AMP_AnalogIn_A ignored"));
    		return;
    	}
    	_pProperties->updateSourceOnStack(sinkName, sourceName, true);

    	DataSet.m_Channel = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;

    	DataSet.m_SourceName = sourceName;
    	DataSet.m_ResourceName = sinkName;

    	IDIntSource VolumeSourcePOMessage(DataSet);
    	InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);

    	auto sourcesOnStack = _pProperties->getSourceOnStack();

    	if(sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
    			|| sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
    					|| sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
    	{
    		if(sourceName != "MIC_PRIVATE" && sourceName != "AVB_Mic2" && sourceName != "AVB_Mic3")
    		{
    			if(sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE")
    			{
    				DataSet.m_SourceName = "MIC_PRIVATE";
    				DataSet.m_ResourceName = sinkName;

    				IDIntSource VolumeSourcePOMessage(DataSet);
    				InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);
    			}
    			else if(sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE" && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE")
    			{
    				if(sinkName == "AMP_A")
    					enableMixSourceAttenuation(sinkName,attenuationdb_ampa);
    				else if(sinkName == "AMP_B")
    					enableMixSourceAttenuation(sinkName,attenuationdb_ampb);

    				DataSet.m_SourceName = "AVB_Mic2";
    				DataSet.m_ResourceName = sinkName;
    				IDIntSource VolumeSourcePOMessage(DataSet);
    				InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);
    			}
    			else if(sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE" && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
    					&& sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
    			{
    				if(sinkName == "AMP_A")
    					enableMixSourceAttenuation(sinkName,attenuationdb_ampa);
    				else if(sinkName == "AMP_B")
    					enableMixSourceAttenuation(sinkName,attenuationdb_ampb);

    				DataSet.m_SourceName = "AVB_Mic3";
    				DataSet.m_ResourceName = sinkName;
    				IDIntSource VolumeSourcePOMessage(DataSet);
    				InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);
    			}

    		}
    	}


    }

    void VolumeManager::vDisconnectAudioSource(const std::string & sinkName, const std::string & sourceName)
    {
    	ETG_TRACE_USR2(("VolumeManager::vDisconnectAudioSource sourceName %s",sourceName.c_str()));
    	ETG_TRACE_USR2(("VolumeManager::vDisconnectAudioSource sinkName %s",sinkName.c_str()));

        _pProperties->updateSourceOnStack(sinkName, sourceName, false);

        std::string curSrc = _pProperties->getCurrentSource(sinkName);
        ETG_TRACE_USR2(("VolumeManager::vDisconnectAudioSource curSrc %s",curSrc.c_str()));
        if(curSrc == sourceName)
        	vSetMute(sinkName);
        restoreSource(sinkName);
    }

   /* static */ void VolumeManager:: vLaunchAmplifierCommand(const AmpVolumeData& ampData)
   {
      ID_Amp_SetVolume outMsg(ampData);
      if(InternalCommunicationAdapter::POMessages != NULL)
          InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

      ETG_TRACE_USR2(("VolumeManager - Main:"
         " - launched amplifier volume command for stream = %u, Step = %d"
         " , dB = %d, Ramp (lin/log) = %d/%d  Sink =  %d"
         , ampData.m_enStream, ampData.m_VolStep
         , ampData.m_VoldB, ampData.m_RampLin, ampData.m_RampdB, ampData.m_Sink ))

#ifdef LinuxX86Make
    // std::cout << ampData.m_enStream << " " << (int)ampData.m_VolStep <<" " <<  ampData.m_VoldB <<" " <<  (int)ampData.m_Sink << "\n" ;
#endif
   }

void VolumeManager::vSetMuteEntertainment(const std::string& sinkName)
{

	ETG_TRACE_ERR(("VolumeManager::vSetMuteEntertainment sink %s",sinkName.c_str()));
	AmpVolumeData ampData;
	ampData.m_VolStep = 0;
	ampData.m_VoldB = 136;
	ampData.m_Sink = DynamicSinkStore::getInstance().getSinkID(sinkName);
	ampData.m_SinkName = sinkName;
	ampData.m_Source = "TUNER_FM";
	ampData.m_Group = "Entertain";
	ampData.m_status = false;
	ID_Amp_SetVolume outMsg(ampData);
	if (InternalCommunicationAdapter::POMessages != NULL)
		InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
}

// --------------------------------------------------------------------------


void VolumeManager::vSetMute(const std::string& sinkName)
{

    ETG_TRACE_ERR(("VolumeManager::vSetMute for sink %s",sinkName.c_str()));

    if(sinkName != "AMP_A" && sinkName != "AMP_B")
        return;

    ETG_TRACE_ERR(("VolumeManager::vSetMute isDynamicSinkMuteActive %d",_pProperties->isDynamicSinkMuteActive(sinkName)));
    if(_pProperties->isDynamicSinkMuteActive(sinkName))
        return;

    auto sourcesOnStack = _pProperties->getSourceOnStack();
    if(sourcesOnStack[sinkName]["Entertain"] == "NONE")
    {
        ETG_TRACE_ERR(("VolumeManager::vSetMute when Entertainment is None"));
        vSetMuteEntertainment(sinkName);
        //return;
    }

    _pProperties->setDynamicSinkMuteflag(sinkName);

    tU8 Mute = 0;
    VolumeData out;
    out.setVolume(Mute);
    out.setResource((midw_fi_tcl_e8_ResourceNo::tenType)DynamicSinkStore::getInstance().getSinkID(sinkName));
    out.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS);
    out.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
    out.sinkName = sinkName;

    out.m_VolumeGain = 0;

    ID_CCA_Start_Volume outMsg(out);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
}

   void VolumeManager::vClearMuteFlag(const std::string& sinkName)
   {
       ETG_TRACE_ERR(("VolumeManager::vClearMute"))

       if(sinkName != "AMP_A" && sinkName != "AMP_B")
           return;
       if(!_pProperties->isDynamicSinkMuteActive(sinkName))
           return;

       _pProperties->clearDynamicSinkMuteflag(sinkName);

   }

void VolumeManager::vClearMute(const std::string& sinkName)
{
    ETG_TRACE_ERR(("VolumeManager::vClearMute"));

    if(sinkName != "AMP_A" && sinkName != "AMP_B")
        return;
    if(!_pProperties->isDynamicSinkMuteActive(sinkName))
        return;

    _pProperties->clearDynamicSinkMuteflag(sinkName);

    VolumeData out;
    out.setVolume(_pProperties->getPersistentVolume(_pProperties->getCurrentSource(sinkName), sinkName));
    out.setResource((midw_fi_tcl_e8_ResourceNo::tenType)DynamicSinkStore::getInstance().getSinkID(sinkName));
    out.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS);
    out.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
    out.m_VolumeGain = 0;
    out.sinkName = sinkName;

    ID_CCA_Start_Volume outMsg(out);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

    restoreSource(sinkName);
}

   tBool VolumeManager::bGetVolumeStatus(tU16 /* u16FunctionId */, tU16* /* pu16NewVolume */)
   {
     return true;
   }

   std::string VolumeManager::getVolumeConfigurationXMLFilePath()
   {


#ifndef LinuxX86Make
       std::string  filename ="";
       filename = "/var/opt/bosch/static/audio/audiomanager/volumelib_configuration.xml";
       tU8 u8VariantInfo = _pProperties->kdsHelper.get_oem_type();
       if (OEM_TYPE_INFINITI == u8VariantInfo)
       {
           filename = "/var/opt/bosch/static/audio/audiomanager/volume_configuration_pivi.xml";
       }
       return filename;
#else
       std::string filename ="";
       std::string naviroot(getenv("_SWNAVIROOT"));
       std::cout << getenv("_SWNAVIROOT") <<"\n" << naviroot << std::endl;
       std::string path = "/../ai_audio/components/AudioManagerPlugins/AMMultiDomainController/GAMVolumeManager/VolumeManager/Volume/ConfigurationLib_inf4cv.xml";
       filename.append(naviroot.append(path));
       std::cout << filename << std::endl;
       return filename;
#endif


   }


void VolumeManager::enableMixSourceAttenuation(std::string sinkname, int db)
{
	ETG_TRACE_USR4(("VolumeManager::enableMixSourceAttenuation got db %d for sink %s",db,sinkname.c_str()));
    std::string Mic2 = "AVB_Mic2", Mic3 = "AVB_Mic3";
    std::string currentSource = _pProperties->getCurrentSource(sinkname);


    if(sinkname == "AMP_A")
        attenuationdb_ampa = db;
    else if(sinkname == "AMP_B")
        attenuationdb_ampb = db;



    std::map<std::string, std::string> out = {
            {"attenuationType", "MIX_SOURCE_ATTENUATION"},
            {"action", "enable"},
            {"sink", sinkname},
            {"db", std::to_string(db)}
    };


    ID_Attenuation outMsg(out);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);


}

void VolumeManager::disableMixSourceAttenuation(std::string sinkname)
{
    std::map<std::string, std::string> out = {
            {"attenuationType", "MIX_SOURCE_ATTENUATION"},
            {"action", "disable"},
            {"sink", sinkname}
    };


    ID_Attenuation outMsg(out);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

}

void VolumeManager::vhandleVolume_OnVolume_Min (tU8 u8VolumeType, const std::string& sinkName, tU16 u16Value)
{
     ETG_TRACE_USR2(("GAMVolumeManager - vhandleVolume_OnVolume_Min for Cabin Sink Entered with Value = %d, Sink  = %s", u16Value, sinkName.c_str()));

    tU8 currentval = 0;
    const std::string& LimitType = "OnVolumeMin";


    currentval = _pProperties->persistenceStore.getPersistenceOnVolume(sinkName, LimitType);    //Fetch Min volume limit from data pool for Cabin A
    ETG_TRACE_USR2(("GAMVolumeManager - Ent On Volume Max limit = %d, for Sink = %s", currentval, sinkName.c_str()));

    if(u8VolumeType == midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC)
    {
        currentval = (tU8)(currentval + u16Value);
        _pProperties->persistenceStore.setPersistenceOnVolume(sinkName, LimitType, computeCurrentVolBasedOnMinAndMaxVolLimit(CabMinVolMinVal, currentval, CabMinVolMaxVal));
        ETG_TRACE_USR2(("GAMVolumeManager - Updated Ent On Volume Min limit after increment = %d, for Sink = %s", currentval, sinkName.c_str()));
    }
    else if (u8VolumeType  == midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC)
    {
        currentval = (tU8)(currentval - u16Value);
        //if(currentval >= 0) //always fulfilled, can not be negative
        if(currentval > 40)// to check wrap up issue.
        {
            currentval = 0;
        }
        _pProperties->persistenceStore.setPersistenceOnVolume(sinkName, LimitType, computeCurrentVolBasedOnMinAndMaxVolLimit(CabMinVolMinVal, currentval, CabMinVolMaxVal));
        ETG_TRACE_USR2(("GAMVolumeManager - Updated Ent On Volume Min limit after decrement = %d, for Sink = %s", currentval, sinkName.c_str()));
    }

  ETG_TRACE_USR2(("GAMVolumeManager - vhandleVolume_OnVolume_Min for Cabin Sink Ended"));
}

void VolumeManager::vhandleVolume_OnVolume_Max (tU8 u8VolumeType, const std::string& sinkName, tU16 u16Value)
{
     ETG_TRACE_USR2(("GAMVolumeManager - vhandleVolume_OnVolume_Max for Cabin Sink Entered with Value = %d, Sink  = %s", u16Value, sinkName.c_str()))

    tU8 currentval = 0;
    const std::string& LimitType = "OnVolumeMax";


    currentval = _pProperties->persistenceStore.getPersistenceOnVolume(sinkName, LimitType);    //Fetch Max volume limit from data pool
    ETG_TRACE_USR2(("GAMVolumeManager - Ent On Volume Max limit = %d, for Sink = %s", currentval, sinkName.c_str()));

    if(u8VolumeType == midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC)
    {
        currentval = (tU8)(currentval + u16Value);
        _pProperties->persistenceStore.setPersistenceOnVolume(sinkName, LimitType, computeCurrentVolBasedOnMinAndMaxVolLimit(CabMaxVolMinVal, currentval, CabMaxVolMaxVal));
        ETG_TRACE_USR2(("GAMVolumeManager - Updated Ent On Volume Max limit after increment = %d, for Sink = %s", currentval, sinkName.c_str()));
    }
    else if (u8VolumeType  == midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC)
    {
        currentval = (tU8)(currentval - u16Value);
        if(currentval > 40)// to check wrap up issue.
        {
            currentval = 0;
        }
        _pProperties->persistenceStore.setPersistenceOnVolume(sinkName, LimitType, computeCurrentVolBasedOnMinAndMaxVolLimit(CabMaxVolMinVal, currentval, CabMaxVolMaxVal));
        ETG_TRACE_USR2(("GAMVolumeManager - Updated Ent On Volume Max limit after decrement = %d, for Sink = %s", currentval, sinkName.c_str()));
    }

  ETG_TRACE_USR2(("GAMVolumeManager - vhandleVolume_OnVolume_Max for Cabin Sink Ended"));
}

tU8 VolumeManager::computeCurrentVolBasedOnMinAndMaxVolLimit(tU8 minlimitval, tU8 CurrentVol, tU8 maxlimitval)
{
       ETG_TRACE_USR2(("GAMVolumeManager - computeCurrentVolBasedOnMinAndMaxVolLimit for Cabin Sink Entered with minValue: %d, maxValue: %d, currentValue: %d", minlimitval, maxlimitval, CurrentVol))

       if (minlimitval > CurrentVol)
       {
           ETG_TRACE_USR2(("GAMVolumeManager - computeCurrentVolBasedOnMinAndMaxVolLimit returning minlimitval: %d", minlimitval))
           return minlimitval;
       }
       else if (maxlimitval < CurrentVol)
       {
           ETG_TRACE_USR2(("GAMVolumeManager - computeCurrentVolBasedOnMinAndMaxVolLimit returning maxlimitval: %d", maxlimitval))
           return maxlimitval;
       }

       ETG_TRACE_USR2(("GAMVolumeManager - computeCurrentVolBasedOnMinAndMaxVolLimit returning CurrentVol: %d", CurrentVol))
       return CurrentVol;
}

void VolumeManager:: setOnVolumeLimit (void)
{
    ETG_TRACE_USR2(("GAMVolumeManager - getLimitedList for Cabin Sink Entered"))

    tU8 maxlimitval=0;
    tU8 minlimitval=0;
    tU8 CurrentVol=0;

    unsigned char Entertain_groupID = _pConfiguration->getEntertainmentGroupID();
    unsigned char groupCount = (unsigned char)_pConfiguration->getSourceGroupCount();


//For Cabin A

    CurrentVol = _pProperties->persistenceStore.getPersistenceVolume(Entertain_groupID, groupCount, "AMP_A");

    ETG_TRACE_USR3(("Current volume of Cabin A before limiting  =%d ",CurrentVol));

    minlimitval = _pProperties->persistenceStore.getPersistenceOnVolume("AMP_A", "OnVolumeMin");   //Fetch Min volume limit from data pool for Cabin A
    maxlimitval = _pProperties->persistenceStore.getPersistenceOnVolume("AMP_A", "OnVolumeMax");   //Fetch Max volume limit from data pool for Cabin A

    CurrentVol = computeCurrentVolBasedOnMinAndMaxVolLimit(minlimitval, CurrentVol, maxlimitval);

    ETG_TRACE_USR3(("Current volume of Cabin A after limiting  =%d ",CurrentVol));

    _pProperties->persistenceStore.setPersistenceVolume(Entertain_groupID, groupCount, "AMP_A", CurrentVol);


//For Cabin B

    CurrentVol = 0;
    CurrentVol = _pProperties->persistenceStore.getPersistenceVolume(Entertain_groupID, groupCount, "AMP_B");

    ETG_TRACE_USR3(("Current volume of Cabin B before limiting  =%d ",CurrentVol));

    minlimitval = _pProperties->persistenceStore.getPersistenceOnVolume("AMP_B", "OnVolumeMin");  //Fetch Min volume limit from data pool for Cabin B
    maxlimitval = _pProperties->persistenceStore.getPersistenceOnVolume("AMP_B", "OnVolumeMax");  //Fetch Max volume limit from data pool for Cabin B

    CurrentVol = computeCurrentVolBasedOnMinAndMaxVolLimit(minlimitval, CurrentVol, maxlimitval);

    ETG_TRACE_USR3(("Current volume of Cabin B after limiting  =%d ",CurrentVol));

    _pProperties->persistenceStore.setPersistenceVolume(Entertain_groupID, groupCount, "AMP_B", CurrentVol);

    ETG_TRACE_USR2(("GAMVolumeManager - getLimitedList for Cabin Sink Ended"))

}

tU16 VolumeManager::getOnVolumeMinLimit(std::string sinkname)
{
    ETG_TRACE_USR2(("GAMVolumeManager - getLimitedList for Cabin Sink Entered"))

    tU8 minlimitval=0;
    tU8 CurrentVol=0;

    unsigned char Entertain_groupID = _pConfiguration->getEntertainmentGroupID();
    unsigned char groupCount = (unsigned char)_pConfiguration->getSourceGroupCount();

    CurrentVol = _pProperties->persistenceStore.getPersistenceVolume(Entertain_groupID, groupCount, sinkname);

    ETG_TRACE_USR3(("Sink %s",sinkname.c_str()));
    ETG_TRACE_USR3(("Current volume %d",CurrentVol));

    minlimitval = _pProperties->persistenceStore.getPersistenceOnVolume(sinkname, "OnVolumeMin");   //Fetch Min volume limit from data pool for Cabin A

    ETG_TRACE_USR3(("Sink %s",sinkname.c_str()));
    ETG_TRACE_USR3(("Current minlimitval %d",minlimitval));

    return minlimitval;
}

tU16 VolumeManager::getOnVolumeMaxLimit(std::string sinkname)
{
    ETG_TRACE_USR2(("GAMVolumeManager - getOnVolumeMaxLimit for Sink %s",sinkname.c_str()))

    tU8 maxlimitval=0;
    tU8 CurrentVol=0;

    unsigned char Entertain_groupID = _pConfiguration->getEntertainmentGroupID();
    unsigned char groupCount = (unsigned char)_pConfiguration->getSourceGroupCount();

    CurrentVol = _pProperties->persistenceStore.getPersistenceVolume(Entertain_groupID, groupCount, sinkname);

    ETG_TRACE_USR3(("Sink %s",sinkname.c_str()));
    ETG_TRACE_USR3(("Current volume %d",CurrentVol));

    maxlimitval = _pProperties->persistenceStore.getPersistenceOnVolume(sinkname, "OnVolumeMax");   //Fetch Max volume limit from data pool for Cabin A

    ETG_TRACE_USR3(("Sink %s",sinkname.c_str()));
    ETG_TRACE_USR3(("Current maxlimitval %d",maxlimitval));

    return maxlimitval;
}

tU8 VolumeManager::getEntVolumeForSink(std::string sinkname)
{
    ETG_TRACE_USR4(("GAMVolumeManager - getEntVolumeForSink %s",sinkname.c_str()))

    tU8 CurrentVol=0;

    unsigned char Entertain_groupID = _pConfiguration->getEntertainmentGroupID();
    unsigned char groupCount = (unsigned char)_pConfiguration->getSourceGroupCount();

    CurrentVol = _pProperties->persistenceStore.getPersistenceVolume(Entertain_groupID, groupCount, sinkname);

//    ETG_TRACE_USR3(("Sink %s",sinkname.c_str()));
    ETG_TRACE_USR3(("Current volume %d",CurrentVol));

    return CurrentVol;
}

void VolumeManager::fetchOnVolumeLimitProperties(void)
{
    ETG_TRACE_USR2(("OnVolumeLimit() invoked "))

    CabMaxVolMaxVal = _pProperties->kdsHelper.getOnVolumeLimitMaxMax();
    ETG_TRACE_USR3(("CabMaxVolMaxVal Value from KDS = %d", CabMaxVolMaxVal))

    CabMaxVolMinVal = _pProperties->kdsHelper.getOnVolumeLimitMaxMin();
    ETG_TRACE_USR3(("CabMaxVolMinVal Value from KDS = %d", CabMaxVolMinVal))

    CabMinVolMaxVal = _pProperties->kdsHelper.getOnVolumeLimitMinMax();
    ETG_TRACE_USR3(("CabMinVolMaxVal Value from KDS = %d", CabMinVolMaxVal))

    CabMinVolMinVal = _pProperties->kdsHelper.getOnVolumeLimitMinMin();
    ETG_TRACE_USR3(("CabMinVolMinVal Value from KDS = %d", CabMinVolMinVal))

    /*
    if(CabMinVolMinVal > CabMinVolMaxVal)
    {
        CabMinVolMinVal = MIN_MIN_VOL_LIMIT;
        CabMinVolMaxVal = MIN_MAX_VOL_LIMIT;
    }
    else if(CabMaxVolMinVal > CabMaxVolMaxVal)
    {
        CabMaxVolMinVal = MAX_MIN_VOl_LIMIT;
        CabMaxVolMaxVal = MAX_MAX_VOl_LIMIT;
    } */

}

void VolumeManager::restoreSource(const std::string & sinkName)
{
    auto sourcesOnStack = _pProperties->getSourceOnStack();

    if(sourcesOnStack[sinkName]["Entertain"] != "NONE"
       && sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
    {
        //restore ent
        vClearMuteFlag(sinkName);
        vSetAudioSource(sinkName, sourcesOnStack[sinkName]["Entertain"], 1);
        disableMixSourceAttenuation(sinkName);
    }
    else if(sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
    {
        //restore mic1
        vClearMuteFlag(sinkName);
        vSetAudioSource(sinkName, sourcesOnStack[sinkName]["MIC_PRIVATE"], 1);

    }
    else if(sourcesOnStack[sinkName]["Entertain"] != "NONE"
       && sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
    {
        //restore mic1
        vClearMuteFlag(sinkName);
        vSetAudioSource(sinkName,sourcesOnStack[sinkName]["MIC_PRIVATE"], 1);
    }
    else if(sourcesOnStack[sinkName]["Entertain"] != "NONE"
       && sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
    {
        //restore mic1
        vClearMuteFlag(sinkName);
        vSetAudioSource(sinkName,sourcesOnStack[sinkName]["MIC_PRIVATE"], 1);
    }
    else if(  sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
      {
          //restore mic2 & attenuate ent
        vClearMuteFlag(sinkName);
        vSetAudioSource(sinkName, sourcesOnStack[sinkName]["AVB_Mic2"], 1);
        if(sinkName == "AMP_A")
            enableMixSourceAttenuation(sinkName,attenuationdb_ampa);
        else if(sinkName == "AMP_B")
            enableMixSourceAttenuation(sinkName,attenuationdb_ampb);

      }
    else if(  sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
      {
           vClearMuteFlag(sinkName);
           vSetAudioSource(sinkName, sourcesOnStack[sinkName]["AVB_Mic3"], 1);

           if(sinkName == "AMP_A")
               enableMixSourceAttenuation(sinkName,attenuationdb_ampa);
           else if(sinkName == "AMP_B")
               enableMixSourceAttenuation(sinkName,attenuationdb_ampb);
      }
}

void VolumeManager::audioSourceRequest(const std::string & sourceName,
                const std::string & muteState, const std::string & sinkName)
{
    ETG_TRACE_USR3(("VolumeManager::audioSourceRequest source %s",sourceName.c_str()));
    ETG_TRACE_USR3(("VolumeManager::audioSourceRequest sink %s",sinkName.c_str()));
    ETG_TRACE_USR3(("VolumeManager::audioSourceRequest muteState %s",muteState.c_str()));

    if(muteState == "DEMUTE")
    {
        vClearMuteFlag(sinkName);
        vSetAudioSource(sinkName, sourceName , 1);
    }
    else
    {
        vDisconnectAudioSource(sinkName, sourceName);
    }
}

bool VolumeManager::validateSourceChangeRequest(const std::string& sourceName,
        const std::string& muteState, const std::string& sinkName)
{
    auto sourcesOnStack = _pProperties->getSourceOnStack();
}

} // namespace VolumeManager


