//
// Uncopyable.h
//
// this abstract base class prevents accidentally copying and/or assigning
// objects of derived classes
//
// concept found in:
//    Effective C++, 55 Specific Ways to Improve Your Programs and Designs, 3rd Edition
//    Scott Meyers, Addison-Wesley, 2005
// as Item 6
//
//  Created on: Jun 26, 2014
//      Author: Martin Koch, Fa. ESE.de
//


#if !defined(EA_F1020B4A_3F23_43d9_AF94_8F0BBA9815E8__INCLUDED_)
#define EA_F1020B4A_3F23_43d9_AF94_8F0BBA9815E8__INCLUDED_
//#ifndef UNCOPYABLE_H_
//#define UNCOPYABLE_H_


namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Uncopyable
   {

      protected:
         // allow construction and destruction of derived objects ...
         /* default constructor */ Uncopyable ()   {  }
         virtual /* destructor */ ~Uncopyable ()   {  }

      private:
         // ... but prevent copying
         /* copy constructor */ Uncopyable (const Uncopyable&);
         Uncopyable& /* assignment */ operator= (const Uncopyable&);

   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


//#endif /* UNCOPYABLE_H_ */
#endif // !defined(EA_F1020B4A_3F23_43d9_AF94_8F0BBA9815E8__INCLUDED_)
