//
// VolumeManager/PropertyStore.cpp
//
// hold current values of all properties VolumeManager is responsible for
//
//  Created on: Jul 3, 2014
//      Author: Martin Koch, Fa. ESE
//

// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Types.h"  // implicitly links midw_fi alltypes.h and stl_pif.h vector
#include "Volume/Utilities/Uncopyable.h"
#include "PropertyStore.h"
// - - - - - - - - - - - -

#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/PropertyStore.cpp.trc.h"

#include "../fc_audiomanager_service_Audio_Stub.h"
#include "Volume/DynamicSinkStore.h"
#include "Configuration/Configuration.h"

namespace VolumeManager {

// ==========================================================================
//
//                        P r o p e r t y - S t o r e
//

PropertyStore::PropertyStore(fc_audiomanager_tclService_Audio_Function_Stub& service) :
        _service(service),attenuation(NULL),configuration(NULL)
{

    DynamicSinkSourceVolumeMap =
    {
        {   "AMP_A", {   "NONE", 0}},
        {   "AMP_B", {   "NONE", 0}}
    };

    DynamicSinkMuteState =
    {
        {   "AMP_A", false},
        {   "AMP_B", false}
    };

    sourcesOnStack["AMP_A"] = {
      {"Entertain",   "NONE"},
      {"MIC_PRIVATE", "NONE"},
      {"AVB_Mic2",    "NONE"},
      {"AVB_Mic3",    "NONE"}
    };

    sourcesOnStack["AMP_B"] = {
      {"Entertain",   "NONE"},
      {"MIC_PRIVATE", "NONE"},
      {"AVB_Mic2",    "NONE"},
      {"AVB_Mic3",    "NONE"}
    };

}

// --------------------------------------------------------------------------

PropertyStore::~PropertyStore()
{
}

void PropertyStore::setDynamicSinkMuteflag(const std::string& sinkname)
{
    auto it = DynamicSinkMuteState.find(sinkname);
    if (it != DynamicSinkMuteState.end())
        it->second = true;
}

void PropertyStore::clearDynamicSinkMuteflag(const std::string& sinkname)
{
    auto it = DynamicSinkMuteState.find(sinkname);
    if (it != DynamicSinkMuteState.end())
        it->second = false;
}

bool PropertyStore::isDynamicSinkMuteActive(const std::string& sinkname)
{
    auto it = DynamicSinkMuteState.find(sinkname);
    if (it != DynamicSinkMuteState.end())
        return it->second;
    return false;
}

void PropertyStore::storePersistentVolume(const std::string &source, const std::string& sinkname, tU8 vol)
{
    if(configuration == NULL) return;
    unsigned char groupID = configuration->getGroupTypeId(source);
    unsigned char groupCount = (unsigned char)configuration->getSourceGroupCount();
    persistenceStore.setPersistenceVolume(groupID, groupCount, sinkname, vol);
}

tU8 PropertyStore::getPersistentVolume(const std::string &source, const std::string& sinkname)
{
    if(configuration == NULL) return 0;
    unsigned char groupID = configuration->getGroupTypeId(source);
    unsigned char groupCount = (unsigned char)configuration->getSourceGroupCount();
    return persistenceStore.getPersistenceVolume(groupID, groupCount, sinkname);
}

void PropertyStore::setCurrentVolume(const std::string& snikname, const tU16 & volumeStep)
{
    auto it = DynamicSinkSourceVolumeMap.find(snikname);
    if (it != DynamicSinkSourceVolumeMap.end())
        (it->second).second = volumeStep;
}

void PropertyStore::setCurrentSource(const std::string& snikname, const std::string & source)
{
    auto it = DynamicSinkSourceVolumeMap.find(snikname);
    if (it != DynamicSinkSourceVolumeMap.end())
        (it->second).first = source;
}

tU16 PropertyStore::getCurrentVolume(const std::string& snikname)
{
    auto it = DynamicSinkSourceVolumeMap.find(snikname);
    if (it != DynamicSinkSourceVolumeMap.end())
        return (it->second).second;
    return 0;
}

std::string  PropertyStore::getCurrentSource(const std::string& snikname)
{
    auto it = DynamicSinkSourceVolumeMap.find(snikname);
    if (it != DynamicSinkSourceVolumeMap.end())
        return (it->second).first;
    return "NONE";
}

 Attenuation*& PropertyStore::getAttenuation()
{
    return attenuation;
}

void PropertyStore::setAttenuation( Attenuation*& attenuation)
{
    this->attenuation = attenuation;
}

Configuration*& PropertyStore::getConfiguration()
{
    return configuration;
}

void PropertyStore::setConfiguration( Configuration*& configuration)
{
    this->configuration = configuration;
}

void PropertyStore::updateSourceOnStack(const std::string & sinkName, const std::string & sourceName, bool state)
{
    std::string group = configuration->getGroupName(sourceName);
    ETG_TRACE_USR4(("PropertyStore::updateSourceOnStack state %d, group s %s",state,group.c_str()));
    ETG_TRACE_USR4(("PropertyStore::updateSourceOnStack sinkName %s",sinkName.c_str()));
    ETG_TRACE_USR4(("PropertyStore::updateSourceOnStack sourceName %s",sourceName.c_str()));

    if(group == "NONE")
        return;
    if(state)
    {
        sourcesOnStack[sinkName][group] = sourceName;
    }
    else if(state == false && sourcesOnStack[sinkName][group] == sourceName)
    {
        sourcesOnStack[sinkName][group] = "NONE";
    }
}

std::map<std::string, std::map<std::string, std::string > > PropertyStore::getSourceOnStack(void)
{
    return sourcesOnStack;
}

bool PropertyStore::volumeStatus(const std::string & sinkName, const std::string & source)
{

	ETG_TRACE_USR4(("PropertyStore::volumeStatus sinkName %s",sinkName.c_str()));
	ETG_TRACE_USR4(("PropertyStore::volumeStatus source %s",source.c_str()));
	ETG_TRACE_USR4(("\n"));
	ETG_TRACE_USR4(("sourcesOnStack[sinkName][Entertain]: %s",sourcesOnStack[sinkName]["Entertain"].c_str()));
	ETG_TRACE_USR4(("sourcesOnStack[sinkName][MIC_PRIVATE]: %s",sourcesOnStack[sinkName]["MIC_PRIVATE"].c_str()));
	ETG_TRACE_USR4(("sourcesOnStack[sinkName][AVB_Mic2]: %s",sourcesOnStack[sinkName]["AVB_Mic2"].c_str()));
	ETG_TRACE_USR4(("sourcesOnStack[sinkName][AVB_Mic3]: %s",sourcesOnStack[sinkName]["AVB_Mic3"].c_str()));

    //auto sourcesOnStack = _pProperties->getSourceOnStack();

    if(sourcesOnStack[sinkName]["Entertain"] != "NONE"
       && sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
    {
        if(sourcesOnStack[sinkName]["Entertain"] == source)
            return true;
    }
    else if(sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
    {
        //restore mic1
        if(sourcesOnStack[sinkName]["MIC_PRIVATE"] == source)
            return true;
    }
    else if(sourcesOnStack[sinkName]["Entertain"] != "NONE"
       && sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
    {
        //restore mic1
        if(sourcesOnStack[sinkName]["MIC_PRIVATE"] == source)
            return true;
    }
    else if(sourcesOnStack[sinkName]["Entertain"] != "NONE"
       && sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
       && sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
    {
        //restore mic1
        if(sourcesOnStack[sinkName]["MIC_PRIVATE"] == source)
            return true;
    }
    else if(  sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic3"] == "NONE")
      {
          //restore mic2 & attenuate ent
          //Comparing the combination of MIC2 and returning True
        if((sourcesOnStack[sinkName]["AVB_Mic2"] == source)||(sourcesOnStack[sinkName]["Entertain"] == source))
            return true;

      }
    else if(  sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic2"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
      {
        //Comparing the combination of MIC3 and returning True
        if((sourcesOnStack[sinkName]["AVB_Mic3"] == source)||(sourcesOnStack[sinkName]["Entertain"] == source))
            return true;
      }
    else if(  sourcesOnStack[sinkName]["MIC_PRIVATE"] == "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
      {
         if( (source == "AVB_Mic2") || (source == "AVB_Mic3") )
            return true;
      }
    else if(  sourcesOnStack[sinkName]["MIC_PRIVATE"] != "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic2"] != "NONE"
         && sourcesOnStack[sinkName]["AVB_Mic3"] != "NONE")
      {
         if( sourcesOnStack[sinkName]["MIC_PRIVATE"] == source)
            return true;
      }

    return false;
}

}  // namespace VolumeManager
