/*
 * KDSHelper.cpp
 *
 *  Created on: Sep 12, 2019
 *      Author: wma5kor
 */

#include "KDSHelper.h"

#ifndef LinuxX86Make
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#endif

namespace VolumeManager
{

KDSHelper::KDSHelper()
{
    // TODO Auto-generated constructor stub

}

KDSHelper::~KDSHelper()
{
    // TODO Auto-generated destructor stub
}

unsigned char KDSHelper::get_oem_type()
{
    unsigned char value;
    kds_config_read("CMVariantCoding","OEMType", value);
    return value;
}

void KDSHelper::kds_config_read(std::string arg1, std::string arg2, unsigned char &output)
{

#ifndef LinuxX86Make
    if(DP_S32_NO_ERR != DP_s32GetConfigItem(arg1.c_str(),arg2.c_str(), &output, 1))
        output = 0x00;
#else
    output = 0x00;
#endif
}

unsigned char KDSHelper::getOnVolumeLimitMaxMax()
{
    unsigned char CabMaxVolMaxVal;
    kds_config_read("SoundVolumeConfig", "CabMaxVolMaxVal", CabMaxVolMaxVal);
    return CabMaxVolMaxVal;
}

unsigned char KDSHelper::getOnVolumeLimitMaxMin()
{
    unsigned char CabMaxVolMinVal;
    kds_config_read("SoundVolumeConfig", "CabMaxVolMinVal", CabMaxVolMinVal);
    return CabMaxVolMinVal;
}

unsigned char KDSHelper::getOnVolumeLimitMinMax()
{
    unsigned char CabMinVolMaxVal;
    kds_config_read("SoundVolumeConfig", "CabMinVolMaxVal", CabMinVolMaxVal);
    return CabMinVolMaxVal;
}

unsigned char KDSHelper::getOnVolumeLimitMinMin()
{
    unsigned char CabMinVolMinVal;
    kds_config_read("SoundVolumeConfig", "CabMinVolMinVal", CabMinVolMinVal);
    return CabMinVolMinVal;
}

}

