//
// Engine.cpp   for sub-component VolumeManager
//
//
//  Created on: Jun 17, 2014
//      Author: Martin Koch, Fa. ESE
//

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h> // implicitly links <osal_if.h>

#include "Volume/Types.h"
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/MessageConfig.h"
#include "audiomanagertypes.h"

#include "Engine.h"
// - - - - - - - - - - -



#include <string>

//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#include "osal_if.h"

#include "Volume/PropertyStore.h"
#include "Volume/Engine/Actions/IAction.h"
#include "Volume/Engine/Functions/IFunction.h"
#include "Volume/Engine/Functions/FunctionBase.h"
#include "Volume/VolumeManager.h"
#include "Volume/DynamicSinkStore.h"

#include "Volume/TypeConversions/Functions.h"
#include "Volume/Configuration/Configuration.h"
#include "./Stream.h"
#include "./StreamSet.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "./ActionFactory.h"
#include "Volume/Configuration/dBCalculator.h"

#include "../../../PostOfficeAdapter/InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/Messages/Source/IDIntSource.h"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/Messages/Source/IDIntSourceType.h"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSinkData.h"
#include "../../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_SinkDetail.h"


#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/Engine.cpp.trc.h"


namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */ Engine::Engine(PropertyStore& store, const Configuration& config, Fading_IF* /* pFader */)
      :  IF_MessageObserver<PO_MessageConfig::enID>("VolumeManager_Engine")
      , _properties(store)
      , _config(config)
      , _pActionFactory(new ActionFactory(_properties, _config))
   {

      PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
      if (pPO)
      {
         // register for forwarded CCA command messages
         pPO->AddObserver(this, PO_MessageConfig::ID_CCA_Start_Volume);
         pPO->AddObserver(this, PO_MessageConfig::IDIntSource);
         pPO->AddObserver(this, PO_MessageConfig::ID_SPIMixVolume);
         pPO->AddObserver(this, PO_MessageConfig::ID_SinkDetail);
      }
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ Engine:: ~Engine ()
   {
      PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
      if (pPO)
         try
         {
             InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
             pPO = NULL;

         }
         catch(...)  {}

      delete _pActionFactory;
      ETG_TRACE_USR1(("Engine terminating ..."))
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void Engine:: MessageNotification (PO_MessageConfig::enID MsgId)
   {
      // implement IF_MessageObserver

      ETG_TRACE_USR4(("Engine::MessageNotification() received for ID %u",MsgId));
      if (NULL == _pActionFactory)   // won't happen
         return;

      //tenResource enResource = Speaker;
      std::string sinkName = "Speakers";
      IAction* pAction = NULL;
      PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;

      switch (MsgId)
      {
         case PO_MessageConfig::ID_CCA_Start_Volume:
            {
               ETG_TRACE_USR4(("Engine::MessageNotification() received ID_CCA_Start_Volume"));

               const VolumeData& data = pPO->QueryMessage<ID_CCA_Start_Volume>(MsgId)->value;
               pAction = _pActionFactory->getVolumeSetAction(data);

               //enResource = DynamicSinkStore::getInstance().getenResource((tU16)data.m_Resource.getResource());
               sinkName = data.sinkName;
               ETG_TRACE_USR4(("Current Source : %s", _properties.getCurrentSource(sinkName).c_str()));

            }
            break;


         case PO_MessageConfig::IDIntSource:
            {
              ETG_TRACE_USR4(("Engine::MessageNotification() received IDIntSource"));
                const VolumeSourceData& pMsg = pPO->QueryMessage<IDIntSource>(MsgId)->value;


               // ETG_TRACE_USR4(("fetch second from map for resource %d",pMsg.m_Resource.getResource()));

               // enResource = DynamicSinkStore::getInstance().getenResource(pMsg.m_ResourceName);
                //enResource = Sink17;
               // ETG_TRACE_USR4(("IDIntSource ResourceNo %d",pMsg.m_Resource.getResource()));
                //ETG_TRACE_USR4(("IDIntSource enResource %d from map",enResource));
                ETG_TRACE_USR4(("IDIntSource m_Channel %d",pMsg.m_Channel));
                ETG_TRACE_USR4(("IDIntSource m_Source %d",pMsg.m_Source));
                ETG_TRACE_USR4(("IDIntSource m_ClientSource %d",pMsg.m_ClientSource));
                _properties.setCurrentSource(pMsg.m_ResourceName, pMsg.m_SourceName) ;

                sinkName = pMsg.m_ResourceName;

                pAction = _pActionFactory->getSourceSwitchAction(pMsg);

            }
            break;
         case PO_MessageConfig::ID_SinkDetail:
         {
           const ID_SinkDetail* pMsg = pPO->QueryMessage<ID_SinkDetail>(MsgId);
           ETG_TRACE_USR4(("Engine: ID_SinkDetail SinkID %d SinkName %s",pMsg->value.sink_Id, pMsg->value.sink_name.c_str()));
           DynamicSinkStore::getInstance().updateDynamicSinkStore(pMsg->value.sink_name,pMsg->value.sink_Id);

           std::string sink_name = pMsg->value.sink_name;
           tU16 sink = DynamicSinkStore::getInstance().getSinkID(sink_name);
           ETG_TRACE_USR4(("Engine: DynamicSinkStore SinkID : %d",sink));
         };
         break;
         default:
            ETG_TRACE_ERR(("Engine::MessageNotification() - unhandled message %u received", MsgId))
            break;
      }

      if (pAction)
      {
      // ETG_TRACE_USR4(("Engine: executing pAction %p for enResource %d",pAction,enResource));
         (void)bExecuteAction(*pAction, sinkName);
         delete pAction;
      }
   }


   void Engine:: vApplyOnVolumeLimits ()
   {
      if (NULL == _pActionFactory)
         return;

      IAction* pAction = _pActionFactory->getOnVolumeLimitAction();
      if (pAction)
         (void) bExecuteAction(*pAction, Speaker);
      delete pAction;
   }

   // -----------------------------------------------------------------------------


   // -----------------------------------------------------------------------------

   // -----------------------------------------------------------------------------

   bool Engine::bExecuteAction(IAction& /* action */, tenResource /* enResource */)
   {
       return false;
   }

    bool Engine::bExecuteAction(IAction& action, const std::string& sinkName)
    {
        if(_config.validateSink(sinkName))
        {
            const  StreamSetConfig * streamSetConfig = (_config.pGetStreamSetConfig(sinkName));
            if(streamSetConfig == NULL) return false;
            StreamSet streamSet(*streamSetConfig, _config, NULL);
            action.vExecute(streamSet);
            return true;
        }
        return false;
    }

}  //  namespace VolumeManager
