//
// VolumeManager/Engine/ActionFactory.cpp
//
// Factory class for volume modifying actions
//
//  Created on: Jul 4, 2014
//      Author: Martin Koch, Fa. ESEi
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

#include "Volume/Types.h"
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Engine/Actions/IAction.h"
#include "./ActionFactory.h"

// - - - - - - - - - - - - -

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#include <stl_pif.h>



#include <map>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Volume/PropertyStore.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Engine/Actions/ActionBase.h"
#include "Volume/Engine/Actions/VolumeSetAction.h"
//#include "Volume/Engine/Actions/OnVolumeLimitAction.h"
#include "Volume/Engine/Actions/SourceSwitchAction.h"
//#include "fc_audiomanager_trace.h"
#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/ActionFactory.cpp.trc.h"



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */ ActionFactory:: ActionFactory (PropertyStore& store, const Configuration& config)
      : _propertyStore(store)
      , _config(config)

   {

   }

   // -----------------------------------------------------------------------------

   /* destructor */ ActionFactory:: ~ActionFactory ()
   {

   }

   // -----------------------------------------------------------------------------
   //
   //                              factory functions
   //

   IAction* ActionFactory:: getVolumeSetAction (const VolumeData& volumeData)
   {
      return new VolumeSetAction(_propertyStore, _config,  volumeData, EN_AUDIO_FADING_RES_USR);
   }

   // -----------------------------------------------------------------------------

   IAction* ActionFactory:: getModeChangeAction (const VolumeModeData& /* modeData */)
   {
//      return new ModeChangeAction(_propertyStore, _config, modeData);
       return NULL;
   }

   // -----------------------------------------------------------------------------

   IAction* ActionFactory:: getSourceSwitchAction (const VolumeSourceData& sourceData)
   {
      return new SourceSwitchAction(_propertyStore, _config,  sourceData);
   }

   // -----------------------------------------------------------------------------

   IAction* ActionFactory:: getLockAction (tenVolumeLockRequester /* enRequester */, tenVolumeLock /* enNewLockState */)
   {
//      return new LockAction(_propertyStore, _config, enRequester, enNewLockState);
       return NULL;
   }

   // -----------------------------------------------------------------------------

   IAction* ActionFactory:: getOnVolumeLimitAction ()
   {
//      return new OnVolumeLimitAction(_propertyStore, _config);
       return NULL;
   }

   // -----------------------------------------------------------------------------

   IAction* ActionFactory:: getListChangeAction (const midw_fi_tcl_Aud_VolumeStatusList& /* volumeList */)
   {
//      return new ListChangeAction(_propertyStore, _config, volumeList);
       return NULL;
   }

   // -----------------------------------------------------------------------------

   IAction* ActionFactory:: getSourceSwitchActionWhenMixActive (const VolumeSourceData& /* sourceData */)
   {
     // return new SourceSwitchActionWhenMixActive(_propertyStore, _config, sourceData);
       return NULL;
   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


